/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import oracle.ias.cache.CacheInternal;

class DiskCacheIdx {
    private static final int BASE = 6;
    private static final int MASK = 63;
    private static final int REC_PER_BLK = 8;
    private static final int INST_PER_REC = 64;
    private static final int INST_REC_MOD = 63;
    private static final int INST_REC_DIV = 6;
    static final int INST_SIZE = 3;
    static final int MAX_INST = 262144;
    private static final int GIDX_REC_TAG = 0;
    private static final int PAD = 28;
    private static final int IDX_REC_TAG = 3;
    private static final int IDX_START = 31;
    private static final int RECORDSIZE = 223;
    int gidxInst;
    byte[][] idxTable;
    private File idxFile;
    private RandomAccessFile idxFileHdl;
    private int buckNum;
    private byte[] idxBuf;

    DiskCacheIdx(String string, String string2, int n) throws IOException {
        this.idxFile = new File(string, string2);
        this.idxFileHdl = null;
        this.buckNum = n;
        this.idxBuf = new byte[1784];
        this.growIdxTable();
        if (!this.idxFile.exists()) {
            this.initIdxRecord(0);
        }
    }

    private int readIdxBlock(int n, byte[] byArray) throws IOException {
        long l;
        if (this.idxFileHdl == null) {
            this.idxFileHdl = new RandomAccessFile(this.idxFile, "rw");
        }
        if ((l = (long)(n * 223)) >= this.idxFileHdl.length()) {
            return 0;
        }
        this.idxFileHdl.seek(l);
        this.idxFileHdl.read(byArray, 0, 1784);
        int n2 = 1564;
        return n + 8;
    }

    private boolean isEOF(int n) throws IOException {
        long l;
        if (this.idxFileHdl == null) {
            this.idxFileHdl = new RandomAccessFile(this.idxFile, "rw");
        }
        return (l = (long)(n * 223)) >= this.idxFileHdl.length();
    }

    private int readInst(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < 3; ++i) {
            n2 = (n2 << 6) + byArray[n++];
        }
        return n2;
    }

    void writeInst(byte[] byArray, int n, int n2) {
        int n3 = n + 3 - 1;
        int n4 = 3;
        while (n4 > 0) {
            byArray[n3] = (byte)(n2 & 0x3F);
            n2 >>= 6;
            --n4;
            --n3;
        }
    }

    boolean updateNeeded() throws IOException {
        boolean bl = false;
        this.readIdxBlock(0, this.idxBuf);
        for (int i = 0; i < 3; ++i) {
            if (this.idxTable[0][i] == this.idxBuf[i]) continue;
            bl = true;
            this.idxTable[0][i] = this.idxBuf[i];
        }
        if (bl) {
            this.gidxInst = this.readInst(this.idxBuf, 0);
        }
        return bl;
    }

    int findFree(int n) throws IOException {
        int n2 = this.getRecInst(n);
        for (int i = this.getIdxRec(n); i < this.idxTable.length; ++i) {
            for (int j = n2; j < 64; ++j) {
                int n3 = 31 + j * 3;
                boolean bl = true;
                int n4 = 0;
                while (n4 < 3) {
                    if (this.idxTable[i][n3] != 0) {
                        bl = false;
                    }
                    ++n4;
                    ++n3;
                }
                if (!bl) continue;
                return i * 64 + j;
            }
            n2 = 0;
        }
        int n5 = this.idxTable.length * 64;
        this.initIdxRecord(this.idxTable.length);
        this.growIdxTable();
        return n5;
    }

    int findNextUpdate(int n) throws IOException {
        int n2;
        int n3 = this.getIdxRec(n);
        int n4 = this.getRecInst(n);
        int n5 = this.getBlkOffset(n);
        int n6 = 1784;
        if (n3 == this.idxTable.length) {
            this.growIdxTable();
        }
        if (this.isEOF(n3)) {
            return -1;
        }
        while ((n2 = this.compareIdxRec(this.idxTable[n3], this.idxBuf, n5, n4)) < 0) {
            if (n2 == -1) {
                System.arraycopy(this.idxBuf, n5, this.idxTable[n3], 0, 223);
            }
            if (++n3 == this.idxTable.length) {
                this.growIdxTable();
            }
            n4 = 0;
            if ((n5 += 223) != n6) continue;
            n5 = 0;
            if (this.readIdxBlock(n3, this.idxBuf) != 0) continue;
        }
        if (n2 >= 0) {
            n2 += n3 * 64;
        }
        if (n2 > 0 && this.getRecInst(n2) == 63) {
            System.arraycopy(this.idxBuf, n5, this.idxTable[n3], 0, 223);
            if (n5 + 223 == n6) {
                this.readIdxBlock(++n3, this.idxBuf);
            }
        }
        return n2;
    }

    private int compareIdxRec(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3;
        int n4;
        boolean bl = false;
        if (n2 == 0) {
            int n5 = 3;
            n4 = 0;
            while (n4 < 3) {
                if (byArray[n5] != byArray2[n + n5]) {
                    bl = true;
                    break;
                }
                ++n4;
                ++n5;
            }
            if (!bl) {
                return -2;
            }
        }
        for (n4 = n3 = 31 + n2 * 3; n4 < 223; ++n4) {
            if (byArray[n4] == byArray2[n + n4]) continue;
            return (n4 - 31) / 3;
        }
        return -1;
    }

    private void initIdxRecord(int n) throws IOException {
        int n2 = 0;
        byte[] byArray = new byte[223];
        if (this.idxFileHdl == null) {
            this.idxFileHdl = new RandomAccessFile(this.idxFile, "rw");
        }
        if (n > 0) {
            n = this.idxTable.length * 64;
        }
        Arrays.fill(byArray, n2, 222, (byte)0);
        this.idxFileHdl.seek(n * 223);
        for (int i = 0; i < 8; ++i) {
            this.idxFileHdl.write(byArray);
        }
    }

    void writeHeader(int n, int n2) throws IOException {
        int n3 = this.getIdxRec(n);
        int n4 = this.getInstOffset(n);
        this.gidxInst = this.incrInst(this.gidxInst);
        if (this.idxFileHdl == null) {
            this.idxFileHdl = new RandomAccessFile(this.idxFile, "rw");
        }
        int n5 = this.readInst(this.idxTable[n3], 3);
        n5 = this.incrInst(n5);
        this.writeInst(this.idxTable[0], 0, this.gidxInst);
        this.writeInst(this.idxTable[n3], n4, n2);
        this.writeInst(this.idxTable[n3], 3, n5);
        this.idxFileHdl.seek(0L);
        this.idxFileHdl.write(this.idxTable[0]);
        if (n3 != 0) {
            this.idxFileHdl.seek(this.getRecOffset(n));
            this.idxFileHdl.write(this.idxTable[n3]);
        }
    }

    void reset() throws IOException {
        this.idxFile.delete();
        this.idxTable = null;
        this.close();
        this.initIdxRecord(0);
        this.growIdxTable();
    }

    void close() {
        try {
            if (this.idxFileHdl != null) {
                this.idxFileHdl.close();
                this.idxFileHdl = null;
            }
        }
        catch (Exception exception) {
            this.idxFileHdl = null;
        }
    }

    int incrInst(int n) {
        if (++n == 262144) {
            n = 1;
        }
        return n;
    }

    int length() {
        return this.idxTable.length;
    }

    private void growIdxTable() {
        int n = 0;
        int n2 = 0;
        byte[] byArray = new byte[223];
        if (this.idxTable != null) {
            n2 = this.idxTable.length;
        }
        int n3 = n2 + 8;
        byte[][] byArrayArray = new byte[n3][];
        if (this.idxTable != null) {
            System.arraycopy(this.idxTable, 0, byArrayArray, 0, n2);
        }
        this.idxTable = byArrayArray;
        Arrays.fill(byArray, n, 222, (byte)0);
        for (int i = n2; i < n3; ++i) {
            this.idxTable[i] = new byte[223];
            System.arraycopy(byArray, 0, this.idxTable[i], 0, 223);
        }
    }

    private int getIdxRec(int n) {
        return n >> 6;
    }

    private int getRecInst(int n) {
        return n & 0x3F;
    }

    private int getInstOffset(int n) {
        return 31 + this.getRecInst(n) * 3;
    }

    private int getRecOffset(int n) {
        return this.getIdxRec(n) * 223;
    }

    private int getBlkOffset(int n) {
        return this.getIdxRec(n) % 8 * 223;
    }

    void printIndex() {
        int n = 0;
        byte[] byArray = new byte[1784];
        try {
            while ((n = this.readIdxBlock(n, byArray)) != 0) {
                for (int i = 0; i < 8; ++i) {
                    int n2 = i * 223;
                    String string = this.idxRecordToString(byArray, n2);
                    if (string == null) continue;
                    System.err.println(string);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void dumpIndex() {
        int n = 0;
        byte[] byArray = new byte[1784];
        try {
            while ((n = this.readIdxBlock(n, byArray)) != 0) {
                for (int i = 0; i < 8; ++i) {
                    int n2 = i * 223;
                    String string = this.idxRecordToString(byArray, n2);
                    if (string == null) continue;
                    CacheInternal.trace(string);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String idxRecordToString(byte[] byArray, int n) {
        String string = this.buckNum + " ";
        int n2 = this.readInst(byArray, n + 3);
        if (n2 == 0) {
            return null;
        }
        int n3 = this.readInst(byArray, n + 0);
        string = string + n3 + "||" + n2 + "|";
        n += 31;
        for (int i = 0; i < 64; ++i) {
            n2 = this.readInst(byArray, n);
            string = string + " " + n2;
            n += 3;
        }
        return string;
    }
}

