/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.Vector;
import oracle.ias.cache.BitMap;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.CacheObjectInputStream;
import oracle.ias.cache.InvalidObjectException;
import oracle.ias.cache.ResponseFailedException;
import oracle.ias.cache.TimeoutException;
import oracle.ias.cache.UpdateMessage;

class Response {
    static final int UNKNOWN = 0;
    static final int OK = 1;
    static final int FAILED = 2;
    static final int WAITING = 3;
    static final int NOTOWNER = 4;
    static final int REJECTED = 5;
    static final int INVALID = 6;
    static final int LOCKWAITER = 7;
    int version = 0;
    int id;
    int viewId = 0;
    BitMap participants;
    Object retObj;
    int status;
    boolean singleReply;
    boolean replyReceived;
    boolean searchComplete;
    Response next;
    byte[] exception;
    String cacheName;
    String qual;
    boolean isList;
    boolean isDisk;
    boolean isStream;

    public Response(int n) {
        this.id = n;
        this.next = null;
        this.retObj = null;
        this.singleReply = false;
        this.replyReceived = false;
        this.searchComplete = false;
        this.status = 0;
        this.participants = null;
        this.exception = null;
        this.cacheName = "";
        this.qual = null;
        this.isList = false;
        this.isDisk = false;
        this.isStream = false;
    }

    synchronized boolean recordResponse(int n, int n2, int n3, byte[] byArray, String string, String string2) {
        if (n3 != this.version) {
            return true;
        }
        this.replyReceived = true;
        if (this.status == 0 || n2 == 2 || byArray != null) {
            this.status = n2;
            this.exception = byArray;
            this.cacheName = string;
            this.qual = string2;
        }
        if (this.singleReply || n2 == 2) {
            this.wakeup();
            return true;
        }
        if (this.participants == null) {
            return false;
        }
        this.participants.clearBit(n);
        if (this.participants.isZero()) {
            this.status = 1;
            this.wakeup();
        }
        return true;
    }

    synchronized boolean awaitOwnership(int n, boolean bl, int n2, int n3) {
        if (this.version != n2) {
            return true;
        }
        if (bl) {
            this.replyReceived = true;
            return true;
        }
        if (n3 == 2 || n3 == 6) {
            this.status = n3;
        } else if (!(n3 != 1 && n3 != 7 || this.status == 2 && this.status == 6)) {
            this.status = n3;
        }
        if (this.status == 1 || this.status == 2 || this.status == 6 || this.status == 7) {
            this.searchComplete = true;
            this.wakeup();
            return true;
        }
        if (this.participants == null) {
            return false;
        }
        this.participants.clearBit(n);
        if (this.participants.isZero()) {
            this.status = 1;
            this.wakeup();
        }
        return true;
    }

    synchronized void saveSearch(long l, Object object) {
        UpdateMessage updateMessage = (UpdateMessage)object;
        if (l != (long)this.version) {
            if (updateMessage.objectType == 0x2000000L || updateMessage.objectType == 4096L) {
                File file = new File((String)updateMessage.updateObj);
                file.delete();
            }
            return;
        }
        if (updateMessage.objectType == 0x2000000L) {
            this.isStream = true;
        }
        if (updateMessage.objectType == 4096L) {
            this.isDisk = true;
        }
        this.retObj = object;
        this.searchComplete = true;
        this.wakeup();
    }

    synchronized void saveSearchList(long l, int n, Object object, int n2) {
        if (l != (long)this.version) {
            if ((long)n2 == 0x2000000L || (long)n2 == 4096L) {
                File file = new File((String)object);
                file.delete();
            }
            return;
        }
        if ((long)n2 == 0x2000000L) {
            this.isStream = true;
        }
        if ((long)n2 == 4096L) {
            this.isDisk = true;
        }
        this.isList = true;
        Vector<Object> vector = (Vector<Object>)this.retObj;
        if (null == vector) {
            this.retObj = vector = new Vector<Object>();
        }
        vector.addElement(object);
    }

    synchronized void setParticipants(long l, BitMap bitMap, int n) {
        if (l != (long)this.version) {
            return;
        }
        this.participants = bitMap;
        this.viewId = n;
    }

    synchronized void resetPmap(BitMap bitMap, int n) {
        if (n <= this.viewId || this.status == 2 || this.status == 6) {
            return;
        }
        this.participants.andMap(bitMap);
        if (this.participants.isZero()) {
            this.status = 1;
            this.wakeup();
        }
    }

    synchronized void setStatus(int n) {
        this.status = n;
        if (this.status == 2 || this.status == 5 || this.status == 6 || this.status == 7) {
            this.wakeup();
        }
    }

    synchronized void waitFor(int n) throws ResponseFailedException, InvalidObjectException, TimeoutException, InterruptedException {
        long l = System.currentTimeMillis() + (long)n;
        long l2 = n;
        if (n < 0) {
            l2 = 999999999L;
        }
        while (true) {
            if (this.status == 2) {
                Exception exception = this.getException();
                if (exception == null) {
                    throw new ResponseFailedException(CacheInternal.EXP_RESPFAIL);
                }
                throw new ResponseFailedException(CacheInternal.EXP_RESPFAIL, exception, this.cacheName);
            }
            if (this.status == 6) {
                throw new InvalidObjectException(CacheInternal.EXP_INVALOBJ);
            }
            if (this.participants.isZero() || this.singleReply && this.replyReceived || this.searchComplete) {
                return;
            }
            if (l2 <= 0L) break;
            this.wait(l2);
            l2 = l - System.currentTimeMillis();
        }
        if (CacheInternal.logger.shouldLog(15)) {
            CacheInternal.logger.log(this.toString());
        }
        throw new TimeoutException();
    }

    synchronized void wakeup() {
        this.notify();
    }

    Exception getException() {
        Exception exception;
        block3: {
            exception = null;
            if (this.exception == null) {
                return null;
            }
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.exception);
                CacheObjectInputStream cacheObjectInputStream = new CacheObjectInputStream(byteArrayInputStream, this.qual);
                exception = (Exception)cacheObjectInputStream.readObject();
            }
            catch (Exception exception2) {
                if (!CacheInternal.logger.shouldLog(6)) break block3;
                CacheInternal.logger.log(CacheInternal.EXP_RESPFAIL, exception2);
            }
        }
        return exception;
    }

    synchronized void free() {
        ++this.version;
        if (this.isDisk || this.isStream) {
            if (this.isList) {
                Vector vector = (Vector)this.retObj;
                Object[] objectArray = vector.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    File file = new File((String)objectArray[i]);
                    file.delete();
                }
            } else {
                UpdateMessage updateMessage = (UpdateMessage)this.retObj;
                if (updateMessage != null) {
                    File file = new File((String)updateMessage.updateObj);
                    file.delete();
                }
            }
        }
        this.participants = null;
        this.retObj = null;
        this.singleReply = false;
        this.replyReceived = false;
        this.searchComplete = false;
        this.status = 0;
        this.exception = null;
        this.cacheName = null;
        this.qual = null;
        this.isList = false;
        this.isDisk = false;
        this.isStream = false;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("version=");
        stringBuffer.append(this.version);
        stringBuffer.append(", id=");
        stringBuffer.append(this.id);
        stringBuffer.append(", viewId=");
        stringBuffer.append(this.viewId);
        stringBuffer.append(", participants=");
        stringBuffer.append(this.participants);
        stringBuffer.append(", status=");
        stringBuffer.append(this.status);
        stringBuffer.append(", singleReply=");
        stringBuffer.append(this.singleReply);
        stringBuffer.append(", replyReceived=");
        stringBuffer.append(this.replyReceived);
        stringBuffer.append(" searchComplete=");
        stringBuffer.append(this.searchComplete);
        if (!bl) {
            stringBuffer.append(", exception=");
            stringBuffer.append(this.exception);
            stringBuffer.append(", cacheName=");
            stringBuffer.append(this.cacheName);
            stringBuffer.append(", qual=");
            stringBuffer.append(this.qual);
            stringBuffer.append(", isList=");
            stringBuffer.append(this.isList);
            stringBuffer.append(", isDisk=");
            stringBuffer.append(this.isDisk);
            stringBuffer.append(", isStream=");
            stringBuffer.append(this.isStream);
            stringBuffer.append(", retObj=");
            stringBuffer.append(this.retObj);
            stringBuffer.append("\nnext=");
            stringBuffer.append(this.next);
        }
        return stringBuffer.toString();
    }
}

