/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.Response;
import oracle.ias.cache.TimeoutException;

class ResponseList {
    static final int INIT_LIST = 16;
    int idx;
    Response[] list;

    public ResponseList() {
        this.growRespList(16);
    }

    void addToReplyList(Response response) {
        if (this.list == null || this.list.length <= this.idx) {
            this.growRespList(this.idx + 16);
        }
        this.list[this.idx] = response;
        ++this.idx;
    }

    void waitForAll(int n) throws TimeoutException, InterruptedException, CacheException {
        long l = System.currentTimeMillis() + (long)n;
        int n2 = n;
        for (int i = 0; i < this.list.length; ++i) {
            if (this.list[i] == null) continue;
            this.list[i].waitFor(n2);
            CacheInternal.respQ.freeRespSlot(this.list[i].id);
            this.list[i] = null;
            n2 = (int)(l - System.currentTimeMillis());
            if (n2 >= 0) continue;
            n2 = 0;
        }
        this.idx = 0;
    }

    void cancelAll() {
        for (int i = 0; i < this.list.length; ++i) {
            if (this.list[i] == null) continue;
            CacheInternal.respQ.freeRespSlot(this.list[i].id);
            this.list[i] = null;
        }
        this.idx = 0;
    }

    private void growRespList(int n) {
        int n2;
        int n3 = 0;
        Response[] responseArray = new Response[n];
        if (this.list != null) {
            n3 = this.list.length;
            for (n2 = 0; n2 < n3; ++n2) {
                responseArray[n2] = this.list[n2];
            }
        }
        for (n2 = n3; n2 < n; ++n2) {
            responseArray[n2] = null;
        }
        this.list = responseArray;
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.list.length; ++i) {
            if (this.list[i] == null) continue;
            string = string + this.list[i].toString();
        }
        return string;
    }
}

