/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.FailureDetector;
import oracle.ias.cache.group.GroupCommunication;
import oracle.ias.cache.group.GroupException;
import oracle.ias.cache.group.GroupManager;
import oracle.ias.cache.group.MessageBuffer;
import oracle.ias.cache.group.Packet;
import oracle.ias.cache.group.ReplyInfo;
import oracle.ias.cache.group.Transport;
import oracle.ias.cache.group.View;
import oracle.ias.cache.group.ViewInfo;

public class Monitor
extends Thread {
    static final int SECONDS = 20;
    static final int FACTOR = 15;
    boolean work = true;
    byte[] long_lock = new byte[0];
    long lastPinged;
    byte[] lock = new byte[0];
    HashSet pendingReply = null;
    static Monitor instance = null;
    static long counter = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Monitor() {
        byte[] byArray = this.long_lock;
        synchronized (this.long_lock) {
            this.lastPinged = System.currentTimeMillis();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.setName("Group Monitor");
            this.setDaemon(true);
            return;
        }
    }

    public static Monitor getInstance() {
        if (instance == null) {
            instance = new Monitor();
        }
        return instance;
    }

    public void run() {
        while (this.work) {
            try {
                Thread.sleep(20000L);
                if (Transport.isMyself(FailureDetector.getCoordinator())) {
                    this.ping();
                } else {
                    this.check();
                }
                ++counter;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (GroupException groupException) {
                if (!GroupCommunication.shouldLog(6)) continue;
                GroupCommunication.log("Monitor Exception:", groupException);
            }
            catch (Exception exception) {
                if (!GroupCommunication.shouldLog(6)) continue;
                GroupCommunication.log("Monitor Exception:", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void ping() throws GroupException, IOException, InterruptedException {
        Object object;
        Object object2;
        GroupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
        View view = GroupManager.getLatestViewInfo(GroupManager.SYSTEM_GROUP).getView();
        GroupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
        GroupManager.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
        ViewInfo viewInfo = GroupManager.getCurrentViewInfo(GroupManager.SYSTEM_GROUP);
        MessageBuffer messageBuffer = viewInfo.getMessageBuffer();
        GroupManager.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
        if (counter % 15L == 0L) {
            object2 = this.lock;
            // MONITORENTER : this.lock
            HashSet hashSet = this.pendingReply != null && this.pendingReply.size() > 0 ? new HashSet(this.pendingReply) : null;
            // MONITOREXIT : object2
            if (hashSet != null && hashSet.size() != 0) {
                object2 = hashSet.iterator();
                while (object2.hasNext()) {
                    object = (Address)object2.next();
                    if (view.getMembers().contains(object)) {
                        block11: {
                            if (GroupCommunication.shouldLog(3)) {
                                GroupCommunication.log("No reply from " + object + ": declare it dead.");
                            }
                            Packet packet = new Packet(22, 0, Transport.getLocalAddress(), (Serializable)object, null);
                            try {
                                Transport.send(packet);
                            }
                            catch (Exception exception) {
                                if (!GroupCommunication.shouldLog(6)) break block11;
                                GroupCommunication.log("Warning, can't send to " + object, exception);
                            }
                        }
                        FailureDetector.processFailure((Address)object);
                        continue;
                    }
                    object2.remove();
                }
            }
        }
        if (view.getMembers().size() <= 1) return;
        Packet packet = new Packet(10, 0, Transport.getLocalAddress(), (Serializable)((Object)GroupManager.SYSTEM_GROUP), new Long(counter));
        packet.setReceiveArray(messageBuffer.getStableVector());
        packet.setReceivedTONumber(messageBuffer.getReceivedTONumber());
        messageBuffer.setUpdated(false);
        object2 = Transport.multicast(packet);
        if (counter % 15L != 0L) return;
        object = this.lock;
        // MONITORENTER : this.lock
        this.pendingReply = new HashSet(((ReplyInfo)object2).getView().getMembers());
        // MONITOREXIT : object
        this.pendingReply.remove(Transport.getLocalAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void gotReply(Address address) {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            if (address == null || this.pendingReply == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.pendingReply.size() > 0) {
                this.pendingReply.remove(address);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void gotPinged() {
        byte[] byArray = this.long_lock;
        synchronized (this.long_lock) {
            this.lastPinged = System.currentTimeMillis();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void check() throws InterruptedException {
        if (System.currentTimeMillis() - this.lastPinged > 600000L) {
            if (GroupCommunication.shouldLog(3)) {
                GroupCommunication.log("Haven't got PING message. Declare Coordinator Dead.");
            }
            FailureDetector.failureDetected(FailureDetector.getCoordinator());
        }
    }

    public void stopit() {
        this.work = false;
        instance = null;
        this.interrupt();
        Thread.yield();
    }
}

