/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import oracle.ias.cache.group.AsyncQueue;
import oracle.ias.cache.group.GroupCommunication;
import oracle.ias.cache.group.Job;
import oracle.ias.cache.group.Packet;
import oracle.ias.cache.group.Transport;

public class Sender
extends Thread {
    AsyncQueue asq;
    boolean work = true;

    public Sender(AsyncQueue asyncQueue) {
        this.asq = asyncQueue;
        this.setName("Sender");
        this.setDaemon(true);
    }

    public void run() {
        while (this.work) {
            Job job;
            do {
                if ((job = this.asq.dequeue()) == null) continue;
                this.execute(job);
            } while (job != null);
            this.asq.sleep(6000);
        }
    }

    void execute(Job job) {
        block11: {
            try {
                switch (job.action) {
                    case 0: {
                        Transport.syncSend((Packet)job.argument);
                        break;
                    }
                    case 1: {
                        Transport.syncSendTotalOrderedMsg((Packet)job.argument);
                        break;
                    }
                    case 2: {
                        Transport.syncMulticast((Packet)job.argument);
                        break;
                    }
                    case 3: {
                        Transport.syncMulticastTotalOrderedMsg((Packet)job.argument);
                        break;
                    }
                    default: {
                        if (GroupCommunication.shouldLog(3)) {
                            GroupCommunication.log("Invalid Job.");
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                if (GroupCommunication.shouldLog(3)) {
                    GroupCommunication.log("Warning: Asynchronize Sender Exception.", exception);
                }
            }
            catch (Error error) {
                if (!GroupCommunication.shouldLog(3)) break block11;
                GroupCommunication.log("Warning: Asynchronize Sender Error.", error);
            }
        }
    }

    void stopit() {
        this.work = false;
        this.asq.wakeup();
    }
}

