/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.IOException;
import java.io.Serializable;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.TreeSet;
import java.util.Vector;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.AsyncQueue;
import oracle.ias.cache.group.CoordinatorBroadcast;
import oracle.ias.cache.group.CoordinatorResolver;
import oracle.ias.cache.group.ElectionNotification;
import oracle.ias.cache.group.EndPoint;
import oracle.ias.cache.group.FailureDetector;
import oracle.ias.cache.group.GroupCommunication;
import oracle.ias.cache.group.GroupConfig;
import oracle.ias.cache.group.GroupException;
import oracle.ias.cache.group.GroupManager;
import oracle.ias.cache.group.GroupSocketOpener;
import oracle.ias.cache.group.Job;
import oracle.ias.cache.group.MessageBuffer;
import oracle.ias.cache.group.MessageQueue;
import oracle.ias.cache.group.NodeListener;
import oracle.ias.cache.group.Packet;
import oracle.ias.cache.group.Receiver;
import oracle.ias.cache.group.ReplyInfo;
import oracle.ias.cache.group.SSLManager;
import oracle.ias.cache.group.Sender;
import oracle.ias.cache.group.ServerSocketEndPoint;
import oracle.ias.cache.group.ServerSocketReceiver;
import oracle.ias.cache.group.StreamHandler;
import oracle.ias.cache.group.Unicaster;
import oracle.ias.cache.group.View;
import oracle.ias.cache.group.ViewInfo;

public class Transport {
    public static int DEFAULT_JOINGROUP_ATTEMPTS = 5;
    public static int CLEAN_INTERVAL = 0x100000;
    public static int DEFAULT_SOCK_CONNECT_TIMEOUT = 90000;
    public static int BACKLOG = 40;
    public static long NODE_LISTENER_STARTUP_TIMEOUT = 120000L;
    public static final String CONNECT_TIMEOUT_PROPERTY = "oracle.ias.cache.group.connect-timeout";
    static int s_timeout;
    public static final String OPMNID = "oracle.ons.indexid";
    public static final String OPNNORACLE_HOME = "oracle.ons.oraclehome";
    static Vector addrList;
    static Hashtable endPointList;
    static ServerSocketEndPoint ssep;
    static ServerSocketEndPoint nlistener;
    static Hashtable receivingQList;
    static InetAddress localHost;
    static final String TGNAME;
    static ThreadGroup tg;
    static boolean initializing;
    static boolean terminated;
    static AsyncQueue asQ;
    static Sender sender;
    static GroupConfig s_config;
    static CoordinatorBroadcast broadcaster;
    static CoordinatorResolver resolver;
    static Vector electionVotes;
    static boolean enableColletingVotes;
    static Address localNLAddress;
    static Object nodeListernerLock;

    static void dump() {
        GroupCommunication.log("--- Start dumping Transport Layer---");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Current Coordinator at: ");
        stringBuffer.append(FailureDetector.getCoordinator());
        GroupCommunication.log(stringBuffer.toString());
        if (asQ != null) {
            asQ.dump();
        }
        if (nlistener != null) {
            nlistener.dump();
        }
        if (ssep != null) {
            ssep.dump();
        }
        if (endPointList != null) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("--- Start dumping EndPoint ---");
            Enumeration enumeration = endPointList.elements();
            int n = 1;
            while (enumeration.hasMoreElements()) {
                EndPoint endPoint = (EndPoint)enumeration.nextElement();
                stringBuffer.append("\n#");
                stringBuffer.append(n++);
                stringBuffer.append(".\t");
                stringBuffer.append(endPoint);
            }
            stringBuffer.append("\n--- End dumping EndPoint ---");
            GroupCommunication.log(stringBuffer.toString());
        }
        GroupCommunication.log("--- End dumping Transport Layer---");
    }

    public static void init(Vector vector, boolean bl, Serializable serializable, String string) throws GroupException, InterruptedException {
        initializing = true;
        terminated = false;
        electionVotes = new Vector();
        s_config = GroupCommunication.getGroupConfig();
        String string2 = System.getProperty(CONNECT_TIMEOUT_PROPERTY);
        if (string2 == null) {
            s_timeout = DEFAULT_SOCK_CONNECT_TIMEOUT;
        } else {
            try {
                s_timeout = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                if (GroupCommunication.shouldLog(6)) {
                    GroupCommunication.log("invalid connect timeout value", exception);
                }
                s_timeout = DEFAULT_SOCK_CONNECT_TIMEOUT;
            }
        }
        try {
            localHost = string != null ? InetAddress.getByName(string) : InetAddress.getLocalHost();
        }
        catch (Exception exception) {
            throw new GroupException(GroupCommunication.EXP_GRP_NOLOCALHOST + exception.toString());
        }
        if (sender == null) {
            asQ = new AsyncQueue();
            sender = new Sender(asQ);
            sender.start();
        }
        Transport.ssinit(s_config.getLowerPortBoundry(), s_config.getUpperPortBoundry(), serializable, localHost, vector);
        Transport.ssep.handler = new ServerSocketReceiver(ssep);
        Transport.ssep.handler.start();
        localNLAddress = Transport.getLocalNodeListenerAddress(vector);
        if (bl) {
            Transport.bootstrapGroup();
        } else {
            Transport.joinGroup(s_config.isMulticast(), vector, s_config.getMulticastInterval(), s_config.getResolutionTimeout());
        }
        initializing = false;
    }

    static void bootstrapGroup() throws GroupException {
        Transport.nlinit();
        FailureDetector.setCoordinator(Transport.ssep.addr);
        Transport.ssep.addr.setPosition(0);
        Transport.ssep.addr.setUid(0L);
        Transport.ssep.addr.setTimeStamp(System.currentTimeMillis());
        GroupManager.initView(null);
    }

    static void joinGroup(boolean bl, Vector vector, int n, long l) throws GroupException {
        int n2;
        boolean bl2 = false;
        Vector<Address> vector2 = null;
        Address[] addressArray = Transport.getASortedAddressList(vector);
        for (n2 = 0; !bl2 && n2 < DEFAULT_JOINGROUP_ATTEMPTS; ++n2) {
            if (!Transport.isNLStarted()) {
                if (Transport.startNodeListener()) {
                    vector2 = (Vector<Address>)vector.clone();
                    vector2.removeElement(localNLAddress);
                } else {
                    vector2 = new Vector<Address>();
                    vector2.addElement(localNLAddress);
                }
            }
            if (Transport.discoverCoordinator(vector2)) {
                bl2 = true;
                continue;
            }
            if (!Transport.isNLStarted()) {
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (Transport.beACoordinator(bl, addressArray, n, l)) {
                try {
                    Transport.ssep.addr.setPosition(0);
                    Transport.ssep.addr.setUid(0L);
                    Transport.ssep.addr.setTimeStamp(System.currentTimeMillis());
                    GroupManager.initView(null);
                    FailureDetector.setCoordinator(Transport.ssep.addr);
                    FailureDetector.setNodeListenerHostname(Transport.ssep.addr.getHostName());
                    resolver.shutdown();
                    broadcaster.shutdown(l * 2L);
                    bl2 = true;
                }
                catch (Exception exception) {
                    if (GroupCommunication.shouldLog(7)) {
                        GroupCommunication.log("Unable to initialize coordinator.", exception);
                    }
                    resolver.shutdown();
                    broadcaster.shutdown();
                }
                continue;
            }
            resolver.shutdown();
            broadcaster.shutdown();
            if (resolver.isLocalConflict()) {
                Transport.stopNodeListener();
            }
            try {
                Thread.sleep(l);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (n2 > DEFAULT_JOINGROUP_ATTEMPTS) {
            throw new GroupException("Unable to find nor become the coordinator after " + (n2 - 1) + " attempts.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean discoverCoordinator(Vector vector) {
        boolean bl = false;
        int n = 0;
        int n2 = vector.size();
        Vector vector2 = new Vector();
        for (int i = 0; i < n2; ++i) {
            Unicaster unicaster = new Unicaster((Address)vector.elementAt(i), vector2);
            unicaster.start();
        }
        while (n < n2) {
            while (vector2.size() > 0) {
                Unicaster unicaster = (Unicaster)vector2.firstElement();
                if (unicaster.getCoordinator() != null && (bl = Transport.connect(unicaster.getNodeListener(), unicaster.getCoordinator()))) {
                    return true;
                }
                vector2.removeElement(unicaster);
                ++n;
            }
            Vector vector3 = vector2;
            synchronized (vector3) {
                try {
                    vector2.wait(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    static Vector removeANodeFromList(String string, Vector vector) {
        Vector<Address> vector2 = new Vector<Address>();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Address address = (Address)vector.elementAt(i);
            if (address.getIPString().equals(string)) continue;
            vector2.addElement(address);
        }
        return vector2;
    }

    static boolean beACoordinator(boolean bl, Address[] addressArray, int n, long l) throws GroupException {
        boolean bl2 = false;
        if (bl) {
            broadcaster = new CoordinatorBroadcast(s_config.getMulticastAddress(), s_config.getMulticastPort(), Transport.ssep.addr, (long)s_config.getMulticastInterval(), false);
            resolver = new CoordinatorResolver(addressArray, Transport.ssep.addr, broadcaster.getMulticastSocket());
        } else {
            broadcaster = new CoordinatorBroadcast(addressArray, Transport.ssep.addr, s_config.getMulticastInterval(), false);
            resolver = new CoordinatorResolver(addressArray, Transport.ssep.addr);
        }
        broadcaster.start();
        resolver.start();
        long l2 = System.currentTimeMillis();
        try {
            resolver.join(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long l3 = System.currentTimeMillis() - l2;
        if (resolver.canBeCoordinator() && l3 >= l) {
            broadcaster.confirmNominee();
            bl2 = true;
        }
        return bl2;
    }

    static void broadcastConfirmation(Address address) throws GroupException {
        CoordinatorBroadcast coordinatorBroadcast = null;
        if (Transport.s_config.useMulticast) {
            coordinatorBroadcast = new CoordinatorBroadcast(s_config.getMulticastAddress(), s_config.getMulticastPort(), address, (long)s_config.getMulticastInterval(), true);
        } else {
            Address[] addressArray = null;
            Vector vector = s_config.getListenerList();
            if (vector != null && vector.size() > 0) {
                addressArray = new Address[vector.size()];
                vector.toArray(addressArray);
            }
            coordinatorBroadcast = new CoordinatorBroadcast(addressArray, address, s_config.getMulticastInterval(), true);
        }
        coordinatorBroadcast.start();
        coordinatorBroadcast.shutdown(s_config.getResolutionTimeout() * 2L);
    }

    static Address getLocalNodeListenerAddress() throws GroupException {
        Vector vector = s_config.getListenerList();
        return Transport.getLocalNodeListenerAddress(vector);
    }

    static Address getLocalNodeListenerAddress(Vector vector) throws GroupException {
        int n = vector.size();
        Address address = null;
        for (int i = 0; i < n; ++i) {
            Address address2 = (Address)vector.elementAt(i);
            if (address2.isOriginal()) {
                address = address2;
                break;
            }
            if (address != null || !address2.getIPString().equals(Transport.getLocalAddress().getIPString())) continue;
            address = address2;
        }
        if (address == null) {
            throw new GroupException("Unable to find a local address from the discoverer list");
        }
        return address;
    }

    static void ssinit(int n, int n2, Serializable serializable, InetAddress inetAddress, Vector vector) throws GroupException {
        try {
            ServerSocket serverSocket = Transport.createServerSocket(n, n2, inetAddress, s_config.getSSLEnabled(), Transport.getAllPortsFrom(vector, inetAddress));
            Address address = null;
            address = inetAddress != null ? new Address(inetAddress, serverSocket.getLocalPort(), serializable) : new Address(InetAddress.getLocalHost(), serverSocket.getLocalPort(), serializable);
            address.setCacheName(s_config.getCacheName());
            String string = System.getProperty(OPMNID);
            String string2 = System.getProperty(OPNNORACLE_HOME);
            StringBuffer stringBuffer = new StringBuffer();
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            if (string != null) {
                stringBuffer.append(' ');
                stringBuffer.append(string);
            }
            if (stringBuffer.toString() != null) {
                address.setUserDefinedId(stringBuffer.toString());
            }
            ssep = new ServerSocketEndPoint(address, serverSocket);
            addrList.addElement(address);
        }
        catch (BindException bindException) {
            throw new GroupException(GroupCommunication.EXP_GRP_PORTINUSE);
        }
        catch (Exception exception) {
            if (GroupCommunication.shouldLog(0)) {
                GroupCommunication.log("Transport initialization failed.", exception);
            }
            throw new GroupException(GroupCommunication.EXP_GRP_SOCKETINITFAIL, exception);
        }
    }

    static boolean nlinit() {
        boolean bl;
        block5: {
            bl = false;
            ServerSocket serverSocket = null;
            try {
                serverSocket = Transport.createServerSocket(Transport.localNLAddress.port, localNLAddress.getIPString());
                nlistener = new ServerSocketEndPoint(localNLAddress, serverSocket);
                Transport.nlistener.handler = new NodeListener(nlistener);
                Transport.nlistener.handler.start();
                Transport.waitUtilNodeListenIsUp(localNLAddress, NODE_LISTENER_STARTUP_TIMEOUT);
                FailureDetector.setNodeListenerHostname(localNLAddress.getHostName());
                bl = true;
            }
            catch (Exception exception) {
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                nlistener = null;
                if (!GroupCommunication.shouldLog(7)) break block5;
                GroupCommunication.log("Unable to start Node Listener at port:" + localNLAddress.getPort() + ". " + exception.getMessage());
            }
        }
        return bl;
    }

    static void waitUtilNodeListenIsUp(Address address, long l) throws GroupException {
        boolean bl = false;
        long l2 = System.currentTimeMillis();
        while (!bl) {
            try {
                Transport.getCoordinatorFromANodeListener(address);
                bl = true;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (System.currentTimeMillis() - l2 <= l) continue;
            throw new GroupException("Timeout while waiting for Node Listener to be available.");
        }
    }

    static int findEmptySlot(Vector vector) throws GroupException {
        int n;
        if (vector == null) {
            throw new GroupException(GroupCommunication.EXP_GRP_INTERNAL + GroupCommunication.EXP_GRP_INVALIDPAR);
        }
        BitSet bitSet = new BitSet();
        for (n = 0; n < vector.size(); ++n) {
            Address address = (Address)vector.elementAt(n);
            bitSet.set(address.getPosition());
        }
        for (n = 0; n < vector.size(); ++n) {
            if (bitSet.get(n)) continue;
            return n;
        }
        return vector.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isNLStarted() {
        Object object = nodeListernerLock;
        synchronized (object) {
            return nlistener != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stopNodeListener() {
        Object object = nodeListernerLock;
        synchronized (object) {
            if (nlistener != null) {
                block6: {
                    try {
                        nlistener.close();
                    }
                    catch (Exception exception) {
                        if (!GroupCommunication.shouldLog(3)) break block6;
                        GroupCommunication.log("Node Listener termination error. " + exception);
                    }
                }
                nlistener = null;
            }
            Transport.clearElectionVoteBuffer();
        }
    }

    static Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return Transport.createSocket(inetAddress, n, s_timeout);
    }

    static Socket createSocket(InetAddress inetAddress, int n, int n2) throws IOException {
        GroupSocketOpener groupSocketOpener = s_config.getSSLEnabled() ? new GroupSocketOpener(inetAddress, n, n2, true) : new GroupSocketOpener(inetAddress, n, n2, false);
        Socket socket = groupSocketOpener.createSocket();
        return socket;
    }

    static ServerSocket createServerSocket(int n, String string) throws IOException {
        ServerSocket serverSocket;
        InetAddress inetAddress = null;
        inetAddress = string != null ? InetAddress.getByName(string) : InetAddress.getLocalHost();
        if (s_config.getSSLEnabled()) {
            SSLManager sSLManager = SSLManager.getInstance();
            serverSocket = sSLManager.createSSLServerSocket(n, BACKLOG, inetAddress);
        } else {
            serverSocket = new ServerSocket(n, BACKLOG, inetAddress);
        }
        return serverSocket;
    }

    static ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress, boolean bl, int[] nArray) throws IOException, GroupException {
        int n3;
        InetAddress inetAddress2 = null;
        ServerSocket serverSocket = null;
        int n4 = n2 - n + 1;
        BitSet bitSet = null;
        int n5 = 0;
        Random random = new Random(System.currentTimeMillis());
        if (n4 <= 0) {
            throw new GroupException("Invalid port range: " + n + "-" + n2);
        }
        bitSet = new BitSet(n4);
        for (n3 = 0; n3 < n4; ++n3) {
            bitSet.set(n3);
        }
        if (nArray != null) {
            for (n3 = 0; n3 < nArray.length; ++n3) {
                int n6 = nArray[n3];
                if (n > n6 || n6 > n2) continue;
                bitSet.clear(n6 - n);
            }
        }
        inetAddress2 = inetAddress != null ? inetAddress : InetAddress.getLocalHost();
        n3 = random.nextInt(n4);
        while (!Transport.isBitSetEmpty(bitSet)) {
            while (!bitSet.get(n3)) {
                n3 = random.nextInt(n4);
            }
            n5 = n + n3;
            try {
                if (bl) {
                    SSLManager sSLManager = SSLManager.getInstance();
                    serverSocket = sSLManager.createSSLServerSocket(n5, BACKLOG, inetAddress2);
                } else {
                    serverSocket = new ServerSocket(n5, BACKLOG, inetAddress2);
                }
                if (n5 == 0 && Transport.arrayContains(nArray, serverSocket.getLocalPort())) continue;
                break;
            }
            catch (IOException iOException) {
                bitSet.clear(n3);
            }
        }
        if (serverSocket == null) {
            throw new GroupException("Unable to create server socket within port range:" + n + "-" + n2);
        }
        return serverSocket;
    }

    private static boolean isBitSetEmpty(BitSet bitSet) {
        boolean bl = true;
        for (int i = 0; i < bitSet.length(); ++i) {
            if (!bitSet.get(i)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private static boolean arrayContains(int[] nArray, int n) {
        boolean bl = false;
        if (nArray == null) {
            return bl;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static int[] getAllPortsFrom(Vector vector, InetAddress inetAddress) {
        int[] nArray = null;
        if (vector != null) {
            int n;
            Vector<Integer> vector2 = new Vector<Integer>();
            for (n = 0; n < vector.size(); ++n) {
                Address address;
                Object e = vector.elementAt(n);
                if (e == null || !(e instanceof Address) || (address = (Address)e).getIPString() != null && !address.getIPString().equals(inetAddress.getHostAddress())) continue;
                vector2.addElement(new Integer(address.getPort()));
            }
            n = vector2.size();
            if (n > 0) {
                nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = (Integer)vector2.elementAt(i);
                }
            }
        }
        return nArray;
    }

    static boolean connect(Address address, Address address2) {
        EndPoint endPoint = null;
        EndPoint endPoint2 = null;
        boolean bl = false;
        try {
            FailureDetector.setCoordinator(address2);
            FailureDetector.setNodeListenerHostname(address.getHostName());
            Socket socket = Transport.createSocket(address2.ip, address2.port);
            endPoint = new EndPoint(address2, socket);
            endPointList.put(address2, endPoint);
            Packet packet = new Packet(3, 0, Transport.ssep.addr, null, null);
            if (GroupCommunication.shouldLog(10)) {
                GroupCommunication.log("Register myself to the coordinator at " + address2);
            }
            endPoint.write(packet);
            Packet packet2 = endPoint.read();
            if (packet2 == null) {
                throw new GroupException(GroupCommunication.EXP_GRP_INTERNAL + GroupCommunication.EXP_GRP_REPLYISNULL);
            }
            addrList.clear();
            addrList.addAll(((View)packet2.message).getMembers());
            Address address3 = (Address)addrList.lastElement();
            if (address3.equals(Transport.ssep.addr)) {
                Transport.ssep.addr.setPosition(address3.getPosition());
                Transport.ssep.addr.setUid(address3.getUid());
                Transport.ssep.addr.setTimeStamp(address3.getTimeStamp());
                if (address3.getUid() > Address.getGUid()) {
                    Address.setGUid(address3.getUid());
                }
            } else {
                throw new GroupException(GroupCommunication.EXP_GRP_INTERNAL + GroupCommunication.EXP_GRP_INVALIDPAR);
            }
            if (addrList == null) {
                throw new GroupException(GroupCommunication.EXP_GRP_INTERNAL + GroupCommunication.EXP_GRP_INVALIDPAR);
            }
            packet = new Packet(3, 0, Transport.ssep.addr, (Serializable)((Object)GroupManager.SYSTEM_GROUP), null);
            Enumeration enumeration = addrList.elements();
            Address address4 = null;
            while (enumeration.hasMoreElements()) {
                address4 = (Address)enumeration.nextElement();
                if (Transport.isMyself(address4) || address4.equals(FailureDetector.getCoordinator())) continue;
                try {
                    Socket socket2 = Transport.createSocket(address4.ip, address4.port);
                    int n = socket2.getSoTimeout();
                    socket2.setSoTimeout(s_timeout);
                    endPoint2 = new EndPoint(address4, socket2);
                    endPoint2.write(packet);
                    packet2 = endPoint2.read();
                    socket2.setSoTimeout(n);
                    endPoint2.handler = new Receiver(endPoint2);
                    endPoint2.handler.start();
                    endPointList.put(address4, endPoint2);
                }
                catch (Exception exception) {
                    if (!GroupCommunication.shouldLog(10)) continue;
                    GroupCommunication.log("Can't establish connection to a cache member at " + address4 + ". " + exception.getMessage());
                }
            }
            packet = new Packet(5, 0, Transport.ssep.addr, address, null);
            endPoint2 = (EndPoint)endPointList.get(FailureDetector.getCoordinator());
            int n = endPoint2.s.getSoTimeout();
            endPoint2.s.setSoTimeout(s_timeout);
            endPoint2.write(packet);
            packet2 = endPoint2.read();
            if (packet2 == null) {
                throw new GroupException(GroupCommunication.EXP_GRP_INTERNAL + GroupCommunication.EXP_GRP_REPLYISNULL);
            }
            Serializable serializable = packet2.message;
            while (!(serializable instanceof View)) {
                if (GroupCommunication.shouldLog(15)) {
                    GroupCommunication.log("Expected a view object from " + FailureDetector.getCoordinator().toString(true) + ". Got: " + serializable.getClass().getName() + ". Ignores packet: " + packet2);
                }
                packet2 = endPoint2.read();
                serializable = packet2.message;
            }
            endPoint2.s.setSoTimeout(n);
            addrList.clear();
            addrList.addAll(((View)serializable).getMembers());
            GroupManager.initView((View)serializable);
            endPoint2.handler = new Receiver(endPoint2);
            endPoint2.handler.start();
            GroupManager.flush(packet2);
            bl = true;
        }
        catch (Exception exception) {
            if (GroupCommunication.shouldLog(10)) {
                GroupCommunication.log("Failed to connect to coordinator at " + FailureDetector.getCoordinator(), exception);
            }
            FailureDetector.setCoordinator(null);
            FailureDetector.setNodeListenerHostname(null);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Address getCoordinatorFromANodeListener(Address address) throws GroupException {
        Address address2 = null;
        Socket socket = null;
        Packet packet = null;
        Packet packet2 = null;
        try {
            try {
                socket = Transport.createSocket(address.ip, address.port);
                socket.setSoTimeout(s_timeout);
                StreamHandler streamHandler = new StreamHandler(socket);
                packet = new Packet(1, 0, Transport.ssep.addr, null, null);
                streamHandler.write(packet);
                packet2 = streamHandler.read();
                Serializable serializable = packet2.message;
                if (serializable != null && serializable instanceof Address) {
                    address2 = (Address)serializable;
                }
            }
            catch (Exception exception) {
                throw new GroupException(GroupCommunication.EXP_GRP_INTERNAL + GroupCommunication.EXP_GRP_REPLYISNULL);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (socket == null) throw throwable;
                socket.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (socket == null) return address2;
        socket.close();
        return address2;
    }

    static void sendElectionVoteTo(Address address, ElectionNotification electionNotification) {
        Socket socket = null;
        Packet packet = null;
        StreamHandler streamHandler = null;
        try {
            socket = Transport.createSocket(address.ip, address.port);
            socket.setSoLinger(false, 1);
            socket.setSoTimeout(s_timeout);
            streamHandler = new StreamHandler(socket);
            packet = new Packet(18, 0, Transport.getLocalAddress(), null, electionNotification);
            streamHandler.write(packet);
            streamHandler.read();
            if (GroupCommunication.shouldLog(15)) {
                GroupCommunication.log("Sent vote: " + electionNotification + " to " + address.toString(true));
            }
        }
        catch (Exception exception) {
            if (GroupCommunication.shouldLog(15)) {
                GroupCommunication.log("Unable to send vote: " + electionNotification + " to " + address.toString(true));
            }
            try {
                if (streamHandler != null) {
                    streamHandler.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    static Address[] getASortedAddressList(Vector vector) {
        Address[] addressArray = null;
        if (vector == null || vector.size() <= 0) {
            return null;
        }
        TreeSet treeSet = new TreeSet(vector);
        addressArray = new Address[treeSet.size()];
        treeSet.toArray(addressArray);
        return addressArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void terminateNodeListenerAt(Address address) throws GroupException {
        Socket socket = null;
        Packet packet = null;
        Packet packet2 = null;
        try {
            try {
                socket = Transport.createSocket(address.ip, address.port);
                socket.setSoTimeout(s_timeout);
                StreamHandler streamHandler = new StreamHandler(socket);
                packet = new Packet(23, 0, Transport.ssep.addr, null, null);
                streamHandler.write(packet);
                packet2 = streamHandler.read();
            }
            catch (Exception exception) {
                throw new GroupException("Unable to terminate Node Listener at " + address.toString(true), exception);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                if (socket == null) throw throwable;
                socket.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (socket == null) return;
        socket.close();
        return;
    }

    public static void term() {
        Object object;
        terminated = true;
        if (sender != null) {
            sender.stopit();
            sender = null;
            asQ = null;
        }
        receivingQList.clear();
        Transport.stopNodeListener();
        try {
            object = new Packet(20, 0, Transport.ssep.addr, (Serializable)((Object)GroupManager.SYSTEM_GROUP), null);
            Transport.multicast((Packet)object, true);
            Thread.sleep(600L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = endPointList.elements();
        while (object.hasMoreElements()) {
            try {
                EndPoint endPoint = (EndPoint)object.nextElement();
                endPoint.close();
                endPoint.handler.join(2000L);
            }
            catch (Exception exception) {}
        }
        try {
            ssep.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        endPointList.clear();
        addrList.clear();
        receivingQList.clear();
    }

    public static void send(Packet packet) throws GroupException, IOException, InterruptedException {
        if (terminated) {
            throw new GroupException(GroupCommunication.EXP_GRP_NOTINITIALIZED);
        }
        if (tg.equals(Thread.currentThread().getThreadGroup()) && (packet.type == 17 || packet.type == 11)) {
            Job job = new Job(0, packet);
            asQ.enqueue(job);
        } else {
            Transport.syncSend(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncSend(Packet packet) throws GroupException, IOException, InterruptedException {
        boolean bl = false;
        EndPoint endPoint = (EndPoint)endPointList.get((Address)packet.destination);
        if (endPoint == null) {
            throw new GroupException(GroupCommunication.EXP_GRP_NOCONNECTION + packet.destination);
        }
        GroupManager.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
        MessageBuffer messageBuffer = GroupManager.getCurrentViewInfo(GroupManager.SYSTEM_GROUP).getMessageBuffer();
        GroupManager.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
        try {
            Object[] objectArray;
            GroupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
            bl = true;
            View view = GroupManager.getLatestViewInfo(GroupManager.SYSTEM_GROUP).getView();
            packet.vid = view.getVid();
            packet.receiverIndex = view.getMembers().indexOf((Address)packet.destination);
            packet.receiverPosition = ((Address)packet.destination).getPosition();
            packet.senderIndex = view.getMembers().indexOf(Transport.getLocalAddress());
            if (messageBuffer.updated()) {
                objectArray = messageBuffer.getReceiveVector();
                packet.setReceiveArray((long[])objectArray);
                packet.setReceivedTONumber(messageBuffer.getReceivedTONumber());
            }
            objectArray = endPoint.lock;
            synchronized (endPoint.lock) {
                endPoint.write(packet);
                endPoint.counter += packet.getSize();
                if (endPoint.counter >= (long)CLEAN_INTERVAL) {
                    endPoint.reset();
                    endPoint.counter = 0L;
                }
                // ** MonitorExit[var5_6 /* !! */ ] (shouldn't be in output)
                if (GroupCommunication.shouldLog(15)) {
                    GroupCommunication.log("syncSend: " + packet);
                } else if (GroupCommunication.shouldLog(10) && packet != null) {
                    GroupCommunication.log("syncSend: " + packet.getType() + " to " + endPoint.addr.toString(true));
                }
            }
        }
        catch (IOException iOException) {
            if (GroupCommunication.shouldLog(6)) {
                GroupCommunication.log("syncSend Warning: " + iOException.getMessage() + ". ep:" + endPoint);
            }
            throw iOException;
        }
        finally {
            if (bl) {
                GroupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
            }
        }
        {
            return;
        }
    }

    public static ReplyInfo sendTotalOrderedMsg(Packet packet) throws GroupException, IOException, InterruptedException {
        if (terminated) {
            throw new GroupException(GroupCommunication.EXP_GRP_NOTINITIALIZED);
        }
        if (!tg.equals(Thread.currentThread().getThreadGroup())) {
            return Transport.syncSendTotalOrderedMsg(packet);
        }
        Job job = new Job(1, packet);
        asQ.enqueue(job);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReplyInfo syncSendTotalOrderedMsg(Packet packet) throws GroupException, IOException, InterruptedException {
        ReplyInfo replyInfo;
        boolean bl = false;
        EndPoint endPoint = (EndPoint)endPointList.get(FailureDetector.getCoordinator());
        if (endPoint == null) {
            if (Transport.isMyself(FailureDetector.getCoordinator())) {
                Transport.multicastTotalOrderedMsg(packet);
            } else {
                throw new GroupException(GroupCommunication.EXP_GRP_NOCONNECTION + FailureDetector.getCoordinator());
            }
        }
        GroupManager.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
        MessageBuffer messageBuffer = GroupManager.getCurrentViewInfo(GroupManager.SYSTEM_GROUP).getMessageBuffer();
        GroupManager.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
        try {
            Object object;
            GroupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
            bl = true;
            View view = GroupManager.getLatestViewInfo(GroupManager.SYSTEM_GROUP).getView();
            packet.vid = view.getVid();
            packet.receiverIndex = view.getMembers().indexOf(FailureDetector.getCoordinator());
            packet.receiverPosition = FailureDetector.getCoordinator().getPosition();
            packet.senderIndex = view.getMembers().indexOf(Transport.getLocalAddress());
            messageBuffer.save(packet);
            if (messageBuffer.updated()) {
                object = messageBuffer.getReceiveVector();
                packet.setReceiveArray((long[])object);
                packet.setReceivedTONumber(messageBuffer.getReceivedTONumber());
            }
            object = endPoint.lock;
            synchronized (endPoint.lock) {
                endPoint.write(packet);
                endPoint.counter += packet.getSize();
                if (endPoint.counter >= (long)CLEAN_INTERVAL) {
                    endPoint.reset();
                    endPoint.counter = 0L;
                }
                // ** MonitorExit[var6_6 /* !! */ ] (shouldn't be in output)
                if (GroupCommunication.shouldLog(15)) {
                    GroupCommunication.log("syncSendTotalOrderedMsg packet: " + packet);
                }
                object = view.getMembers();
                replyInfo = new ReplyInfo(view);
                if (GroupCommunication.shouldLog(15)) {
                    GroupCommunication.log("syncSendTotalOrderedMsg: " + packet);
                } else if (GroupCommunication.shouldLog(10) && packet != null) {
                    GroupCommunication.log("syncSendTotalOrderedMsg: " + packet.getType() + " to " + endPoint.addr.toString(true));
                }
            }
        }
        catch (IOException iOException) {
            if (GroupCommunication.shouldLog(6)) {
                GroupCommunication.log("syncSendTotalOrderedMsg Warning: " + iOException.getMessage() + ". ep:" + endPoint + ", msg:" + packet);
            }
            throw iOException;
        }
        finally {
            if (bl) {
                GroupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
            }
        }
        {
            return replyInfo;
        }
    }

    public static ReplyInfo multicast(Packet packet) throws GroupException, IOException, InterruptedException {
        return Transport.multicast(packet, false);
    }

    private static ReplyInfo multicast(Packet packet, boolean bl) throws GroupException, IOException, InterruptedException {
        if (terminated && !bl) {
            throw new GroupException(GroupCommunication.EXP_GRP_NOTINITIALIZED);
        }
        if (!tg.equals(Thread.currentThread().getThreadGroup()) || packet.type != 17 && packet.type != 10 && packet.type != 20) {
            return Transport.syncMulticast(packet);
        }
        Job job = new Job(2, packet);
        asQ.enqueue(job);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static ReplyInfo syncMulticast(Packet packet) throws GroupException, IOException, InterruptedException {
        Object var1_1 = null;
        int n = 0;
        ReplyInfo replyInfo = null;
        boolean bl = false;
        try {
            Object object;
            GroupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
            bl = true;
            ViewInfo viewInfo = GroupManager.getLatestViewInfo((String)((Object)packet.destination));
            View view = viewInfo.getView();
            packet.vid = view.getVid();
            packet.senderIndex = view.getMembers().indexOf(Transport.getLocalAddress());
            MessageBuffer messageBuffer = viewInfo.getMessageBuffer();
            if (messageBuffer.updated()) {
                object = messageBuffer.getReceiveVector();
                packet.setReceiveArray((long[])object);
                packet.setReceivedTONumber(messageBuffer.getReceivedTONumber());
                messageBuffer.setUpdated(false);
            }
            object = view.getMembers();
            Vector vector = viewInfo.getEPList();
            Hashtable hashtable = Transport.getEndPointList();
            if (object == null) throw new GroupException(GroupCommunication.EXP_GRP_NOGROUPINFO);
            if (vector == null) {
                throw new GroupException(GroupCommunication.EXP_GRP_NOGROUPINFO);
            }
            for (n = 0; n < ((Vector)object).size(); ++n) {
                packet.receiverIndex = n;
                Address address = (Address)((Vector)object).elementAt(n);
                packet.receiverPosition = address.getPosition();
                if (!Transport.isMyself(address)) {
                    EndPoint endPoint = (EndPoint)hashtable.get(address);
                    if (endPoint != null) {
                        block16: {
                            byte[] byArray = endPoint.lock;
                            // MONITORENTER : endPoint.lock
                            try {
                                endPoint.write(packet);
                                endPoint.counter += packet.getSize();
                                if (endPoint.counter >= (long)CLEAN_INTERVAL) {
                                    endPoint.reset();
                                    endPoint.counter = 0L;
                                }
                            }
                            catch (Exception exception) {
                                if (!GroupCommunication.shouldLog(6)) break block16;
                                GroupCommunication.log("Warning: Can't send msg from " + Transport.ssep.addr + " to " + endPoint.addr + " :" + exception);
                            }
                        }
                        // MONITOREXIT : byArray
                        continue;
                    }
                    if (GroupCommunication.shouldLog(6)) {
                        GroupCommunication.log("Warning, no connection to " + address);
                    }
                    if (!GroupCommunication.shouldLog(15)) continue;
                    GroupCommunication.log("Unable to send [" + packet + "] to [" + address + "]");
                    continue;
                }
                replyInfo = new ReplyInfo(view);
            }
            if (GroupCommunication.shouldLog(15)) {
                GroupCommunication.log("syncMulticast: " + packet + " in view:" + view.getVid());
                return replyInfo;
            }
            if (!GroupCommunication.shouldLog(10)) return replyInfo;
            if (packet == null) return replyInfo;
            GroupCommunication.log("syncMulticast: " + packet.getType() + " in view: " + view.getVid());
            return replyInfo;
        }
        finally {
            if (bl) {
                GroupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
            }
        }
    }

    public static synchronized ReplyInfo multicastTotalOrderedMsg(Packet packet) throws GroupException, IOException, InterruptedException {
        if (terminated) {
            throw new GroupException(GroupCommunication.EXP_GRP_NOTINITIALIZED);
        }
        packet.setSequenceNumber(Packet.incSequencer());
        if (!tg.equals(Thread.currentThread().getThreadGroup())) {
            return Transport.syncMulticastTotalOrderedMsg(packet);
        }
        Job job = new Job(3, packet);
        asQ.enqueue(job);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static synchronized ReplyInfo syncMulticastTotalOrderedMsg(Packet packet) throws GroupException, IOException, InterruptedException {
        Object var1_1 = null;
        int n = 0;
        int n2 = 0;
        ReplyInfo replyInfo = null;
        boolean bl = false;
        try {
            Vector vector;
            Vector vector2;
            Object[] objectArray;
            MessageBuffer messageBuffer;
            View view;
            ViewInfo viewInfo;
            if (packet.getVid() == -1) {
                GroupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
                bl = true;
                viewInfo = GroupManager.getLatestViewInfo((String)((Object)packet.destination));
                view = viewInfo.getView();
                packet.vid = view.getVid();
                packet.senderIndex = view.getMembers().indexOf(Transport.getLocalAddress());
                packet.fromMyself = true;
                messageBuffer = viewInfo.getMessageBuffer();
                messageBuffer.save(packet);
                Receiver.deliver(packet, messageBuffer);
                if (messageBuffer.updated()) {
                    objectArray = messageBuffer.getReceiveVector();
                    packet.setReceiveArray((long[])objectArray);
                    packet.setReceivedTONumber(messageBuffer.getReceivedTONumber());
                    messageBuffer.setUpdated(false);
                }
                vector2 = view.getMembers();
                vector = viewInfo.getEPList();
                if (vector2 == null) throw new GroupException(GroupCommunication.EXP_GRP_NOGROUPINFO);
                if (vector == null) {
                    throw new GroupException(GroupCommunication.EXP_GRP_NOGROUPINFO);
                }
            } else {
                GroupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
                bl = true;
                viewInfo = GroupManager.getLatestViewInfo(GroupManager.SYSTEM_GROUP);
                view = viewInfo.getView();
                messageBuffer = viewInfo.getMessageBuffer();
                vector2 = view.getMembers();
                vector = viewInfo.getEPList();
                viewInfo = GroupManager.getViewInfo(GroupManager.SYSTEM_GROUP, packet.getVid());
                if (viewInfo != null) {
                    messageBuffer = viewInfo.getMessageBuffer();
                    messageBuffer.save(packet);
                }
                if (vector2 == null) throw new GroupException(GroupCommunication.EXP_GRP_NOGROUPINFO);
                if (vector == null) {
                    throw new GroupException(GroupCommunication.EXP_GRP_NOGROUPINFO);
                }
            }
            for (n = 0; n < vector2.size(); ++n) {
                packet.receiverIndex = n;
                packet.receiverPosition = ((Address)vector2.elementAt(n)).getPosition();
                if (!Transport.isMyself((Address)vector2.elementAt(n))) {
                    if (n2 < vector.size()) {
                        EndPoint endPoint = (EndPoint)vector.elementAt(n2);
                        if (endPoint != null) {
                            block20: {
                                objectArray = endPoint.lock;
                                // MONITORENTER : endPoint.lock
                                try {
                                    endPoint.write(packet);
                                    endPoint.counter += packet.getSize();
                                    if (endPoint.counter >= (long)CLEAN_INTERVAL) {
                                        endPoint.reset();
                                        endPoint.counter = 0L;
                                    }
                                }
                                catch (Exception exception) {
                                    if (!GroupCommunication.shouldLog(6)) break block20;
                                    GroupCommunication.log("Warning: Can't send msg from " + Transport.ssep.addr + " to " + var1_1 + " :" + exception);
                                }
                            }
                            // MONITOREXIT : objectArray
                        }
                        ++n2;
                        continue;
                    }
                    if (!GroupCommunication.shouldLog(15)) continue;
                    GroupCommunication.log("Warning, no connection to " + vector2.elementAt(n));
                    continue;
                }
                replyInfo = new ReplyInfo(view);
            }
            if (GroupCommunication.shouldLog(15)) {
                GroupCommunication.log("syncMulticastTotalOrderedMsg: " + packet + " in view:" + view.getVid());
                return replyInfo;
            }
            if (!GroupCommunication.shouldLog(10)) return replyInfo;
            if (packet == null) return replyInfo;
            GroupCommunication.log("syncMulticastTotalOrderedMsg: " + packet.getType() + " to view: " + view.getVid());
            return replyInfo;
        }
        finally {
            if (bl) {
                GroupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
            }
        }
    }

    public static void registerReceivingQueue(String string, MessageQueue messageQueue) {
        receivingQList.put(string, messageQueue);
    }

    public static void deregisterReceivingQueue(String string, MessageQueue messageQueue) {
        receivingQList.remove(string);
    }

    static void removeAddress(Address address) {
        if (address != null) {
            addrList.removeElement(address);
            endPointList.remove(address);
        }
    }

    static void removeEndPoint(Address address) {
        if (address != null) {
            endPointList.remove(address);
        }
    }

    static boolean isMyself(Address address) {
        return Transport.ssep.addr.equals(address);
    }

    static synchronized void setAddrList(Vector vector) {
        addrList = new Vector(vector);
    }

    static synchronized Vector getAddrList() {
        return new Vector(addrList);
    }

    static Hashtable getEndPointList() {
        return endPointList;
    }

    static Address getLocalAddress() {
        return Transport.ssep.addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean startNodeListener() {
        boolean bl = false;
        Object object = nodeListernerLock;
        synchronized (object) {
            bl = nlistener == null ? Transport.nlinit() : true;
        }
        return bl;
    }

    static boolean isReady() {
        return !initializing;
    }

    static boolean isNLDeathDetectable() {
        return s_config.isNLDeathDetected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addElectionVote(ElectionNotification electionNotification) {
        Vector vector = electionVotes;
        synchronized (vector) {
            if (enableColletingVotes) {
                electionVotes.addElement(electionNotification);
                electionVotes.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearElectionVoteBuffer() {
        Vector vector = electionVotes;
        synchronized (vector) {
            electionVotes.clear();
        }
    }

    static void toEnableCollectingVotes(boolean bl) {
        enableColletingVotes = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ElectionNotification getACoordinatorVote() {
        ElectionNotification electionNotification = null;
        Vector vector = electionVotes;
        synchronized (vector) {
            try {
                electionVotes.wait(s_config.getMulticastInterval());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (electionVotes.size() > 0) {
                Object e = electionVotes.firstElement();
                if (e != null && e instanceof ElectionNotification) {
                    electionNotification = (ElectionNotification)e;
                }
                electionVotes.removeElementAt(0);
            }
        }
        return electionNotification;
    }

    static ThreadGroup getRTG() {
        return tg;
    }

    static void resetCleanInterval(int n) {
        if (n <= 1) {
            return;
        }
        CLEAN_INTERVAL = Math.round(4096 / (n - 1)) * 1024;
    }

    static {
        addrList = new Vector();
        endPointList = new Hashtable();
        nlistener = null;
        receivingQList = new Hashtable();
        localHost = null;
        TGNAME = new String("ReceiverThreadGroup");
        tg = new ThreadGroup(TGNAME);
        initializing = true;
        terminated = false;
        asQ = null;
        sender = null;
        broadcaster = null;
        resolver = null;
        electionVotes = null;
        enableColletingVotes = false;
        localNLAddress = null;
        nodeListernerLock = new Object();
    }
}

