/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.InputStream;
import java.io.OutputStream;
import oracle.net.ano.Ano;
import oracle.net.ns.ClientProfile;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;
import oracle.net.ns.SQLnetDef;
import oracle.net.nt.ConnOption;
import oracle.net.nt.NTAdapter;

public class SessionAtts
implements SQLnetDef {
    private int sdu;
    private int tdu;
    protected NTAdapter nt;
    protected InputStream ntInputStream;
    protected OutputStream ntOutputStream;
    protected NetInputStream nsInputStream;
    protected NetOutputStream nsOutputStream;
    protected ConnOption cOption;
    protected boolean dataEOF;
    protected boolean connected;
    public boolean onBreakReset;
    public ClientProfile profile;
    public Ano ano;
    public boolean anoEnabled;
    public boolean isEncryptionActive;
    public boolean isChecksumActive;
    public boolean areEncryptionAndChecksumActive;

    public SessionAtts(int n, int n2) {
        this.sdu = n;
        this.tdu = n2;
    }

    public void setSDU(int n) {
        if (n <= 0) {
            this.sdu = 2048;
            return;
        }
        if (n > Short.MAX_VALUE) {
            this.sdu = Short.MAX_VALUE;
            return;
        }
        if (n < 512) {
            this.sdu = 512;
            return;
        }
        this.sdu = n;
    }

    public int getSDU() {
        return this.sdu;
    }

    public void setTDU(int n) {
        if (n <= 0) {
            this.tdu = Short.MAX_VALUE;
            return;
        }
        if (n > Short.MAX_VALUE) {
            this.tdu = Short.MAX_VALUE;
            return;
        }
        if (n < 255) {
            this.tdu = 255;
            return;
        }
        this.tdu = n;
    }

    public int getTDU() {
        return this.tdu;
    }

    public void print() {
        System.out.println("Session Attributes: ");
        System.out.println("sdu            : " + this.sdu);
        System.out.println("tdu            : " + this.tdu);
        System.out.println("nt             : " + this.nt);
        System.out.println("ntInputStream  : " + this.ntInputStream);
        System.out.println("ntOutputStream : " + this.ntOutputStream);
        System.out.println("nsInputStream  : " + this.nsInputStream);
        System.out.println("nsOutputStream : " + this.nsOutputStream);
        System.out.println("profile        : " + this.profile);
        System.out.println("cOption        : " + this.cOption);
        System.out.println("onBreakReset   : " + this.onBreakReset);
        System.out.println("dataEOF        : " + this.dataEOF);
        System.out.println("connected      : " + this.connected);
    }

    public void turnEncryptionOn(NetInputStream netInputStream, NetOutputStream netOutputStream) throws NetException {
        if (netInputStream != null && netOutputStream != null) {
            this.nsInputStream = netInputStream;
            this.nsOutputStream = netOutputStream;
            return;
        }
        throw new NetException(300);
    }

    public int getANOFlags() {
        int n = 1;
        if (this.ano != null) {
            n = this.ano.getNAFlags();
        }
        return n;
    }

    public OutputStream getOutputStream() {
        return this.nsOutputStream;
    }

    public InputStream getInputStream() {
        return this.nsInputStream;
    }
}

