/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.fixup;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipcf.OipcfExecuteFixUpRuleException;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;

public class RunlevelFixes {
    public static final String CHANGE_CURRENT_RUNLEVEL = "CHANGE_CURRENT_RUNLEVEL";
    public static final String DESIRED_CURRENT_RUNLEVEL = "DESIRED_CURRENT_RUNLEVEL";
    public static final String CHANGE_DEFAULT_RUNLEVEL = "CHANGE_DEFAULT_RUNLEVEL";
    public static final String DESIRED_DEFAULT_RUNLEVEL = "DESIRED_DEFAULT_RUNLEVEL";
    public static final String ENABLE_STRING = "\"true\"";
    public static final String EQUALS = "=";

    public static OipcfFixUpResult enableDefaultRunlevelChange(OipcrIRulesEngine re, String refhost, OipcrIResult res, ArrayList outfiles) {
        return RunlevelFixes.enableRunlevelChange(re, refhost, res, outfiles, true);
    }

    public static OipcfFixUpResult enableCurrentRunlevelChange(OipcrIRulesEngine re, String refhost, OipcrIResult res, ArrayList outfiles) {
        return RunlevelFixes.enableRunlevelChange(re, refhost, res, outfiles, false);
    }

    public static OipcfFixUpResult enableRunlevelChange(OipcrIRulesEngine re, String refhost, OipcrIResult res, ArrayList outfiles, boolean bDefault) {
        OipcfFixUpResult oFixUpResult;
        String sResponseFile = (String)outfiles.get(0);
        String sEnableFile = (String)outfiles.get(1);
        if (sResponseFile == null || !new File(sResponseFile).exists()) {
            OipcfFixUpResult oFixUpResult2 = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-002", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-002")), (List)outfiles);
            return oFixUpResult2;
        }
        if (sEnableFile == null || !new File(sEnableFile).exists()) {
            OipcfFixUpResult oFixUpResult3 = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-001", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-001")), (List)outfiles);
            return oFixUpResult3;
        }
        StringBuffer sRunlevelBuffer = new StringBuffer();
        Iterator iter = null;
        if (res == null) {
            OipcfFixUpResult oFixUpResult4 = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-003", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-003")), (List)outfiles);
            return oFixUpResult4;
        }
        iter = res.getResultDetails();
        if (iter.hasNext()) {
            OipcrResultDetails oResultDetails = (OipcrResultDetails)iter.next();
            if (oResultDetails.getResult() != 1) {
                String sExpectedRunlevel = (String)oResultDetails.getExpectedData();
                if (sExpectedRunlevel == null) {
                    OipcfFixUpResult oFixUpResult5 = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-004", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-004")), (List)outfiles);
                    return oFixUpResult5;
                }
                sRunlevelBuffer.append(sExpectedRunlevel);
            }
        }
        try {
            RunlevelFixes.instantiateEnableFile(sEnableFile, bDefault);
        }
        catch (IOException e) {
            oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException((Throwable)e), (List)outfiles);
            return oFixUpResult;
        }
        try {
            RunlevelFixes.instantiateResponseFile(sResponseFile, sRunlevelBuffer.toString(), bDefault);
        }
        catch (IOException e) {
            oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException((Throwable)e), (List)outfiles);
            return oFixUpResult;
        }
        return new OipcfFixUpResult(OipcfFixUpResult.PASSED);
    }

    protected static void instantiateEnableFile(String sEnableFile, boolean bDefault) throws IOException {
        String line;
        File oFile = new File(sEnableFile);
        String changeRunlevelString = bDefault ? CHANGE_DEFAULT_RUNLEVEL : CHANGE_CURRENT_RUNLEVEL;
        BufferedReader br = new BufferedReader(new FileReader(oFile));
        ArrayList<String> fileContentsList = new ArrayList<String>();
        try {
            while ((line = br.readLine()) != null) {
                fileContentsList.add(line);
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{sEnableFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-005", (Object[])args));
        }
        boolean bCheck = false;
        for (int i = 0; i < fileContentsList.size(); ++i) {
            line = (String)fileContentsList.get(i);
            if (!line.startsWith(changeRunlevelString)) continue;
            line = changeRunlevelString + EQUALS + ENABLE_STRING;
            fileContentsList.set(i, line);
            bCheck = true;
            break;
        }
        if (!bCheck) {
            line = changeRunlevelString + EQUALS + ENABLE_STRING;
            fileContentsList.add(line);
        }
        try {
            RunlevelFixes.writeToFile(sEnableFile, fileContentsList);
        }
        catch (IOException e) {
            Object[] args = new String[]{sEnableFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-006", (Object[])args));
        }
    }

    protected static void instantiateResponseFile(String sResponseFile, String desiredRunlevel, boolean bDefault) throws IOException {
        File oFile = new File(sResponseFile);
        BufferedReader br = new BufferedReader(new FileReader(oFile));
        String desiredRunlevelString = bDefault ? DESIRED_DEFAULT_RUNLEVEL : DESIRED_CURRENT_RUNLEVEL;
        StringTokenizer st = new StringTokenizer(desiredRunlevel, ",");
        String desiredRunLevel = "";
        if (st.hasMoreTokens()) {
            desiredRunLevel = st.nextToken();
        }
        ArrayList<String> fileContentsList = new ArrayList<String>();
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                fileContentsList.add(line);
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{sResponseFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-005", (Object[])args));
        }
        boolean bCheck = false;
        for (int i = 0; i < fileContentsList.size(); ++i) {
            line = (String)fileContentsList.get(i);
            if (!line.startsWith(desiredRunlevelString)) continue;
            line = desiredRunlevelString + EQUALS + desiredRunLevel;
            fileContentsList.set(i, line);
            bCheck = true;
            break;
        }
        if (!bCheck) {
            line = desiredRunlevelString + EQUALS + desiredRunLevel;
            fileContentsList.add(line);
        }
        try {
            RunlevelFixes.writeToFile(sResponseFile, fileContentsList);
        }
        catch (IOException e) {
            Object[] args = new String[]{sResponseFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-006", (Object[])args));
        }
    }

    private static void writeToFile(String sFile, ArrayList fileContentsList) throws IOException {
        File oFile = new File(sFile);
        BufferedWriter bw = new BufferedWriter(new FileWriter(oFile));
        for (int i = 0; i < fileContentsList.size(); ++i) {
            String line = (String)fileContentsList.get(i);
            bw.write(line, 0, line.length());
            bw.newLine();
        }
        bw.close();
    }
}

