/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.helper.helper10205;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.ops.mgmt.asm.ASM;
import oracle.ops.mgmt.asm.ASMConfigurationException;
import oracle.ops.mgmt.asm.ASMInstance;
import oracle.ops.mgmt.asm.ASMInstanceException;
import oracle.ops.mgmt.asm.ASMInstanceNotExistException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ListenerException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.Listener;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.nodeapps.config.NodeApps;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.helper.helper10205.CVUHelper;

public class CVUHelper10205
extends CVUHelper {
    public CVUHelper10205() {
        this.addCommandLineOption("-getCRSUser", 1, "getCRSUser", "gets the clusterware home user name");
        this.addCommandLineOption("-checkASMRunning", 2, "checkASMRunning", "check if ASM is running on nodes");
        this.addCommandLineOption("-getASMhome", 2, "getASMhome", "gets the ASM home on the given node");
        this.addCommandLineOption("-getASMsid", 2, "getASMsid", "gets the ASM sid on the given node");
        this.addCommandLineOption("-checkDefaultListener", 2, "checkDefaultListener", "checks if default listener for the node is running");
    }

    public int checkASMRunning(String[] args) {
        String[] nodeArray = args[1].split(",");
        boolean failNodes = false;
        boolean succNodes = false;
        MessageBundle msgBndl = MessageBundle.getMessageBundle((String)"Prko");
        for (int j = 0; j < nodeArray.length; ++j) {
            String[] insts;
            String node = nodeArray[j];
            try {
                insts = ASM.getInstances((String)node, (Version)new Version());
            }
            catch (ASMConfigurationException e) {
                this.displayErrorResult(e.getMessage(), 2);
                return 0;
            }
            String oh = null;
            ASMInstance asmInst = null;
            if (insts == null || insts.length == 0) {
                failNodes = true;
                this.displayWarningResult("<ASM_FAIL_NODE>" + node + "</ASM_FAIL_NODE>");
                continue;
            }
            for (int i = 0; i < insts.length; ++i) {
                try {
                    oh = ASM.getOracleHome((String)insts[i], (String)node, (Version)new Version());
                    asmInst = new ASMInstance(insts[i], node, oh, new Version());
                    if (!asmInst.isEnabled()) {
                        failNodes = true;
                        this.displayWarningResult("<ASM_FAIL_NODE>" + node + "</ASM_FAIL_NODE>");
                        continue;
                    }
                    if (asmInst.isRunning()) {
                        succNodes = true;
                        this.displaySuccessResult("<ASM_SUCC_NODE>" + node + "</ASM_SUCC_NODE>");
                        continue;
                    }
                    failNodes = true;
                    this.displayWarningResult("<ASM_FAIL_NODE>" + node + "</ASM_FAIL_NODE>");
                    continue;
                }
                catch (ASMInstanceException e) {
                    failNodes = true;
                    this.displayWarningResult("<ASM_FAIL_NODE>" + node + "</ASM_FAIL_NODE>");
                    continue;
                }
                catch (ASMConfigurationException e) {
                    failNodes = true;
                    this.displayWarningResult("<ASM_FAIL_NODE>" + node + "</ASM_FAIL_NODE>");
                }
            }
        }
        if (succNodes) {
            if (failNodes) {
                this.displayVRESStatus(1);
                return 0;
            }
            this.displayVRESStatus(0);
            return 0;
        }
        this.displayVRESStatus(2);
        return 0;
    }

    public int getASMhome(String[] args) {
        String asmHome = null;
        String node = args[1];
        try {
            String[] insts = ASM.getInstances((String)node, (Version)new Version());
            if (insts == null || insts.length == 0) {
                Trace.out((String)"Couldn't get the ASM instances configured for the given node");
                this.displayErrorResult("No configured ASM instance is found", 2);
                return 0;
            }
            asmHome = ASM.getOracleHome((String)insts[0], (String)node, (Version)new Version());
            this.displaySuccessResult(asmHome, 0);
            return 0;
        }
        catch (ASMConfigurationException e) {
            Trace.out((String)("Couldn't get ASM home. " + e.getMessage()));
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (ASMInstanceNotExistException e) {
            Trace.out((String)("Couldn't get ASM home. " + e.getMessage()));
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int getASMsid(String[] args) {
        Object asmHome = null;
        String node = args[1];
        try {
            String[] insts = ASM.getInstances((String)node, (Version)new Version());
            if (insts == null || insts.length == 0) {
                Trace.out((String)"Couldn't get the ASM instances configured for the given node");
                this.displayErrorResult("No configured ASM instance is found", 2);
                return 0;
            }
            this.displaySuccessResult(insts[0], 0);
            return 0;
        }
        catch (ASMConfigurationException e) {
            Trace.out((String)("Couldn't get ASM home. " + e.getMessage()));
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int checkDefaultListener(String[] args) {
        String node = args[1];
        try {
            Listener listnr = null;
            listnr = new Listener(node);
            if (listnr.exists() && listnr.isRunning()) {
                Trace.out((String)("Default listener " + listnr.getResourceName() + " was found configured and running on local node"));
                this.displaySuccessResult(node, 0);
                return 0;
            }
            NodeApps nodeApps = new NodeApps(node, new Version());
            String resourceRunningNode = nodeApps.nodeRunning(listnr.getResourceName());
            if (resourceRunningNode != null) {
                Trace.out((String)("Default listener " + listnr.getResourceName() + " was found configured but running on node " + resourceRunningNode));
                this.displaySuccessResult(resourceRunningNode, 0);
                return 0;
            }
            Trace.out((String)("Default listener " + listnr.getResourceName() + " was not found configured"));
            this.displayErrorResult("Default listener " + listnr.getResourceName() + " was not found configured", 2);
            return 0;
        }
        catch (ListenerException le) {
            Trace.out((String)("Caught ListenerException : " + le.getMessage()));
            this.displayErrorResult(le.getMessage(), 2);
            return 0;
        }
        catch (NodeException ne) {
            Trace.out((String)("Caught NodeException : " + ne.getMessage()));
            this.displayErrorResult(ne.getMessage(), 2);
            return 0;
        }
    }

    public int getCRSUser(String[] args) {
        String crsHome = System.getProperty("GI_HOME");
        try {
            Util hasUtil = new Util();
            this.displaySuccessResult(hasUtil.getOracleUser(crsHome, null), 0);
            return 0;
        }
        catch (UtilException e) {
            Trace.out((String)"Couldn't get oracle user");
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int processCommandLine(String methodName, String[] args) {
        String className = "oracle.ops.verification.helper.helper10205.CVUHelper10205";
        try {
            Class<?> helperClass = Class.forName(className);
            Class[] clsArr = new Class[]{args.getClass()};
            Method cmdMethod = helperClass.getMethod(methodName, clsArr);
            Object[] arglist = new Object[]{args};
            Integer retVal = (Integer)cmdMethod.invoke(helperClass.newInstance(), arglist);
            return retVal;
        }
        catch (NoSuchMethodException e) {
            this.displayExecutionError("Method " + methodName + " not found: " + e.getMessage());
            return 2;
        }
        catch (InstantiationException e) {
            this.displayExecutionError("error while instantiating method " + methodName + ": " + e.getMessage());
            return 2;
        }
        catch (ClassNotFoundException e) {
            this.displayExecutionError("Class " + className + " not found: " + e.getMessage());
            return 2;
        }
        catch (IllegalAccessException e) {
            this.displayExecutionError("Illegal Access while running method " + methodName + ": " + e.getMessage());
            return 2;
        }
        catch (InvocationTargetException e) {
            this.displayExecutionError("error while invoking method " + methodName + ": " + e.getMessage());
            return 2;
        }
    }

    public static void main(String[] args) {
        int retVal = 2;
        CVUHelper10205.setupTracing();
        Trace.out((String)"CVUHelper10205 main");
        CVUHelper10205 cvuHelper = new CVUHelper10205();
        String methodName = cvuHelper.parseArguments(args);
        if (methodName != null) {
            retVal = cvuHelper.processCommandLine(methodName, args);
            if (retVal != 2) {
                cvuHelper.displayExecutionSuccess();
            } else {
                cvuHelper.displayExecutionError("exception returned by method : " + args[0]);
            }
        } else {
            cvuHelper.displayExecutionError("Invalid commandline argument :" + args[0]);
        }
        Trace.out((String)"==== cvuhelper exiting normally.");
        System.exit(retVal);
    }
}

