/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.config.client;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Logger;
import oracle.install.config.client.SchedulerAgentInternalPlugIn;
import oracle.install.driver.oui.Configurable;
import oracle.install.driver.oui.config.ConfigAssistantParams;
import oracle.install.ivw.common.bean.OracleSetupBean;
import oracle.install.ivw.common.bean.WindowsSecureOptionSettings;
import oracle.install.library.util.PlatformInfo;

public class SchedulerAgentHelper {
    private static final Logger logger = Logger.getLogger(SchedulerAgentHelper.class.getName());
    public static final String WIN_SERVICE_USER_PASSWORD_FLAG_NAME = "s_winServiceUserPasswordFlag";
    public static final String WIN_SERVICE_USER_PASSWORD_NAME = "S_WINSERVICEUSERPASSWORD";
    public static final String WIN_SERVICE_USER_PASSWORD_VALUE = "${S_WINSERVICEUSERPASSWORD}";
    public static final String SchedulerAgent = "SchedulerAgent";

    public static ConfigAssistantParams constructConfigParams(Configurable configJob, OracleSetupBean setupBean) {
        WindowsSecureOptionSettings winSecureSettings;
        ConfigAssistantParams params = new ConfigAssistantParams(SchedulerAgent);
        PlatformInfo platformInfo = PlatformInfo.getInstance();
        LinkedList arguments = new LinkedList();
        HashMap<String, String> secretArguments = new HashMap<String, String>();
        configJob.setTransientParameter("oracle.rdbms.scheduler", WIN_SERVICE_USER_PASSWORD_FLAG_NAME, "");
        configJob.setTransientParameter("oracle.rdbms.scheduler", WIN_SERVICE_USER_PASSWORD_NAME, "");
        if (platformInfo.isWindows() && !(winSecureSettings = setupBean.getWindowsSecureOptionSettings()).isDeclineOption()) {
            secretArguments.put("-winServiceUserPassword", winSecureSettings.getPassword());
            configJob.setTransientParameter("oracle.rdbms.scheduler", WIN_SERVICE_USER_PASSWORD_FLAG_NAME, "-winServiceUserPassword");
            configJob.setTransientParameter("oracle.rdbms.scheduler", WIN_SERVICE_USER_PASSWORD_NAME, WIN_SERVICE_USER_PASSWORD_VALUE);
        }
        params.setSecretArguments(secretArguments);
        params.setSecretParamRegexMap(SchedulerAgentInternalPlugIn.secretParamRegexMap);
        return params;
    }
}

