/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.client.action;

import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.flow.Action;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.ivw.client.bean.ClientSetupBean;
import oracle.install.ivw.client.driver.ClientSetupDriver;
import oracle.install.ivw.common.bean.AutoUpdatesInstallSettings;
import oracle.install.ivw.common.util.autoupdates.UpdateManager;
import oracle.install.ivw.common.util.autoupdates.UpdatesRestartManager;

public class ClientStartAction
implements Action {
    private String scratchPathLoc = System.getProperty("oracle.installer.scratchPath");
    private static final Logger logger = Logger.getLogger(ClientStartAction.class.getName());

    public final void execute(FlowContext flowContext) {
        ClientSetupDriver setupDriver = (ClientSetupDriver)SetupDriver.getInstance();
        ClientSetupBean setupBean = setupDriver.getSetupBean();
        flowContext.addBean((Object)setupBean);
        flowContext.addBean((Object)setupBean.getCentralInventory());
        flowContext.addBean((Object)setupBean.getAutoUpdatesInstallSettings());
        flowContext.addBean((Object)setupBean.getWindowsSecureOptionSettings());
        flowContext.addBean((Object)setupBean.getClientInstallSettings());
        flowContext.addBean((Object)setupBean.getRootConfigurationSettings());
    }

    public final Route transition(FlowContext flowContext) {
        AutoUpdatesInstallSettings autoBean = (AutoUpdatesInstallSettings)flowContext.getBean(AutoUpdatesInstallSettings.class);
        ClientSetupDriver setupDriver = (ClientSetupDriver)SetupDriver.getInstance();
        ClientSetupBean setupBean = setupDriver.getSetupBean();
        UpdatesRestartManager.getInstance().prepareAutoBeanPostRestart(autoBean);
        setupBean.setAutoUpdatesInstallSettings(autoBean);
        flowContext.addBean((Object)setupBean.getAutoUpdatesInstallSettings());
        if (UpdateManager.getInstance().isStandAloneMode()) {
            return new Route("DOWNLOAD_UPDATES_ONLY");
        }
        return Route.SUCCESS;
    }
}

