/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.client.action;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.install.commons.base.util.ComponentConfig;
import oracle.install.commons.base.util.ComponentConfigBuilder;
import oracle.install.commons.flow.Action;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.annotation.UIRef;
import oracle.install.ivw.client.bean.ClientInstallSettings;

@UIRef(value="CustomInstallUI")
public class CustomInstallAction
implements Action {
    private Logger logger = Logger.getLogger(CustomInstallAction.class.getName());
    private final String COMPONENT_XML = "/oracle/install/ivw/client/resource/custom_components.xml";

    public final void execute(FlowContext flowContext) {
        ComponentConfig componentBean = this.getComponentBean();
        if (componentBean != null) {
            ClientInstallSettings installSettings = (ClientInstallSettings)((Object)flowContext.getBean(ClientInstallSettings.class));
            String[] componentIDs = installSettings.getCustomComponents();
            ComponentConfigBuilder builder = ComponentConfigBuilder.getInstance();
            builder.selectForInstall(componentBean, componentIDs);
        }
    }

    public Route transition(FlowContext flowContext) {
        ClientInstallSettings installSettings = (ClientInstallSettings)((Object)flowContext.getBean(ClientInstallSettings.class));
        String[] customComponents = installSettings.getCustomComponents();
        Vector<String> dialogComps = new Vector<String>();
        dialogComps.add("oracle.rdbms.scheduler");
        dialogComps.add("oracle.ntoramts");
        HashMap<String, String> compsMap = new HashMap<String, String>();
        compsMap.put("oracle.rdbms.scheduler", "SCHEDULERAGENT");
        compsMap.put("oracle.ntoramts", "ORAMTS");
        Vector<Object> customRoute = new Vector<Object>();
        if (customComponents != null && customComponents.length > 0) {
            for (String component : customComponents) {
                int separator = component.indexOf(":");
                String currentCompName = component.substring(0, separator);
                if (dialogComps.indexOf(currentCompName) <= -1) continue;
                customRoute.add(compsMap.get(currentCompName));
            }
            customRoute.add("ENDCUSTOM");
            if (customRoute.size() > 1) {
                for (int i = 1; i < customRoute.size(); ++i) {
                    String previous = (String)customRoute.get(i - 1);
                    String current = (String)customRoute.get(i);
                    String propertyName = "ORACLE_INSTALL_" + previous;
                    String propertyValue = "TO_" + current;
                    System.setProperty(propertyName, propertyValue);
                }
            }
            return new Route("TO_" + (String)customRoute.get(0));
        }
        return new Route("TO_ENDCUSTOM");
    }

    private ComponentConfig getComponentBean() {
        ComponentConfig bean = null;
        try {
            URL url = CustomInstallAction.class.getResource("/oracle/install/ivw/client/resource/custom_components.xml");
            ComponentConfigBuilder builder = ComponentConfigBuilder.getInstance();
            bean = builder.getComponentBean(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bean;
    }

    private void displayCustomComponents(Map<String, String[]> map) {
        this.logger.info("Custom Components:");
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            this.logger.info("\n" + entry.getKey() + "={");
            for (String comp : entry.getValue()) {
                this.logger.info(comp + ",");
            }
            this.logger.info("}");
        }
    }
}

