/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.client.action;

import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.verification.PreReqType;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationTask;
import oracle.install.commons.base.interview.common.action.AbstractPrereqAction;
import oracle.install.commons.base.interview.common.validator.PrereqValidator;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.annotation.UIRef;
import oracle.install.commons.flow.validation.annotation.ValidatorRef;
import oracle.install.ivw.client.bean.ClientInstallSettings;
import oracle.install.ivw.common.bean.AutoUpdatesInstallSettings;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.ProductInfo;
import oracle.install.library.util.cvu.CVUHelper;

@UIRef(value="PrereqUI")
@ValidatorRef(value=PrereqValidator.class)
public class PrereqAction
extends AbstractPrereqAction {
    private static final Logger logger = Logger.getLogger(PrereqAction.class.getName());
    public static final String sep = File.separator;
    private String refDataDir = null;

    public List<VerificationTask> getProductVerificationTasks(FlowContext flowContext) throws VerificationException {
        Object dbtasks = null;
        List tasks = null;
        AutoUpdatesInstallSettings autoBean = (AutoUpdatesInstallSettings)flowContext.getBean(AutoUpdatesInstallSettings.class);
        CVUHelper cvu = CVUHelper.getInstance();
        String customRefhostFile = this.computeCustomRefDataFileName(flowContext);
        boolean isCustomRefData = this.isCustomRefDataFilePresent(customRefhostFile);
        this.setCVUVariables(flowContext, cvu);
        try {
            ClientInstallSettings installSettings = (ClientInstallSettings)((Object)flowContext.getBean(ClientInstallSettings.class));
            ClientInstallSettings.InstallType installType = installSettings.getInstallType();
            if (installType == ClientInstallSettings.InstallType.InstantClient) {
                String customXML = System.getProperty("oracle.install.cvu.prereq_xml_loc", "");
                if (customXML != null && customXML.length() > 0) {
                    cvu.setPreReqXmlFile(PreReqType.PREREQ_SI_DB_INST, customXML);
                } else if (isCustomRefData) {
                    cvu.setPreReqXmlFile(PreReqType.PREREQ_SI_DB_INST, this.getRefdataDir() + sep + customRefhostFile);
                }
            } else {
                String defaultFile = CVUHelper.getPrereqXML((boolean)autoBean.isApplyUpdates(), (String)autoBean.getPatchDownloadLocation());
                cvu.setPreReqXmlFile(PreReqType.PREREQ_SI_DB_INST, defaultFile);
                logger.log(Level.INFO, "In PrereqAction: CVU PREREQ LOCATION  set to: " + defaultFile);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        tasks = cvu.getPreReqTasksForSIDBInst();
        return tasks;
    }

    public void setCVUVariables(FlowContext flowContext, CVUHelper cvu) throws VerificationException {
        PlatformInfo platformInfo = PlatformInfo.getInstance();
        String temp = null;
        String cv_destLoc = null;
        temp = System.getenv("TEMP") != null ? System.getenv("TEMP") : "/tmp";
        cvu.setVariableValue("TEMP_AREA", temp);
        cv_destLoc = System.getenv("CV_DESTLOC");
        if (cv_destLoc != null) {
            cvu.setVariableValue("CV_DESTLOC", cv_destLoc);
        }
        cvu.setVariableValue("CLIENT_INSTALL", "true");
    }

    public final Route transition(FlowContext flowContext) {
        return Route.SUCCESS;
    }

    public String computeCustomRefDataFileName(FlowContext flowContext) {
        String retVal = "";
        ClientInstallSettings installSettings = (ClientInstallSettings)((Object)flowContext.getBean(ClientInstallSettings.class));
        String installType = installSettings.getInstallType().toString();
        String top_level = ProductInfo.getInstance().getShiphomeTopLevelComponent();
        retVal = top_level + "_" + installType + ".xml";
        logger.info("custom prereq file name: " + retVal);
        return retVal;
    }

    public boolean isCustomRefDataFilePresent(String fileName) {
        String refDataFile = this.getRefdataDir() + sep + fileName;
        logger.info("refDataFile: " + refDataFile);
        boolean retVal = new File(refDataFile).exists();
        logger.info("isCustomRefDataFilePresent: " + retVal);
        return retVal;
    }

    public String getRefdataDir() {
        if (this.refDataDir == null) {
            try {
                String STARUP_LOC = System.getProperty("oracle.installer.startup_location");
                this.refDataDir = new File(STARUP_LOC + sep + ".." + sep + "stage" + sep + "cvu").getCanonicalPath();
            }
            catch (Exception e) {
                return "";
            }
        }
        return this.refDataDir;
    }
}

