/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.client.validator;

import java.io.File;
import oracle.cluster.winsecurity.Credentials;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.client.bean.ClientInstallSettings;
import oracle.install.ivw.client.resource.ClientErrorCode;
import oracle.install.ivw.common.bean.InstallSettings;
import oracle.install.ivw.common.bean.WindowsSecureOptionSettings;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.ivw.common.validator.BaseInstallLocationValidator;
import oracle.install.library.processes.RunningProcessInfoUnix;
import oracle.install.library.processes.ssgetRunningProcessW32;
import oracle.install.library.util.FileParser;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.StageSizeInfo;
import oracle.install.library.util.WinHelper;

public class InstallLocationValidator
extends BaseInstallLocationValidator {
    public void validate(FlowContext flowContext) throws ValidationException {
        ClientInstallSettings installSettings = (ClientInstallSettings)((Object)flowContext.getBean(ClientInstallSettings.class));
        String iType = installSettings.getInstallType().name();
        boolean validateOracleBase = true;
        if (installSettings.isUpgrading()) {
            iType = ClientInstallSettings.InstallType.Custom.name();
            validateOracleBase = false;
        }
        super.validate(flowContext, iType, validateOracleBase);
        StatusMessages errorMessages = super.getValidationStatusMessages();
        String oracleHome = installSettings.getOracleHome();
        String oracleBase = installSettings.getOracleBase();
        if (oracleHome == null || oracleHome.length() == 0) {
            return;
        }
        try {
            long spaceRequired = 0L;
            boolean considerOracleHomeOffset = false;
            spaceRequired = installSettings.getInstallType() == ClientInstallSettings.InstallType.Custom ? StageSizeInfo.getSize((String)ClientInstallSettings.InstallType.Administrator.toString(), (boolean)considerOracleHomeOffset) : StageSizeInfo.getSize((String)installSettings.getInstallType().toString(), (boolean)considerOracleHomeOffset);
            if (GenericValidation.validateForFreeSpace((long)spaceRequired, (String)installSettings.getOracleHome()) < 0L) {
                errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_MIN_FREE_DISK_SPACE_ERR, new Object[]{spaceRequired}));
            }
            if (PlatformInfo.getInstance().isWindows()) {
                boolean b_clientOnTopOfDB = false;
                WindowsSecureOptionSettings secureBean = (WindowsSecureOptionSettings)flowContext.getBean(WindowsSecureOptionSettings.class);
                String userName = null;
                if (InventoryInfo.getInstance().isHomeWithLocationExist(installSettings.getOracleHome())) {
                    userName = WinHelper.getOracleHomeUser((String)installSettings.getOracleHome());
                    b_clientOnTopOfDB = true;
                }
                if (userName != null && (userName.equals(Credentials.BuiltinUser.LOCALSYSTEM.toString()) || userName.equals(Credentials.BuiltinUser.LOCALSERVICE.toString()) ? !secureBean.isDeclineOption() : !userName.equals(secureBean.getUserName()))) {
                    throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_EXISTING_HOME_USER_NOT_MATCHING, new Object[]{userName});
                }
                userName = !secureBean.isDeclineOption() ? secureBean.getUserName() : Credentials.BuiltinUser.LOCALSERVICE.toString();
                WinHelper WinHelper2 = new WinHelper();
                if (!WinHelper.userOwnsSpecifiedBase((String)userName, (String)installSettings.getOracleBase(), (boolean)b_clientOnTopOfDB)) {
                    throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_HOME_USER_NOT_OWNER_OF_SPECIFIED_OB, new Object[0]);
                }
            }
            if (installSettings.isUpgrading()) {
                String oraHome = installSettings.getOracleHome();
                String[] validHomes = installSettings.getUpgradableHomes();
                boolean validHome = false;
                for (int i = 0; i < validHomes.length; ++i) {
                    if (!validHomes[i].equals(oraHome)) continue;
                    validHome = true;
                    break;
                }
                if (!validHome) {
                    errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ClientErrorCode.INVALID_HOME_FOR_UPGRADE, new Object[0]));
                }
                String processesFilename = System.getProperty("oracle.installer.startup_location") + "/../stage/processes.properties";
                File processesFile = new File(processesFilename);
                String[] processesList = null;
                if (processesFile.canRead() && processesFile.isFile()) {
                    String processesLine = FileParser.getPropertyFromTextFile((File)processesFile, (String)"FILES_TO_CHECK");
                    String tmpOraHome = oraHome.replaceAll("\\\\", "\\\\\\\\");
                    String instantiatedLine = processesLine.replaceAll("%ORACLE_HOME%", tmpOraHome);
                    processesList = instantiatedLine.split(",");
                }
                if (PlatformInfo.getInstance().isWindows()) {
                    ssgetRunningProcessW32.getInstance().getRunningProcesses(processesList);
                } else {
                    RunningProcessInfoUnix.getInstance().getRunningProcesses(processesList);
                }
            }
        }
        catch (InstallException e) {
            errorMessages.add((StatusMessage)new ValidationStatusMessage((Throwable)e));
        }
    }

    public InstallSettings getInstallSettings(FlowContext flowContext) {
        InstallSettings installSettings = (InstallSettings)flowContext.getBean(ClientInstallSettings.class);
        return installSettings;
    }
}

