/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.client.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.TogglePane;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.ivw.client.bean.ClientInstallSettings;
import oracle.install.library.util.UIUtil;

@ViewDef(id="InstallModeUI")
public class InstallModeGUI
implements View {
    private static final Logger logger = Logger.getLogger(InstallModeGUI.class.getName());
    private Resource resource = Application.getInstance().getResource("oracle.install.ivw.client.resource.ClientDialogLabelResID");
    private JPanel basePanel;
    private MultilineLabel lblInstallModePrompt = null;
    private JRadioButton rdoNewInstall = null;
    private JRadioButton rdoUpgrade = null;
    private ButtonGroup group;
    private MultilineLabel lblNewInstall = null;
    private MultilineLabel lblUpgrade = null;

    public InstallModeGUI() {
        this.buildUI();
    }

    protected void buildUI() {
        this.basePanel = new JPanel();
        this.basePanel.setLayout(new GridBagLayout());
        this.lblInstallModePrompt = new MultilineLabel();
        this.lblNewInstall = new MultilineLabel();
        this.lblUpgrade = new MultilineLabel();
        this.rdoNewInstall = UIUtil.createDescriptiveRadioButton((MultilineLabel)this.lblNewInstall);
        this.rdoUpgrade = UIUtil.createDescriptiveRadioButton((MultilineLabel)this.lblUpgrade);
        this.group = new ButtonGroup();
        this.group.add(this.rdoNewInstall);
        this.group.add(this.rdoUpgrade);
        LayoutUtils.addComponent((Component)this.lblInstallModePrompt, (Container)this.basePanel, (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(5, 10, 10, 5));
        LayoutUtils.addComponent((Component)new TogglePane((JToggleButton)this.rdoNewInstall, (Component)this.lblNewInstall), (Container)this.basePanel, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)new TogglePane((JToggleButton)this.rdoUpgrade, (Component)this.lblUpgrade), (Container)this.basePanel, (int)0, (int)2, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this.basePanel, (int)0, (int)3, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        this.rdoNewInstall.setSelected(true);
        ActiveHelpManager.registerComponent((JComponent)this.rdoNewInstall, (String)"InstallMode.rdoNewInstall");
        ActiveHelpManager.registerComponent((JComponent)this.rdoUpgrade, (String)"InstallMode.rdoUpgrade");
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        if (eventType == EventType.INIT) {
            ClientInstallSettings installSettings = (ClientInstallSettings)((Object)flowContext.getBean(ClientInstallSettings.class));
            this.rdoUpgrade.setSelected(installSettings.isUpgrading());
        }
    }

    public void processInput(FlowContext flowContext) {
        ClientInstallSettings bean = (ClientInstallSettings)((Object)flowContext.getBean(ClientInstallSettings.class));
        logger.log(Level.INFO, "Install Mode UI entering processInput");
        if (this.rdoUpgrade.isSelected()) {
            bean.setUpgrading(true);
        } else {
            bean.setUpgrading(false);
        }
    }

    public Component getView() {
        return this.basePanel;
    }

    public void localize(FlowContext flowContext) {
        if (this.basePanel != null) {
            String text = this.resource.getString("INSTALL_CLIENT_INSTALL_MODE_PROMPT", "Choose a mode of installation.", new Object[0]);
            this.lblInstallModePrompt.setText(text);
            text = this.resource.getString("INSTALL_CLIENT_INSTALL_MODE_NEWINSTALL_LABEL", "&New Install", new Object[0]);
            SwingUtils.setText((AbstractButton)this.rdoNewInstall, (String)text);
            text = this.resource.getString("INSTALL_CLIENT_INSTALL_MODE_NEWINSTALL_PROMPT", "Installs client software into a new location.", new Object[0]);
            this.lblNewInstall.setText(text);
            text = this.resource.getString("INSTALL_CLIENT_INSTALL_MODE_UPGRADE_LABEL", "&Upgrade", new Object[0]);
            SwingUtils.setText((AbstractButton)this.rdoUpgrade, (String)text);
            text = this.resource.getString("INSTALL_CLIENT_INSTALL_MODE_UPGRADE_PROMPT", "Updates existing client software with the current version.", new Object[0]);
            this.lblUpgrade.setText(text);
        }
    }
}

