/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.client.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.TogglePane;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ResourceURL;
import oracle.install.ivw.client.bean.ClientInstallSettings;
import oracle.install.library.util.StageSizeInfo;
import oracle.install.library.util.UIUtil;

public class InstallTypesPane
extends JPanel {
    private ClientInstallSettings.InstallType installType = null;
    private static final Logger logger = Logger.getLogger(InstallTypesPane.class.getName());
    private MultilineLabel lblInstallTypePrompt = null;
    private ButtonGroup buttonGroup = null;
    private JRadioButton rdoInstantClient = null;
    private JRadioButton rdoAdministrator = null;
    private JRadioButton rdoRuntime = null;
    private JRadioButton rdoCustom = null;
    private HashMap<ButtonModel, ClientInstallSettings.InstallType> buttonMap = null;
    private MultilineLabel lblInstantClient = null;
    private MultilineLabel lblAdministrator = null;
    private MultilineLabel lblRuntime = null;
    private MultilineLabel lblCustom = null;

    public InstallTypesPane() {
        this.buildUI();
    }

    public ClientInstallSettings.InstallType getInstallType() {
        return this.buttonMap.get(this.buttonGroup.getSelection());
    }

    public void setInstallType(ClientInstallSettings.InstallType type) {
        this.installType = type;
        switch (type) {
            case Administrator: {
                this.rdoAdministrator.setSelected(true);
                break;
            }
            case Custom: {
                this.rdoCustom.setSelected(true);
                break;
            }
            case InstantClient: {
                this.rdoInstantClient.setSelected(true);
                break;
            }
            case Runtime: {
                this.rdoRuntime.setSelected(true);
            }
        }
        logger.info("InstallTypesPane installType is: " + (Object)((Object)this.installType));
    }

    private void buildUI() {
        this.lblInstallTypePrompt = new MultilineLabel();
        this.lblInstantClient = new MultilineLabel();
        this.lblAdministrator = new MultilineLabel();
        this.lblRuntime = new MultilineLabel();
        this.lblCustom = new MultilineLabel();
        this.rdoInstantClient = UIUtil.createDescriptiveRadioButton((MultilineLabel)this.lblInstantClient);
        this.rdoInstantClient.setSelected(true);
        this.rdoInstantClient.setName("InstallTypesPane.rdoInstantClient");
        this.rdoAdministrator = UIUtil.createDescriptiveRadioButton((MultilineLabel)this.lblAdministrator);
        this.rdoAdministrator.setName("InstallTypesPane.rdoAdministrator");
        this.rdoRuntime = UIUtil.createDescriptiveRadioButton((MultilineLabel)this.lblRuntime);
        this.rdoRuntime.setName("InstallTypesPane.rdoRuntime");
        this.rdoCustom = UIUtil.createDescriptiveRadioButton((MultilineLabel)this.lblCustom);
        this.rdoCustom.setName("InstallTypesPane.rdoCustom");
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.rdoInstantClient);
        this.buttonGroup.add(this.rdoAdministrator);
        this.buttonGroup.add(this.rdoRuntime);
        this.buttonGroup.add(this.rdoCustom);
        this.buttonMap = new HashMap();
        this.buttonMap.put(this.rdoInstantClient.getModel(), ClientInstallSettings.InstallType.InstantClient);
        this.buttonMap.put(this.rdoAdministrator.getModel(), ClientInstallSettings.InstallType.Administrator);
        this.buttonMap.put(this.rdoRuntime.getModel(), ClientInstallSettings.InstallType.Runtime);
        this.buttonMap.put(this.rdoCustom.getModel(), ClientInstallSettings.InstallType.Custom);
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblInstallTypePrompt, (Container)this, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)new TogglePane((JToggleButton)this.rdoInstantClient, (Component)this.lblInstantClient), (Container)this, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)new TogglePane((JToggleButton)this.rdoAdministrator, (Component)this.lblAdministrator), (Container)this, (int)0, (int)2, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)new TogglePane((JToggleButton)this.rdoRuntime, (Component)this.lblRuntime), (Container)this, (int)0, (int)3, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)new TogglePane((JToggleButton)this.rdoCustom, (Component)this.lblCustom), (Container)this, (int)0, (int)4, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this, (int)0, (int)4, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        this.localize();
        ActiveHelpManager.registerComponent((JComponent)this.rdoInstantClient, (String)"InstallTypesPane.rdoInstantClient");
        ActiveHelpManager.registerComponent((JComponent)this.rdoAdministrator, (String)"InstallTypesPane.rdoAdministrator");
        ActiveHelpManager.registerComponent((JComponent)this.rdoRuntime, (String)"InstallTypesPane.rdoRuntime");
        ActiveHelpManager.registerComponent((JComponent)this.rdoCustom, (String)"InstallTypesPane.rdoCustom");
    }

    public void localize() {
        boolean considerOracleHomeOffset = false;
        Application application = Application.getInstance();
        this.lblInstallTypePrompt.setText(application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.client.resource.ClientDialogLabelResID", (String)"INSTALL_CLIENT_INSTALL_TYPE_DLG_PROMPT"), new Object[0]));
        String text = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.client.resource.ClientDialogLabelResID", (String)"INSTALL_CLIENT_INSTALL_TYPE_DLG_INSTANTCLIENT_LABEL"), new Object[]{StageSizeInfo.getSizeString((String)ClientInstallSettings.InstallType.InstantClient.toString(), (boolean)considerOracleHomeOffset)});
        SwingUtils.setText((AbstractButton)this.rdoInstantClient, (String)text);
        this.lblInstantClient.setText(application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.client.resource.ClientDialogLabelResID", (String)"INSTALL_CLIENT_INSTALL_TYPE_DLG_INSTANTCLIENT_PROMPT"), new Object[0]));
        text = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.client.resource.ClientDialogLabelResID", (String)"INSTALL_CLIENT_INSTALL_TYPE_DLG_ADMINISTRATOR_LABEL"), new Object[]{StageSizeInfo.getSizeString((String)ClientInstallSettings.InstallType.Administrator.toString(), (boolean)considerOracleHomeOffset)});
        SwingUtils.setText((AbstractButton)this.rdoAdministrator, (String)text);
        this.lblAdministrator.setText(application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.client.resource.ClientDialogLabelResID", (String)"INSTALL_CLIENT_INSTALL_TYPE_DLG_ADMINISTRATOR_PROMPT"), new Object[0]));
        text = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.client.resource.ClientDialogLabelResID", (String)"INSTALL_CLIENT_INSTALL_TYPE_DLG_RUNTIME_LABEL"), new Object[]{StageSizeInfo.getSizeString((String)ClientInstallSettings.InstallType.Runtime.toString(), (boolean)considerOracleHomeOffset)});
        SwingUtils.setText((AbstractButton)this.rdoRuntime, (String)text);
        this.lblRuntime.setText(application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.client.resource.ClientDialogLabelResID", (String)"INSTALL_CLIENT_INSTALL_TYPE_DLG_RUNTIME_PROMPT"), new Object[0]));
        text = application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.client.resource.ClientDialogLabelResID", (String)"INSTALL_CLIENT_INSTALL_TYPE_DLG_CUSTOM_LABEL"), new Object[0]);
        SwingUtils.setText((AbstractButton)this.rdoCustom, (String)text);
        this.lblCustom.setText(application.getProperty(ResourceURL.resURL((String)"oracle.install.ivw.client.resource.ClientDialogLabelResID", (String)"INSTALL_CLIENT_INSTALL_TYPE_DLG_CUSTOM_PROMPT"), new Object[0]));
    }
}

