/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.client.view;

import java.awt.Component;
import java.util.logging.Logger;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.flow.validation.CompositeValidator;
import oracle.install.commons.flow.validation.UncheckedValidationException;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.client.resource.ClientDialogLabelResID;
import oracle.install.ivw.common.bean.WindowsSecureOptionSettings;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.ivw.common.view.WindowsSecureOptionPane;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.InstallHelper;
import oracle.install.library.util.WinHelper;

@ViewDef(id="WindowsSecureOptionUI")
public class WindowsSecureOptionUI
implements View,
CompositeValidator {
    private Logger logger = Logger.getLogger(WindowsSecureOptionUI.class.getName());
    private StatusMessages<ValidationStatusMessage> messages;
    WindowsSecureOptionPane view;

    public WindowsSecureOptionUI() {
        this.logger.info("Entering WindowsSecureOptionUI...");
        this.view = new WindowsSecureOptionPane();
        this.controlDeclineOption();
        this.messages = new StatusMessages();
    }

    public Component getView() {
        return this.view;
    }

    public void localize(FlowContext flowContext) {
        Application application = Application.getInstance();
        Resource resource = application.getResource(ClientDialogLabelResID.class.getName());
        this.view.setLblPageDesc(resource.getString("WindowsSecureOptionPane.lblPageDesc.text", "Use Windows Built-in Account or specify a standard Windows User Account (not an Administrator account) to install and configure the Oracle Home. This account is used for running the Windows Services for the Oracle Home. Do not log in using this account to perform administrative tasks.", new Object[0]));
        this.view.localize();
    }

    public void validate(FlowContext arg0) throws ValidationException {
        String existingUserName = this.view.getExistingUserName().trim();
        String newUserName = this.view.getNewUserName().trim();
        String password = this.view.getNewUserPassword().trim();
        String confirmPassword = this.view.getConfirmPassword().trim();
        if (!this.view.isDeclineSecureOption() && this.view.isExistingUser() && (existingUserName == null || existingUserName.trim().length() == 0)) {
            throw new ValidationException((ErrorCode)CommonErrorCode.USER_NAME_EMPTY, new Object[]{"User name is empty."});
        }
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        WindowsSecureOptionSettings winSecurebean = (WindowsSecureOptionSettings)flowContext.getBean(WindowsSecureOptionSettings.class);
        if (eventType == EventType.INIT) {
            this.view.enableExistingUser(true);
            this.view.enableNewUser(true);
            this.view.enableDeclineOption(true);
            this.view.selectDeclineOption(true);
            this.view.setisExistingUserPasswordRequired(true);
            String isDeclineOptionUserValue = InstallHelper.getValue((String)"oracle.install.IsBuiltInAccount");
            if (isDeclineOptionUserValue == null) {
                winSecurebean.setDeclineOption(true);
            }
        }
        if (eventType == EventType.LOAD) {
            this.view.enableExistingUser(true);
            this.view.enableNewUser(true);
            this.view.enableDeclineOption(true);
            this.view.selectDeclineOption(true);
            this.view.setisExistingUserPasswordRequired(true);
            Object userName = null;
            this.view.enableExistingUser(true);
            this.view.enableNewUser(true);
            this.view.enableDeclineOption(true);
            if (!winSecurebean.isDeclineOption()) {
                boolean bUserExists = false;
                if (!GenericValidation.isEmpty((String)winSecurebean.getUserName())) {
                    bUserExists = WinHelper.UserExists((String)winSecurebean.getUserName(), (String)winSecurebean.getPassword());
                }
                if (GenericValidation.isEmpty((String)winSecurebean.getUserName()) || winSecurebean.isExistingUser() || bUserExists) {
                    this.view.selectExistingUserOption(true);
                    if (!GenericValidation.isEmpty((String)winSecurebean.getUserName())) {
                        this.view.setExistingUserName(winSecurebean.getUserName());
                    }
                } else {
                    this.view.selectNewUserOption(true);
                    if (!GenericValidation.isEmpty((String)winSecurebean.getUserName())) {
                        this.view.setNewUserName(winSecurebean.getUserName());
                    }
                }
            } else {
                this.view.selectDeclineOption(true);
            }
        }
    }

    public void processInput(FlowContext flowContext) throws UncheckedValidationException {
        WindowsSecureOptionSettings bean = (WindowsSecureOptionSettings)flowContext.getBean(WindowsSecureOptionSettings.class);
        String existingUserPassword = this.view.getExistingUserPassword();
        String newUserPassword = this.view.getNewUserPassword();
        boolean declineSecureOption = this.view.isDeclineSecureOption();
        bean.setPasswordRequired("0");
        if (!this.view.isDeclineSecureOption()) {
            if (this.view.isExistingUser()) {
                bean.setUserName(this.view.getExistingUserName());
                bean.setExistingUser(true);
                if (existingUserPassword != null) {
                    bean.setPassword(existingUserPassword);
                }
            }
            if (this.view.isNewUser()) {
                bean.setUserName(this.view.getNewUserName());
                bean.setExistingUser(false);
                if (newUserPassword != null) {
                    bean.setPassword(newUserPassword);
                }
            }
        }
        bean.setDeclineOption(declineSecureOption);
    }

    public StatusMessages<ValidationStatusMessage> getValidationStatusMessages() {
        return this.messages;
    }

    public void controlDeclineOption() {
    }
}

