/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcf;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipcf.OipcfExecuteFixUpRuleException;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpMap;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpMapReader;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpResult;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpRule;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpRuleNotFoundException;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpRuleSet;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpRuleSetNotFoundException;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpSet;
import oracle.sysman.oip.oipc.oipcp.OipcpIPrereqChecker;
import oracle.sysman.oip.oipc.oipcp.OipcpIPrereqListener;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqChecker;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqEvent;
import oracle.sysman.oip.oipc.oipcp.OipcpPrerequisiteCheck;
import oracle.sysman.oip.oipc.oipcp.OipcpPrerequisiteResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcu.OipcuPrereqProps;
import oracle.sysman.oix.oixd.OixdInvalidDocumentException;
import org.xml.sax.SAXException;

public class OipcfFixUpGenerator
implements OipcpIPrereqListener {
    private OipcpIPrereqChecker m_oChecker;
    private OipcfFixUpMap m_oFixUpMap;
    private Class[] m_oExecuteFixUpRuleParams;
    private static final String S_DEFAULT_FIXUP_MAP_FILE_NAME = "fixupmap.xml";
    private static final String FIXUPMAP = "fixupmap";
    private static final String RULES_ENGINE_TYPE = "oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine";
    private static final String STRING_TYPE = "java.lang.String";
    private static final String RESULT_TYPE = "oracle.sysman.oip.oipc.oipcr.OipcrIResult";
    private static final String ARRAYLIST_TYPE = "java.util.ArrayList";
    private static final String S_SEPARATOR = ";";
    private static final String FIXUP_OUTFILE_LOC = "fixup";
    private static OipcfFixUpGenerator s_prereqFixUpGen;

    private static void initialize() {
        s_prereqFixUpGen = new OipcfFixUpGenerator();
    }

    public static OipcfFixUpGenerator getFixUpGenerator() {
        if (s_prereqFixUpGen == null) {
            OipcfFixUpGenerator.initialize();
        }
        return s_prereqFixUpGen;
    }

    private OipcfFixUpGenerator() {
        OiiolTextLogger.appendText((String)"Creating OipcfFixUpGenerator...\n", (int)OiiolTextLogger.LOG_DETAILED);
        try {
            this.m_oExecuteFixUpRuleParams = new Class[]{Class.forName(RULES_ENGINE_TYPE), Class.forName(STRING_TYPE), Class.forName(RESULT_TYPE), Class.forName(ARRAYLIST_TYPE)};
            OiiolTextLogger.appendText((String)"Created OipcfFixUpGenerator.\n", (int)OiiolTextLogger.LOG_DETAILED);
        }
        catch (ClassNotFoundException e) {
            OiiolTextLogger.appendText((String)("Exception caught while creating OipcfFixUpGenerator.\nCause:" + e.getMessage() + "\n"), (int)OiiolTextLogger.LOG_DETAILED);
            e.printStackTrace(System.err);
        }
    }

    public void registerChecker(OipcpIPrereqChecker oChecker) {
        this.m_oChecker = oChecker;
        OiiolTextLogger.appendText((String)"Registered the OipcpIPrereqChecker object.\n", (int)OiiolTextLogger.LOG_DETAILED);
    }

    public void onPrereqEvent(OipcpPrereqEvent oEvent) {
        OipcpPrerequisiteCheck oCheck = null;
        switch (oEvent.getID()) {
            case 0: {
                OiiolTextLogger.appendText((String)"PREREQ_SESSION_START event received \n", (int)OiiolTextLogger.LOG_DETAILED);
                try {
                    OiiolTextLogger.appendText((String)"Creating fixupmap from by reading fixupmap.xml files.\n", (int)OiiolTextLogger.LOG_DETAILED);
                    this.createFixUpMap();
                }
                catch (IOException ioe) {
                    OiiolTextLogger.appendText((String)"java.io.IOException occured while reading the fixumap.xml files in the method oracle.sysman.oip.oipc.oipcf.OipcfFixUpGenerator::createFixUpMap().\n", (int)OiiolTextLogger.LOG_DETAILED);
                    ioe.printStackTrace();
                }
                catch (SAXException se) {
                    OiiolTextLogger.appendText((String)"org.xml.sax.SAXException occured while building the fixupmap in the method oracle.sysman.oip.oipc.oipcf.OipcfFixUpGenerator::createFixUpMap().\n", (int)OiiolTextLogger.LOG_DETAILED);
                    se.printStackTrace();
                }
                catch (ParserConfigurationException pce) {
                    OiiolTextLogger.appendText((String)"javax.xml.parsers.ParserConfigurationException occured while building the fixupmap in the method oracle.sysman.oip.oipc.oipcf.OipcfFixUpGenerator::createFixUpMap().\n", (int)OiiolTextLogger.LOG_DETAILED);
                    pce.printStackTrace();
                }
                catch (OixdInvalidDocumentException ide) {
                    OiiolTextLogger.appendText((String)"oracle.sysman.oix.oixd.OixdInvalidDocumentException occured while building the fixupmap in the method oracle.sysman.oip.oipc.oipcf.OipcfFixUpGenerator::createFixUpMap().\n", (int)OiiolTextLogger.LOG_DETAILED);
                    ide.printStackTrace();
                }
                break;
            }
            case 1: {
                OiiolTextLogger.appendText((String)"PREREQ_SESSION_END event received \n", (int)OiiolTextLogger.LOG_DETAILED);
                break;
            }
            case 2: {
                OiiolTextLogger.appendText((String)"PREREQ_START event received \n", (int)OiiolTextLogger.LOG_DETAILED);
                break;
            }
            case 3: {
                OiiolTextLogger.appendText((String)"PREREQ_END event received \n", (int)OiiolTextLogger.LOG_DETAILED);
                oCheck = (OipcpPrerequisiteCheck)oEvent.getEventInfo();
                OiiolTextLogger.appendText((String)"Executing the fixup rules: \n", (int)OiiolTextLogger.LOG_DETAILED);
                this.executeFixUpRules(oCheck);
                OiiolTextLogger.appendText((String)"Finished executing the fixup rules. \n", (int)OiiolTextLogger.LOG_DETAILED);
            }
        }
    }

    private void createFixUpMap() throws IOException, SAXException, ParserConfigurationException, OixdInvalidDocumentException {
        OipcfFixUpMapReader oReader;
        OipcuPrereqProps oPrereqProps = ((OipcpPrereqChecker)this.m_oChecker).getPrereqProps();
        Iterator oIter = oPrereqProps.getFilesListForProperty(FIXUPMAP);
        String sConfigLoc = oPrereqProps.getConfigLoc();
        ArrayList<String> oFixUpMapList = new ArrayList<String>();
        if (oIter != null) {
            OiiolTextLogger.appendText((String)"Found enty for fixupmap.xml file(s) inprerequisite.properties. \n", (int)OiiolTextLogger.LOG_DETAILED);
            while (oIter.hasNext()) {
                String sFileName = (String)oIter.next();
                oFixUpMapList.add(OiixPathOps.concatPath((String)sConfigLoc, (String)sFileName));
            }
        } else {
            OiiolTextLogger.appendText((String)"Could not find the entry for fixupmap.xml file(s) inprerequisite.properties. Looking for fixupmap.xml in current directory. \n", (int)OiiolTextLogger.LOG_DETAILED);
            String sCurrentWorkingDir = System.getProperty("user.dir");
            oFixUpMapList.add(OiixPathOps.concatPath((String)sCurrentWorkingDir, (String)S_DEFAULT_FIXUP_MAP_FILE_NAME));
        }
        if ((oReader = OipcfFixUpMapReader.getReader(oFixUpMapList)) != null) {
            OiiolTextLogger.appendText((String)"Obtained reference to OipcfFixUpMapReader.\n", (int)OiiolTextLogger.LOG_DETAILED);
            oReader.build();
            this.m_oFixUpMap = oReader.getFixUpMap();
        } else {
            OiiolTextLogger.appendText((String)"Could not get reference to OipcfFixUpMapReader.\n", (int)OiiolTextLogger.LOG_DETAILED);
        }
    }

    private void executeFixUpRules(OipcpPrerequisiteCheck oCheck) {
        OiiolTextLogger.appendText((String)"Getting reference to OipcrRulesEngine from OipcpPrereqChecker.\n", (int)OiiolTextLogger.LOG_DETAILED);
        OipcrIRulesEngine m_oRulesEngine = ((OipcpPrereqChecker)this.m_oChecker).getRuleEngine();
        OipcrIResult oRawResult = null;
        OiiolTextLogger.appendText((String)"Getting reference to OipcpPrerequisiteResult from the OipcpPrerequisiteCheck object.\n", (int)OiiolTextLogger.LOG_DETAILED);
        OipcpPrerequisiteResult oPrereqResult = oCheck.getResult();
        if (oPrereqResult != null) {
            OiiolTextLogger.appendText((String)"Obtained a non null reference to OipcpPrerequisiteResult from the OipcpPrerequisiteCheck object.\n", (int)OiiolTextLogger.LOG_DETAILED);
            oRawResult = oPrereqResult.getRawResult();
            int nResult = oPrereqResult.getResult();
            if (nResult == 1 || nResult == 3) {
                OiiolTextLogger.appendText((String)("The prerequisite result for the check " + oCheck.getName() + " is PASSED or NOT EXECUTED , so returning.\n"), (int)OiiolTextLogger.LOG_DETAILED);
                return;
            }
            String sRefFile = oCheck.getRefFile();
            String sConfigLoc = ((OipcpPrereqChecker)this.m_oChecker).getPrereqConfigLoc();
            sRefFile = OiixPathOps.concatPath((String)sConfigLoc, (String)sRefFile);
            List oFixUpList = oCheck.getFixUpList();
            OiiolTextLogger.appendText((String)("Obtained the list of fixup rules to be executed from the prerequisite check " + oCheck.getName() + ".\n"), (int)OiiolTextLogger.LOG_DETAILED);
            if (oFixUpList == null || oFixUpList.isEmpty()) {
                OiiolTextLogger.appendText((String)("List of fixup rules to be executed for the prerequisite check " + oCheck.getName() + " is empty.\n"), (int)OiiolTextLogger.LOG_DETAILED);
                return;
            }
            for (int i = 0; i < oFixUpList.size(); ++i) {
                OipcfFixUpSet oFixUpSet = null;
                OipcfFixUpRuleSet oRuleSet = null;
                OipcfFixUpRule oRule = null;
                String sClassName = null;
                Class oFixUpClass = null;
                String sMethodName = null;
                Method oMethod = null;
                OipcfFixUpResult oFixUpResult = null;
                ArrayList filesList = null;
                try {
                    Object[] args;
                    oFixUpSet = (OipcfFixUpSet)oFixUpList.get(i);
                    OiiolTextLogger.appendText((String)("Executing the fixup rule having:<FIXUPSETREF NAME=" + oFixUpSet.getFixUpSet() + " FIXUP=" + oFixUpSet.getFixUpRule() + ">.\n"), (int)OiiolTextLogger.LOG_DETAILED);
                    filesList = (ArrayList)oFixUpSet.getFixUpFiles();
                    if (this.m_oFixUpMap == null) {
                        oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, new OipcfExecuteFixUpRuleException("The file fixupmap.xml was not found or is invalid"), filesList);
                        oFixUpSet.setFixUpResult(oFixUpResult);
                        continue;
                    }
                    if (filesList != null && !filesList.isEmpty()) {
                        OiiolTextLogger.appendText((String)"Obtained a non empty list of <FILES> .\n", (int)OiiolTextLogger.LOG_DETAILED);
                        String sOutfileLoc = System.getProperty("oracle.installer.fixUpOutfileLoc");
                        if (sOutfileLoc == null) {
                            sOutfileLoc = System.getProperty("oracle.installer.prereqLogLoc");
                            if (sOutfileLoc == null) {
                                sOutfileLoc = System.getProperty("oracle.installer.scratchPath");
                            }
                            sOutfileLoc = OiixPathOps.concatPath((String)sOutfileLoc, (String)FIXUP_OUTFILE_LOC);
                        }
                        for (int j = 0; j < filesList.size(); ++j) {
                            String sFile = (String)filesList.get(j);
                            String sFullPath = OiixPathOps.concatPath((String)sOutfileLoc, (String)sFile);
                            filesList.set(j, sFullPath);
                            File oFile = new File(sFullPath);
                            if (oFile.exists()) continue;
                            String src = System.getProperty("oracle.installer.prereqConfigLoc");
                            src = OiixPathOps.concatPath((String)src, (String)sFile);
                            String dest = sFullPath;
                            OiiolTextLogger.appendText((String)("Copying the file:" + src + " to the location:" + dest + ".\n"), (int)OiiolTextLogger.LOG_DETAILED);
                            try {
                                OiixFileOps.copyFile((String)src, (String)dest, (boolean)false, (boolean)true);
                                continue;
                            }
                            catch (IOException e) {
                                OiiolTextLogger.appendText((String)("java.io.IOException caught while copying the file:" + src + " to the location:" + dest + ".\n"), (int)OiiolTextLogger.LOG_DETAILED);
                                Object[] args2 = new String[]{src, dest};
                                throw new OipcfExecuteFixUpRuleException("OUI-65043", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcf.resources.OipcfRuntimeRes", (String)"OUI-65043", (Object[])args2), e);
                            }
                            catch (OiifbCancelException e) {
                                OiiolTextLogger.appendText((String)("oracle.sysman.oii.oiif.oiifb.OiifbCancelException caught while copying the file:" + src + " to the location:" + dest + ".\n"), (int)OiiolTextLogger.LOG_DETAILED);
                                Object[] args3 = new String[]{src, dest};
                                throw new OipcfExecuteFixUpRuleException("OUI-65043", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcf.resources.OipcfRuntimeRes", (String)"OUI-65043", (Object[])args3), e);
                            }
                        }
                    }
                    try {
                        oRuleSet = this.m_oFixUpMap.getFixUpRuleSet(oFixUpSet.getFixUpSet());
                        OiiolTextLogger.appendText((String)("Found FixupRuleSet:" + oRuleSet.getName() + "in fixupmap.xml .\n"), (int)OiiolTextLogger.LOG_DETAILED);
                    }
                    catch (OipcfFixUpRuleSetNotFoundException e) {
                        OiiolTextLogger.appendText((String)("Could not find FixupRuleSet:" + oFixUpSet.getFixUpSet() + " in fixupmap.xml.\n"), (int)OiiolTextLogger.LOG_DETAILED);
                        throw new OipcfExecuteFixUpRuleException((Throwable)((Object)e));
                    }
                    try {
                        oRule = oRuleSet.getFixUpRule(oFixUpSet.getFixUpRule());
                        OiiolTextLogger.appendText((String)("Found FixupRule " + oRule.getName() + "in fixupset " + oRuleSet.getName() + ".\n"), (int)OiiolTextLogger.LOG_DETAILED);
                    }
                    catch (OipcfFixUpRuleNotFoundException e) {
                        OiiolTextLogger.appendText((String)("Could not find FixupRule " + oFixUpSet.getFixUpRule() + " in fixupset " + oRuleSet.getName() + ".\n"), (int)OiiolTextLogger.LOG_DETAILED);
                        throw new OipcfExecuteFixUpRuleException((Throwable)((Object)e));
                    }
                    try {
                        sClassName = oRuleSet.getClassName();
                        oFixUpClass = Class.forName(sClassName);
                        OiiolTextLogger.appendText((String)("Loaded the class " + sClassName + ".\n"), (int)OiiolTextLogger.LOG_DETAILED);
                    }
                    catch (ClassNotFoundException e) {
                        OiiolTextLogger.appendText((String)("Could not load the class " + sClassName + " through system class loader." + "Trying using jar class loaders.\n"), (int)OiiolTextLogger.LOG_DETAILED);
                        try {
                            oFixUpClass = OiixJarClassLoader.getClass((String)sClassName);
                            OiiolTextLogger.appendText((String)("Loaded the class " + sClassName + "using jar class loader.\n"), (int)OiiolTextLogger.LOG_DETAILED);
                        }
                        catch (ClassNotFoundException e2) {
                            OiiolTextLogger.appendText((String)("Could not load the class " + sClassName + " through jar class loader.\n"), (int)OiiolTextLogger.LOG_DETAILED);
                            args = new String[]{sClassName, oRuleSet.getName(), e.getMessage()};
                            throw new OipcfExecuteFixUpRuleException("OUI-65031", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcf.resources.OipcfRuntimeRes", (String)"OUI-65031", (Object[])args), e);
                        }
                    }
                    try {
                        sMethodName = oRule.getMethodName();
                        if (oFixUpClass != null) {
                            oMethod = oFixUpClass.getDeclaredMethod(sMethodName, this.m_oExecuteFixUpRuleParams);
                            OiiolTextLogger.appendText((String)("Obtained the method " + sClassName + "::" + sMethodName + ".\n"), (int)OiiolTextLogger.LOG_DETAILED);
                        }
                    }
                    catch (NoSuchMethodException e) {
                        OiiolTextLogger.appendText((String)("java.lang.NoSuchMethodException was thrown when trying to obtain " + sClassName + "::" + sMethodName + " .\n"), (int)OiiolTextLogger.LOG_DETAILED);
                        StringBuffer sb = new StringBuffer("");
                        Method[] oMethods = oFixUpClass.getDeclaredMethods();
                        sb.append("Methods listed in the class:" + sClassName + "\n");
                        for (int j = 0; j < oMethods.length; ++j) {
                            sb.append("-------------------------------\n");
                            sb.append("Method:" + j + "\n");
                            sb.append("Name:" + oMethods[j].getName() + "\n");
                            int mod = oMethods[j].getModifiers();
                            sb.append("IsPublic:" + Modifier.isPublic(mod) + "\n");
                            sb.append("IsStatic:" + Modifier.isStatic(mod) + "\n");
                            sb.append("Parameters:\n");
                            Class<?>[] oArgsClass = oMethods[j].getParameterTypes();
                            for (int k = 0; k < oArgsClass.length; ++k) {
                                sb.append(oArgsClass[k].getName() + "\n");
                            }
                            Class<?>[] oExcpnTypes = oMethods[j].getExceptionTypes();
                            sb.append("Exceptions:\n");
                            for (int k = 0; k < oExcpnTypes.length; ++k) {
                                sb.append(oExcpnTypes[k].getName() + "\n");
                            }
                            sb.append("Return type:" + oMethods[j].getReturnType().getName() + "\n");
                            sb.append("-------------------------------\n");
                        }
                        System.err.println(sb.toString());
                        Object[] args4 = new String[]{sMethodName, oRule.getName(), sClassName, e.getMessage()};
                        OiiolTextLogger.appendText((String)sb.toString(), (int)OiiolTextLogger.LOG_DETAILED);
                        throw new OipcfExecuteFixUpRuleException("OUI-65032", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcf.resources.OipcfRuntimeRes", (String)"OUI-65032", (Object[])args4), e);
                    }
                    catch (NullPointerException e) {
                        OiiolTextLogger.appendText((String)("java.lang.NullPointerException was thrown when trying to obtain " + sClassName + "::" + sMethodName + " .\n"), (int)OiiolTextLogger.LOG_DETAILED);
                        Object[] args5 = new String[]{sMethodName, oRule.getName(), sClassName, e.getMessage()};
                        throw new OipcfExecuteFixUpRuleException("OUI-65033", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcf.resources.OipcfRuntimeRes", (String)"OUI-65033", (Object[])args5), e);
                    }
                    catch (SecurityException e) {
                        OiiolTextLogger.appendText((String)("java.lang.SecurityException was thrown when trying to obtain " + sClassName + "::" + sMethodName + " .\n"), (int)OiiolTextLogger.LOG_DETAILED);
                        Object[] args6 = new String[]{sMethodName, oRule.getName(), sClassName, e.getMessage()};
                        throw new OipcfExecuteFixUpRuleException("OUI-65034", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcf.resources.OipcfRuntimeRes", (String)"OUI-65034", (Object[])args6), e);
                    }
                    Object[] arguments = new Object[]{m_oRulesEngine, sRefFile, oRawResult, filesList};
                    try {
                        oFixUpResult = (OipcfFixUpResult)oMethod.invoke(null, arguments);
                        OiiolTextLogger.appendText((String)("Invoked the method  " + sClassName + "::" + sMethodName + " .\n"), (int)OiiolTextLogger.LOG_DETAILED);
                        oFixUpSet.setFixUpResult(oFixUpResult);
                        continue;
                    }
                    catch (ClassCastException e) {
                        OiiolTextLogger.appendText((String)("java.lang.ClassCastException was thrown when " + sClassName + "::" + sMethodName + " was invoked.\n"), (int)OiiolTextLogger.LOG_DETAILED);
                        args = new String[]{oRuleSet.getName(), oRule.getName(), sClassName, sMethodName, e.getMessage()};
                        throw new OipcfExecuteFixUpRuleException("OUI-65035", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcf.resources.OipcfRuntimeRes", (String)"OUI-65035", (Object[])args), e);
                    }
                    catch (IllegalAccessException e) {
                        args = new String[]{oRuleSet.getName(), oRule.getName(), sClassName, sMethodName, e.getMessage()};
                        OiiolTextLogger.appendText((String)("java.lang.IllegalAccessException was thrown when " + sClassName + "::" + sMethodName + " was invoked.\n"), (int)OiiolTextLogger.LOG_DETAILED);
                        throw new OipcfExecuteFixUpRuleException("OUI-65036", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcf.resources.OipcfRuntimeRes", (String)"OUI-65036", (Object[])args), e);
                    }
                    catch (IllegalArgumentException e) {
                        args = new String[]{oRuleSet.getName(), oRule.getName(), sClassName, sMethodName, e.getMessage()};
                        OiiolTextLogger.appendText((String)("java.lang.IllegalArgumentException was thrown when " + sClassName + "::" + sMethodName + " was invoked.\n"), (int)OiiolTextLogger.LOG_DETAILED);
                        throw new OipcfExecuteFixUpRuleException("OUI-65037", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcf.resources.OipcfRuntimeRes", (String)"OUI-65037", (Object[])args), e);
                    }
                    catch (InvocationTargetException e) {
                        OiiolTextLogger.appendText((String)("java.lang.reflect.InvocationTargetException was thrown when " + sClassName + "::" + sMethodName + " was invoked.\n"), (int)OiiolTextLogger.LOG_DETAILED);
                        args = new String[]{oRuleSet.getName(), oRule.getName(), sClassName, sMethodName, e.getTargetException().getMessage()};
                        throw new OipcfExecuteFixUpRuleException("OUI-65038", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcf.resources.OipcfRuntimeRes", (String)"OUI-65038", (Object[])args), e);
                    }
                    catch (NullPointerException e) {
                        OiiolTextLogger.appendText((String)("java.lang.NullPointerException was thrown when " + sClassName + "::" + sMethodName + " was invoked.\n"), (int)OiiolTextLogger.LOG_DETAILED);
                        args = new String[]{oRuleSet.getName(), oRule.getName(), sClassName, sMethodName, e.getMessage()};
                        throw new OipcfExecuteFixUpRuleException("OUI-65040", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcf.resources.OipcfRuntimeRes", (String)"OUI-65040", (Object[])args), e);
                    }
                    catch (ExceptionInInitializerError e) {
                        args = new String[]{oRuleSet.getName(), oRule.getName(), sClassName, sMethodName, e.getMessage()};
                        OiiolTextLogger.appendText((String)("java.lang.ExceptionInInitializerError occured when " + sClassName + "::" + sMethodName + " was invoked.\n"), (int)OiiolTextLogger.LOG_DETAILED);
                        throw new OipcfExecuteFixUpRuleException("OUI-65041", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcf.resources.OipcfRuntimeRes", (String)"OUI-65041"), e);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    String sRuleName = null;
                    if (oRule != null) {
                        sRuleName = oRule.getName();
                    }
                    OiiolTextLogger.appendText((String)("Setting the result of execution of the fixup rule " + sRuleName + "to failed.\n"), (int)OiiolTextLogger.LOG_DETAILED);
                    oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, new OipcfExecuteFixUpRuleException(e), filesList);
                    oFixUpSet.setFixUpResult(oFixUpResult);
                }
            }
        }
    }
}

