/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipck;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipck.OipckIRefKnowledgeSourceLibrary;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceFactory;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceInfo;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckRefKnowledgeSource;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;

public class OipckRefKnowledgeSourceLibrary
implements OipckIRefKnowledgeSourceLibrary {
    private Map m_oRefKnowledgeSource = new HashMap(5);
    private List m_oRefKnowledgeSourceInfo = new ArrayList(5);
    private static final int s_iInitialLibrarySize = 5;

    OipckRefKnowledgeSourceLibrary() {
    }

    public Object getRefKnowledgeSource(String sKey, String sFile) throws OipckUnknownKnowledgeSourceException, OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        OipckKnowledgeSourceInfo dummyksi = new OipckKnowledgeSourceInfo();
        dummyksi.setName(sKey);
        int idx = this.m_oRefKnowledgeSourceInfo.indexOf(dummyksi);
        if (idx != -1) {
            OipckKnowledgeSourceInfo ksi = (OipckKnowledgeSourceInfo)this.m_oRefKnowledgeSourceInfo.get(idx);
            ArrayList<OipckRefKnowledgeSource> rksl = (ArrayList<OipckRefKnowledgeSource>)this.m_oRefKnowledgeSource.get(ksi);
            OipckRefKnowledgeSource rks = null;
            boolean bLoad = false;
            if (rksl == null) {
                rksl = new ArrayList<OipckRefKnowledgeSource>();
                bLoad = true;
            } else {
                rks = this.getRefKnowledgeSource(rksl, sFile);
                boolean bl = bLoad = rks == null;
            }
            if (bLoad) {
                rks = this.loadRefKnowledgeSource(ksi, sFile);
                rksl.add(rks);
                this.m_oRefKnowledgeSource.put(ksi, rksl);
            }
            return rks.getKnowledgeSource();
        }
        Object[] args = new String[]{sKey};
        throw new OipckUnknownKnowledgeSourceException("OUI-12001", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipck.resources.OipckRuntimeRes", (String)"OUI-12001", (Object[])args));
    }

    private OipckRefKnowledgeSource getRefKnowledgeSource(List rksl, String sFileName) {
        OipckRefKnowledgeSource rks = null;
        if (rksl != null) {
            int nCnt = rksl.size();
            for (int i = 0; i < nCnt; ++i) {
                OipckRefKnowledgeSource temp = (OipckRefKnowledgeSource)rksl.get(i);
                if (!OiipgFileSystem.equalPathStrs((String)temp.getRefFile(), (String)sFileName)) continue;
                rks = temp;
            }
        }
        return rks;
    }

    void addKnowledgeSourceInfo(OipckKnowledgeSourceInfo ksi) {
        if (!this.m_oRefKnowledgeSource.containsKey(ksi)) {
            this.m_oRefKnowledgeSourceInfo.add(ksi);
            this.m_oRefKnowledgeSource.put(ksi, null);
        }
    }

    Iterator getKnowledgeSourceInfo() {
        return this.m_oRefKnowledgeSourceInfo.iterator();
    }

    private OipckRefKnowledgeSource loadRefKnowledgeSource(OipckKnowledgeSourceInfo ksi, String sFileName) throws OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        if (ksi == null) {
            return null;
        }
        String sName = ksi.getName();
        return OipckKnowledgeSourceFactory.getRefKnowledgeSource(sName, ksi.getBuilder(), sFileName);
    }
}

