/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcp;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpSet;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqCollection;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqInputException;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqReader;
import oracle.sysman.oip.oipc.oipcp.OipcpPrerequisiteCheck;
import oracle.sysman.oip.oipc.oipcp.OipcpPrerequisiteResult;
import oracle.sysman.oip.oipc.oipcp.OipcpPrerequisiteSet;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oix.oixd.OixdDOMReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OipcpPrereqDOMReader
extends OipcpPrereqReader {
    private Map m_oPrereqSets = new HashMap(10);
    private Map m_oPrereqChecks = new HashMap(10);
    private Collection m_oPrereqInputFiles;
    private String m_sPrereqInputFile;

    public OipcpPrereqDOMReader(Collection prereqInputFiles) {
        this.m_oPrereqInputFiles = prereqInputFiles;
    }

    public Map getPrereqSets() {
        return this.m_oPrereqSets;
    }

    public Map getPrereqChecks() {
        return this.m_oPrereqChecks;
    }

    public void setPrereqInputFile(Collection oFiles) {
        this.m_oPrereqInputFiles = oFiles;
    }

    public Collection getPrereqInputFiles() {
        return this.m_oPrereqInputFiles;
    }

    private String getPrereqInputFile() {
        return this.m_sPrereqInputFile;
    }

    public OipcpPrereqCollection buildPrereqCollection() throws OipcpPrereqInputException {
        Iterator oPrereqInputFiles = this.m_oPrereqInputFiles.iterator();
        while (oPrereqInputFiles.hasNext()) {
            try {
                this.m_sPrereqInputFile = (String)oPrereqInputFiles.next();
                FileInputStream in = new FileInputStream(this.m_sPrereqInputFile);
                Document oPrereqDoc = OixdDOMReader.getDocument((InputStream)in);
                Element oPrereqTestsNode = oPrereqDoc.getDocumentElement();
                NodeList oSetNodes = oPrereqTestsNode.getElementsByTagName("PREREQUISITESET");
                int nSize = oSetNodes.getLength();
                for (int i = 0; i < nSize; ++i) {
                    Element oNode = (Element)oSetNodes.item(i);
                    OipcpPrerequisiteSet oSet = this.createPrereqSet(oNode);
                    this.addToSets(oSet);
                }
                NodeList oCheckNodes = oPrereqTestsNode.getElementsByTagName("PREREQUISITE");
                nSize = oCheckNodes.getLength();
                for (int i = 0; i < nSize; ++i) {
                    Element oNode = (Element)oCheckNodes.item(i);
                    OipcpPrerequisiteCheck oCheck = this.createPrereqCheck(oNode);
                    this.addToChecks(oCheck);
                }
            }
            catch (SAXException se) {
                se.printStackTrace();
                throw new OipcpPrereqInputException(se.getMessage(), se);
            }
            catch (ParserConfigurationException pe) {
                pe.printStackTrace();
                throw new OipcpPrereqInputException(pe.getMessage(), pe);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new OipcpPrereqInputException(ioe.getMessage(), ioe);
            }
        }
        OipcpPrereqCollection oPrereqCollection = new OipcpPrereqCollection(this.m_oPrereqSets, this.m_oPrereqChecks);
        return oPrereqCollection;
    }

    private OipcpPrerequisiteSet createPrereqSet(Element oNode) throws OipcpPrereqInputException {
        OipcpPrerequisiteSet oSet = null;
        String sName = oNode.getAttribute("NAME");
        if (this.m_oPrereqSets.containsKey(sName)) {
            oSet = (OipcpPrerequisiteSet)this.m_oPrereqSets.get(sName);
            if (oSet == null) {
                Object[] args = new String[]{oSet.getName(), this.getPrereqInputFile()};
                String sMessage = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OUI-62000", (Object[])args);
                throw new OipcpPrereqInputException(sMessage);
            }
            if (!oSet.isEmpty()) {
                Object[] args = new String[]{oSet.getName(), this.getPrereqInputFile()};
                String sMessage = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OUI-62001", (Object[])args);
                throw new OipcpPrereqInputException(sMessage);
            }
        } else {
            oSet = new OipcpPrerequisiteSet(sName);
        }
        NodeList oSetRefNodes = oNode.getElementsByTagName("PREREQUISITESETREF");
        int nSize = oSetRefNodes.getLength();
        for (int i = 0; i < nSize; ++i) {
            Element oSetRefElement = (Element)oSetRefNodes.item(i);
            String sSetName = oSetRefElement.getAttribute("NAME");
            OipcpPrerequisiteSet oSetRef = new OipcpPrerequisiteSet(sSetName);
            oSetRef = this.addToSets(oSetRef);
            oSet.addPrereq(oSetRef);
        }
        NodeList oCheckRefNodes = oNode.getElementsByTagName("PREREQUISITEREF");
        nSize = oCheckRefNodes.getLength();
        for (int i = 0; i < nSize; ++i) {
            Element oCheckRefElement = (Element)oCheckRefNodes.item(i);
            String sCheckName = oCheckRefElement.getAttribute("NAME");
            OipcpPrerequisiteCheck oCheckRef = new OipcpPrerequisiteCheck(sCheckName);
            oCheckRef = this.addToChecks(oCheckRef);
            int nSeverity = this.getSeverityAsInt(oCheckRefElement.getAttribute("SEVERITY"));
            if (nSeverity > oCheckRef.getSeverity()) {
                oCheckRef.setSeverity(nSeverity);
            }
            oSet.addPrereq(oCheckRef);
        }
        return oSet;
    }

    private OipcpPrerequisiteCheck createPrereqCheck(Element oNode) throws OipcpPrereqInputException {
        String sName = oNode.getAttribute("NAME");
        String sTitle = oNode.getAttribute("EXTERNALNAME");
        String sTitleId = oNode.getAttribute("EXTERNALNAMEID");
        int nSeverity = this.getSeverityAsInt(oNode.getAttribute("SEVERITY"));
        String sDesc = "";
        String sDescId = "";
        NodeList oList = oNode.getElementsByTagName("DESCRIPTION");
        if (oList != null && oList.getLength() >= 1) {
            Element oElem = (Element)oList.item(0);
            sDesc = oElem.getAttribute("TEXT");
            sDescId = oElem.getAttribute("TEXTID");
        } else {
            sDesc = sName;
        }
        String sRule = "";
        String sRuleSet = "";
        String sRefFile = "";
        oList = oNode.getElementsByTagName("RULESETREF");
        if (oList != null && oList.getLength() >= 1) {
            Element oElem = (Element)oList.item(0);
            sRule = oElem.getAttribute("RULE");
            sRuleSet = oElem.getAttribute("NAME");
            sRefFile = oElem.getAttribute("FILE");
        }
        String sErrMsg = "";
        String sErrMsgId = "";
        oList = oNode.getElementsByTagName("PROBLEM");
        if (oList != null && oList.getLength() >= 1) {
            Element oElem = (Element)oList.item(0);
            sErrMsg = oElem.getAttribute("TEXT");
            sErrMsgId = oElem.getAttribute("TEXTID");
        }
        String sRecText = "";
        String sRecTextId = "";
        oList = oNode.getElementsByTagName("RECOMMENDATION");
        if (oList != null && oList.getLength() >= 1) {
            Element oElem = (Element)oList.item(0);
            sRecText = oElem.getAttribute("TEXT");
            sRecTextId = oElem.getAttribute("TEXTID");
        }
        oList = oNode.getElementsByTagName("FIXUP");
        ArrayList<OipcfFixUpSet> oFixUpList = new ArrayList<OipcfFixUpSet>();
        if (oList != null && oList.getLength() >= 1) {
            Element oElem = (Element)oList.item(0);
            NodeList oFixUpSetRefList = oElem.getElementsByTagName("FIXUPSETREF");
            int nSize = oFixUpSetRefList.getLength();
            for (int i = 0; i < nSize; ++i) {
                String sFixUpSet = "";
                String sFixUpRule = "";
                Element oFixUpSetRef = (Element)oFixUpSetRefList.item(i);
                sFixUpSet = oFixUpSetRef.getAttribute("NAME");
                sFixUpRule = oFixUpSetRef.getAttribute("FIXUP");
                NodeList oFixUpFiles = oFixUpSetRef.getElementsByTagName("FILE");
                ArrayList<String> oFixUpFileList = new ArrayList<String>();
                for (int j = 0; j < oFixUpFiles.getLength(); ++j) {
                    Element oFixUpFile = (Element)oFixUpFiles.item(j);
                    String sFixUpFileName = oFixUpFile.getAttribute("NAME");
                    oFixUpFileList.add(sFixUpFileName);
                }
                OipcfFixUpSet oFixUpSet = new OipcfFixUpSet(sFixUpSet, sFixUpRule, oFixUpFileList);
                oFixUpList.add(oFixUpSet);
            }
        }
        OipcpPrerequisiteResult oResult = null;
        String sResultValue = null;
        oList = oNode.getElementsByTagName("RESULT");
        if (oList != null && oList.getLength() >= 1) {
            Element oElem = (Element)oList.item(0);
            sResultValue = oElem.getAttribute("VALUE");
            if (sResultValue.equalsIgnoreCase(OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OUI-62003"))) {
                oResult = new OipcpPrerequisiteResult(OipcrResult.PASSED_RESULT);
            } else if (sResultValue.equalsIgnoreCase(OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OUI-62004"))) {
                oResult = new OipcpPrerequisiteResult(OipcrResult.FAILED_RESULT);
            } else if (sResultValue.equalsIgnoreCase(OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OUI-62005"))) {
                oResult = new OipcpPrerequisiteResult(OipcrResult.NOT_EXECUTED_RESULT);
            }
        }
        OipcpPrerequisiteCheck oCheck = new OipcpPrerequisiteCheck(sName, sRuleSet, sRule, nSeverity, sErrMsg, sErrMsgId, sTitle, sTitleId, sDesc, sDescId, sRecText, sRecTextId, sRefFile, oFixUpList);
        oCheck.setResult(oResult);
        OipcpPrerequisiteCheck oExistingCheck = null;
        if (this.m_oPrereqChecks.containsKey(sName)) {
            String sMessage;
            Object[] args;
            oExistingCheck = (OipcpPrerequisiteCheck)this.m_oPrereqChecks.get(sName);
            if (oExistingCheck == null) {
                args = new String[]{oCheck.getName(), this.getPrereqInputFile()};
                sMessage = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OUI-62000", (Object[])args);
                throw new OipcpPrereqInputException(sMessage);
            }
            if (!oExistingCheck.isEmpty()) {
                args = new String[]{oCheck.getName(), this.getPrereqInputFile()};
                sMessage = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OUI-62001", (Object[])args);
                throw new OipcpPrereqInputException(sMessage);
            }
            oExistingCheck.update(oCheck);
            oExistingCheck.setResult(oCheck.getResult());
        } else {
            oExistingCheck = this.addToChecks(oCheck);
        }
        return oExistingCheck;
    }

    private int getSeverityAsInt(String sSeverity) {
        int nSeverity = 1;
        if (sSeverity.equalsIgnoreCase("Error")) {
            nSeverity = 0;
        } else if (sSeverity.equalsIgnoreCase("Warning")) {
            nSeverity = 1;
        }
        return nSeverity;
    }

    private OipcpPrerequisiteSet addToSets(OipcpPrerequisiteSet oSet) throws OipcpPrereqInputException {
        OipcpPrerequisiteSet oExistingSet = null;
        if (this.m_oPrereqSets.containsKey(oSet.getName())) {
            oExistingSet = (OipcpPrerequisiteSet)this.m_oPrereqSets.get(oSet.getName());
            if (oExistingSet.isEmpty()) {
                oExistingSet.setPrereqs(oSet.getPrereqs());
            } else if (!oSet.isEmpty() && !oExistingSet.equals(oSet)) {
                Object[] args = new String[]{oSet.getName(), this.getPrereqInputFile()};
                String sMessage = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OUI-62001", (Object[])args);
                throw new OipcpPrereqInputException(sMessage);
            }
        } else {
            this.m_oPrereqSets.put(oSet.getName(), oSet);
        }
        return (OipcpPrerequisiteSet)this.m_oPrereqSets.get(oSet.getName());
    }

    private OipcpPrerequisiteCheck addToChecks(OipcpPrerequisiteCheck oCheck) {
        OipcpPrerequisiteCheck oExistingCheck = null;
        if (this.m_oPrereqChecks.containsKey(oCheck.getName())) {
            oExistingCheck = (OipcpPrerequisiteCheck)this.m_oPrereqChecks.get(oCheck.getName());
            if (oExistingCheck.isEmpty()) {
                if (!oCheck.isEmpty()) {
                    oExistingCheck.update(oCheck);
                } else if (oCheck.getSeverity() > oExistingCheck.getSeverity()) {
                    oExistingCheck.setSeverity(oCheck.getSeverity());
                }
            } else if (!oCheck.isEmpty() && !oExistingCheck.equals(oCheck)) {
                // empty if block
            }
        } else {
            this.m_oPrereqChecks.put(oCheck.getName(), oCheck);
        }
        return (OipcpPrerequisiteCheck)this.m_oPrereqChecks.get(oCheck.getName());
    }
}

