/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.cluster.VoteDiskInfo;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilQuery;
import oracle.sysman.oii.oiil.OiilQueryException;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class GetVDSKLocations
implements OiilQuery {
    public static final String SuccMsg = "SUCCESS";
    public static String VDSKSH = "vdsk10102.sh ";
    public static String chmodCmd = "/bin/chmod 555 ";

    public Object performQuery(Vector inputs) throws OiilQueryException {
        String crsHome = (String)this.retItem(inputs, "oracleHome");
        String crsVersion = (String)this.retItem(inputs, "crsversion");
        if (crsVersion == null || crsVersion.trim().length() == 0) {
            crsVersion = "10.1.0.2.0";
        }
        String[] result = null;
        if (crsVersion.equals("10.1.0.2.0")) {
            String pathName = new String(System.getProperty("oracle.installer.NatLibDir"));
            String command = pathName + VDSKSH + crsHome;
            String[] env = new String[]{"ORACLE_HOME=" + crsHome};
            OiixPlatform oiiPl = new OiixPlatform();
            int platID = oiiPl.getCurrentPlatform();
            String exePermCmd = chmodCmd + pathName + "/" + VDSKSH;
            RunLocalUnixCommand commandObject = new RunLocalUnixCommand(exePermCmd, env, platID);
            commandObject = new RunLocalUnixCommand(command, env, platID);
            String[] lines = commandObject.outStore;
            result = lines == null ? new String[]{"ERROR", null} : new String[]{SuccMsg, lines[0]};
        } else {
            try {
                Version v = new Version();
                ClusterInfo clusterObj = new ClusterInfo(crsHome, v);
                VoteDiskInfo[] vdskObj = clusterObj.getVoteDiskLocations();
                if (vdskObj != null) {
                    result = new String[vdskObj.length + 1];
                    int idx = 0;
                    result[idx++] = SuccMsg;
                    for (int i = 0; i < vdskObj.length; ++i) {
                        result[idx++] = vdskObj[i].getPath();
                    }
                }
            }
            catch (ClusterInfoException ciexcep) {
                String errMsg = ciexcep.getMessage();
                String[] RetMsg = new String[]{"ERROR", errMsg};
                return RetMsg;
            }
        }
        return result;
    }

    Object retItem(Vector inputs, String param) {
        int pos = OiixVectorOps.vectIndexOf((Vector)inputs, (Object)param);
        if (pos == -1) {
            return null;
        }
        OiilActionInputElement aie = (OiilActionInputElement)inputs.elementAt(pos);
        return aie.getObject();
    }

    public static void main(String[] args) {
        GetVDSKLocations obj = new GetVDSKLocations();
        Vector<OiilActionInputElement> inputs = new Vector<OiilActionInputElement>();
        String[] retval = null;
        try {
            inputs.addElement(new OiilActionInputElement("oracleHome", (Object)args[0]));
            inputs.addElement(new OiilActionInputElement("crsversion", (Object)args[1]));
            retval = (String[])obj.performQuery(inputs);
            if (retval != null) {
                for (int i = 0; i < retval.length; ++i) {
                    System.out.println("retval[" + i + "]:" + retval[i]);
                }
            } else {
                System.out.println("Return Value is null: " + retval);
            }
        }
        catch (OiilQueryException oe) {
            // empty catch block
        }
    }
}

