/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.net;

import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import oracle.i18n.net.OraInternetAddress;
import oracle.i18n.util.LocaleMapper;

public class OraMimeMessage
extends MimeMessage {
    private Locale m_locale;
    private String m_iana_charset;

    public OraMimeMessage(Session session, Locale locale) throws MessagingException {
        super(session);
        String[] stringArray;
        this.m_locale = locale;
        if (locale != null) {
            this.setContentLanguage(new String[]{locale.toString().replace('_', '-')});
        }
        this.m_iana_charset = (stringArray = LocaleMapper.getIANACharSetFromLocale(4, locale)) != null && stringArray.length > 0 ? stringArray[0] : "utf-8";
    }

    public OraMimeMessage(Session session, String string) throws MessagingException, UnsupportedEncodingException {
        super(session);
        "a".getBytes(string);
        this.m_iana_charset = LocaleMapper.getIANACharacterSet(3, string);
    }

    public OraMimeMessage(Session session, Locale locale, String string) throws MessagingException, UnsupportedEncodingException {
        super(session);
        "a".getBytes(string);
        this.m_locale = locale;
        if (locale != null) {
            this.setContentLanguage(new String[]{locale.toString().replace('_', '-')});
        }
        this.m_iana_charset = LocaleMapper.getIANACharacterSet(3, string);
    }

    public void setSubject(String string) throws MessagingException {
        super.setSubject(string, OraInternetAddress.getSafeCharacterSet(string, this.m_iana_charset));
    }

    public void setDescription(String string) throws MessagingException {
        super.setDescription(string, OraInternetAddress.getSafeCharacterSet(string, this.m_iana_charset));
    }

    public void setContent(Object object, String string) throws MessagingException {
        if ("text/html".equals(string) || "text/plain".equals(string)) {
            super.setContent(object, string + "; charset=" + this.m_iana_charset);
        } else {
            super.setContent(object, string);
        }
    }

    public void setText(String string) throws MessagingException {
        super.setText(string, this.m_iana_charset);
    }

    public void setHeader(String string, String string2) throws MessagingException {
        if ("Content-Type".equals(string) && ("text/plain".equals(string2) || "text/html".equals(string2))) {
            super.setHeader("Content-Type", string2 + "; charset=" + this.m_iana_charset);
            return;
        }
        if (string2 == null || !OraInternetAddress.isNonAsciiContained(string2)) {
            super.setHeader(string, string2);
            return;
        }
        try {
            super.setHeader(string, MimeUtility.encodeText((String)string2, (String)this.m_iana_charset, (String)("ISO-2022-JP".equalsIgnoreCase(this.m_iana_charset) ? "B" : null)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void addHeader(String string, String string2) throws MessagingException {
        if ("Content-Type".equals(string) && ("text/plain".equals(string2) || "text/html".equals(string2))) {
            super.addHeader("Content-Type", string2 + "; charset=" + this.m_iana_charset);
        } else if (string2 == null || !OraInternetAddress.isNonAsciiContained(string2)) {
            super.addHeader(string, string2);
        }
        try {
            super.addHeader(string, MimeUtility.encodeText((String)string2, (String)this.m_iana_charset, (String)("ISO-2022-JP".equalsIgnoreCase(this.m_iana_charset) ? "B" : null)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

