/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import oracle.i18n.text.OraCollator;
import oracle.i18n.text.OraMapTable;
import oracle.i18n.text.SortedCommonLocales;
import oracle.i18n.util.OraLocaleInfo;
import oracle.i18n.util.OraResourceBundle;

public class OraDisplayLocaleInfo {
    public static final int SHORT = 3;
    public static final int LONG = 1;
    public static final int DEFAULT = 2;
    private static int m_initv = 1;
    private static final Map m_cache = new HashMap(m_initv);
    private static final String M_C_LANGUAGE_RESB = "oracle.i18n.util.message.LanguageTranslations";
    private static final String M_C_TERRITORY_RESB = "oracle.i18n.util.message.TerritoryTranslations";
    private static final String M_C_LANG_TERRIT_RESB = "oracle.i18n.util.message.LanguageTerritoryTranslations";
    private static final String M_C_TIMEZONE_RESB = "oracle.i18n.util.message.TimeZoneTranslations";
    private static final String M_C_LINGUISTIC_SORT_RESB = "oracle.i18n.util.message.LinguisticSortTranslations";
    private static final String M_C_CHARACTER_SET_RESB = "oracle.i18n.util.message.CharacterSetTranslations";
    private static final String M_C_CURRENCY_RESB = "oracle.i18n.util.message.CurrencyTranslations";
    private static final OraDisplayLocaleInfo m_english_odli = new OraDisplayLocaleInfo(new Locale("en", ""), null);
    private final ResourceBundle m_language_resb;
    private final ResourceBundle m_territory_resb;
    private final ResourceBundle m_lang_territ_resb;
    private final Locale m_locale;
    private final Locale m_defLocale;
    private static final Map m_ccl;
    private static final Set m_comDLSet;
    private static final OraMapTable COMMON_LOCALES;

    private OraDisplayLocaleInfo(Locale locale, Locale locale2) {
        this.m_locale = locale;
        this.m_defLocale = locale2;
        this.m_language_resb = OraResourceBundle.getBundle(M_C_LANGUAGE_RESB, locale, locale2, this.getClass().getClassLoader());
        this.m_territory_resb = OraResourceBundle.getBundle(M_C_TERRITORY_RESB, locale, locale2, this.getClass().getClassLoader());
        this.m_lang_territ_resb = OraResourceBundle.getBundle(M_C_LANG_TERRIT_RESB, locale, locale2, this.getClass().getClassLoader());
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public static OraDisplayLocaleInfo getInstance(Locale locale) {
        return OraDisplayLocaleInfo.getInstance(locale, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OraDisplayLocaleInfo getInstance(Locale locale, Locale locale2) {
        OraDisplayLocaleInfo oraDisplayLocaleInfo = null;
        Map map = m_cache;
        synchronized (map) {
            oraDisplayLocaleInfo = (OraDisplayLocaleInfo)m_cache.get(locale);
            if (oraDisplayLocaleInfo == null) {
                oraDisplayLocaleInfo = new OraDisplayLocaleInfo(locale, locale2);
                m_cache.put(locale, oraDisplayLocaleInfo);
            }
        }
        return oraDisplayLocaleInfo;
    }

    public String getDisplayLocale(Locale locale) {
        return this.getDisplayLocale(locale.getLanguage(), locale.getCountry());
    }

    public String getDisplayLocale(String string, String string2) {
        if (string2 != null && !string2.equals("")) {
            try {
                String string3 = this.m_lang_territ_resb.getString(string.toLowerCase());
                String string4 = this.m_territory_resb.getString(string2.toUpperCase());
                Object[] objectArray = new Object[]{string4};
                return MessageFormat.format(string3, objectArray);
            }
            catch (MissingResourceException missingResourceException) {
                return string + " (" + string2 + ")";
            }
            catch (NullPointerException nullPointerException) {
                return "";
            }
        }
        try {
            return this.m_language_resb.getString(string.toLowerCase());
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayLanguage(Locale locale) {
        try {
            return this.getDisplayLanguage(locale.getLanguage());
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayLanguage(String string) {
        try {
            return this.m_language_resb.getString(string.toLowerCase());
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayCountry(Locale locale) {
        try {
            return this.getDisplayCountry(locale.getCountry());
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayCountry(String string) {
        try {
            return this.m_territory_resb.getString(string.toUpperCase());
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayTerritory(String string) {
        return this.getDisplayCountry(string);
    }

    public String getDisplayTimeZone(TimeZone timeZone) {
        return this.getDisplayTimeZone(2, timeZone != null ? timeZone.getID() : "");
    }

    public String getDisplayTimeZone(String string) {
        return this.getDisplayTimeZone(2, string);
    }

    public String getDisplayTimeZone(int n, TimeZone timeZone) {
        return this.getDisplayTimeZone(n, timeZone != null ? timeZone.getID() : "");
    }

    public String getDisplayTimeZone(int n, String string) {
        ResourceBundle resourceBundle = OraResourceBundle.getBundle(M_C_TIMEZONE_RESB, this.m_locale, this.m_defLocale, this.getClass().getClassLoader());
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            int n2 = TimeZone.getTimeZone(string).getRawOffset() / 1000;
            String string2 = " ";
            if (n2 > 0) {
                string2 = "+";
            } else if (n2 < 0) {
                n2 *= -1;
                string2 = "-";
            }
            int n3 = n2 / 3600;
            String string3 = "0" + new Integer(n3).toString();
            String string4 = "0" + new Integer((n2 - n3 * 3600) / 60).toString();
            return "(UTC" + string2 + string3.substring(0, 2) + ":" + string4.substring(0, 2) + ")";
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayLinguisticSort(String string) {
        ResourceBundle resourceBundle = OraResourceBundle.getBundle(M_C_LINGUISTIC_SORT_RESB, this.m_locale, this.m_defLocale, this.getClass().getClassLoader());
        try {
            return resourceBundle.getString(string.toLowerCase());
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayCharacterSet(String string) {
        ResourceBundle resourceBundle = OraResourceBundle.getBundle(M_C_CHARACTER_SET_RESB, this.m_locale, this.m_defLocale, this.getClass().getClassLoader());
        try {
            return resourceBundle.getString(string.toUpperCase());
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayCurrency(String string) {
        ResourceBundle resourceBundle = OraResourceBundle.getBundle(M_C_CURRENCY_RESB, this.m_locale, this.m_defLocale, this.getClass().getClassLoader());
        try {
            return resourceBundle.getString(string.toUpperCase());
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public static synchronized List getCommonLocales(Locale locale) {
        Object object;
        Object[] objectArray;
        ArrayList<Object> arrayList = (ArrayList<Object>)m_ccl.get(locale);
        if (arrayList != null) {
            return arrayList;
        }
        String string = locale.toString();
        String string2 = null;
        if (m_comDLSet.isEmpty()) {
            objectArray = COMMON_LOCALES.getStringArrayAttribute("COMMON_DISPLAY_LOCALES");
            for (int i = 0; i < objectArray.length; ++i) {
                m_comDLSet.add(objectArray[i]);
            }
        }
        objectArray = null;
        string2 = OraDisplayLocaleInfo.matchCommonDisplayLocales(string, m_comDLSet);
        if (string2 != null) {
            object = SortedCommonLocales.getInstance(string2);
            objectArray = ((SortedCommonLocales)object).getSortedCommonLocales();
        } else {
            object = OraLocaleInfo.getCommonLocales();
            objectArray = new Locale[((Locale[])object).length];
            OraDisplayLocaleInfo oraDisplayLocaleInfo = OraDisplayLocaleInfo.getInstance(locale);
            OraLocaleInfo oraLocaleInfo = OraLocaleInfo.getInstance(locale);
            String[] stringArray = oraLocaleInfo.getLocalLinguisticSorts();
            OraCollator oraCollator = stringArray.length == 0 ? OraCollator.getInstance(locale) : OraCollator.getInstance(stringArray[0]);
            System.arraycopy(object, 0, objectArray, 0, ((Object)object).length);
            OraDisplayLocaleInfo.sortByDisplay((Locale[])objectArray, 0, objectArray.length - 1, oraDisplayLocaleInfo, oraCollator);
        }
        arrayList = new ArrayList<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        m_ccl.put(locale, arrayList);
        return arrayList;
    }

    public static void sortByDisplay(Locale[] localeArray, int n, int n2, OraDisplayLocaleInfo oraDisplayLocaleInfo, OraCollator oraCollator) {
        String string = oraDisplayLocaleInfo.getDisplayLocale(localeArray[(n + n2) / 2]);
        int n3 = n;
        int n4 = n2;
        Locale locale = null;
        while (true) {
            if (oraCollator.compare(oraDisplayLocaleInfo.getDisplayLocale(localeArray[n3]), string) < 0) {
                ++n3;
                continue;
            }
            while (oraCollator.compare(string, oraDisplayLocaleInfo.getDisplayLocale(localeArray[n4])) < 0) {
                --n4;
            }
            if (n3 >= n4) break;
            locale = localeArray[n3];
            localeArray[n3] = localeArray[n4];
            localeArray[n4] = locale;
            ++n3;
            --n4;
        }
        if (n < n3 - 1) {
            OraDisplayLocaleInfo.sortByDisplay(localeArray, n, n3 - 1, oraDisplayLocaleInfo, oraCollator);
        }
        if (n4 + 1 < n2) {
            OraDisplayLocaleInfo.sortByDisplay(localeArray, n4 + 1, n2, oraDisplayLocaleInfo, oraCollator);
        }
    }

    private static String matchCommonDisplayLocales(String string, Set set) {
        if (string.equals("zh_SG") || string.equals("zh")) {
            string = "zh_CN";
        } else if (string.equals("zh_MA") || string.equals("zh_HK")) {
            string = "zh_TW";
        }
        String string2 = string.substring(0, 2);
        if (set.contains(string)) {
            return string;
        }
        if (set.contains(string2)) {
            return string2;
        }
        return null;
    }

    static {
        m_cache.put(Locale.ENGLISH, m_english_odli);
        m_ccl = new HashMap();
        m_comDLSet = new HashSet();
        COMMON_LOCALES = OraMapTable.getInstance(1);
    }
}

