<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:template match="summary">
<xsl:variable name="indent" select="' '" />
<html>
<body>
<table width="100%" border="0" cellpadding="1" cellspacing="2" style="border-collapse: collapse;">
	<xsl:apply-templates select="category"/>
</table>
</body>
</html>
</xsl:template>
<xsl:template match="category">
   <tr>
	   <th style="background-color: #E0E0E0" colspan ="2" align="left"> 
        <font size="3"><xsl:value-of select="description/text()"/></font>
       </th>
   </tr>
   <xsl:apply-templates select="variable"/>
   <tr>
	   <td colspan="2" bgcolor="ffffff">&#160;</td>
   </tr>
</xsl:template>
<xsl:template match="category/variable">
<tr> 
	<xsl:apply-templates select="*"/>
</tr>
</xsl:template>
<xsl:template match="category/variable/description">	
   <td width="30%">
	   <xsl:value-of select="text()"/>
   </td>
</xsl:template>
<xsl:template match="category/variable/value">
   <td width="70%" align="left">
     <xsl:value-of select="text()" />
   </td>
</xsl:template>
<xsl:template match="category/variable/percentage">
	<td width="70%" align="left">
		<div style="background-color: #E0E0E0; " width="100px">
			<div style="background-color: #8080ff; border-color: #000000">
				<xsl:attribute name="width"><xsl:value-of select="@value"/>px</xsl:attribute>
			</div>
		</div>
		<xsl:if test="string-length(description/text())>0">
   	       <div align="left">
			 <font size="2"><xsl:value-of select="description/text()"/></font>
	       </div>
		</xsl:if>
	</td>
</xsl:template>
</xsl:stylesheet>
