Rem
Rem $Header: rdbms/admin/apex_to_common.sql /st_rdbms_12.1.0.1/1 2013/04/14 20:05:52 talliu Exp $
Rem
Rem apex_to_common.sql
Rem
Rem Copyright (c) 2012, 2013, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      apex_to_common.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sankejai    03/26/13 - 16530655: do not update status in container$
Rem    pyam        11/15/12 - Converts Local APEX to Common APEX in a PDB.
Rem    pyam        11/15/12 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

VARIABLE pdbname VARCHAR2(128)
WHENEVER SQLERROR EXIT;

BEGIN
  SELECT sys_context('USERENV', 'CON_NAME') 
    INTO :pdbname
    FROM dual
    WHERE sys_context('USERENV', 'CON_NAME') <> 'CDB$ROOT';
END;
/

col pdbname new_value pdbname

select :pdbname pdbname from dual;

alter session set "_ORACLE_SCRIPT"=true;
alter session set "_NONCDB_TO_PDB"=true;
alter session set container=CDB$ROOT;

-- if pdb was already closed, don't exit on error
WHENEVER SQLERROR CONTINUE;

alter pluggable database "&pdbname" close;

WHENEVER SQLERROR EXIT;

alter pluggable database "&pdbname" open restricted;

create or replace view sys.cdb$common_root_objects sharing=object as
select u.name owner, o.name object_name, o.type# object_type, o.namespace nsp,
       o.subname object_subname, o.signature object_sig,
       decode(bitand(o.flags, 65536), 65536, 'MDL', 'OBL') sharing
  from sys.obj$ o, sys.user$ u where
  o.owner#=u.user# and bitand(o.flags, 196608) <> 0;

alter session set container="&pdbname";

create or replace view sys.cdb$common_root_objects sharing=object as
select u.name owner, o.name object_name, o.type# object_type, o.namespace nsp,
       o.subname object_subname, o.signature object_sig,
       decode(bitand(o.flags, 65536), 65536, 'MDL', 'OBL') sharing
  from sys.obj$ o, sys.user$ u where
  o.owner#=u.user# and bitand(o.flags, 196608) <> 0;

create or replace view sys.cdb$objects sharing=none as
select u.name owner, o.name object_name, o.signature object_sig,
       o.namespace nsp, o.subname object_subname, o.obj# object_id,
       o.type# object_type, o.flags flags, o.status status
  from sys.obj$ o, sys.user$ u
  where o.owner#=u.user#;

-- mark objects in our PDB as common if they exist as common in ROOT,
-- and invalidate
DECLARE
  cursor c is
    select p.object_id, p.flags flags, p.object_subname subname,
           p.object_type type#,
           decode(r.sharing, 'MDL', 65536, 131072) sharing_flag, p.status status
      from sys.cdb$common_root_objects r, sys.cdb$objects p
    where r.owner=p.owner and r.object_name=p.object_name
      and r.object_type=p.object_type and r.nsp=p.nsp
      and (p.object_subname is null and r.object_subname is null
           or r.object_subname=p.object_subname)
      and bitand(p.flags, 196608)=0;
  new_status number;
BEGIN
  FOR obj in c
  LOOP
    BEGIN
      IF (obj.type# not in (2, 28, 29, 30, 56) AND
          (obj.type# <> 13 or obj.subname is null))
      THEN
        new_status := 6;
      ELSE
        new_status := obj.status;
      END IF;
      execute immediate 'update sys.obj$ set flags=' ||
                        (obj.flags + obj.sharing_flag) || ', status=' ||
                        new_status || ' where obj#=' || obj.object_id;
    END;
  END LOOP;
  commit;
END;
/

alter system flush shared_pool
/
/
/

drop view sys.cdb$common_root_objects;
drop view sys.cdb$objects;

alter session set container=CDB$ROOT;

drop view sys.cdb$common_root_objects;
alter session set "_ORACLE_SCRIPT"=false;

alter pluggable database "&pdbname" close;
alter pluggable database "&pdbname" open;
alter session set container="&pdbname";

@@utlrp


alter session set container=cdb$root;
alter session set "_NONCDB_TO_PDB"=false;
alter pluggable database "&pdbname" close;
alter pluggable database "&pdbname" open;
alter session set container="&pdbname";

