Rem
Rem $Header: rdbms/admin/catcdbviews.sql /main/24 2012/11/01 11:34:27 thbaby Exp $
Rem
Rem catCDBViews.sql
Rem
Rem Copyright (c) 2011, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      catCDBViews.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem
Rem BEGIN SQL_FILE_METADATA
Rem SQL_SOURCE_FILE: rdbms/admin/catcdbviews.sql
Rem SQL_SHIPPED_FILE: rdbms/admin/catcdbviews.sql
Rem SQL_PHASE: CATCDBVIEWS
Rem SQL_STARTUP_MODE: NORMAL
Rem SQL_IGNORABLE_ERRORS: NONE
Rem SQL_CALLING_FILE: rdbms/admin/catpstrt.sql
Rem END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    thbaby      10/29/12 - 14781792: ignore GRANT_PATH type
Rem    thbaby      09/26/12 - 13867272: unconditionally create cdb views in
Rem                           catcdbviews during upgrade, catch recompilation 
Rem                           error in create_cdbview
Rem    gravipat    08/22/12 - 13739232: Ignore long columns
Rem    vpriyans    07/05/12 - Bug 14272027: Allow audit_admin and audit_viewer
Rem                           roles to select from cdb_unified_audit_trail
Rem    thbaby      06/21/12 - prevent sql injection by correctly using quotes
Rem    gravipat    06/15/12 - lrg 6995210: Remove quotes around oldview_name
Rem    thbaby      06/11/12 - allow CDB_* views over non-SYS-owned DBA_* views
Rem    gravipat    05/14/12 - 13083137: Make create_cdbview private
Rem    ssonawan    04/25/12 - bug 13964209: add cdb_unified_audit_trail
Rem    surman      03/27/12 - 13615447: Add SQL patching tags
Rem    gravipat    02/21/12 - 13724677: CDB_USERS should only show common users
Rem                           once
Rem    bhammers    07/28/07 - add exception for new vies containing xml type
Rem    gravipat    11/29/11 - Get rid of CDBView table function
Rem    sumkumar    11/09/11 - Remove WITH GRANT OPTION from public grants
Rem                         - Do not run SQL statements twice
Rem    gravipat    11/08/11 - 13356587: Use a different escape character
Rem    bhammers    07/28/07 - add exception for new vies containing xml type
Rem    gravipat    04/25/11 - Created
Rem

create or replace package sys.CDBView as 
  ----------------------------
  --  PROCEDURES AND FUNCTIONS
  --
  procedure create_cdbviews(chk_upgrd IN boolean);
  -- Main driver to create CDB views for all existing DBA views
  --  Input arguments:
  --    chk_upgrd - boolean to indicate whether we invoked create_cdbviews
  --                as part of upgrade. If chk_upgrd is TRUE, and
  --                create_cdbviews was invoked as part of upgrade, then we
  --                dont create the cdb views. Otherwise, we'll create the cdb
  --                view
end CDBView;
/

grant execute on sys.CDBView to execute_catalog_role
/

create or replace package body sys.CDBView is
-- Create the cdb view
-- private helper procedure to create the cdb view
-- Note that quotes should not be added around owner, oldview_name and 
-- newview_name before create_cdbview is invoked since all three are used 
-- as literals to query dictionary views.
procedure create_cdbview(chk_upgrd IN boolean, owner IN varchar2,
                         oldview_name IN varchar2, newview_name IN varchar2) as
  sqlstmt      varchar2(4000);
  col_name     varchar2(128);
  comments     varchar2(4000);
  openmode     varchar2(12);
  collist      varchar2(4000);
  grantee      varchar2(128);
  synonym      varchar2(128);
  col_type     varchar2(128);
  cdbviewexs   number;
  conid        number;
  quoted_owner   varchar2(130); -- 2 more than size of owner
  quoted_oldview varchar2(130); -- 2 more than size of oldview_name
  quoted_newview varchar2(130); -- 2 more than size of newview_name
  quoted_grantee varchar2(130); -- 2 more than size of grantee

  cursor cdbviewchkcur is select count(*) from dba_views where
                          view_name = newview_name;
  cursor granteecur is select p.grantee 
                         from dba_tab_privs p 
                        where p.owner = owner 
                          and p.table_name = oldview_name;
  cursor tblcommentscur is select comments from dba_tab_comments
                                  where table_name = oldview_name;
  cursor colcommentscur is select column_name, comments from dba_col_comments
                                  where table_name = oldview_name;
  cursor coltypecur is select data_type from dba_tab_cols
                      where table_name = oldview_name and column_name = col_name;
  cursor synonymcur is select s.synonym_name
                         from dba_synonyms s
                        where s.table_owner = owner 
                          and s.table_name = oldview_name
                          and s.table_name = s.synonym_name
                          and s.owner = 'PUBLIC';
begin
  -- if we are in regular db create mode, then check if the view already
  -- exists
  if(chk_upgrd) then
    open cdbviewchkcur;
    fetch cdbviewchkcur into cdbviewexs;
    close cdbviewchkcur;
    if(cdbviewexs = 1) then
      return;
    end if;
  end if;

  quoted_owner   := '"' || owner        || '"';
  quoted_oldview := '"' || oldview_name || '"';
  quoted_newview := '"' || newview_name || '"';

  -- Create cdb view
  sqlstmt := 'CREATE OR REPLACE VIEW ' || 
     quoted_owner || '.' || quoted_newview || 
     ' CONTAINER_DATA AS SELECT * FROM CDB$VIEW(' ||
     quoted_owner || '.' || quoted_oldview || ')';

  -- dbms_output.put_line(sqlstmt);
  execute immediate sqlstmt;

  -- create public synonym
  sqlstmt := 'create or replace public synonym ' || 
             quoted_newview || ' for ' || 
             quoted_owner || '.' || quoted_newview;
  -- dbms_output.put_line(sqlstmt);
  execute immediate sqlstmt;

  if newview_name = 'CDB_UNIFIED_AUDIT_TRAIL' then  
    sqlstmt := 'grant select on ' || quoted_owner || '.' || quoted_newview ||
               ' to audit_admin, audit_viewer';
    execute immediate sqlstmt;
  else
    sqlstmt := 'grant select on ' || quoted_owner || '.' || quoted_newview || 
               ' to select_catalog_role'; 
    -- dbms_output.put_line(sqlstmt);
    execute immediate sqlstmt;
  end if;

  -- table and column comments
  open tblcommentscur;
  fetch tblcommentscur into comments;
  comments := replace(comments, '''','''''');
  sqlstmt := 'comment on table ' || quoted_owner || '.' || quoted_newview ||
              ' is ''' || comments || ' in all containers''';
  -- dbms_output.put_line(sqlstmt);
  execute immediate sqlstmt;
  close tblcommentscur;

  sqlstmt := 'comment on column ' || quoted_owner || '.' || quoted_newview ||
             '.CON_ID is ''container id''';
  -- dbms_output.put_line(sqlstmt);
  execute immediate sqlstmt;
  open colcommentscur;
  loop
    fetch colcommentscur into col_name, comments;
    exit when colcommentscur%NOTFOUND;

    open coltypecur;
    fetch coltypecur into col_type;
    close coltypecur;

    comments := replace(comments, '''','''''');
    if comments is not NULL     and 
       col_type <> 'LONG'       and 
       col_type <> 'GRANT_PATH' then
      sqlstmt := 'comment on column ' ||
                 quoted_owner || '.' || quoted_newview || '.' ||
                 col_name || ' is ''' || comments || '''';
      -- dbms_output.put_line(sqlstmt);
      execute immediate sqlstmt;
    end if;
  end loop;
  close colcommentscur;

exception
  -- Catch recompilation error (4045). This is because certain XDB views may 
  -- not be recompilable during upgrade at the point where create_cdbviews
  -- is called from catcdbviews. We let the rest of the CDB view creations
  -- to proceed. Later, when catupend is call, the CDB views that were
  -- not created (due to the recompilation error) will be created. 
  -- Similarly, catch table or view does not exist error (942). 
  when others then
    if sqlcode in (-942, -4045) then null;
    else raise;
    end if;
end;

-- create all cdb views from existing dba_views
procedure create_cdbviews(chk_upgrd IN boolean) as
  owner        varchar2(128);
  oldview_name varchar2(128);
  newview_name varchar2(128);
  openmode     varchar2(12);
  upgrderror EXCEPTION;
  cursor dbaviewlist is select u.name, o.name from sys.obj$ o, sys.user$ u
                               where o.type#=4 and o.owner#=u.user# and
                               o.name like 'DBA+_%' escape '+'
                               order by u.name, o.name;
begin
  -- Do we need to check for upgrade mode? If we are in upgrade. just exit
  if(chk_upgrd) then
    execute immediate 'select status from v$instance' into openmode;
    if openmode = 'OPEN MIGRATE' then
      raise upgrderror;
    end if;
  end if;

  execute immediate 'alter session set "_ORACLE_SCRIPT"=true';

  -- CREATE CDB Views for DBA views
  open dbaviewlist;
  loop
    fetch dbaviewlist into owner, oldview_name;
    exit when dbaviewlist%NOTFOUND;

    if (owner != 'SYS'   and 
        owner != 'DVSYS' and 
        owner != 'WMSYS' and
        owner != 'LBACSYS') then 
      continue; 
    end if;

    newview_name := 'CDB' || substr(oldview_name, 4, length(oldview_name)-3);

    -- ready to create the cdb view
    create_cdbview(chk_upgrd, owner, oldview_name, newview_name);

  end loop;
  close dbaviewlist;

  -- PLACEHOLDER for creating new cdb views. please add the creation of
  -- new cdbviews here. If the name of the cdb view starts with CDB_ no
  -- changes to the downgrade script are required. If not, please drop
  -- it in the downgrade script (e1102000.sql).

  -- CREATE CDBVIEW for database_properties
  create_cdbview(chk_upgrd, 'SYS', 'DATABASE_PROPERTIES', 'CDB_PROPERTIES');

  -- Create cdbview for UNIFIED_AUDIT_TRAIL
  create_cdbview(chk_upgrd, 'SYS', 'UNIFIED_AUDIT_TRAIL',
                                   'CDB_UNIFIED_AUDIT_TRAIL');

EXCEPTION
  when upgrderror THEN
    NULL;
end;

end CDBView;
/
show errors;

Rem 13867272: Create CDB views for both install and upgrade cases. If we 
Rem dont create CDB views here for the upgrade case, then catpprvt.sql cannot 
Rem refer to these CDB views in static SQL used in package bodies. 
exec sys.CDBView.create_cdbviews(FALSE);

