Rem Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
Rem
Rem    NAME
Rem      catcont.sql - Availability Machine Container Schema
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cplakyda    09/13/12 - Performance improvements
Rem    cplakyda    07/17/12 - Retain actual filesize
Rem    swerthei    04/26/12 - Created
Rem

create table amgrp$
(
  gid         number,                -- group id assigned automatically
  gname       varchar2(30) not null, -- group name assigned by user
  ausize      number,                -- AU size of this group, in bytes
  constraint amgrp$_p primary key (gid),
  constraint amgrp$_u unique (gname),
  constraint check_gid check(gid >= 1)
)
/

create table amcont$
(
  cid   number not null,        -- unique container id, 1-based
  gid   number not null,        -- group id
  crid  number not null,        -- relative id within group, 0-based
  state char(1 byte) not null,  -- R = File record created
                                -- F = File formatted
                                -- C = Complete
                                -- D = Delete
  fname varchar2(512) not null, -- file name
  constraint amcont$_p primary key (cid),
  constraint amcont$_f1 foreign key(gid) references amgrp$
    on delete cascade,
  constraint amcont$_u1 unique(gid, crid),
  constraint amcont$_check_cid check(cid >= 1),
  constraint amcont$_check_crid check(crid >= 0),
  constraint amcont$_check_state check(state in ('R', 'F', 'C', 'D')),
  constraint amcont$_u2 unique(fname)
)
/

-- ### remove all except the PK constraint for production

create table amau$
(
  bucket#      number not null,  -- 0-based partition number
  gid          number not null,
  au#          number not null,  -- unique within gid
  state        char(1 byte) not null, -- F=Free, U=Uncommitted, A=Allocated
  fid          number not null,  -- file number (au# when not allocated)
  incarnation# number not null,  -- file incarnation number
  crestamp     number not null,  -- file creation timestamp
  fsize        number,           -- actual filesize in bytes
  sequence#    number not null,  -- 1-based AU number within file
                                 -- (-)rowcount for first row
  alocount     number not null,  -- space allocation counter
  next_bucket# number,           -- next bucket containing rows for this file
  constraint amau$_check_au# check(au# >= 1),
  constraint amau$_check_state check(state in ('F', 'U', 'A')),
  constraint amau$_unique_1 unique(gid, au#),
  constraint fk_1 foreign key(gid) references amgrp$ on delete cascade
)
partition by range(bucket#)
(
  partition p001 values less than(001),
  partition p002 values less than(002),
  partition p003 values less than(003),
  partition p004 values less than(004),
  partition p005 values less than(005),
  partition p006 values less than(006),
  partition p007 values less than(007),
  partition p008 values less than(008),
  partition p009 values less than(009),
  partition p010 values less than(010),
  partition p011 values less than(011),
  partition p012 values less than(012),
  partition p013 values less than(013),
  partition p014 values less than(014),
  partition p015 values less than(015),
  partition p016 values less than(016),
  partition p017 values less than(017),
  partition p018 values less than(018),
  partition p019 values less than(019),
  partition p020 values less than(020),
  partition p021 values less than(021),
  partition p022 values less than(022),
  partition p023 values less than(023),
  partition p024 values less than(024),
  partition p025 values less than(025),
  partition p026 values less than(026),
  partition p027 values less than(027),
  partition p028 values less than(028),
  partition p029 values less than(029),
  partition p030 values less than(030),
  partition p031 values less than(031),
  partition p032 values less than(032),
  partition p033 values less than(033),
  partition p034 values less than(034),
  partition p035 values less than(035),
  partition p036 values less than(036),
  partition p037 values less than(037),
  partition p038 values less than(038),
  partition p039 values less than(039),
  partition p040 values less than(040),
  partition p041 values less than(041),
  partition p042 values less than(042),
  partition p043 values less than(043),
  partition p044 values less than(044),
  partition p045 values less than(045),
  partition p046 values less than(046),
  partition p047 values less than(047),
  partition p048 values less than(048),
  partition p049 values less than(049),
  partition p050 values less than(050),
  partition p051 values less than(051),
  partition p052 values less than(052),
  partition p053 values less than(053),
  partition p054 values less than(054),
  partition p055 values less than(055),
  partition p056 values less than(056),
  partition p057 values less than(057),
  partition p058 values less than(058),
  partition p059 values less than(059),
  partition p060 values less than(060),
  partition p061 values less than(061),
  partition p062 values less than(062),
  partition p063 values less than(063),
  partition p064 values less than(064),
  partition p065 values less than(065),
  partition p066 values less than(066),
  partition p067 values less than(067),
  partition p068 values less than(068),
  partition p069 values less than(069),
  partition p070 values less than(070),
  partition p071 values less than(071),
  partition p072 values less than(072),
  partition p073 values less than(073),
  partition p074 values less than(074),
  partition p075 values less than(075),
  partition p076 values less than(076),
  partition p077 values less than(077),
  partition p078 values less than(078),
  partition p079 values less than(079),
  partition p080 values less than(080),
  partition p081 values less than(081),
  partition p082 values less than(082),
  partition p083 values less than(083),
  partition p084 values less than(084),
  partition p085 values less than(085),
  partition p086 values less than(086),
  partition p087 values less than(087),
  partition p088 values less than(088),
  partition p089 values less than(089),
  partition p090 values less than(090),
  partition p091 values less than(091),
  partition p092 values less than(092),
  partition p093 values less than(093),
  partition p094 values less than(094),
  partition p095 values less than(095),
  partition p096 values less than(096),
  partition p097 values less than(097),
  partition p098 values less than(098),
  partition p099 values less than(099),
  partition p100 values less than(100),
  partition p101 values less than(101),
  partition p102 values less than(102),
  partition p103 values less than(103),
  partition p104 values less than(104),
  partition p105 values less than(105),
  partition p106 values less than(106),
  partition p107 values less than(107),
  partition p108 values less than(108),
  partition p109 values less than(109),
  partition p110 values less than(110),
  partition p111 values less than(111),
  partition p112 values less than(112),
  partition p113 values less than(113),
  partition p114 values less than(114),
  partition p115 values less than(115),
  partition p116 values less than(116),
  partition p117 values less than(117),
  partition p118 values less than(118),
  partition p119 values less than(119),
  partition p120 values less than(120),
  partition p121 values less than(121),
  partition p122 values less than(122),
  partition p123 values less than(123),
  partition p124 values less than(124),
  partition p125 values less than(125),
  partition p126 values less than(126),
  partition p127 values less than(127),
  partition p128 values less than(128)
)
/

create index amau$_i on amau$(gid, state, fid, sequence#) local COMPRESS 2
/

create index amau$uncommitted on amau$ (case when state = 'U' then state end)
/
