Rem
Rem $Header: rdbms/admin/catgwm.sql /main/5 2012/08/04 12:46:12 nbenadja Exp $
Rem
Rem catgwm.sql
Rem
Rem Copyright (c) 2011, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      catgwm.sql - Catalog script for GSM
Rem
Rem    DESCRIPTION
Rem      Creates roles and users for GSM.
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sdball      06/08/12 - gran cdb_services to gsmadmin_internal.
Rem    nbenadja    10/31/11 - Add privileges to gsmadmin
Rem    sdball      10/19/11 - use v_$ rather than gv_$ tables.
Rem    sdball      09/27/11 - Move privs to catgw.sql (needed for all
Rem                           databases).
Rem    mjstewar    04/12/11 - Created
Rem

-- SET ECHO ON
-- SPOOL catgwm.log

--*****************
-- Create GSM Roles
--*****************

---------------
-- gsmuser_role
---------------

-- Create role for GSM USER
CREATE ROLE gsmuser_role;
GRANT connect to gsmuser_role;

grant select on gv_$instance                to gsmuser_role;
grant select on gv_$osstat                  to gsmuser_role;
grant select on gv_$sysmetric_history       to gsmuser_role;
grant select on gv_$sysmetric               to gsmuser_role;
grant select on gv_$servicemetric_history   to gsmuser_role;
grant select on gv_$servicemetric           to gsmuser_role;
grant select on gv_$active_services         to gsmuser_role;
grant select on gv_$session                 to gsmuser_role;

grant select on v_$dg_broker_config         to gsmuser_role;
grant select on gv_$dg_broker_config        to gsmuser_role;


--*****************
-- Create GSM Users
--*****************

--------------------
-- gsmadmin_internal
--------------------

-- gsmadmin_internal owns the GSM administrative packages

CREATE USER gsmadmin_internal identified by gsm
  account lock password expire
  default tablespace sysaux
  quota 100M on sysaux;

-- So that packages can count number of list values for _gsm parameter
grant select on v_$parameter2 to gsmadmin_internal;

-- So that packages can do 'alter system set'
grant alter system to gsmadmin_internal;

-- So that we can select from dba_services
grant select on sys.dba_services to gsmadmin_internal;

grant select on sys.gv_$active_services to gsmadmin_internal;


----------
-- gsmuser
----------

-- GSM process connects to GSM databases as gsmuser.
 
CREATE USER gsmuser identified by gsm 
  account lock password expire;

GRANT gsmuser_role to gsmuser;

