Rem
Rem $Header: rdbms/admin/catgwmcat.sql /st_rdbms_12.1.0.1/2 2013/05/17 15:52:39 thbaby Exp $
Rem
Rem catgwmcat.sql
Rem
Rem Copyright (c) 2011, 2013, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      catgwmcat.sql - Catalog script for GSM on the catalog database
Rem
Rem    DESCRIPTION
Rem      Installation/upgrade script for GSM components on the cloud
Rem      catalog database.
Rem
Rem      Run the script like this:
Rem
Rem         catgwmcat.sql
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    thbaby      05/06/13 - 16768773: remove creation of CDB_SERVICES
Rem    akruglik    02/05/13 - (bug 16194686) disambiguate reference to
Rem                           gv$active_services in ALTER USER SET
Rem                           CONTAINER_DATA statement
Rem    aikumar     11/27/12 - bug-15925294:Change dbms_lock_allocated_v2 back
Rem                           to dbms_lock_allocated
Rem    lenovak     11/07/12 - runtime status flags to the catalog
Rem    rpang       10/11/12 - Use new dbms_network_acl_admin API
Rem    nbenadja    10/11/12 - Add container_data for grants in CDB.
Rem    sdball      08/28/12 - Add ACLs for GSMADMIN_INTERNAL
Rem    sdball      08/03/12 - Add gds_catalog_select role
Rem    nbenadja    07/30/12 - Grant select on gv_$active_services.
Rem    nbenadja    06/23/12 - Fix multiple CDB returned from gv$_database.
Rem    sdball      06/13/12 - Support for number of instances
Rem    nbenadja    06/21/12 - Re-create cdb_services, in case it hasn't been
Rem                           created during an upgrade.
Rem    nbenadja    06/21/12 - Handle CDB databases.
Rem    nbenadja    06/15/12 - Grant select_catalog_role to gsmadmin_internal.
Rem    sdball      06/07/12 - grant gv$instance to gsmadmin_internal
Rem    sdball      06/04/12 - Support for non-unique service name
Rem    sdball      06/04/12 - Defer DBMS_RLS calls to catalog creation because
Rem                           they require EE (Bug 14143065)
Rem    nbenadja    05/09/12 - Hande services in PDBs.
Rem    sdball      05/08/12 - Create verify objects
Rem    sdball      04/16/12 - dbms_lock_allocated is now dbms_lock_allocated_v2
Rem    sdball      03/26/12 - move PLB and SQL to correct installers
Rem    sdball      03/12/12 - Remove packages to corret install location
Rem                           Remove gsm_admin user
Rem                           Grant privs on DBMS_LOCK
Rem    sdball      02/22/12 - grant gsm_change_message only to
Rem                           gsmadmin_internal
Rem    sdball      01/04/12 - Refferential integrity checks
Rem    sdball      12/13/11 - Checking parameters
Rem    sdball      12/05/11 - change pooladmin_role to gsm_pooladmin_role
Rem    sdball      11/29/11 - Autovncr functionality
Rem    sdball      11/09/11 - Add gv_$lock for RAC
Rem    sdball      10/28/11 - gsmadmin_internal needs select on dba_locks
Rem    sdball      10/28/11 - gsmadmin_internal needs CREATE JOB privilege
Rem    sdball      10/25/11 - Add date field to gsm_requests
Rem    sdball      10/19/11 - use v_$ rather than gv_$ tables.
Rem                           add mastergsm field to cloud table
Rem    lenovak     08/22/11 - grant ALTER SYSTEM to gsm_admin_role
Rem    lenovak     07/22/11 - vncr support
Rem    mjstewar    07/21/11 - Change region_sequence
Rem    mjstewar    04/25/11 - Created
Rem

-- SET ECHO ON
-- SPOOL catgwmcat.log

prompt
prompt
prompt Starting Oracle GSM Catalog DB Installation ...
prompt ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
prompt

--*****************
-- Create GSM Roles
--*****************

----------------
-- gsmadmin_role
----------------

-- Create role for GSM cloud administrator
CREATE ROLE gsmadmin_role;
GRANT connect to gsmadmin_role;

GRANT execute on gsmadmin_internal.dbms_gsm_common to gsmadmin_role;

-----------------
-- gsm_pooladmin_role
-----------------

-- Create role GSM pool administrator
CREATE ROLE gsm_pooladmin_role;
GRANT connect to gsm_pooladmin_role;

GRANT execute on gsmadmin_internal.dbms_gsm_common to gsm_pooladmin_role;
/

-- Create gds_catalog_select role
CREATE ROLE gds_catalog_select;

--*****************
-- Create GSM Users
--*****************

--------------------
-- gsmadmin_internal
--------------------

-- gsmadmin_internal user exists on all databases,
-- but we need to give it some more privileges on the cloud
-- catalog database.

-- So that dbms_gsm_cloudadmin can execute dbms_aqadm.add_subscriber()
grant execute on dbms_aqadm to gsmadmin_internal;

-- So that dbms_gsm_cloudamdin can execute dbms_aq.enqueue()
grant execute on dbms_aq to gsmadmin_internal;

-- So that we can grab locks
grant execute on dbms_lock to gsmadmin_internal;

-- So that we can create VPD policies in dbms_gsm_cloudadmin
grant execute on sys.dbms_rls to gsmadmin_internal;

-- So that dbms_gsm_cloudadmin can execute dbms_aqadm.purge_table()
grant aq_administrator_role to gsmadmin_role;

-- So the VPD routine can select from dba_role_privs
grant select on dba_role_privs to gsmadmin_internal;

-- So that dbms_gsm_cloudadmin can check if spfile is set.
grant select on v_$parameter to gsmadmin_internal;

-- so that we can check for GSM master lock
grant select on sys.dbms_lock_allocated to gsmadmin_internal;

-- so that we can check for GSM master lock
grant select on sys.gv_$lock to gsmadmin_internal;

-- for parameter checking
grant select on sys.dba_tab_columns to gsmadmin_internal;

-- so that we can check for CDB database 
grant select on sys.gv_$database to gsmadmin_internal;
-- so we can check running instances
grant select on sys.gv_$instance to gsmadmin_internal;


-- Because we create sequences within the schema
grant create sequence to gsmadmin_internal;

-- So that we can assign users to the gsm_pooladmin_role
grant grant any role to gsmadmin_internal;

-- So that we can lock/unlock the gsmcatuser account
grant alter user to gsmadmin_internal;

-- So that gsm will be able to exec alter system register on catalog
grant alter system to gsmadmin_role;

-- so that we can crerate jobs
grant create job to gsmadmin_internal;

-- For CDB databases
grant select on sys.dba_services to gsmadmin_internal;
grant select on sys.cdb_services to gsmadmin_internal;

grant select on sys.gv_$active_services to gsmadmin_internal;


/
alter session set "_oracle_script"=true;

/
DECLARE
 isCDB varchar2(3);
 stmt  varchar (1024);

BEGIN

  select distinct CDB into isCDB from gv_$database;
  IF (isCDB = 'YES')
  THEN
     stmt := 'grant set container to gsmadmin_internal container = all';
     execute immediate stmt;
     stmt :=  'grant alter session to gsmadmin_internal container = all';
     execute immediate stmt;
     stmt := 'alter user gsmadmin_internal set container_data = all' ||
              '  for cdb_services container =current';
     execute immediate stmt;
     stmt := 'alter user gsmadmin_internal set container_data = all' ||
              '  for "PUBLIC".gv$active_services container =current';
     execute immediate stmt;
 END IF;

END;
/

-------------
-- gsmcatuser
-------------

-- GSM process connects to GSM cloud catalog database as
-- gsmcatuser.  Password will be changed by GSM when first
-- GSM is added to the cloud.

CREATE USER gsmcatuser identified by gsm
  account lock password expire;

GRANT connect to gsmcatuser;

-- So that gsmcatuser can call dbms_aq.dequeue(), dbms_aq.listen()
grant execute on dbms_aq to gsmcatuser;

-- So that gsmcatuser can call dbms_aqadm.add_subscriber()
grant aq_administrator_role to gsmcatuser;


ALTER SESSION SET CURRENT_SCHEMA = gsmadmin_internal;


--****************************
-- Create Cloud Catalog Tables
--****************************


CREATE TABLE region (
   name            VARCHAR2(30)   NOT NULL,
   num             NUMBER         NOT NULL,
   buddy_region    NUMBER         DEFAULT NULL REFERENCES region(num),
   PRIMARY KEY (name),
   CONSTRAINT num_unique UNIQUE (num)
 )
/
show errors



-- region_sequence is used for generating region.num.
-- GSM listener requires that region.num be in the range 0-9
CREATE SEQUENCE region_sequence minvalue 0 maxvalue 9 cache 9 cycle
/
show errors

CREATE TABLE gsm (
   name            VARCHAR2(30)     NOT NULL,
   num             NUMBER           NOT NULL,
   endpoint1       VARCHAR2(256)    NOT NULL,
   endpoint2       VARCHAR2(256)    NOT NULL,
   ons_port_local  NUMBER           NOT NULL,
   ons_port_remote NUMBER           NOT NULL,
   region_num      NUMBER           NOT NULL REFERENCES region(num),
   oracle_home     VARCHAR2(4000),
   hostname        VARCHAR2(256),
   PRIMARY KEY (name)
 )
/
show errors

CREATE TABLE cloud (
   name               VARCHAR2(30)    NOT NULL,
   encryption_key     VARCHAR2(30),
   change_seq#        NUMBER,
   next_db_num        NUMBER,
   mastergsm          VARCHAR2(30) DEFAULT NULL REFERENCES gsm(name) ON DELETE SET NULL,
   autovncr           NUMBER(1) DEFAULT 1,   -- boolean (1 TRUE, 0 FALSE)
   max_instances      NUMBER DEFAULT NULL,
   PRIMARY KEY (name)
 )
/
show errors

CREATE TABLE vncr (
   name            VARCHAR2(256)   NOT NULL,
   group_id        VARCHAR2(30),
   PRIMARY KEY (name)
 )
/
show errors

CREATE SEQUENCE gsm_sequence
/
show errors

CREATE TABLE database_pool (
   name           VARCHAR2(30)    NOT NULL,
   broker_config  NUMBER(1),   -- boolean (1: TRUE, 0: FALSE)
   PRIMARY KEY (name)
 )
/
show errors

CREATE TABLE database_pool_admin (
   pool_name       VARCHAR2(30)    REFERENCES database_pool(name),
   user_name       VARCHAR2(30)    NOT NULL,  -- references "user" table
   PRIMARY KEY (pool_name, user_name)
 )
/
show errors

CREATE TABLE database (
   name                   VARCHAR2(30)    NOT NULL,
   pool_name              VARCHAR2(30)    REFERENCES database_pool(name),
   region_num             NUMBER          DEFAULT NULL REFERENCES region(num),
   gsm_password           VARCHAR2(30)    NOT NULL,
   connect_string         VARCHAR2(256)   NOT NULL,
   database_num           NUMBER          NOT NULL,
   status                 CHAR(1)         NOT NULL,  -- 'D': default
                                                     -- 'I': incomplete add
                                                     -- 'S': needs reSync
                                                     -- 'R': logically removed
   scan_address           VARCHAR2(256)   DEFAULT NULL,
   ons_port               NUMBER          DEFAULT NULL,
   num_assigned_instances NUMBER          NOT NULL, 
   PRIMARY KEY (name)
 )
/
show errors


CREATE TABLE service (
   name                       VARCHAR2(64)    NOT NULL,
   network_name               VARCHAR2(250)   NOT NULL,
   pool_name                  VARCHAR2(30)    REFERENCES database_pool(name),
   status                     CHAR(1),
                                -- 'S' (Started)
                                -- 'P' (Stopped)
   preferred_all              NUMBER(1),      
                                -- boolean (1 TRUE, 0 FALSE)
   locality                   NUMBER(1),      
                                -- anywhere (1), local_only (2)
   region_failover            NUMBER(1),      
                                -- boolean (1 TRUE, 0 FALSE)
   role                       NUMBER(1),      
                                -- primary (1), physical_standby (2), logical_standby (3)
   failover_primary           NUMBER(1),      
                                -- boolean (1 TRUE, 0 FALSE)
   any_lag                    NUMBER(1),      
                                -- boolean (1 TRUE, 0 FALSE)
   lag                        NUMBER,         
                                -- lag value if 'any_lag' is FALSE
   runtime_balance            NUMBER(1),      
                                -- none (0), service_time (1), throughput (2)
   load_balance               NUMBER(1),      
                                -- none (0), short (1), long (2)
   notification               NUMBER(1), 
                                -- boolean (1 TRUE, 0 FALSE)
   tafpolicy                  NUMBER(1),      
                                -- none (0), basic (1), preconnect (2)
   policy                     NUMBER(1),      
                                -- manual (1), automatic (2)
   dtp                        NUMBER(1),      
                                -- boolean (1 TRUE, O FALSE)
   failover_method            VARCHAR2(6),    
                                -- 'NONE' or 'BASIC'
   failover_type              VARCHAR2(12),    
                                -- 'NONE', 'SESSION', 'SELECT', or 'TRANSACTION'
   failover_retries           NUMBER,
   failover_delay             NUMBER,
   edition                    VARCHAR2(30),
   pdb                        VARCHAR2(30),
   commit_outcome             NUMBER,
                                -- boolean (1 TRUE, 0 FALSE)
   retention_timeout          NUMBER,
   replay_initiation_timeout  NUMBER,
   session_state_consistency  VARCHAR2(7),
                                -- 'STATIC' or 'DYNAMIC'
   sql_translation_profile    VARCHAR2(30),
   PRIMARY KEY (name, pool_name)
 )
/
show errors

CREATE TABLE service_preferred_available (
   service_name    VARCHAR2(64),
   pool_name       VARCHAR2(30)  REFERENCES database_pool(name),
   database        VARCHAR2(30)  REFERENCES database(name),
   preferred       NUMBER(1),  -- (1 preferred, 0 available)
   status          CHAR(1) default NULL,
                               -- 'E' (Enabled)
                               -- 'D' (Disabled)
   state           CHAR(1) default 'S',
                               -- 'S' (Stopped)
                               -- 'D' (Down - stopped by user)
                               -- 'U' (Up and rUnning)
   FOREIGN KEY (service_name, pool_name) REFERENCES service(name, pool_name),
   PRIMARY KEY (service_name, pool_name, database)
 )
/
show errors

-----------------------------------
-- Create Change Queue Message Type
-----------------------------------
CREATE TYPE gsm_change_message AS OBJECT (
   admin_id             NUMBER,
   change_id            NUMBER,
   seq#                 NUMBER,
   command              VARCHAR2(30),
   target               VARCHAR2(64),
   pool_name            VARCHAR2(30),     -- Only for pool admin actions
   additional_params    VARCHAR2(1024)    -- Additional parameters for the command
                                          -- Depends on the command and is not used
                                          -- for all commands.  Uses the same syntax
                                          -- as in the gsmctl command.  For example
                                          -- for START SERVICE may contain the 
                                          -- database name:
                                          --        "-database db_name"
)
/
show errors

GRANT execute on gsmadmin_internal.gsm_change_message to gsmadmin_role;

CREATE TABLE gsm_requests (
   change_seq#    NUMBER,                            -- copied from request
   request        gsm_change_message NOT NULL,
   failure_count  NUMBER default 0,
   error_message  VARCHAR2(1024) default NULL,
   status         CHAR(1) default 'N',               -- values 'N', 'D', 'F','A'
   change_date    DATE default SYSDATE,
   PRIMARY KEY (change_seq#)
)
/
show errors

CREATE TABLE verify_history
              (run_number      NUMBER NOT NULL,
	          message_number  NUMBER NOT NULL,
              message_string  VARCHAR(1000),
              message_date    DATE NOT NULL)
/
show errors

GRANT SELECT on verify_history TO gsmadmin_role;
/
show errors

CREATE SEQUENCE verify_run_number
/
show errors

-------------------------
-- Create AQ Change Queue
-------------------------
BEGIN
    dbms_aqadm.create_queue_table(
        queue_table => 'gsmadmin_internal.change_log_queue_table',
        multiple_consumers => TRUE,
        queue_payload_type => 'gsmadmin_internal.gsm_change_message',
        storage_clause => 'TABLESPACE "SYSAUX"',
        comment => 'Creating GSM change log queue table');

    dbms_aqadm.create_queue(
        queue_name => 'gsmadmin_internal.change_log_queue',
        queue_table => 'gsmadmin_internal.change_log_queue_table',
        comment => 'GSM Change Log Queue');
EXCEPTION
WHEN others THEN
  IF sqlcode = -24001 THEN NULL;
       -- suppress error for pre-existent queue table
  ELSE raise;
  END IF;
END;
/
show errors

-- This can only be done by the queue owner (gsmadmin_internal) or
-- SYS.  
BEGIN
  dbms_aqadm.grant_queue_privilege(
     privilege => 'dequeue',
     queue_name => 'gsmadmin_internal.change_log_queue',
     grantee => 'GSMCATUSER');
END;
/
show errors

BEGIN
  dbms_aqadm.grant_queue_privilege(
     privilege => 'enqueue',
     queue_name => 'gsmadmin_internal.change_log_queue',
     grantee => 'GSMADMIN_INTERNAL');
END;
/
show errors

BEGIN
   dbms_aqadm.start_queue('gsmadmin_internal.change_log_queue', 
                          TRUE, 
                          TRUE);
END;
/
show errors

----------------------------------
-- Grant resolve network privilege
----------------------------------

BEGIN
  dbms_network_acl_admin.append_host_ace(
    host => '*',
    ace => xs$ace_type(privilege_list => xs$name_list('RESOLVE'),  
                       principal_name => 'GSMADMIN_INTERNAL',  
                       principal_type => xs_acl.ptype_db));
END;
/
show errors

-----------------------
-- Set Table Privileges
-----------------------

GRANT select on cloud to gsmadmin_role, gds_catalog_select;
GRANT select on region to gsmadmin_role, gds_catalog_select;
GRANT select on gsm to gsmadmin_role, gds_catalog_select;
GRANT select on vncr to gsmadmin_role, gds_catalog_select;
GRANT select on database_pool to gsmadmin_role, gds_catalog_select;
GRANT select on database_pool_admin to gsmadmin_role, gds_catalog_select;
GRANT select on gsm_requests to gsmadmin_role, gds_catalog_select;

GRANT select on database to gsmadmin_role, gds_catalog_select;
GRANT select on service to gsmadmin_role, gds_catalog_select;
GRANT select on service_preferred_available to gsmadmin_role, gds_catalog_select;

GRANT select on database_pool to gsm_pooladmin_role;
GRANT select on database to gsm_pooladmin_role;
GRANT select on service to gsm_pooladmin_role;
GRANT select on service_preferred_available to gsm_pooladmin_role;
GRANT select on gsm_requests to gsm_pooladmin_role;

-- Pool admin has to see regions in order to know which regions
-- to which to add databases.
GRANT select on region to gsm_pooladmin_role;


GRANT update,delete on gsm_requests to gsm_pooladmin_role, gsmadmin_role;
GRANT update on service_preferred_available to gsmcatuser;
GRANT update on database to gsmcatuser;

GRANT gsmadmin_role, gsm_pooladmin_role to gsmcatuser;



ALTER SESSION SET CURRENT_SCHEMA = SYS;

