Rem
Rem $Header: rdbms/admin/catilm.sql /st_rdbms_12.1.0.1/6 2013/03/25 12:47:05 hlakshma Exp $
Rem
Rem catilm.sql
Rem
Rem Copyright (c) 2011, 2013, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      catilm.sql 
Rem
Rem    DESCRIPTION
Rem      ILM activity tracking related views
Rem
Rem    NOTES
Rem
Rem
Rem BEGIN SQL_FILE_METADATA
Rem SQL_SOURCE_FILE: rdbms/admin/catilm.sql
Rem SQL_SHIPPED_FILE: rdbms/admin/catilm.sql
Rem SQL_PHASE: CATPDEPS_MAIN2
Rem SQL_STARTUP_MODE: NORMAL
Rem SQL_IGNORABLE_ERRORS: NONE
Rem SQL_CALLING_FILE: rdbms/admin/catpdeps.sql
Rem END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    hlakshma    01/06/13 - Exclude interim objects created during
Rem                           redefinition process from ADO views
Rem    vradhakr    12/26/12 - Handle system status row in heat_map_stat$.
Rem    hlakshma    12/17/12 - Fix definition of view user_ilmresults
Rem    surman      12/10/12 - XbranchMerge surman_bug-12876907 from main
Rem    prgaharw    11/25/12 - 15865137 - Remove space from decoded string
Rem    surman      11/14/12 - 12876907: Add ORACLE_SCRIPT
Rem    vraja       10/23/12 - fix 4-way join underlying
Rem                           _SYS_HEAT_MAP_SEG_HISTOGRAM
Rem    vraja       10/15/12 - ILM renamed to HEAT_MAP
Rem    hlakshma    10/04/12 - Fix ILM view names
Rem    amylavar    09/24/12 - Change 'OLTP' to 'ADVANCED'
Rem    hlakshma    08/30/12 - Add support for EHCC row-level locking
Rem    hlakshma    04/06/12 - Modify views to include policies based on
Rem                           VALID_TIME_END
Rem    surman      03/27/12 - 13615447: Add SQL patching tags
Rem    liaguo      02/21/12 - owner
Rem    prgaharw    02/16/12 - Decode READ ONLY flag in ILMPOLICY$ views
Rem    hlakshma    01/20/12 - Edit view user_ilmexecution to support
Rem                           manual override
Rem    liaguo      11/09/11 - Use obj# for views
Rem    hlakshma    11/09/11 - Move ILM related views from cdsqlddl.sql
Rem    liaguo      10/18/11 - show real time data with gv$ views
Rem    liaguo      09/30/11 - view changes
Rem    liaguo      06/08/11 - Project 32788 DB ILM
Rem    liaguo      06/08/11 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql

/*
 * Internal HEAT MAP segment access stats histograms incl. real time access
 * info from GV$HEAT_MAP_SEGMENT.
 */
create or replace view "_SYS_HEAT_MAP_SEG_HISTOGRAM"
    (OBJ#, DATAOBJ#, TRACK_TIME, SEGMENT_WRITE, SEGMENT_READ, FULL_SCAN,
     LOOKUP_SCAN)
as
   select s.obj#, s.dataobj#, s.track_time,
          decode(bitand(s.segment_access, 1), 1, 'YES', 'NO'),
          decode(bitand(s.segment_access, 2), 2, 'YES', 'NO'),
          decode(bitand(s.segment_access, 4), 4, 'YES', 'NO'),
          decode(bitand(s.segment_access, 8), 8, 'YES', 'NO')
    from heat_map_stat$ s where s.OBJ# != -1
union all
   select obj#, dataobj#, track_time,
          segment_write, segment_read,
          full_scan, lookup_scan
     from
         GV$HEAT_MAP_SEGMENT
     where
       segment_write = 'YES' OR lookup_scan = 'YES' OR full_scan = 'YES';
/

/*
 * Show various  segment access info in the system
 */
create or replace view DBA_HEAT_MAP_SEG_HISTOGRAM
    (OWNER, OBJECT_NAME, SUBOBJECT_NAME, TRACK_TIME, SEGMENT_WRITE,
     FULL_SCAN, LOOKUP_SCAN)
as select u.name, o.name, o.subname, s.track_time,
          s.segment_write, s.full_scan, s.lookup_scan
from obj$ o, sys."_SYS_HEAT_MAP_SEG_HISTOGRAM" s, user$ u
where s.obj# = o.obj# and o.owner# = u.user#
order by o.obj#
/
create or replace public synonym DBA_HEAT_MAP_SEG_HISTOGRAM
for sys.DBA_HEAT_MAP_SEG_HISTOGRAM
/
grant select on DBA_HEAT_MAP_SEG_HISTOGRAM to PUBLIC with grant option
/
comment on table DBA_HEAT_MAP_SEG_HISTOGRAM is
'Segment access information for all segments'
/
comment on column DBA_HEAT_MAP_SEG_HISTOGRAM.TRACK_TIME is
'System time when the segment access was tracked'
/
comment on column DBA_HEAT_MAP_SEG_HISTOGRAM.SEGMENT_WRITE is
'Segment has write access YES/NO'
/
comment on column DBA_HEAT_MAP_SEG_HISTOGRAM.FULL_SCAN is
'Segment has full scan YES/NO'
/
comment on column DBA_HEAT_MAP_SEG_HISTOGRAM.LOOKUP_SCAN is
'Segment has lookup scan YES/NO'
/

/*
 * remark Show segment access information for an user's objects 
 */
create or replace view USER_HEAT_MAP_SEG_HISTOGRAM
   (OBJECT_NAME, SUBOBJECT_NAME, TRACK_TIME, SEGMENT_WRITE, FULL_SCAN, LOOKUP_SCAN)
as select o.name, o.subname, s.track_time,
   s.segment_write, s.full_scan, s.lookup_scan
from obj$ o, sys."_SYS_HEAT_MAP_SEG_HISTOGRAM" s
where o.owner#=userenv('SCHEMAID') 
  and s.obj# = o.obj#
order by o.obj#
/
create or replace public synonym USER_HEAT_MAP_SEG_HISTOGRAM
for sys.USER_HEAT_MAP_SEG_HISTOGRAM
/
grant select on USER_HEAT_MAP_SEG_HISTOGRAM to PUBLIC with grant option
/
comment on table USER_HEAT_MAP_SEG_HISTOGRAM is
'Segment access information for segments owned by the user'
/
comment on column USER_HEAT_MAP_SEG_HISTOGRAM.TRACK_TIME is
'System time when the segment access was tracked'
/
comment on column USER_HEAT_MAP_SEG_HISTOGRAM.SEGMENT_WRITE is
'Segment has write access YES/NO'
/
comment on column USER_HEAT_MAP_SEG_HISTOGRAM.FULL_SCAN is
'Segment has full scan YES/NO'
/
comment on column USER_HEAT_MAP_SEG_HISTOGRAM.LOOKUP_SCAN is
'Segment has lookup scan YES/NO'
/


create or replace view ALL_HEAT_MAP_SEG_HISTOGRAM
    (OWNER, OBJECT_NAME, SUBOBJECT_NAME, TRACK_TIME, SEGMENT_WRITE,
      FULL_SCAN, LOOKUP_SCAN)
as select u.name, o.name, o.subname, s.track_time,
          s.segment_write, s.full_scan, s.lookup_scan
from sys.obj$ o, sys.user$ u, sys."_SYS_HEAT_MAP_SEG_HISTOGRAM" s
where o.owner# = u.user#
  and (o.owner# = userenv('SCHEMAID') 
       or o.obj# in
            (select oa.obj#
             from sys.objauth$ oa
             where grantee# in ( select kzsrorol
                                 from x$kzsro
                               )
            )
       or /* user has system privileges */
         exists (select null from v$enabledprivs
                 where priv_number in (-45 /* LOCK ANY TABLE */,
                                       -47 /* SELECT ANY TABLE */,
                                       -48 /* INSERT ANY TABLE */,
                                       -49 /* UPDATE ANY TABLE */,
                                       -50 /* DELETE ANY TABLE */)
                 )
       )
  and o.obj# = s.obj#
order by s.obj#
/
create or replace public synonym ALL_HEAT_MAP_SEG_HISTOGRAM
for sys.ALL_HEAT_MAP_SEG_HISTOGRAM
/
grant select on ALL_HEAT_MAP_SEG_HISTOGRAM to PUBLIC with grant option
/
comment on table ALL_HEAT_MAP_SEG_HISTOGRAM is
'Segment access information for all segments visible to the user'
/
comment on column ALL_HEAT_MAP_SEG_HISTOGRAM.TRACK_TIME is
'System time when the segment access was tracked'
/
comment on column ALL_HEAT_MAP_SEG_HISTOGRAM.SEGMENT_WRITE is
'Segment has write access YES/NO'
/
comment on column ALL_HEAT_MAP_SEG_HISTOGRAM.FULL_SCAN is
'Segment has full scan YES/NO'
/
comment on column ALL_HEAT_MAP_SEG_HISTOGRAM.LOOKUP_SCAN is
'Segment has lookup scan YES/NO'
/

/*
 * Show last segment access time info for all objects enabled for ILM
 * activity tracking.
 */
create or replace view DBA_HEAT_MAP_SEGMENT
  (
    OWNER, OBJECT_NAME, SUBOBJECT_NAME, SEGMENT_WRITE_TIME, SEGMENT_READ_TIME, 
    FULL_SCAN, LOOKUP_SCAN
  )
as
select u.name, o.name, o.subname, tw.SEGMENT_WRITE, tr.SEGMENT_READ, 
       ts.FULL_SCAN, ti.LOOKUP_SCAN
  from obj$ o, user$ u,
   (select tw1.obj#, tw1.dataobj#, tw2.SEGMENT_WRITE from 
      (select unique obj#,dataobj# from sys."_SYS_HEAT_MAP_SEG_HISTOGRAM") tw1,
      (select dataobj#, max(track_time) "SEGMENT_WRITE"
         from sys."_SYS_HEAT_MAP_SEG_HISTOGRAM" 
        where segment_write='YES' group by dataobj#)  tw2
     where (tw1.dataobj# = tw2.dataobj#(+))) tw,
   (select tr1.obj#, tr1.dataobj#, tr2.SEGMENT_READ from 
      (select unique obj#,dataobj# from sys."_SYS_HEAT_MAP_SEG_HISTOGRAM") tr1,
      (select dataobj#, max(track_time) "SEGMENT_READ"
         from sys."_SYS_HEAT_MAP_SEG_HISTOGRAM" 
        where segment_read='YES' group by dataobj#)  tr2
     where (tr1.dataobj# = tr2.dataobj#(+))) tr,
   (select ts1.obj#, ts1.dataobj#, ts2.FULL_SCAN from 
      (select unique obj#,dataobj# from sys."_SYS_HEAT_MAP_SEG_HISTOGRAM") ts1,
      (select dataobj#, max(track_time) "FULL_SCAN"
         from sys."_SYS_HEAT_MAP_SEG_HISTOGRAM" 
        where full_scan='YES' group by dataobj#)  ts2
     where (ts1.dataobj# = ts2.dataobj#(+))) ts,
   (select ti1.obj#, ti1.dataobj#, ti2.LOOKUP_SCAN from 
      (select unique obj#,dataobj# from sys."_SYS_HEAT_MAP_SEG_HISTOGRAM") ti1,
      (select dataobj#, max(track_time) "LOOKUP_SCAN"
         from sys."_SYS_HEAT_MAP_SEG_HISTOGRAM" 
        where lookup_scan='YES' group by dataobj#)  ti2
     where (ti1.dataobj# = ti2.dataobj#(+))) ti 
 where (tw.obj# = tr.obj#) and (tw.obj# = ts.obj#) and
       (tw.obj# = ti.obj#) and (tw.obj# = o.obj#) and
       (o.owner# = u.user#)
 order by tw.obj# 
/
create or replace public synonym DBA_HEAT_MAP_SEGMENT
for sys.DBA_HEAT_MAP_SEGMENT
/
grant select on DBA_HEAT_MAP_SEGMENT to PUBLIC with grant option
/
comment on table DBA_HEAT_MAP_SEGMENT is
'Last segment access time'
/
comment on column DBA_HEAT_MAP_SEGMENT.SEGMENT_WRITE_TIME is
'Last segment write access time'
/
comment on column DBA_HEAT_MAP_SEGMENT.SEGMENT_READ_TIME is
'Last segment read access time'
/
comment on column DBA_HEAT_MAP_SEGMENT.FULL_SCAN is
'Last full scan time'
/
comment on column DBA_HEAT_MAP_SEGMENT.LOOKUP_SCAN is
'Last range scan or point scan time'
/

/*
 * Show last segment access time info for the user's objects that are
 * enabled for ILM activity tracking.
 */
create or replace view USER_HEAT_MAP_SEGMENT
  (
    OBJECT_NAME, SUBOBJECT_NAME, SEGMENT_WRITE_TIME, 
    SEGMENT_READ_TIME, FULL_SCAN, LOOKUP_SCAN
  )
as
select s.object_name, s.subobject_name, 
       s.SEGMENT_WRITE_TIME, s.SEGMENT_READ_TIME,
       s.FULL_SCAN, s.LOOKUP_SCAN 
  from sys.DBA_HEAT_MAP_SEGMENT s, sys.obj$ o 
 where o.owner#=userenv('SCHEMAID')
   and s.object_name=o.name
/
create or replace public synonym USER_HEAT_MAP_SEGMENT
for sys.USER_HEAT_MAP_SEGMENT
/
grant select on USER_HEAT_MAP_SEGMENT to PUBLIC with grant option
/
comment on table USER_HEAT_MAP_SEGMENT is
'Users segment last access time'
/
comment on column USER_HEAT_MAP_SEGMENT.SEGMENT_WRITE_TIME is
'Last segment write access time'
/
comment on column USER_HEAT_MAP_SEGMENT.SEGMENT_READ_TIME is
'Last segment read access time'
/
comment on column USER_HEAT_MAP_SEGMENT.FULL_SCAN is
'Last full scan time'
/
comment on column USER_HEAT_MAP_SEGMENT.LOOKUP_SCAN is
'Last range scan or point scan access time'
/

create or replace view ALL_HEAT_MAP_SEGMENT
  (
    OWNER, OBJECT_NAME, SUBOBJECT_NAME, SEGMENT_WRITE_TIME, 
    SEGMENT_READ_TIME, FULL_SCAN, LOOKUP_SCAN
  )
as
select u.name, s.object_name, s.subobject_name, 
       s.SEGMENT_WRITE_TIME, s.SEGMENT_READ_TIME, 
       s.FULL_SCAN, s.LOOKUP_SCAN 
  from sys.DBA_HEAT_MAP_SEGMENT s, sys.obj$ o, sys.user$ u
 where o.owner# = u.user#
   and (o.owner# = userenv('SCHEMAID') 
        or o.obj# in
             (select oa.obj#
              from sys.objauth$ oa
              where grantee# in ( select kzsrorol
                                    from x$kzsro
                                )
             )
        or /* user has system privileges */
          exists (select null from v$enabledprivs
                  where priv_number in (-45 /* LOCK ANY TABLE */,
                                        -47 /* SELECT ANY TABLE */,
                                        -48 /* INSERT ANY TABLE */,
                                        -49 /* UPDATE ANY TABLE */,
                                        -50 /* DELETE ANY TABLE */)
                 )
       )
   and s.object_name=o.name
/
create or replace public synonym ALL_HEAT_MAP_SEGMENT
for sys.ALL_HEAT_MAP_SEGMENT
/
grant select on ALL_HEAT_MAP_SEGMENT to PUBLIC with grant option
/
comment on table ALL_HEAT_MAP_SEGMENT is
'Users segment last access time'
/
comment on column ALL_HEAT_MAP_SEGMENT.SEGMENT_WRITE_TIME is
'Last segment write access time'
/
comment on column ALL_HEAT_MAP_SEGMENT.SEGMENT_READ_TIME is
'Last segment read access time'
/
comment on column ALL_HEAT_MAP_SEGMENT.FULL_SCAN is
'Last full scan time'
/
comment on column ALL_HEAT_MAP_SEGMENT.LOOKUP_SCAN is
'Last range scan or point scan access time'
/


/* For review of changes to ILM related views, please contact the 
 * data layer manager 
 */
  
/* This view provides information on ILM policies applicable to user objects.
 *
 * Note on ILM policy owner 
 * -----------------------
 * The user owns the policies on his/her own objects. 
 *
 * The tablespace level policies are owned by the policy creator. The policy
 * owner does not have any user semantics, so we do not expose this 
 * information. We maintain this only in anticipation of future changes where
 * an ILM policy can be created separately
 */

create or replace view USER_ILMPOLICIES
(POLICY_NAME, POLICY_TYPE, TABLESPACE, ENABLED)  
as 
select  a.name, 
        decode(a.ptype, 1, 'DATA MOVEMENT'),
        null,
        decode(bitand(a.FLAG,1),1,'NO     ',0,'YES    ') 
  from sys.ilm$ a  
 where a.owner#   = userenv('SCHEMAID')
   and bitand(a.flag,8)     = 0
union
/* Select tablespace level policies in tablespaces where the user has some
 * quota
 */ 
select a.name,
       decode(a.ptype, 1, 'DATA MOVEMENT'),
       b.name,
       decode(bitand(a.FLAG,1),1,'NO     ',0,'YES    ')
  from sys.ilm$ a, 
       sys.ts$  b,
       sys.tsq$ c 
 where bitand(a.flag, 8) = 8 
   and  a.ts#    = b.ts#
   and  b.ts#    = c.ts#
   and  c.user# = userenv('SCHEMAID') 
   and (c.blocks > 0 or c.maxblocks != 0)
union
/* Select tablespace level policies in case the use has unlimited 
 * tablespace privileges
 */
select a.name,
       decode(a.ptype, 1, 'DATA MOVEMENT'),
       b.name,
       decode(bitand(a.FLAG,1),1,'NO     ',0,'YES    ')
  from sys.ilm$ a,
       sys.ts$  b 
 where bitand(a.flag,8) = 8
   and a.ts# = b.ts#
   and exists
      (select null
         from sys.v$enabledprivs
        where priv_number = -15 /* UNLIMITED TABLESPACE */)  
/
comment on table USER_ILMPOLICIES is
 'ILM policies owned by the user'
/
comment on column USER_ILMPOLICIES.POLICY_NAME is
 'Name of the policy'
/
comment on column USER_ILMPOLICIES.POLICY_TYPE is
 'Type of the policy'
/
comment on column USER_ILMPOLICIES.TABLESPACE is 
 'Tablespace name in case of tablespace level policy'
/
comment on column USER_ILMPOLICIES.ENABLED is
 'Is the policy enabled?'
/
grant select on USER_ILMPOLICIES to public
/
create or replace public synonym user_ilmpolicies for sys.user_ilmpolicies
/

/* Properties of data movement related ILM policies applicable to user 
 * objects
 */ 

create or replace view USER_ILMDATAMOVEMENTPOLICIES 
(POLICY_NAME, ACTION_TYPE, SCOPE, COMPRESSION_LEVEL, TIER_TABLESPACE,
 TIER_STATUS, CONDITION_TYPE, CONDITION_DAYS, CUSTOM_FUNCTION)
as 
select a.name, 
       decode(b.action, 1,'COMPRESSION',2,'STORAGE'),  
       decode(b.scope, 1,'SEGMENT',2,'GROUP',3,'ROW'),
       decode(b.ctype, 2, 'ADVANCED', 
                       3, (CASE 
                           WHEN b.clevel = 1 and bitand(b.flag,32) = 0
                                  THEN 'QUERY LOW'
                           WHEN b.clevel = 2 and bitand(b.flag,32) = 0
                                  THEN 'QUERY HIGH' 
                           WHEN b.clevel = 3 and bitand(b.flag,32) = 0
                                  THEN 'ARCHIVE LOW'
                           WHEN b.clevel = 4 and bitand (b.flag,32) = 0
                                  THEN 'ARCHIVE HIGH'
                           WHEN b.clevel = 1 and bitand(b.flag,32)  = 32
                                  THEN 'QUERY LOW ROW LEVEL LOCKING'
                           WHEN b.clevel = 2 and bitand(b.flag,32)  = 32
                                  THEN 'QUERY HIGH ROW LEVEL LOCKING' 
                           WHEN b.clevel = 3 and bitand(b.flag,32)  = 32
                                  THEN 'ARCHIVE LOW ROW LEVEL LOCKING'
                           WHEN b.clevel = 4 and bitand (b.flag,32) = 32
                                  THEN 'ARCHIVE HIGH ROW LEVEL LOCKING'
                           END)),
       b.tier_tbs,
       decode(b.flag, 1, 'READ ONLY'),
       CASE 
       WHEN bitand(b.flag, 8) = 8 THEN 'USER DEFINED'
       WHEN b.action = 2 and  bitand(b.flag, 8) <> 8 THEN null
       ELSE 
       decode(b.condition, 0, 'LAST ACCESS TIME', 1,'LOW ACCESS', 
                           2,'LAST MODIFICATION TIME', 3,'CREATION TIME', 
                           5, 'VALID TIME END')
       END,
       b.days,
       b.custfunc  
  from sys.ilm$ a, sys.ilmpolicy$ b,
       (select a.policy# 
          from sys.ilm$ a
         where bitand(a.flag, 8) = 0
           and a.owner# = userenv('SCHEMAID')
        union
        select a.policy#
          from sys.ilm$ a , 
               sys.ts$  b,
               sys.tsq$ c 
        where  bitand(a.flag, 8) = 8
          and  a.ts#    = b.ts#
          and  b.ts#    = c.ts#
          and  c.user# = userenv('SCHEMAID') 
          and (c.blocks > 0 or c.maxblocks != 0)
        union     
         select a.policy#
          from sys.ilm$ a  
        where  bitand(a.flag, 8) = 8
          and  exists
         (select null
            from sys.v$enabledprivs
           where priv_number = -15 /* UNLIMITED TABLESPACE */)) c  
 where a.policy# = b.policy# 
   and a.policy# = c.policy#
/
comment on table USER_ILMDATAMOVEMENTPOLICIES is
 'Data movement related policies for a user'
/
comment on column USER_ILMDATAMOVEMENTPOLICIES.POLICY_NAME is
 'Name of the policy'
/
comment on column USER_ILMDATAMOVEMENTPOLICIES.ACTION_TYPE is
 'Type of the action executed by the policy'
/
comment on column USER_ILMDATAMOVEMENTPOLICIES.SCOPE is
 'Scope of the policy'
/
comment on column USER_ILMDATAMOVEMENTPOLICIES.COMPRESSION_LEVEL is
 'Compression level for the object'
/
comment on column USER_ILMDATAMOVEMENTPOLICIES.CONDITION_TYPE is
 'Column on which the policy is based'
/
comment on column USER_ILMDATAMOVEMENTPOLICIES.CONDITION_DAYS is
 'Value associated with the condition specified in days'
/
comment on column USER_ILMDATAMOVEMENTPOLICIES.CUSTOM_FUNCTION is
 'Optional function that evaluates the precondition on the policy '
/
grant select on USER_ILMDATAMOVEMENTPOLICIES to public
/
create or replace public synonym USER_ILMDATAMOVEMENTPOLICIES
for SYS.USER_ILMDATAMOVEMENTPOLICIES
/

/*
 * View all the objects and policies for a user. Many objects inherit 
 * policies via their parent objects. This view shows all the policies and 
 * the objects affected by the policies and indicates whether the policy is 
 * inherited by an object or is directly specified on it.
 */

create or replace view USER_ILMOBJECTS 
(POLICY_NAME, OBJECT_OWNER, OBJECT_NAME, SUBOBJECT_NAME, OBJECT_TYPE, 
 INHERITED_FROM, ENABLED)
as 
/* 
 * Selects all <object,policy> information for policies on all objects.
 */
select a.name, d.name, c.name, c.subname, 
       DECODE(c.type#,19, 'TABLE PARTITION',
                      2,'TABLE',
                      34,'TABLE SUBPARTITION'), 
       (CASE 
        WHEN bitand(a.FLAG,8) = 8 
             THEN 'TABLESPACE'
        WHEN (b.obj_typ <> b.obj_typ_orig AND b.obj_typ_orig = 2) 
             THEN 'TABLE'
        WHEN (b.obj_typ <> b.obj_typ_orig AND b.obj_typ_orig = 19) 
             THEN 'TABLE PARTITION'
        ELSE 'POLICY NOT INHERITED'
        END),
       (CASE
        WHEN (bitand(b.FLAG,1)    = 1
              OR bitand(a.FLAG,1) = 1) 
             THEN 'NO'
        ELSE 'YES'
        END)
  from sys.ilm$ a, 
       sys.ilmobj$ b, 
       sys.obj$ c, 
       sys.user$ d,
       (select a.policy# 
          from sys.ilm$ a
         where bitand(a.flag, 8) = 0
           and a.owner# = userenv('SCHEMAID')
        union
        select a.policy#
          from sys.ilm$ a , 
               sys.ts$  b,
               sys.tsq$ c 
        where  bitand(a.flag, 8) = 8
          and  a.ts#    = b.ts#
          and  b.ts#    = c.ts#
          and  c.user# = userenv('SCHEMAID') 
          and (c.blocks > 0 or c.maxblocks != 0)
        union     
         select a.policy#
          from sys.ilm$ a  
        where  bitand(a.flag, 8) = 8
          and  exists
         (select null
            from sys.v$enabledprivs
           where priv_number = -15 /* UNLIMITED TABLESPACE */)) e
 where a.policy# = b.policy#
   AND b.obj#    = c.obj#
   AND c.owner#  = d.user#  
   AND a.policy# = e.policy#
   AND c.name not like 'REDEF$%'
   AND c.name not like 'MLOG$%'
minus
select a.name, d.name, c.name, c.subname, 
       DECODE(c.type#,19, 'TABLE PARTITION',
                      2,'TABLE',
                      34,'TABLE SUBPARTITION'), 
       (CASE 
        WHEN bitand(a.FLAG,8) = 8 
             THEN 'TABLESPACE'
        WHEN (b.obj_typ <> b.obj_typ_orig AND b.obj_typ_orig = 2) 
             THEN 'TABLE'
        WHEN (b.obj_typ <> b.obj_typ_orig AND b.obj_typ_orig = 19) 
             THEN 'TABLE PARTITION'
        ELSE 'POLICY NOT INHERITED'
        END),
       (CASE
        WHEN (bitand(b.FLAG,1)    = 1
              OR bitand(a.FLAG,1) = 1) 
             THEN 'NO'
        ELSE 'YES'
        END)
  from sys.ilm$ a, 
       sys.ilmobj$ b, 
       sys.obj$ c, 
       sys.user$ d,
       (select a.policy# 
          from sys.ilm$ a
         where bitand(a.flag, 8) = 0
           and a.owner# = userenv('SCHEMAID')
        union
        select a.policy#
          from sys.ilm$ a , 
               sys.ts$  b,
               sys.tsq$ c 
        where  bitand(a.flag, 8) = 8
          and  a.ts#    = b.ts#
          and  b.ts#    = c.ts#
          and  c.user# = userenv('SCHEMAID') 
          and (c.blocks > 0 or c.maxblocks != 0)
        union     
         select a.policy#
          from sys.ilm$ a  
        where  bitand(a.flag, 8) = 8
          and  exists
         (select null
            from sys.v$enabledprivs
           where priv_number = -15 /* UNLIMITED TABLESPACE */)) e,
         sys.redef_object$ f        
 where a.policy#  = b.policy#
   AND b.obj#     = c.obj#
   AND c.owner#   = d.user#  
   AND a.policy#  = e.policy#
   AND f.obj_type = 1
   AND f.int_obj_owner= d.name
   AND f.int_obj_name = c.name
/
comment on table USER_ILMOBJECTS is 
 'Policies and the objects they affect for a user'
/
comment on column USER_ILMOBJECTS.POLICY_NAME is
 'Name of the policy'
/
comment on column USER_ILMOBJECTS.OBJECT_NAME is
 'Name of the object'
/
comment on column USER_ILMOBJECTS.SUBOBJECT_NAME is
 'Name of the subobject'
/
comment on column USER_ILMOBJECTS.OBJECT_TYPE is
 'Type of the object'
/
comment on column USER_ILMOBJECTS.INHERITED_FROM is
 'Is the policy inherited? If so from where?'
/

comment on column USER_ILMOBJECTS.ENABLED is
 'Is the policy enabled on the object?'
/

grant select on USER_ILMOBJECTS to public
/
create or replace public synonym USER_ILMOBJECTS 
for SYS.USER_ILMOBJECTS
/

/* Details regarding ILM execution for a user */

create or replace view USER_ILMTASKS
(TASK_ID, STATE, CREATION_TIME, START_TIME, COMPLETION_TIME)
AS
SELECT a.execution_id, 
       DECODE(a.execution_state, 1, 'INACTIVE',
                                 2, 'ACTIVE', 
                                 3, 'COMPLETED',
                                 'UNKNOWN'),
       a.creation_time, 
       a.start_time,
       a.completion_time
  FROM sys.ilm_execution$ a
 WHERE a.owner = userenv('SCHEMAID')
/
comment on table USER_ILMTASKS is 
 'Information on ILM execution for a user'
/
comment on column USER_ILMTASKS.TASK_ID is 
 'Number that uniquely identifies a specific ILM task'
/
comment on column USER_ILMTASKS.STATE is
 'State of the ILM task'
/
comment on column USER_ILMTASKS.CREATION_TIME is
 'Creation time of the ILM task'
/
comment on column USER_ILMTASKS.START_TIME is 
 'Time of start of a specific ILM task'
/
comment on column USER_ILMTASKS.COMPLETION_TIME is 
 'Time of completion of ILM task'
/

GRANT SELECT ON USER_ILMTASKS TO public
/
create or replace public synonym USER_ILMTASKS
for SYS.USER_ILMTASKS
/

/* 
 * Details on policies considered for a particular execution. Also shows
 * the jobname that executes the policy in case the policy was selected for 
 * execution and reason in case the policy was not selected for execution. 
 */

create or replace view USER_ILMEVALUATIONDETAILS
(TASK_ID, POLICY_NAME, OBJECT_OWNER, OBJECT_NAME, SUBOBJECT_NAME, 
OBJECT_TYPE, SELECTED_FOR_EXECUTION, JOB_NAME, COMMENTS)
AS
SELECT b.execution_id, a.name , e.name, c.name , c.subname,
       DECODE(c.type#,19, 'TABLE PARTITION',
                      2,'TABLE',
                      34,'TABLE SUBPARTITION'),
       DECODE(b.jobscheduled, 1, 'POLICY DISABLED', 
                              2, 'SELECTED FOR EXECUTION',
                              3, 'SELECTED FOR EXECUTION',
                              4, 'POLICY OVERRULED',
                              5, 'INHERITED POLICY OVERRULED', 
                              6, 'PRECONDITION NOT SATISFIED', 
                              7, 'JOB ALREADY EXISTS',
                              8, 'POLICY SUCCESSFUL PREVIOUSLY',
                              9, 'NO OPERATION SINCE LAST ILM ACTION',
                              10, 'TARGET COMPRESSION NOT HIGHER THAN CURRENT',
                              11, 'ILM ONLY RECENTLY EVALUATED ON OBJECT',
                              12, 'STATISTICS NOT AVAILABLE',
                              13, 'TABLE HAS MATERIALIZED VIEW',  
                                  'NO'),
       b.jobname, b.comments 
  FROM sys.ilm$ a, 
       sys.ilm_executiondetails$ b, 
       sys.obj$ c, 
       sys.ilm_execution$ d, 
       sys.user$ e
 WHERE a.policy#    = b.policy#
   AND b.obj#         = c.obj#
   AND b.execution_id = d.execution_id
   AND d.owner        = userenv('SCHEMAID')
   AND c.owner#       = e.user#
/
comment on table USER_ILMEVALUATIONDETAILS is 
 'Details on policies considered for a particular task'
/
comment on column USER_ILMEVALUATIONDETAILS.TASK_ID is 
 'Number that uniquely identifies a specific ILM task'
/
comment on column USER_ILMEVALUATIONDETAILS.POLICY_NAME is 
 'Name of the policy'
/
comment on column USER_ILMEVALUATIONDETAILS.OBJECT_NAME is 
 'Name of the object'
/
comment on column USER_ILMEVALUATIONDETAILS.SUBOBJECT_NAME is 
 'Name of the subobject'
/
comment on column USER_ILMEVALUATIONDETAILS.OBJECT_TYPE is 
 'Type of the object'
/
comment on column USER_ILMEVALUATIONDETAILS.SELECTED_FOR_EXECUTION is 
 'Has the object been selected for execution?'
/
comment on column USER_ILMEVALUATIONDETAILS.JOB_NAME is 
 'Job name for executing the policy on the object if selected for execution'
/
comment on column USER_ILMEVALUATIONDETAILS.COMMENTS is 
 'More information if a policy is not selected for execution on an object'
/

grant select on USER_ILMEVALUATIONDETAILS to public
/

create or replace public synonym USER_ILMEVALUATIONDETAILS 
for SYS.USER_ILMEVALUATIONDETAILS
/

/* Information on jobs created for policies owned by a user.*/

create or replace view USER_ILMRESULTS
(TASK_ID, 
 JOB_NAME, 
 JOB_STATE, 
 START_TIME,
 COMPLETION_TIME, 
 COMMENTS,
 STATISTICS)
AS
SELECT a.execution_id, a.jobname,
       DECODE(a.job_status, 1,'JOB CREATED', 
                            2, 'COMPLETED SUCCESSFULLY', 
                            3, 'FAILED', 
                            4, 'STOPPED', 
                            5, 'JOB CREATION FAILED', 
                            6, 'JOB SCHEDULED', 
                            7, 'JOB DISABLED', 
                            8, 'JOB RUNNING',
                           10, 'DEPENDANT OBJECTS BEING REBUILT',
                           11, 'FAILED TO REBUILD DEPENDANT OBJECTS',
                               'NOT KNOWN'), 
       a.start_time,
       a.completion_time, 
       a.comments,
       a.statistics
  FROM sys.ilm_results$ a, sys.ilm_execution$ b
 WHERE a.execution_id = b.execution_id
   AND b.owner          = userenv('SCHEMAID')
/

comment on table USER_ILMRESULTS is
 'Information on jobs created for a user'
/
comment on column USER_ILMRESULTS.TASK_ID is 
 'Number that uniquely identifies a specific ILM execution'
/
comment on column USER_ILMRESULTS.JOB_NAME is 
 'Job name for executing policies'
/
comment on column USER_ILMRESULTS.JOB_STATE is 
 'State of the Job'
/
comment on column USER_ILMRESULTS.START_TIME is 
 'Time of start of the job'
/
comment on column USER_ILMRESULTS.COMPLETION_TIME is 
 'Time of completion of the job'
/
comment on column USER_ILMRESULTS.COMMENTS is 
 'More information if the job failed'
/
comment on column USER_ILMRESULTS.STATISTICS is 
 'ILM job related statistics'
/

grant select on USER_ILMRESULTS to public
/

create or replace public SYNONYM USER_ILMRESULTS for SYS.USER_ILMRESULTS
/

/* ILM policies in the database*/

create or replace view DBA_ILMPOLICIES
(POLICY_NAME, 
 POLICY_TYPE, 
 TABLESPACE, 
 ENABLED)  
as 
select  a.name,
        decode(ptype, 1, 'DATA MOVEMENT'),
        null, 
        decode(bitand(FLAG,1),1,'NO    ',0,'YES   ') 
  from sys.ilm$ a, sys.user$ b
 where a.owner# = b.user#  
   and bitand(a.flag, 8)   = 0
union
select  a.name,
        decode(ptype, 1, 'DATA MOVEMENT'),
        c.name, 
        decode(bitand(FLAG,1),1,'NO    ',0,'YES   ') 
  from sys.ilm$ a, sys.user$ b, sys.ts$ c
 where a.owner# = b.user#  
   and a.ts#    = c.ts#
   and bitand(a.flag, 8) = 8
/
comment on table DBA_ILMPOLICIES is
 'ILM policies in the database'
/
comment on column DBA_ILMPOLICIES.POLICY_NAME is
 'Name of the policy'
/
comment on column DBA_ILMPOLICIES.POLICY_TYPE is
 'Type of the policy'
/
comment on column DBA_ILMPOLICIES.ENABLED is
 'Is the policy enabled?'
/
grant select on DBA_ILMPOLICIES to select_catalog_role
/
create or replace public synonym dba_ilmpolicies for sys.dba_ilmpolicies
/

/* Properties of data movement related ILM policies*/ 

create or replace view DBA_ILMDATAMOVEMENTPOLICIES 
(POLICY_NAME,
 ACTION_TYPE, 
 SCOPE, 
 COMPRESSION_LEVEL,
 TIER_TABLESPACE, 
 TIER_STATUS, 
 CONDITION_TYPE, 
 CONDITION_DAYS, 
 CUSTOM_FUNCTION)
as 
select a.name, 
       decode(b.action, 1,'COMPRESSION',2,'STORAGE'),  
       decode(b.scope, 1,'SEGMENT',2,'GROUP',3,'ROW'),
       decode(b.ctype, 2, 'ADVANCED', 
                       3, (CASE 
                           WHEN b.clevel = 1 and bitand(b.flag,32) = 0
                                  THEN 'QUERY LOW'
                           WHEN b.clevel = 2 and bitand(b.flag,32) = 0
                                  THEN 'QUERY HIGH' 
                           WHEN b.clevel = 3 and bitand(b.flag,32) = 0
                                  THEN 'ARCHIVE LOW'
                           WHEN b.clevel = 4 and bitand (b.flag,32) = 0
                                  THEN 'ARCHIVE HIGH'
                           WHEN b.clevel = 1 and bitand(b.flag,32)  = 32
                                  THEN 'QUERY LOW ROW LEVEL LOCKING'
                           WHEN b.clevel = 2 and bitand(b.flag,32)  = 32
                                  THEN 'QUERY HIGH ROW LEVEL LOCKING' 
                           WHEN b.clevel = 3 and bitand(b.flag,32)  = 32
                                  THEN 'ARCHIVE LOW ROW LEVEL LOCKING'
                           WHEN b.clevel = 4 and bitand (b.flag,32) = 32
                                  THEN 'ARCHIVE HIGH ROW LEVEL LOCKING'
                           END)),
       b.tier_tbs,
       decode(b.flag, 1, 'READ ONLY'),
       CASE
       WHEN bitand(b.flag, 8) = 8 THEN 'USER DEFINED'
       WHEN b.action = 2 and  bitand(b.flag, 8) <> 8 THEN null
       ELSE
       decode(b.condition, 0, 'LAST ACCESS TIME', 1,'LOW ACCESS', 
                           2,'LAST MODIFICATION TIME', 3,'CREATION TIME', 
                           5, 'VALID TIME END')
       END,
       b.days,
       b.custfunc 
  from sys.ilm$ a, sys.ilmpolicy$ b
 where a.policy# = b.policy# 
/
comment on table DBA_ILMDATAMOVEMENTPOLICIES is
 'Data movement related policies in database'
/
comment on column DBA_ILMDATAMOVEMENTPOLICIES.POLICY_NAME is
 'Name of the policy'
/
comment on column DBA_ILMDATAMOVEMENTPOLICIES.ACTION_TYPE is
 'Type of the action executed by the policy'
/
comment on column DBA_ILMDATAMOVEMENTPOLICIES.SCOPE is
 'Scope of the policy'
/
comment on column DBA_ILMDATAMOVEMENTPOLICIES.COMPRESSION_LEVEL is
 'Compression level for the object'
/
comment on column DBA_ILMDATAMOVEMENTPOLICIES.TIER_TABLESPACE is
 'Tablespace to move the object to in case of storage tiering policy'
/
comment on column DBA_ILMDATAMOVEMENTPOLICIES.CONDITION_TYPE is
 'Column on which the policy is based'
/
comment on column DBA_ILMDATAMOVEMENTPOLICIES.CONDITION_DAYS is
 'Value associated with the condition specified in days'
/
comment on column DBA_ILMDATAMOVEMENTPOLICIES.CUSTOM_FUNCTION is
 'Optional function that evaluates the precondition on the policy '
/
grant select on DBA_ILMDATAMOVEMENTPOLICIES to select_catalog_role
/
create or replace public synonym DBA_ILMDATAMOVEMENTPOLICIES
for SYS.DBA_ILMDATAMOVEMENTPOLICIES
/


/*
 * View all the objects and policies in the database. Many objects inherit 
 * policies via their parent objects. This view shows all the policies and 
 * the objects affected by the policies and indicates whether the policy is 
 * inherited by an object or is directly specified on it.
 */

create or replace view DBA_ILMOBJECTS 
(POLICY_NAME, OBJECT_OWNER, OBJECT_NAME, SUBOBJECT_NAME, 
 OBJECT_TYPE, INHERITED_FROM, ENABLED)
as 
/* 
 * Selects all <object,policy> information for policies on all objects.
 */
select a.name, e.name, c.name, c.subname,
       DECODE(c.type#,19, 'TABLE PARTITION',
                      2,'TABLE',
                      34,'TABLE SUBPARTITION'), 
       (CASE 
        WHEN bitand(a.FLAG,8) = 8 
             THEN 'TABLESPACE'
        WHEN (b.obj_typ <> b.obj_typ_orig AND b.obj_typ_orig = 2) 
             THEN 'TABLE'
        WHEN (b.obj_typ <> b.obj_typ_orig AND b.obj_typ_orig = 19) 
             THEN 'TABLE PARTITION'
        ELSE 'POLICY NOT INHERITED'
        END),
       (CASE
        WHEN (bitand(b.FLAG,1)    = 1
              OR bitand(a.FLAG,1) = 1) 
             THEN 'NO'
        ELSE '  YES  '
        END)
  from sys.ilm$ a, 
       sys.ilmobj$ b, 
       sys.obj$ c, 
       sys.user$ e
 where a.policy# = b.policy#
   AND b.obj#    = c.obj#  
   AND c.owner#  = e.user#
   and c.name not like 'REDEF$%'
   and c.name not like 'MLOG$%'
minus
select a.name, e.name, c.name, c.subname,
       DECODE(c.type#,19, 'TABLE PARTITION',
                      2,'TABLE',
                      34,'TABLE SUBPARTITION'), 
       (CASE 
        WHEN bitand(a.FLAG,8) = 8 
             THEN 'TABLESPACE'
        WHEN (b.obj_typ <> b.obj_typ_orig AND b.obj_typ_orig = 2) 
             THEN 'TABLE'
        WHEN (b.obj_typ <> b.obj_typ_orig AND b.obj_typ_orig = 19) 
             THEN 'TABLE PARTITION'
        ELSE 'POLICY NOT INHERITED'
        END),
       (CASE
        WHEN (bitand(b.FLAG,1)    = 1
              OR bitand(a.FLAG,1) = 1) 
             THEN 'NO'
        ELSE '  YES  '
        END)
  from sys.ilm$ a, 
       sys.ilmobj$ b, 
       sys.obj$ c, 
       sys.user$ e,
       sys.redef_object$ f
 where a.policy#      = b.policy#
   AND b.obj#         = c.obj#  
   AND c.owner#       = e.user# 
   AND f.obj_type     = 1
   AND f.int_obj_owner= e.name
   AND f.int_obj_name = c.name 
/
comment on table DBA_ILMOBJECTS is 
 'Policies and the objects they affect in the database'
/
comment on column DBA_ILMOBJECTS.POLICY_NAME is
 'Name of the policy'
/
comment on column DBA_ILMOBJECTS.OBJECT_OWNER is
 'Owner of the object'
/
comment on column DBA_ILMOBJECTS.OBJECT_NAME is
 'Name of the object'
/
comment on column DBA_ILMOBJECTS.SUBOBJECT_NAME is
 'Name of the subobject'
/
comment on column DBA_ILMOBJECTS.OBJECT_TYPE is
 'Type of the object'
/
comment on column DBA_ILMOBJECTS.INHERITED_FROM is
 'Is the policy inherited? If so from where?'
/

comment on column DBA_ILMOBJECTS.ENABLED is
 'Is the policy enabled on the object?'
/


grant select on DBA_ILMOBJECTS to select_catalog_role
/
create or replace public synonym DBA_ILMOBJECTS 
for SYS.DBA_ILMOBJECTS
/

/* Details regarding ILM execution*/

create or replace view DBA_ILMTASKS
(TASK_ID, TASK_OWNER, STATE, CREATION_TIME, START_TIME, COMPLETION_TIME)
AS
SELECT a.execution_id, b.name, 
       DECODE(a.execution_state, 1, 'INACTIVE',
                                 2, 'ACTIVE', 
                                 3, 'COMPLETED',
                                 'UNKNOWN'),
       a.creation_time, 
       a.start_time,
       a.completion_time
  FROM sys.ilm_execution$ a, sys.user$ b
 where a.owner = b.user#
/
comment on table DBA_ILMTASKS is 
 'Information on ILM execution'
/
comment on column DBA_ILMTASKS.TASK_ID is 
 'Number that uniquely identifies a specific ILM execution'
/
comment on column DBA_ILMTASKS.TASK_OWNER is 
 'Owner of the specific ILM execution'
/
comment on column DBA_ILMTASKS.STATE is
 'State of the ILM task'
/
comment on column DBA_ILMTASKS.CREATION_TIME is
 'Creation time of the ILM task'
/
comment on column DBA_ILMTASKS.START_TIME is 
 'Time of start of a specific ILM execution'
/

GRANT SELECT ON DBA_ILMTASKS TO select_catalog_role
/
create or replace public synonym DBA_ILMTASKS 
for SYS.DBA_ILMTASKS
/

/* 
 * Details on policies considered for a particular execution. Also shows
 * the jobname that executes the policy in case the policy was selected for 
 * execution and reason in case the policy was not selected for execution. 
 */

create or replace view DBA_ILMEVALUATIONDETAILS
(TASK_ID, POLICY_NAME, OBJECT_OWNER, OBJECT_NAME, 
SUBOBJECT_NAME, OBJECT_TYPE, SELECTED_FOR_EXECUTION, JOB_NAME, 
COMMENTS)
AS
SELECT b.execution_id, a.name , f.name, c.name , c.subname,
       DECODE(c.type#,19, 'TABLE PARTITION',
                      2,  'TABLE',
                      34,'TABLE SUBPARTITION'),
       DECODE(b.jobscheduled, 1, 'POLICY DISABLED',
                              2, 'SELECTED FOR EXECUTION',
                              3, 'SELECTED FOR EXECUTION', 
                              4, 'POLICY OVERRULED',
                              5, 'INHERITED POLICY OVERRULED', 
                              6, 'PRECONDITION NOT SATISFIED', 
                              7, 'JOB ALREADY EXISTS',
                              8, 'POLICY SUCCESSFUL PREVIOUSLY',
                              9, 'NO OPERATION SINCE LAST ILM ACTION',
                              10, 'TARGET COMPRESSION NOT HIGHER THAN CURRENT',
                              11, 'ILM ONLY RECENTLY EVALUATED ON OBJECT',
                              12, 'STATISTICS NOT AVAILABLE',
                              13, 'TABLE HAS MATERIALIZED VIEW', 
                                  'NO'),
       b.jobname, b.comments 
  FROM sys.ilm$ a, 
       sys.ilm_executiondetails$ b, 
       sys.obj$ c, 
       sys.ilm_execution$ d, 
       sys.user$ f
 WHERE a.policy#      = b.policy#
   AND b.obj#         = c.obj#
   AND b.execution_id = d.execution_id
   AND c.owner#       = f.user#
/
comment on table DBA_ILMEVALUATIONDETAILS is 
 'Details on policies considered for a particular execution'
/
comment on column DBA_ILMEVALUATIONDETAILS.TASK_ID is 
 'Number that uniquely identifies a specific ILM execution'
/
comment on column DBA_ILMEVALUATIONDETAILS.POLICY_NAME is 
 'Name of the policy'
/
comment on column DBA_ILMEVALUATIONDETAILS.OBJECT_OWNER is 
 'Owner of the object'
/
comment on column DBA_ILMEVALUATIONDETAILS.OBJECT_NAME is 
 'Name of the object'
/
comment on column DBA_ILMEVALUATIONDETAILS.SUBOBJECT_NAME is 
 'Name of the subobject'
/
comment on column DBA_ILMEVALUATIONDETAILS.OBJECT_TYPE is 
 'Type of the object'
/
comment on column DBA_ILMEVALUATIONDETAILS.SELECTED_FOR_EXECUTION is 
 'Has the object been selected for execution?'
/
comment on column DBA_ILMEVALUATIONDETAILS.JOB_NAME is 
 'Job name for executing the policy on the object if selected for execution'
/
comment on column DBA_ILMEVALUATIONDETAILS.COMMENTS is 
 'More information if a policy is not selected for execution on an object'
/

grant select on DBA_ILMEVALUATIONDETAILS to select_catalog_role
/

create or replace public synonym DBA_ILMEVALUATIONDETAILS 
for SYS.DBA_ILMEVALUATIONDETAILS
/

/* Information on ILM jobs created*/

create or replace view DBA_ILMRESULTS
(TASK_ID, 
 JOB_NAME, 
 JOB_STATE, 
 START_TIME,
 COMPLETION_TIME, 
 COMMENTS,
 STATISTICS)
AS
SELECT a.execution_id, a.jobname,
       DECODE(a.job_status, 1,'JOB CREATED', 
                            2, 'COMPLETED SUCCESSFULLY', 
                            3, 'FAILED', 
                            4, 'STOPPED', 
                            5, 'JOB CREATION FAILED', 
                            6, 'JOB SCHEDULED', 
                            7, 'JOB DISABLED', 
                            8, 'JOB RUNNING',
                           10, 'DEPENDANT OBJECTS BEING REBUILT',
                           11, 'FAILED TO REBUILD DEPENDANT OBJECTS',
                               'NOT KNOWN'), 
       a.start_time,
       a.completion_time, 
       a.comments,
       a.statistics
  FROM sys.ilm_results$ a, 
       sys.ilm_execution$ b
 WHERE a.execution_id = b.execution_id
/

comment on table DBA_ILMRESULTS is
 'Information on ILM jobs'
/
comment on column DBA_ILMRESULTS.TASK_ID is 
 'Number that uniquely identifies a specific ILM task'
/
comment on column DBA_ILMRESULTS.JOB_NAME is 
 'Job name for executing policies'
/
comment on column DBA_ILMRESULTS.JOB_STATE is 
 'State of the Job'
/
comment on column DBA_ILMRESULTS.START_TIME is 
 'Time of start of the job'
/
comment on column DBA_ILMRESULTS.COMPLETION_TIME is 
 'Time of completion of the job'
/
comment on column DBA_ILMRESULTS.COMMENTS is 
 'More information if the job failed'
/
comment on column DBA_ILMRESULTS.STATISTICS is 
 'ILM job related statistics'
/

grant select on DBA_ILMRESULTS to select_catalog_role
/

create or replace public SYNONYM DBA_ILMRESULTS for SYS.DBA_ILMRESULTS
/

/* Information on ILM environment parameters */

create or replace view DBA_ILMPARAMETERS 
(NAME, VALUE)
as
select param_name, param_value
  from ilm_param$
/
comment on table DBA_ILMPARAMETERS is
 'Describes ILM PARAMETERS in the database and their values'
/
comment on column DBA_ILMPARAMETERS.NAME is
 'Name of the ILM environment parameter'
/
comment on column DBA_ILMPARAMETERS.VALUE is
 'Name of the ILM environment parameter value'
/

grant select on DBA_ILMPARAMETERS to select_catalog_role
/

create or replace public SYNONYM DBA_ILMPARAMETERS for SYS.DBA_ILMPARAMETERS
/

@?/rdbms/admin/sqlsessend.sql
