Rem
Rem $Header: rdbms/admin/catilmini.sql /st_rdbms_12.1.0.1/4 2013/01/11 21:22:21 sjanardh Exp $
Rem
Rem catilmini.sql
Rem
Rem Copyright (c) 2011, 2013, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      catilmini.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem
Rem BEGIN SQL_FILE_METADATA
Rem SQL_SOURCE_FILE: rdbms/admin/catilmini.sql
Rem SQL_SHIPPED_FILE: rdbms/admin/catilmini.sql
Rem SQL_PHASE: CATPEXEC_MAIN
Rem SQL_STARTUP_MODE: NORMAL
Rem SQL_IGNORABLE_ERRORS: NONE
Rem SQL_CALLING_FILE: rdbms/admin/catpexec.sql
Rem END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    vradhakr    01/06/13 - Bug 16067485: Add status row to heat_map_stat$.
Rem    sjanardh    01/10/13 - XbranchMerge maba_bug-14615619 from main
Rem    surman      12/10/12 - XbranchMerge surman_bug-12876907 from main
Rem    maba        11/26/12 - log error for bug 14615619
Rem    surman      11/14/12 - 12876907: Add ORACLE_SCRIPT
Rem    hlakshma    06/18/12 - Provide reasonable defaults for storage tiering
Rem                           related ILM constants
Rem    surman      03/27/12 - 13615447: Add SQL patching tags
Rem    hlakshma    01/03/12 - Add initializations for customizing ILM
Rem                           environment
Rem    hlakshma    11/11/11 - Insert entries for concurrency control
Rem    hlakshma    02/07/11 - ILM initialization
Rem    hlakshma    02/07/11 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql

REM Add entires for controling ILM runtime environment

DECLARE
  attribute_exists       EXCEPTION;
  PRAGMA                EXCEPTION_INIT(attribute_exists, -00001);

BEGIN  
  /* ILM concurrency control */
  begin 
    insert into SYS.ILM_CONCURRENCY$ (last_exec_time, attribute)
                          values (systimestamp-1,1);
  exception
    when attribute_exists then
       null; 
  end;
 
  /* ILM runtime related initialization */ 
  begin
    insert into SYS.ILM_PARAM$ (param#, param_name, param_value)
                        values (DBMS_ILM_ADMIN.enabled, 
                                'ENABLED', DBMS_ILM_ADMIN.ILM_ENABLED);
  exception
    when attribute_exists then
       null;
  end;
  
  begin
    insert into SYS.ILM_PARAM$ (param#, param_name, param_value)
                        values (DBMS_ILM_ADMIN.JOBLIMIT, 
                                'JOB LIMIT', 
                                 DBMS_ILM_ADMIN.ILM_LIMIT_DEF);
  exception
    when attribute_exists then
       null;
  end;

  begin
    insert into SYS.ILM_PARAM$ (param#, param_name, param_value)
                        values (DBMS_ILM_ADMIN.EXECUTION_MODE, 
                                'EXECUTION MODE', 
                                DBMS_ILM_ADMIN.ILM_EXECUTION_DEFAULT);
  exception
    when attribute_exists then
       null;
  end;

  begin
    insert into SYS.ILM_PARAM$ (param#, param_name, param_value)
                        values (DBMS_ILM_ADMIN.EXECUTION_INTERVAL, 

                                'EXECUTION INTERVAL', 15);
  exception
    when attribute_exists then
       null;
  end;
 
  begin
    insert into SYS.ILM_PARAM$ (param#, param_name               , param_value)
                        values (DBMS_ILM_ADMIN.TBS_PERCENT_USED , 'TBS PERCENT USED' , 85 );
  exception
    when attribute_exists then
      null;
  end;

  begin
    insert into SYS.ILM_PARAM$ (param#, param_name               , param_value)
                        values (DBMS_ILM_ADMIN.TBS_PERCENT_FREE , 'TBS PERCENT FREE', 25 );
  exception
    when attribute_exists then
      null;
  end;

END;
/
 
REM Add subscriber to the scheduler event queue

DECLARE
  subscriber_exists     EXCEPTION;
  PRAGMA                EXCEPTION_INIT(subscriber_exists, -24034);
  subs                  SYS.AQ$_AGENT;

BEGIN

   subs := SYS.AQ$_AGENT('ILM_AGENT', NULL, NULL);
   DBMS_AQADM.ADD_SUBSCRIBER('SYS.SCHEDULER$_EVENT_QUEUE', subs);

EXCEPTION
  WHEN subscriber_exists THEN
    NULL;

END;
/

REM Register ILM callback

DECLARE 

BEGIN

DBMS_AQ.REGISTER (
          SYS.AQ$_REG_INFO_LIST(
             SYS.AQ$_REG_INFO(
               'SYS.SCHEDULER$_EVENT_QUEUE:ILM_AGENT',
                DBMS_AQ.NAMESPACE_AQ,
                'plsql://SYS.PRVT_ILM.ILM_CALLBACK',
                HEXTORAW('FF')
                )
             ),
         1
         );
exception
  when others then
    if sqlcode = -04063 then
      dbms_system.ksdwrt(1, 'Error-04063: scheduler$_event_queue will be re-validated');
    else
      raise;
    end if;

END;
/

REM Insert status row in heat_map_stat$

DECLARE 
  v_rows number;
BEGIN
  select count(*) into v_rows from heat_map_stat$ where obj#=-1;
  if (v_rows = 0) then
    insert into heat_map_stat$
      values (-1, -1, -1, sysdate, 0, 1, NULL, NULL, NULL);
    commit;
  end if;
END;
/

@?/rdbms/admin/sqlsessend.sql
