Rem
Rem $Header: rdbms/admin/catmet2.sql /main/3 2012/09/28 08:58:34 mjangir Exp $
Rem
Rem catmet2.sql
Rem
Rem Copyright (c) 2004, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      catmet2.sql - Creates heterogeneous types for Data Pump's mdapi
Rem
Rem    DESCRIPTION
Rem      Creates heterogeneous type definitions for
Rem        TABLE_EXPORT
Rem        SCHEMA_EXPORT
Rem        DATABASE_EXPORT
Rem        TRANSPORTABLE_EXPORT
Rem      Also loads xsl stylesheets
Rem      All this must be delayed until the packages have been built.
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mjangir     09/21/12 - bug 14658090: run catmetx to enable diffing code
Rem    lbarton     06/22/04 - Bug 3695154: obsolete initmeta.sql 
Rem    lbarton     04/27/04 - lbarton_bug-3334702
Rem    lbarton     01/28/04 - Created
Rem

-- create the types

exec dbms_metadata_build.set_debug(false);
exec DBMS_METADATA_DPBUILD.create_table_export;
exec DBMS_METADATA_DPBUILD.create_schema_export;
exec DBMS_METADATA_DPBUILD.create_database_export;
exec DBMS_METADATA_DPBUILD.create_transportable_export;

-- load XSL stylesheets

exec SYS.DBMS_METADATA_UTIL.LOAD_STYLESHEETS;

-- Bug 6603832: Run catmetx.sql if XDB is installed in the database
-- Bug 14658090: Run catmetx.sql to enable the diffing code 
COLUMN :xdb_metadata NEW_VALUE xdb_metadata_file NOPRINT
VARIABLE xdb_metadata VARCHAR2(50)

DECLARE
  xdb_version registry$.version%type;
  catalog_version registry$.version%type;
BEGIN
  :xdb_metadata := 'nothing.sql';    -- initialize for not running catmetx.sql
  select version into catalog_version from registry$ where cid = 'CATALOG';
  select version into xdb_version from registry$ where cid='XDB';
  IF xdb_version = catalog_version THEN
    :xdb_metadata := 'catmetx.sql';
  END IF;
EXCEPTION
  WHEN no_data_found THEN NULL;  --  XDB not loaded
END;
/

SELECT :xdb_metadata FROM DUAL;
@@&xdb_metadata_file


