Rem Copyright (c) 1987, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem NAME
Rem    CATMETGRANT1.SQL - Grants of the Oracle dictionary for
Rem                       Metadata API.
Rem  FUNCTION
Rem     Grants privileges on views, objects and types of
Rem     the Oracle dictionary for use by the DataPump Metadata API.
Rem  NOTES
Rem     Must be run when connected to SYS or INTERNAL.
Rem     IMPORTANT! Keep the files catnomtt.sql and catnomta.sql in synch with
Rem     this file. These are invoked by catnodp.sql during downgrade.
Rem
Rem     All types must have EXECUTE granted to PUBLIC.
Rem     All top-level views used by the mdAPI to actually fetch full object
Rem     metadata (eg, KU$_TABLE_VIEW) must have SELECT granted to PUBLIC, but
Rem     must have CURRENT_USERID checking security clause.
Rem     All views subordinate to the top level views (eg, KU$_SCHEMAOBJ_VIEW)
Rem     must have SELECT granted to SELECT_CATALOG_ROLE.
Rem
Rem
Rem BEGIN SQL_FILE_METADATA
Rem SQL_SOURCE_FILE: rdbms/admin/catmetgrant1.sql
Rem SQL_SHIPPED_FILE: rdbms/admin/catmetgrant1.sql
Rem SQL_PHASE: CATPDEPS_MAIN2
Rem SQL_STARTUP_MODE: NORMAL
Rem SQL_IGNORABLE_ERRORS: NONE
Rem SQL_CALLING_FILE: rdbms/admin/catpdeps.sql
Rem END SQL_FILE_METADATA
Rem
Rem  MODIFIED
Rem     surman     12/10/12 - XbranchMerge surman_bug-12876907 from main
Rem     surman     11/14/12 - 12876907: Add ORACLE_SCRIPT
Rem     sdavidso   11/01/12 - bug14490576 - 2ndary tables for
Rem                           full/transportable
Rem     lbarton    10/11/12 - bug 14358248: non-privileged parallel export of
Rem                           views-as-tables fails
Rem     lbarton    10/03/12 - bug 10350062: ILM compression and storage tiering
Rem     bwright    10/03/12 - Bug 14679947: Add grant to ku$_object_error_view
Rem     rapayne    09/20/12 - bug 12899189: add grant to new view, 
Rem                           ku$_10_1_table_objnum_view.
Rem     lbarton    07/26/12 - bug 13454387: long varchar
Rem     surman     03/27/12 - 13615447: Add SQL patching tags
Rem     lbarton    10/27/11 - 36954_dpump_tabcluster_zonemap
Rem     lbarton    10/13/11 - bug 13092452: hygiene
Rem     jerrede    09/07/11 - Created for Parallel Upgrade Project #23496
Rem

@@?/rdbms/admin/sqlsessstart.sql

grant execute on ku$_schemaobj_t to public
/
grant select on ku$_schemaobj_view to select_catalog_role
/
grant select on ku$_schemaobjnum_view to select_catalog_role
/
grant select on ku$_edition_schemaobj_view to select_catalog_role;
grant select on ku$_edition_obj_view to select_catalog_role;
grant execute on ku$_storage_t to public
/
grant select on ku$_storage_view to select_catalog_role
/
grant execute on ku$_deferred_stg_t to public
/
grant select on ku$_deferred_stg_view to select_catalog_role
/
grant execute on ku$_file_t to public
/
grant select on ku$_file_view to select_catalog_role
/
grant execute on ku$_file_list_t to public
/
grant execute on ku$_tablespace_t to public
/
grant select on ku$_tablespace_view to public
/
grant execute on ku$_switch_compiler_t to public
/
grant select on ku$_switch_compiler_view to public
/
grant execute on ku$_simple_type_t to public
/
grant select on ku$_simple_type_view to public
/
grant execute on ku$_collection_t to public
/
grant select on ku$_collection_view to public
/
grant execute on ku$_argument_t to public
/
grant execute on ku$_argument_list_t to public
/
grant select on ku$_argument_view to public
/
grant execute on ku$_procinfo_t to public
/
grant select on ku$_procinfo_view to public
/
grant execute on ku$_procjava_t to public
/
grant select on ku$_procjava_view to public
/
grant execute on ku$_procc_t to public
/
grant select on ku$_procc_view to public
/
grant execute on ku$_procplsql_t to public
/
grant select on ku$_procplsql_view to public
/
grant execute on ku$_method_list_t to public
/
grant select on ku$_method_view to public
/
grant execute  on ku$_type_attr_t to public
/
grant execute on ku$_type_attr_list_t to public
/
grant select on ku$_type_attr_view to public
/
grant execute on ku$_type_t to public
/
grant select on ku$_type_view to public
/
grant execute on ku$_type_body_t to public
/
grant select on ku$_type_body_view to public
/
grant execute on ku$_full_type_t to public
/
grant select on ku$_full_type_view to public
/
grant execute on ku$_exp_type_body_t to public
/
grant select on ku$_exp_type_body_view to public
/
grant select on ku$_inc_type_view to public
/
grant select on ku$_deptypes_base_view to select_catalog_role
/
grant select on ku$_deptypes_view to public
/
grant execute on ku$_simple_col_t to public
/
grant execute on ku$_simple_col_list_t to public
/
grant select on ku$_simple_col_view to select_catalog_role
/
grant select on ku$_simple_setid_col_view to select_catalog_role
/
grant select on ku$_simple_pkref_col_view to select_catalog_role
/
grant execute on ku$_index_col_t to public
/
grant execute on ku$_index_col_list_t to public
/
grant select on ku$_index_col_view to select_catalog_role
/
grant execute on ku$_lobindex_t to public
/
grant select on ku$_lobindex_view to select_catalog_role
/
grant execute on ku$_lob_t to public
/
grant select on ku$_lob_view to select_catalog_role
/
grant execute on ku$_partlob_t to public
/
grant select on ku$_partlob_view to select_catalog_role
/
grant execute on ku$_lobfragindex_t to public
/
grant select on ku$_lobfragindex_view to select_catalog_role
/
grant select on ku$_sublobfragindex_view to select_catalog_role
/
grant execute on ku$_lobfrag_t to public
/
grant execute on ku$_lobfrag_list_t to public
/
grant select on ku$_lobfrag_view to select_catalog_role
/
grant select on ku$_piotlobfrag_view to select_catalog_role
/
grant select on ku$_sublobfrag_view to select_catalog_role
/
grant execute on ku$_lobcomppart_t to public
/
grant execute on ku$_lobcomppart_list_t to public
/
grant select on ku$_lobcomppart_view to select_catalog_role
/
grant execute on ku$_tlob_comppart_t to public
/
grant execute on ku$_tlob_comppart_list_t to public
/
grant select on ku$_tlob_comppart_view to select_catalog_role
/
grant execute on ku$_temp_subpart_t to public
/
grant select on ku$_temp_subpart_view to select_catalog_role
/
grant execute on ku$_temp_subpartdata_t to public
/
GRANT SELECT ON  ku$_temp_subpartdata_view TO PUBLIC;
grant execute on ku$_temp_subpartlobfrg_t to public
/
grant select on ku$_temp_subpartlobfrg_view to select_catalog_role
/
grant execute on ku$_temp_subpartlob_t to public
/
GRANT SELECT ON  ku$_temp_subpartlob_view TO PUBLIC;
grant execute on ku$_hntp_t to public
/
grant select on ku$_hntp_view to select_catalog_role
/
grant execute on ku$_ntpart_t to public
/
grant select on ku$_ntpart_view to select_catalog_role
/
grant execute on ku$_ntpart_list_t to public
/
grant execute on ku$_ntpart_parent_t to public
/
grant select on ku$_ntpart_parent_view to select_catalog_role
/
grant execute on ku$_ind_part_t to public
/
grant execute on ku$_ind_part_list_t to public
/
grant select on ku$_ind_part_view to select_catalog_role
/
grant execute on ku$_piot_part_t to public
/
grant execute on ku$_piot_part_list_t to public
/
grant select on ku$_piot_part_view to select_catalog_role
/
grant execute on ku$_tab_part_t to public
/
grant execute on ku$_tab_part_list_t to public
/
grant select on ku$_tab_part_view to select_catalog_role
/
grant execute on ku$_tab_subpart_t to public
/
grant execute on ku$_tab_subpart_list_t to public
/
grant select on ku$_tab_subpart_view to select_catalog_role
/
grant execute on ku$_tab_tsubpart_t to public
/
grant execute on ku$_tab_tsubpart_list_t to public
/
grant select on ku$_tab_tsubpart_view to select_catalog_role
/
grant execute on ku$_tab_compart_t to public
/
grant execute on ku$_tab_compart_list_t to public
/
grant select on ku$_tab_compart_view to select_catalog_role
/
grant execute on ku$_ind_subpart_t to public
/
grant execute on ku$_ind_subpart_list_t to public
/
grant select on ku$_ind_subpart_view to select_catalog_role
/
grant execute on ku$_ind_compart_t to public
/
grant execute on ku$_ind_compart_list_t to public
/
grant select on ku$_ind_compart_view to select_catalog_role
/
grant execute on ku$_part_col_t to public
/
grant execute on ku$_part_col_list_t to public
/
grant select on ku$_tab_part_col_view to select_catalog_role
/
grant select on ku$_tab_subpart_col_view to select_catalog_role
/
grant select on ku$_ind_part_col_view to select_catalog_role
/
grant select on ku$_ind_subpart_col_view to select_catalog_role
/
grant execute on ku$_insert_ts_t to public
/
grant execute on ku$_insert_ts_list_t to public
/
grant select on ku$_insert_ts_view to select_catalog_role
/
grant execute on ku$_partobj_t to public
/
grant select on ku$_partobj_view to select_catalog_role
/
grant execute on ku$_tab_partobj_t to public
/
grant select on ku$_tab_partobj_view to select_catalog_role
/
grant execute on ku$_ind_partobj_t to public
/
grant select on ku$_ind_partobj_view to select_catalog_role
/
grant execute on ku$_domidx_2ndtab_t to public
/
grant execute on ku$_domidx_2ndtab_list_t to public
/
grant select on ku$_domidx_2ndtab_view to select_catalog_role
/
grant select on ku$_2ndtab_info_view to public
/
grant execute on  ku$_domidx_plsql_t to public
/
grant select on ku$_domidx_plsql_view to select_catalog_role
/
grant execute on ku$_jijoin_table_t to public
/
grant execute on ku$_jijoin_table_list_t to public
/
grant select on ku$_jijoin_table_view to select_catalog_role
/
grant execute on ku$_jijoin_t to public
/
grant execute on ku$_jijoin_list_t to public
/
grant select on ku$_jijoin_view to select_catalog_role
/
grant execute on ku$_index_t to public
/
grant execute on ku$_index_list_t to public
/
grant select on ku$_all_index_view to public
/
grant select on ku$_index_view to public
/
grant select on ku$_10_2_index_view to public
/
grant execute on ku$_constraint_col_t to public
/
grant select on ku$_constraint_col_view to select_catalog_role
/
grant execute on ku$_constraint_col_list_t to public
/
grant execute on ku$_constraint0_t to public
/
grant execute on ku$_constraint0_list_t to public
/
grant execute on ku$_constraint1_t to public
/
grant execute on ku$_constraint1_list_t to public
/
grant execute on ku$_constraint2_t to public
/
grant execute on ku$_constraint2_list_t to public
/
grant select on ku$_constraint0_view to select_catalog_role
/
grant select on ku$_constraint1_view to select_catalog_role
/
grant select on ku$_constraint2_view to select_catalog_role
/
grant execute on ku$_pkref_constraint_t to public
/
grant execute on ku$_pkref_constraint_list_t to public
/
grant select on ku$_pkref_constraint_view to select_catalog_role
/
grant execute on ku$_constraint_t to public
/
grant select on ku$_constraint_view to public
/
grant execute on ku$_ref_constraint_t to public
/
grant select on ku$_ref_constraint_view to public
/
grant execute on ku$_find_hidden_cons_t to public
/
grant select on ku$_find_hidden_cons_view to public
/
grant execute on ku$_prim_column_t to public
/
grant execute on ku$_prim_column_list_t to public
/
grant select on ku$_prim_column_view to select_catalog_role
/
grant execute on ku$_subcoltype_t to public
/
grant execute on ku$_subcoltype_list_t to public
/
grant select on ku$_subcoltype_view to select_catalog_role
/
grant execute on ku$_coltype_t to public
/
grant select on ku$_coltype_view to select_catalog_role
/
grant execute on ku$_xmlschema_t to public
/
grant select on ku$_xmlschema_view to public
/
grant select on ku$_exp_xmlschema_view to public
/
grant execute on ku$_xmlschema_elmt_t to public
/
grant select on ku$_xmlschema_elmt_view to select_catalog_role
/
grant select on ku$_xmlschema_special_view to public
/
grant execute on ku$_opqtype_t to public
/
grant select on ku$_opqtype_view to select_catalog_role
/
grant execute on ku$_radm_mc_t to public
/
grant execute on ku$_radm_mc_list_t to public
/
grant select on ku$_radm_mc_view to select_catalog_role
/
grant execute on ku$_radm_policy_t to public
/
grant select on ku$_radm_policy_view to select_catalog_role
/
grant execute on ku$_radm_fptm_t to public
/
grant select on ku$_radm_fptm_view to select_catalog_role
/
grant execute on ku$_dummy_isr_t to public
/
grant select on ku$_dummy_isr_view to select_catalog_role
/
grant execute on ku$_dummy_isrm_t to public
/
grant select on ku$_dummy_isrm_view to select_catalog_role
/
grant execute on ku$_dummy_realm_t to public
/
grant select on ku$_dummy_realm_view to select_catalog_role
/
grant execute on ku$_dummy_realm_member_t to public
/
grant select on ku$_dummy_realm_member_view to select_catalog_role
/
grant execute on ku$_dummy_realm_auth_t to public
/
grant select on ku$_dummy_realm_auth_view to select_catalog_role
/
grant execute on ku$_dummy_rule_t to public
/
grant select on ku$_dummy_rule_view to select_catalog_role
/
grant execute on ku$_dummy_rule_set_t to public
/
grant select on ku$_dummy_rule_set_view to select_catalog_role
/
grant execute on ku$_dummy_rule_set_member_t to public
/
grant select on ku$_dummy_rule_set_member_view to select_catalog_role
/
grant execute on ku$_dummy_command_rule_t to public
/
grant select on ku$_dummy_command_rule_view to select_catalog_role
/
grant execute on ku$_dummy_role_t to public
/
grant select on ku$_dummy_role_view to select_catalog_role
/
grant execute on ku$_dummy_factor_t to public
/
grant select on ku$_dummy_factor_view to select_catalog_role
/
grant execute on ku$_dummy_factor_link_t to public
/
grant select on ku$_dummy_factor_link_view to select_catalog_role
/
grant execute on ku$_dummy_factor_type_t to public
/
grant select on ku$_dummy_factor_type_view to select_catalog_role
/
grant execute on ku$_dummy_identity_t to public
/
grant select on ku$_dummy_identity_view to select_catalog_role
/
grant execute on ku$_dummy_identity_map_t to public
/
grant select on ku$_dummy_identity_map_view to select_catalog_role
/
grant select on ku$_table_xmlschema_view  to select_catalog_role
/
grant execute on ku$_oidindex_t to public
/
grant select on ku$_oidindex_view to select_catalog_role
/
grant execute on ku$_column_t to public
/
grant execute on ku$_column_list_t to public
/
grant select on ku$_column_view to select_catalog_role
/
grant execute on ku$_pcolumn_t to public
/
grant execute on ku$_pcolumn_list_t to public
/
grant select on ku$_pcolumn_view to select_catalog_role
/
grant execute on ku$_ov_table_t to public
/
grant select on ku$_ov_table_view to select_catalog_role
/
grant execute on ku$_map_table_t to public
/
grant select on ku$_map_table_view to select_catalog_role
/
grant execute on ku$_hnt_t to public
/
grant select on ku$_hnt_view to select_catalog_role
/
grant execute on ku$_iont_t to public
/
grant select on ku$_iont_view to select_catalog_role
/
grant execute on ku$_nt_t to public
/
grant execute on ku$_nt_list_t to public
/
grant execute on ku$_nt_parent_t to public
/
grant select on ku$_nt_parent_view to select_catalog_role
/
grant execute on ku$_tabcluster_t to public
/
grant select on ku$_tabcluster_col_view to select_catalog_role
/
grant select on ku$_tabcluster_view to select_catalog_role
/
grant execute on ku$_clstcol_t to public
/
grant select on ku$_clstcol_view to select_catalog_role
/
grant execute on ku$_clstcol_list_t to public
/
grant execute on ku$_clstjoin_t to public
/
grant execute on ku$_clstjoin_list_t to public
/
grant select on ku$_clstjoin_view to select_catalog_role
/
grant execute on ku$_clst_zonemap_t to public
/
grant select on ku$_clst_zonemap_view to select_catalog_role
/
grant execute on ku$_clst_t to public
/
grant select on ku$_clst_view to select_catalog_role
/
grant execute on ku$_tabclst_t to public
/
grant select on ku$_tabclst_view to public
/
grant execute on ku$_ilm_policy_t to public
/
grant execute on ku$_ilm_policy_list_t to public
/
grant select on ku$_ilm_policy_view to select_catalog_role
/
grant select on ku$_ilm_policy_view2 to select_catalog_role
/
grant select on ku$_tbs_ilm_policy_view to select_catalog_role
/
grant execute on ku$_extloc_t to public
/
grant execute on ku$_extloc_list_t to public
/
grant execute on ku$_exttab_t to public
/
grant select on ku$_exttab_view to public
/
grant execute on ku$_cube_fact_t to public
/
grant execute on ku$_cube_fact_list_t to public
/
grant execute on ku$_cube_hier_t to public
/
grant execute on ku$_cube_hier_list_t to public
/
grant execute on ku$_cube_dim_t to public
/
grant execute on ku$_cube_dim_list_t to public
/
grant execute on ku$_cube_tab_t to public
/
grant select on ku$_cube_fact_view to select_catalog_role
/
grant select on ku$_cube_tab_view to select_catalog_role
/
grant execute on ku$_fba_t to public
/
grant select on ku$_fba_view to select_catalog_role
/
grant execute on ku$_htable_t to public
/
grant select on ku$_htable_view to public
/
grant select on ku$_10_1_htable_view to public
/
grant execute on ku$_phtable_t to public
/
grant select on ku$_phtable_view to public
/
grant select on ku$_10_1_phtable_view to public
/
grant execute on ku$_fhtable_t to public
/
grant select on ku$_fhtable_view to public
/
grant select on ku$_10_2_fhtable_view to public
/
grant select on ku$_10_1_fhtable_view to public
/
grant execute on ku$_pfhtable_t to public
/
grant select on ku$_pfhtable_view to public
/
grant select on ku$_10_1_pfhtable_view to public
/
grant select on ku$_ref_par_level_view to public
/
grant select on ku$_acptable_view to public
/
grant execute on ku$_iotable_t to public
/
grant select on ku$_iotable_view to public
/
grant select on ku$_10_1_iotable_view to public
/
grant execute on ku$_ov_tabpart_t to public
/
grant execute on ku$_ov_tabpart_list_t to public
/
grant select on ku$_ov_tabpart_view to select_catalog_role
/
grant execute on ku$_iot_partobj_t to public
/
grant select on ku$_iot_partobj_view to select_catalog_role
/
grant execute on ku$_piotable_t to public
/
grant select on ku$_piotable_view to public
/
grant select on ku$_10_1_piotable_view to public
/
grant execute on ku$_table_objnum_t to public
/
grant select on ku$_table_objnum_view to public
/
grant select on ku$_2nd_table_objnum_view to public
/
grant select on ku$_ptable_ts_view to select_catalog_role
/
grant select on ku$_11_2_table_objnum_view to public
/
grant select on ku$_10_1_table_objnum_view to public
/
grant select on ku$_ntable_objnum_view to public
/
grant select on ku$_11_2_ntable_objnum_view to public
/
grant select on ku$_xdb_ntable_objnum_view to public
/
grant select on ku$_11_2_xdb_ntbl_objnum_view to public
/
grant select on ku$_deptable_objnum_view to public
/
grant select on ku$_11_2_deptbl_objnum_view to public
/
grant select on ku$_table_types_view to select_catalog_role
/
grant select on ku$_xmlschema_types_view to select_catalog_role
/
grant select on ku$_tts_types_view to select_catalog_role
/
grant select on ku$_domidx_objnum_view to public
/
grant execute on  ku$_option_objnum_t to public
/
grant select on  ku$_expreg to select_catalog_role
/
grant select on ku$_option_objnum_view to select_catalog_role
/
grant select on ku$_option_view_objnum_view to select_catalog_role
/
grant execute on  ku$_marker_t to public
/
grant select on ku$_marker_view to public
/
grant select on ku$_tabprop_view to public
/
grant select on sys.ku$_viewprop_view to public
/
grant select on sys.ku$_view_exists_view to public
/
grant select on sys.ku$_pfhtabprop_view to public
/
grant select on sys.ku$_refparttabprop_view to public
/
grant select on sys.ku$_mvprop_view to public
/
grant select on sys.ku$_mvlprop_view to public
/
grant select on sys.ku$_mzprop_view to public
/
grant select on sys.ku$_syn_exists_view to public
/
grant select on sys.ku$_objgrant_exists_view to public
/
grant select on sys.ku$_constraint_exists_view to public
/
grant select on sys.ku$_ref_constraint_exists_view to public
/
grant select on sys.ku$_ind_exists_view to public
/
grant select on sys.ku$_trig_exists_view to public
/
grant select on sys.ku$_edition_trig_exists_view to public
/
grant select on sys.ku$_proc_exists_view to public
/
grant select on sys.ku$_edition_proc_exists_view to public
/
grant select on sys.ku$_tts_view to select_catalog_role;
grant select on sys.ku$_tab_ts_view to public
/
grant select on sys.ku$_tts_ind_view to select_catalog_role;
grant select on sys.ku$_ind_ts_view to public
/
grant select on sys.ku$_clu_ts_view to public
/
grant select on sys.ku$_tts_mv_view to select_catalog_role
/
grant select on sys.ku$_mv_ts_view to public
/
grant execute on ku$_mv_deptbl_objnum_t to public
/
grant select on sys.ku$_mv_deptbl_objnum_view to public
/
grant select on sys.ku$_tts_mvl_view to select_catalog_role
/
grant select on sys.ku$_mvl_ts_view to public
/
grant select on ku$_unload_method_view to select_catalog_role;
GRANT SELECT ON sys.ku$xktfbue TO PUBLIC
/
GRANT INSERT ON sys.ku$xktfbue TO PUBLIC
/
grant execute on ku$_bytes_alloc_t to public
/
grant select on ku$_bytes_alloc_view to select_catalog_role
/
grant execute on ku$_tab_bytes_alloc_t to public
/
grant execute on ku$_table_data_t to public
/
grant select on ku$_htable_bytes_alloc_view to select_catalog_role
/
grant select on ku$_htable_data_view to public
/
grant select on ku$_htpart_bytes_alloc_view to select_catalog_role
/
grant select on ku$_htpart_data_view to public
/
grant select on ku$_htspart_bytes_alloc_view to select_catalog_role
/
grant select on ku$_htspart_data_view to public
/
grant select on ku$_iotable_bytes_alloc_view to select_catalog_role
/
grant select on ku$_iotable_data_view to public
/
grant select on ku$_iotpart_bytes_alloc_view to select_catalog_role
/
grant select on ku$_iotpart_data_view to public
/
grant select on ku$_ntable_bytes_alloc_view to select_catalog_role
/
grant select on ku$_ntable_data_view to public
/
grant select on ku$_niotable_data_view to public
/
grant select on ku$_eqntable_bytes_alloc_view to select_catalog_role
/
grant select on ku$_eqntable_data_view to public
/
grant select on ku$_table_data_view to public
/
grant select on ku$_10_2_table_data_view to public
/
grant select on ku$_10_1_table_data_view to public
/
grant select on ku$_tab_subname_view to public;
grant select on ku$_ind_subname_view to public;
grant execute on ku$_post_data_table_t to public
/
grant select on ku$_post_data_table_view to public
/
grant execute on ku$_strmsubcoltype_t to public
/
grant execute on ku$_strmsubcoltype_list_t to public
/
grant select on ku$_strmsubcoltype_view to select_catalog_role
/
grant execute on ku$_strmcoltype_t to public
/
grant select on ku$_strmcoltype_view to select_catalog_role
/
grant select on ku$_10_2_strmsubcoltype_view to select_catalog_role
/
grant execute on ku$_10_2_strmcoltype_t to public
/
grant select on ku$_10_2_strmcoltype_view to select_catalog_role
/
grant execute on ku$_strmcol_t to public
/
grant execute on ku$_strmcol_list_t to public
/
grant select on ku$_strmcol_view to select_catalog_role
/
grant execute on ku$_10_2_strmcol_t to public
/
grant execute on ku$_10_2_strmcol_list_t to public
/
grant select on ku$_10_2_strmcol_view to select_catalog_role
/
grant execute on ku$_strmtable_t to public
/
grant select on ku$_strmtable_view to public
/
grant execute on ku$_10_2_strmtable_t to public
/
grant select on ku$_10_2_strmtable_view to public
/
grant execute on ku$_proc_t to public
/
grant select on ku$_base_proc_view to select_catalog_role
/
grant execute on ku$_proc_objnum_t to public
/
grant select on ku$_base_proc_objnum_view to select_catalog_role
/
grant select on ku$_proc_view to public
/
grant select on ku$_func_view to public
/
grant select on ku$_pkg_objnum_view to public
/
grant select on ku$_pkg_view to public
/
grant select on ku$_pkgbdy_view to public
/
grant execute on ku$_full_pkg_t to public
/
grant select on ku$_full_pkg_view to public
/
grant execute on ku$_exp_pkg_body_t to public
/
grant select on ku$_exp_pkg_body_view to public
/
grant execute on ku$_alter_proc_t to public
/
grant select on ku$_alter_proc_view to public
/
grant select on ku$_alter_func_view to public
/
grant select on ku$_alter_pkgspc_view to public
/
grant select on ku$_alter_pkgbdy_view to public
/
grant execute on ku$_oparg_t to public
/
grant execute on ku$_oparg_list_t to public
/
grant execute on ku$_opancillary_t to public
/
grant execute on ku$_opancillary_list_t to public
/
grant select on ku$_opancillary_view to select_catalog_role
/
grant execute on ku$_opbinding_t to public
/
grant select on ku$_object_error_view to public
/


@?/rdbms/admin/sqlsessend.sql
