Rem
Rem $Header: rdbms/admin/catmetviews_mig.sql /main/1 2012/10/19 01:35:34 traney Exp $
Rem
Rem catmetviews_mig.sql
Rem
Rem Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
Rem
Rem    NAME
Rem      catmetviews_mig.sql - catmet migration views
Rem
Rem    DESCRIPTION
Rem      Creates catmet views whose definitions are dependent on columns in
Rem    bootstrap tables.
Rem
Rem    NOTES
Rem      Run from catmetviews.sql and utlmmigtbls.sql.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    traney      09/26/12 - Created
Rem

-------------------------------------------------------------------------------
--                              SCHEMA OBJECTS
-------------------------------------------------------------------------------

-- view for schema objects
declare
  obj_id number;
  column_exists number;
  propsrow_exists number;
  use_new_cols boolean := FALSE;
  success_with_error exception;
  pragma exception_init(success_with_error, -24344);
begin
  select obj# into obj_id from obj$ where owner#=0 and name='OBJ$';
  select count(*) into column_exists from col$
   where obj# = obj_id and name='SIGNATURE';
  select count(*) into propsrow_exists from props$ where
   name='BOOTSTRAP_UPGRADE_ERROR';
  if column_exists = 1 or propsrow_exists = 1 then
    use_new_cols := TRUE;
  end if;
  execute immediate q'!
create or replace force view ku$_schemaobj_view of ku$_schemaobj_t
  with object identifier(obj_num) as
  select o.obj#, o.dataobj#, o.owner#, u.name, o.name, o.namespace, o.subname,
         o.type#,
         -- translate type# to name: type# values are defined in kgl.h
         decode(o.type#,
                 0, 'CURSOR',                    1, 'INDEX',
                 2, 'TABLE',                     3, 'CLUSTER',
                 4, 'VIEW',                      5, 'SYNONYM',
                 6, 'SEQUENCE',                  7, 'PROCEDURE',
                 8, 'FUNCTION',                  9, 'PACKAGE',
                11, 'PACKAGE_BODY',             12, 'TRIGGER',
                13, 'TYPE',                     14, 'TYPE_BODY',
                15, 'OBJECT',                   16, 'USER',
                17, 'LINK',                     18, 'PIPE',
                19, 'TABLE PARTITION',          20, 'INDEX PARTITION',
                21, 'LOB',                      22, 'LIBRARY',
                23, 'DIRECTORY',                24, 'QUEUE',
                25, 'IOT',                      26, 'REPLICATION OBJECT GROUP',
                27, 'REPLICATION PROPAGATOR',   28, 'JAVA_SOURCE',
                29, 'JAVA_CLASS',               30, 'JAVA_RESOURCE',
                31, 'JAVA JAR',                 32, 'INDEXTYPE',
                33, 'OPERATOR',                 34, 'TABLE SUBPARTITION',
                35, 'INDEX SUBPARTITION',       36, 'SERVER-SIDE REPAPI',
                37, 'REPLICATION INTERNAL PACKAGE',
                38, 'CONTEXT POLICY OBJECT',
                39, 'PUB_SUB INTERNAL INFORMATION',
                40, 'LOB PARTITION',            41, 'LOB SUBPARTITION',
                42, 'SUMMARY',                  43, 'DIMENSION',
                44, 'CONTEXT',                  45, 'OUTLINE',
                46, 'RULESET OBJECT',           47, 'SCHEDULER PLAN',
                48, 'SCHEDULER CLASS',          49, 'PENDING SCHEDULER PLAN',
                50, 'PENDING SCHEDULER CLASS',  51, 'SUBSCRIPTION INFORMATION',
                52, 'LOCATION INFORMATION',     53, 'REMOTE OBJECTS INFO',
                54, 'REPAPI SNAPSHOT METADATA', 55, 'IFS DATA',
                56, 'JAVA SHARED DATA',         57, 'SECURITY PROFILE',
                58, 'TRANSFORMATION',           59, 'RULE',
                60, 'CAPTURE PROCESS',          61, 'APPLY PROCESS',
                62, 'RULE EVALUATION CONTEXT',  63, 'LOG-BASED REPL SOURCE',
                64, 'STREAM DDL',               65, 'KGL TEST',
                66, 'SCHEDULER JOB',            67, 'SCHEDULER PROGRAM',
                68, 'SCHEDULER CLASS',          69, 'SCHEDULER WINDOW',
                70, 'MULTI-VERSIONED OBJECT',   71, 'SCHEDULER JOB SLAVE',
                72, 'SCHEDULER WINDOW GROUP',   73, 'CDC CHANGE SET',
                74, 'SCHEDULER SCHEDULE',       75, 'SQL TUNING BASE',     
                76, 'HINTSET',                  77, 'SCHEDULER ATTRIBUTES',     
                78, 'RESOURCE MANAGER CDB PLAN',     
                79, 'SCHEDULER JOB CHAIN',      80, 'STRACH PAD',     
                81, 'STREAMS FILE GROUP',       82, 'MINING MODEL',     
                83, 'SCHEDULER EVENT QUEUE INFO',     
                84, 'LIGHT WEIGHT SESSION',     85, 'DATA SECURITY DOCUMENT',     
                86, 'SECURITY CLASS',           87, 'ASSEMBLY',     
                88, 'STUB',                     89, 'LIGHTWEIGHT JOBS',     
                90, 'CREDENTIAL',               91, 'REMOTE OBJECT REFERENCE',     
                92, 'OLAP CUBE DIMENSION',      93, 'OLAP CUBE',     
                94, 'OLAP MEASURE FOLDER',      95, 'OLAP CUBE BUILD PROCESS',     
                96, 'STREAM PROPAGATION',       97, 'FUSION XS PARAMETERS',     
                98, 'XDB REPOSITORY',           99, 'OBJECT ID',     
                100, 'SCHEDULER FILE WATCHER', 
                101, 'JOB SCHEDULER NAMED DESTINATION',     
                102, 'CURSOR STATS',            103, 'TEXT MVDATA CACHE ',     
                104, 'TEXT MVDATA -M    ',      105, 'TEXT MVDATA -F    ',     
                106, 'TABLE-INDEX PARTITION CACHE',     
                107, 'SPATIAL INDEX METADATA',     
                108, 'FUSION XS NAMESPACE TEMPLATES',     
                109, 'FUSION XS SECURITY CLASS',     
                110, 'FUSION SECURITY ACL',     111, 'PLUGGABLE DATABASE',     
                112, 'SPATIAL GEOM METADATA',   113, 'SPATIAL SRID METADATA',     
                114, 'SQL TRANSLATION PROFILE', 115, 'AUDIT POLICY',     
                116, 'SPATIAL FEATURE USAGE',     
                117, 'SPATIAL CRS DIMENSION METADATA',     
                118, 'SCHEDULER IN-MEMORY JOBS',     
                119, 'OLS ILABELS',     
                120, 'OLS GROUP NUMBER TO SHORT NAME MAPPINGS',     
                121, 'OLS GROUP SHORT NAME TO NUMBER MAPPINGS',     
                122, 'OLS COMPARTMENT NUMBER TO SHORT NAME MAPPINGS',     
                123, 'OLS COMPARTMENT SHORT NAME TO NUMBER MAPPINGS',     
                124, 'OLS LEVEL NUMBER TO SHORT NAME MAPPINGS',     
                125, 'OLS LEVEL SHORT NAME TO NUMBER MAPPINGS',     
                126, 'OPTIMIZER FINDING',       127, 'OPTIMIZER DIRECTIVE OWNER',
                128, 'OLS USERS',               129, 'DATABASE VAULT RULE',     
                130, 'DATABASE VAULT RULE SET',     
                131, 'LABEL SECURITY POLICY-TABLE CACHE',     
                132, 'LABEL SECURITY LABEL-PID CACHE',     
                133, 'OLS READ CONTROL RELATED CACHE',     
                134, 'OLS$AUDIT OPTIONS',       135, 'USER PRIVILEGE',     
                136, 'SCHEDULER RESOURCE CONSTRAINT',     
                137, 'QUEUE DURABLE SUBSCRIBERS',     
                     'ERROR'),
         to_char(o.ctime,'YYYY-MM-DD HH24:MI:SS'),
         to_char(o.mtime,'YYYY-MM-DD HH24:MI:SS'),
         to_char(o.stime,'YYYY-MM-DD HH24:MI:SS'),
         o.status, o.remoteowner,
         o.linkname, o.flags, o.oid$,
         o.spare1, o.spare2, o.spare3,
         o.spare4, o.spare5, to_char(o.spare6,'YYYY/MM/DD HH24:MI:SS'),
         case when (o.spare3 > 0) then
             (select u.name from user$ u where o.spare3 = u.user#)
         else null
         end,
  !' || -- drop back into PL/SQL to define the columns conditionally
  case when use_new_cols then '
         o.signature, o.spare7, o.spare8, o.spare9
  ' else 'null, 0, 0, 0' end || q'!
  from obj$ o, user$ u
  where o.owner# = u.user#
  !';
exception
  when success_with_error then
  if use_new_cols then 
    null;
  else
    raise;
  end if;
end;
/


declare
  obj_id number;
  column_exists number;
  propsrow_exists number;
  use_new_cols boolean := FALSE;
  success_with_error exception;
  pragma exception_init(success_with_error, -24344);
begin
  select obj# into obj_id from obj$ where owner#=0 and name='OBJ$';
  select count(*) into column_exists from col$
   where obj# = obj_id and name='SIGNATURE';
  select count(*) into propsrow_exists from props$ where
   name='BOOTSTRAP_UPGRADE_ERROR';
  if column_exists = 1 or propsrow_exists = 1 then
    use_new_cols := TRUE;
  end if;
  execute immediate q'!
create or replace force view ku$_edition_obj_view
 (    obj#,
      dataobj#,
      defining_owner#,
      name,
      namespace,
      subname,
      type#,
      ctime,
      mtime,
      stime,
      status,
      remoteowner,
      linkname,
      flags,
      oid$,
      spare1,
      spare2,
      spare3,
      spare4,
      spare5,
      spare6,
      signature,
      spare7,
      spare8,
      spare9,
      owner#,
      defining_edition
 )
as
select o.*,
  !' || -- drop back into PL/SQL to define the columns conditionally
  case when use_new_cols then ''
  else 'null, 0, 0, 0, ' end || q'!
       o.spare3,
       case when (o.type# not in (select ue.type# from user_editioning$ ue
                                  where ue.user# = o.spare3) or
                  bitand(o.flags, 1048576) = 1048576 or
                  bitand(u.spare1, 16) = 0) then
         null
       when (u.type# = 2) then
        (select eo.name from obj$ eo where eo.obj# = u.spare2)
       else
        'ORA$BASE'
       end
from obj$ o, user$ u
where o.owner# = u.user#
  and (   /* non-versionable object */
          (   (    o.type# not in (select type# from user_editioning$ ue
                                  where ue.user# = o.spare3)
               and o.type# != 88)
           or bitand(o.flags, 1048576) = 1048576
           or bitand(u.spare1, 16) = 0)
          /* versionable object visible in designated edition */
       or (    o.type# in (select ue.type# from user_editioning$ ue
                           where ue.user# = o.spare3)
           and (   (u.type# <> 2 and
                    (select distinct sys.dbms_metadata.get_edition from dual)
                        = 'ORA$BASE')
                or (u.type# = 2 and
                    u.spare2 =
                        (select distinct sys.dbms_metadata.get_edition_id from dual))
                or exists (select 1 from obj$ o2, user$ u2
                           where o2.type# = 88
                             and o2.dataobj# = o.obj#
                             and o2.owner# = u2.user#
                             and u2.type#  = 2
                             and u2.spare2 =
                        (select distinct sys.dbms_metadata.get_edition_id from dual))
               )
          )
      )
  !';
exception
  when success_with_error then
  if use_new_cols then 
    null;
  else
    raise;
  end if;
end;
/

-------------------------------------------------------------------------------
--                              PRIMITIVE COLUMNS
-------------------------------------------------------------------------------

-- view to get all primitive columns (columns that are not LOBs or UDTs).
-- Each column has a constraint ADT embedded in it if the column has
-- a not-null constraint.  If there is no such constraint,
-- the constraint attribute evaluates to null.  Other constraints on columns
-- are in the table UDT.
declare
  obj_id number;
  column_exists number;
  propsrow_exists number;
  use_new_cols boolean := FALSE;
  success_with_error exception;
  pragma exception_init(success_with_error, -24344);
begin
  select obj# into obj_id from obj$ where owner#=0 and name='COL$';
  select count(*) into column_exists from col$
   where obj# = obj_id and name='EVALEDITION#';
  select count(*) into propsrow_exists from props$ where
   name='BOOTSTRAP_UPGRADE_ERROR';
  if column_exists = 1 or propsrow_exists = 1 then
    use_new_cols := TRUE;
  end if;
  execute immediate q'!
create or replace force view ku$_prim_column_view of ku$_prim_column_t
  with object identifier (obj_num,intcol_num) as
  select c.obj#, c.col#, c.intcol#, c.segcol#,
         bitand(c.property, 4294967295),
         trunc(c.property / power(2,32)),
         c.name, c.type#, c.length,
         c.precision#, c.scale, c.null$, c.deflength,
         sys.dbms_metadata_util.long2varchar(c.deflength,
                                        'SYS.COL$',
                                        'DEFAULT$',
                                        c.rowid),
         case
           when c.deflength is null or bitand(c.property,32+65536)=0
           then null
           else
             (select sys.dbms_metadata.parse_default(u.name,o.name,
                                                     c.deflength, c.rowid)
              from obj$ o, user$ u
              where o.obj#=c.obj# and o.owner#=u.user#)
         end,
         sys.dbms_metadata_util.blob2clob(c.obj#,c.intcol#, c.property),
         (select e.guard_id from ecol$ e where e.tabobj#=c.obj# and e.colnum=c.intcol#),
         c.charsetid, c.charsetform,
         c.intcol#,0,NULL,
         ( select value(cv)
             from ku$_constraint_col_view ccv, ku$_constraint0_view cv
             where c.intcol# = ccv.intcol_num
             and c.obj# = ccv.obj_num
             and ccv.con_num = cv.con_num
             and cv.contype in (7,11)
         ),
         c.spare1, c.spare2, c.spare3, c.spare4, c.spare5,
         to_char(c.spare6,'YYYY/MM/DD HH24:MI:SS'),
         case when (bitand(c.property,137438953472+274877906944)!=0) then
             (select value(i) from ku$_identity_col_view i
                              where i.obj_num = c.obj#)
         else null end, !' ||
         case when use_new_cols then 
           'nvl(evaledition#,0),
            nvl(unusablebefore#,0),
            nvl(unusablebeginning#,0)'
         else '0, 0, 0' end || q'!
  from col$ c !' ||
  case when use_new_cols then
  'where ((nvl(unusablebefore#,0) = 0 OR
          dbms_editions_utilities.compare_edition(
            dbms_metadata.get_edition_id, unusablebefore#) in (0, 2))
          AND
          (nvl(unusablebeginning#,0) = 0 OR
           dbms_editions_utilities.compare_edition(
             dbms_metadata.get_edition_id, unusablebeginning#) = 1))'
  else ''
  end || q'!
  !';
exception
  when success_with_error then
    null;
end;
/


