Rem
Rem $Header: rdbms/admin/catpend.sql /st_rdbms_12.1.0.1/1 2013/01/03 10:52:42 surman Exp $
Rem
Rem catpend.sql
Rem
Rem Copyright (c) 2006, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      catpend.sql - CATProc END
Rem
Rem    DESCRIPTION
Rem      This script runs the final actions for catproc.sqll
Rem
Rem    NOTES
Rem      This script must be run only as a subscript of catproc.sql.
Rem      It is run with catctl.pl as a  single process phase.
Rem
Rem
Rem BEGIN SQL_FILE_METADATA
Rem SQL_SOURCE_FILE: rdbms/admin/catpend.sql
Rem SQL_SHIPPED_FILE: rdbms/admin/catpend.sql
Rem SQL_PHASE: CATPEND
Rem SQL_STARTUP_MODE: NORMAL
Rem SQL_IGNORABLE_ERRORS: NONE
Rem SQL_CALLING_FILE: rdbms/admin/catproc.sql
Rem END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    surman      12/10/12 - XbranchMerge surman_bug-12876907 from main
Rem    surman      11/14/12 - 12876907: Add ORACLE_SCRIPT
Rem    ssonawan    07/12/12 - bug 13843068: add changes required for Default
Rem                           Password Scanner tool
Rem    nbenadja    06/21/12 - Add prvtgwm.sql and catgwmcat.sql
Rem    gravipat    05/14/12 - create_cdbviews is now part of CDBView package
Rem    surman      03/27/12 - 13615447: Add SQL patching tags
Rem    jerrede     02/10/12 - Fix lrg 6728115 Incorrectly marking RDBMS status
Rem                           during a create database
Rem    jerrede     11/02/11 - Fix bug 13252372
Rem    dgraj       10/30/11 - Project 32079: Add script for TSDP
Rem    cmlim       08/28/11 - mandatory xdb: invoke catqm.sql during install
Rem                           only
Rem    mjstewar    06/22/11 - Add GSM schema to schema list
Rem    gravipat    05/09/11 - DB Consolidation: create cdb views during db
Rem                           creation
Rem    jibyun      02/28/11 - Project 5687: Invoke catadmprvs.sql
Rem    pyoun       01/16/09 - bug 7653375 add random salt confounder
Rem    shiyer      03/26/08 - Remove TSMSYS schema
Rem    dsemler     02/07/08 - Add APPQOSSYS schema to schema list
Rem    achoi       02/01/08 - add DIP, ORACLE_OCM
Rem    rburns      01/19/07 - add package reset
Rem    rburns      08/28/06 - move sql_bind_capture
Rem    mzait       06/15/06 - add TSMSYS to the registry
Rem    rburns      05/22/06 - add timestamp 
Rem    rburns      01/13/06 - split catproc for parallel upgrade 
Rem    rburns      01/13/06 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql

------------------------------------------------------------------------------

Rem
Rem [g]v$sql_bind_capture
Rem   must be create here since it has a dependency with AnyData type
-- should be included in some other script
-- causes hang in catpdeps.sql
Rem
create or replace view v_$sql_bind_capture as select * from o$sql_bind_capture;
create or replace public synonym v$sql_bind_capture for v_$sql_bind_capture;
grant select on v_$sql_bind_capture to select_catalog_role;

create or replace view gv_$sql_bind_capture as select * from go$sql_bind_capture;
create or replace public synonym gv$sql_bind_capture for gv_$sql_bind_capture;
grant select on gv_$sql_bind_capture to select_catalog_role;

Rem Reset the package state of any packages used during catproc.sql
execute DBMS_SESSION.RESET_PACKAGE; 

Rem
Rem add random salt confounder for bug 7653375
Rem
insert into props$
    (select 'NO_USERID_VERIFIER_SALT', RAWTOHEX(sys.DBMS_CRYPTO.RANDOMBYTES (16)),
NULL from dual
     where 'NO_USERID_VERIFIER_SALT' NOT IN (select name from props$));


Rem
Rem Invoke catqm.sql to install XDB during installs only.
Rem
VARIABLE dbinst_name VARCHAR2(256)
COLUMN :dbinst_name NEW_VALUE dbinst_file NOPRINT

DECLARE
  upgrade_mode   BOOLEAN;       -- TRUE/FALSE if instance is in upgrade mode
  temp_ts        VARCHAR2(30);  -- temporary tablespace name
  instance_mode  VARCHAR2(30);  -- status from v$instance
  p_null         CHAR(1);
  xdb_ts         VARCHAR2(30);  -- name of tablespace to install XDB in
BEGIN
  SELECT status into instance_mode FROM v$instance;
  IF instance_mode = 'OPEN MIGRATE' THEN
    upgrade_mode := TRUE;
  ELSE
    upgrade_mode := FALSE;
  END IF;

  xdb_ts := 'SYSAUX';

  IF (dbms_registry.is_loaded('XDB') IS NULL) AND (upgrade_mode = FALSE) THEN
     SELECT temporary_tablespace INTO temp_ts FROM dba_users
            WHERE username='SYS'; -- use SYS temporary tablespace
     :dbinst_name := dbms_registry_server.XDB_path ||
                     'catqm.sql XDB ' || xdb_ts || ' ' || temp_ts || ' YES';
  ELSE
     :dbinst_name := dbms_registry.nothing_script;
  END IF;
END;
/
SELECT :dbinst_name FROM DUAL;
@&dbinst_file


Rem
Rem Invoke catadmprvs.sql
Rem
@@catadmprvs.sql

SET SERVEROUTPUT ON

Rem Indicate CATPROC load complete and check validity
DECLARE
  bUpgradeMode   BOOLEAN := FALSE; -- TRUE/FALSE if instance is in upgrade mode
  InstanceStatus VARCHAR2(30);     -- status from v$instance
BEGIN

   --
   -- If we are in upgrade mode then validate based on upgrade
   -- errors otherwise if we are in create database validate
   -- based on invalid objects.
   --
   SELECT status into InstanceStatus FROM v$instance;
   IF InstanceStatus = 'OPEN MIGRATE' THEN
      bUpgradeMode := TRUE;
   END IF;

   dbms_registry.update_schema_list('CATPROC',
   dbms_registry.schema_list_t('SYSTEM', 'OUTLN', 'DBSNMP', 'DIP',
                               'ORACLE_OCM', 'APPQOSSYS', 'GSMADMIN_INTERNAL'));
   dbms_registry.loaded('CATPROC');
   dbms_registry_sys.validate_catproc(bUpgradeMode);
   dbms_registry_sys.validate_catalog(bUpgradeMode);
END;
/

Rem create cdb views only for db creation. If we are in upgrade then
Rem skip creation of cdb views. handled inside procedure create_cdbviews.
exec CDBView.create_cdbviews(TRUE);

Rem
Rem Invoke catgwmcat.sql
Rem
@@catgwmcat.sql

Rem
Rem Invoke prvtgwm.sql
Rem
@@prvtgwm.sql

Rem
Rem Run script for TSDP during db creation
Rem

DECLARE
  upgrade_mode   BOOLEAN;       -- TRUE/FALSE if instance is in upgrade mode
  instance_mode  VARCHAR2(30);  -- status from v$instance
BEGIN
  SELECT status into instance_mode FROM v$instance;
  IF instance_mode = 'OPEN MIGRATE' THEN
    upgrade_mode := TRUE;
  ELSE
    upgrade_mode := FALSE;
  END IF;

  IF (dbms_registry.is_loaded('XDB') IS NOT NULL) AND (upgrade_mode = FALSE)
     THEN
     :dbinst_name := '@tsdpend.sql';
  ELSE
     :dbinst_name := dbms_registry.nothing_script;
  END IF;
END;
/
SELECT :dbinst_name FROM DUAL;
@&dbinst_file

---------------------------
-- Default Password Scanner
----------------------------
-- Since 10G verifiers of default accounts will eventually be removed from
--   default-pwd$, we use 0x10 flag in ASTATUS column of user$ to indicate
--   default accounts who are using default passwords.
-- Hence this ASTATUS column flag should be set correctly, in all scenarios -
--   (a) Upgrade, (b) Fresh Install, (c) Password change & (d) Account creation
-- DBA_USERS_WITH _DEFPWD view definition will use only this flag to project
--   the required list of default accounts using default passwords.
DECLARE
  upgrade_mode   BOOLEAN;       -- TRUE/FALSE if instance is in upgrade mode
  instance_mode  VARCHAR2(30);  -- status from v$instance
BEGIN

  SELECT status into instance_mode FROM v$instance;

  IF instance_mode = 'OPEN MIGRATE' THEN
    upgrade_mode := TRUE;
  ELSE
    upgrade_mode := FALSE;
  END IF;

  IF (upgrade_mode = FALSE) THEN
    -- Fresh DB Install: set 0x10 flag for all default accounts
    update user$ set astatus=(astatus + 16 - BITAND(astatus,16))
      where name in (select name from user$, default_pwd$ 
                     where name=user_name);
  ELSE
    -- DB Upgrade: set 0x10 flag for default accounts, who are 
    --             using default passwords in pre-12.1 DB
    update user$ set astatus=(astatus + 16 - BITAND(astatus,16))
       where name in (select name from user$, default_pwd$ 
                      where name=user_name AND pv_type = 0 AND
                            password=pwd_verifier);
  END IF;

  -- Delete default accounts entries from default_pwd$, which contain 10G
  --   verifiers and for which accounts SHA-1 hash has already added.
  -- Since default_pwd$ has SHA-1 hash for such accounts, 10G verifiers are no
  --   longer needed and they should be deleted.
  delete from default_pwd$ dp
    where dp.pv_type=0 and
          dp.user_name IN (select user_name from default_pwd$ where pv_type=1);

  -- At this point, some default accounts would not have SHA-1 hash and hence
  --   their 10G verifiers are preserved in default_pwd$. 
  -- Since such accounts are using non-trivial default passwords, we need to
  --   check with their product owners for generating and adding SHA-1 hash
  --   into default_pwd$.
END;
/

commit;

SELECT dbms_registry_sys.time_stamp('CATPROC') AS timestamp FROM DUAL;  

SET SERVEROUTPUT OFF



@?/rdbms/admin/sqlsessend.sql
