Rem
Rem $Header: rdbms/admin/catprofa.sql /st_rdbms_12.1.0.1/1 2013/01/03 10:52:42 surman Exp $
Rem
Rem catprofa.sql
Rem
Rem Copyright (c) 2010, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      catprofa.sql - Privilege Capture Views
Rem
Rem    DESCRIPTION
Rem      Views for privilege capture
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem
Rem BEGIN SQL_FILE_METADATA
Rem SQL_SOURCE_FILE: rdbms/admin/catprofa.sql
Rem SQL_SHIPPED_FILE: rdbms/admin/catprofa.sql
Rem SQL_PHASE: CATPROFA
Rem SQL_STARTUP_MODE: NORMAL
Rem SQL_IGNORABLE_ERRORS: NONE
Rem SQL_CALLING_FILE: rdbms/admin/catproftab.sql
Rem END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    surman      12/10/12 - XbranchMerge surman_bug-12876907 from main
Rem    surman      11/14/12 - 12876907: Add ORACLE_SCRIPT
Rem    jheng       08/13/12 - Add user privilege
Rem    jheng       07/18/12 - Change column enabled to boolean
Rem    jheng       04/24/12 - Bug 12696127: remove sessionid
Rem    surman      03/27/12 - 13615447: Add SQL patching tags
Rem    jheng       12/01/11 - Change view names
Rem    jheng       09/06/11 - bug 12876448: fix role type profile report
Rem    jheng       11/19/10 - privilege usage analysis
Rem    jheng       11/19/10 - Created
Rem
-- DBA view to show the existing captures

@@?/rdbms/admin/sqlsessstart.sql

CREATE OR REPLACE VIEW SYS.DBA_PRIV_CAPTURES(name, description, type, enabled, roles, context)
AS
SELECT name, description, 
decode(type, 1, 'DATABASE', 2, 'ROLE', 3, 'CONTEXT', 4, 'ROLE_AND_CONTEXT') type, decode(enabled, 1, 'Y', 0, 'N') enabled, roles, context
FROM sys.priv_capture$;

--DBA view to show captured privileges for all captures
CREATE OR REPLACE VIEW SYS.DBA_USED_PRIVS (CAPTURE, SEQUENCE, OS_USER, USERHOST, MODULE, USERNAME, USED_ROLE, SYS_PRIV, OBJ_PRIV, USER_PRIV, OBJECT_OWNER, OBJECT_NAME, OBJECT_TYPE, COLUMN_NAME, OPTION$, PATH)
as
select cap.name, priv.run_seq#, priv.os_user, priv.host, priv.module, u.name,
  (select name from sys.user$ where priv.role# != 0 and priv.role#=user#),
  (select m.name from sys.system_privilege_map m
    where priv.syspriv# = -m.privilege),
  (select m.name from sys.table_privilege_map m
    where priv.objpriv# = m.privilege and priv.syspriv# = 0),
  decode(priv.userpriv#, 0, 'INHERIT PRIVILEGES', 1, 'TRANSLATE SQL', NULL),
  decode(priv.userpriv#, 255,
         (select u.name from sys.obj$ o, sys.user$ u 
         where o.obj#=priv.obj# and o.owner#=u.user#), NULL),
  decode(priv.userpriv#, 255, /* not user privilege */
         (select o.name from sys.obj$ o, sys.user$ u where o.obj#=priv.obj#
          and o.owner#=u.user#),
         (select u.name from sys.user$ u where u.user# = priv.obj#)),
  decode(priv.userpriv#, 255, /* not user privilege */
         (select d.object_type from dba_objects d where d.object_id = priv.obj#), 'USER'),
  (select c.name from sys.col$ c
    where priv.col# !=0 and obj#=priv.obj# and col#=priv.col#),
    priv.option$, pa.path
from sys.captured_priv$ priv,sys.priv_used_path$ pa,
      sys.priv_capture$ cap, sys.user$ u
where priv.capture = cap.id# and u.user#=priv.user# and priv.id# =pa.id# and priv.capture = pa.capture;

--DBA view to show used system privileges with grant path
CREATE OR REPLACE VIEW SYS.DBA_USED_SYSPRIVS_PATH (CAPTURE, SEQUENCE, OS_USER, USERHOST, MODULE, USERNAME, USED_ROLE, SYS_PRIV, ADMIN_OPTION, PATH)
AS
SELECT CAPTURE, SEQUENCE, OS_USER, USERHOST, MODULE, USERNAME, USED_ROLE, SYS_PRIV, OPTION$, PATH FROM SYS.DBA_USED_PRIVS WHERE SYS_PRIV IS NOT NULL;

--DBA view to show used object privielges with grant path
CREATE OR REPLACE VIEW SYS.DBA_USED_OBJPRIVS_PATH (CAPTURE, SEQUENCE, OS_USER, USERHOST, MODULE, USERNAME, USED_ROLE, OBJ_PRIV, OBJECT_OWNER, OBJECT_NAME, OBJECT_TYPE, COLUMN_NAME, GRANT_OPTION, PATH)
AS
SELECT CAPTURE, SEQUENCE, OS_USER, USERHOST, MODULE, USERNAME, USED_ROLE, OBJ_PRIV, OBJECT_OWNER, OBJECT_NAME, OBJECT_TYPE, COLUMN_NAME, OPTION$, PATH FROM SYS.DBA_USED_PRIVS WHERE OBJ_PRIV IS NOT NULL;

--DBA view to show user privileges with grant path
CREATE OR REPLACE VIEW SYS.DBA_USED_USERPRIVS_PATH (CAPTURE, SEQUENCE, OS_USER, USERHOST, MODULE, USERNAME, USED_ROLE, USER_PRIV, ONUSER, GRANT_OPTION, PATH)
AS
SELECT CAPTURE, SEQUENCE, OS_USER, USERHOST, MODULE, USERNAME, USED_ROLE, USER_PRIV, OBJECT_NAME, OPTION$, PATH FROM SYS.DBA_USED_PRIVS WHERE USER_PRIV IS NOT NULL;

--DBA view to show used system privileges without grant path
CREATE OR REPLACE VIEW SYS.DBA_USED_SYSPRIVS (CAPTURE, SEQUENCE, OS_USER, USERHOST, MODULE, USERNAME, USED_ROLE, SYS_PRIV, ADMIN_OPTION) AS 
SELECT UNIQUE CAPTURE, SEQUENCE, OS_USER, USERHOST, MODULE, USERNAME, USED_ROLE, SYS_PRIV, OPTION$ FROM SYS.DBA_USED_PRIVS WHERE SYS_PRIV IS NOT NULL;

--DBA view to show used object privileges without grant path
CREATE OR REPLACE VIEW SYS.DBA_USED_OBJPRIVS (CAPTURE, SEQUENCE, OS_USER, USERHOST, MODULE, USERNAME, USED_ROLE, OBJ_PRIV, OBJECT_OWNER, OBJECT_NAME, OBJECT_TYPE, COLUMN_NAME, GRANT_OPTION)
AS
SELECT UNIQUE CAPTURE, SEQUENCE, OS_USER, USERHOST, MODULE, USERNAME, USED_ROLE, OBJ_PRIV, OBJECT_OWNER, OBJECT_NAME, OBJECT_TYPE, COLUMN_NAME,OPTION$ FROM SYS.DBA_USED_PRIVS WHERE OBJ_PRIV IS NOT NULL;

--DBA view to show used user privileges without grant path
CREATE OR REPLACE VIEW SYS.DBA_USED_USERPRIVS(CAPTURE, SEQUENCE, OS_USER, USERHOST, MODULE, USERNAME, USED_ROLE, USER_PRIV, ONUSER, GRANT_OPTION)
AS
SELECT UNIQUE CAPTURE, SEQUENCE, OS_USER, USERHOST, MODULE, USERNAME, USED_ROLE, USER_PRIV, OBJECT_NAME, OPTION$ FROM SYS.DBA_USED_PRIVS WHERE USER_PRIV IS NOT NULL;

--DBA view for used PUBLIC privilege
CREATE OR REPLACE VIEW SYS.DBA_USED_PUBPRIVS (CAPTURE, SEQUENCE, OS_USER, USERHOST, MODULE, USERNAME, SYS_PRIV, OBJ_PRIV, OBJECT_OWNER, OBJECT_NAME, OBJECT_TYPE, OPTION$)
AS
SELECT UNIQUE CAPTURE, SEQUENCE, OS_USER, USERHOST, MODULE, USERNAME, SYS_PRIV, OBJ_PRIV, OBJECT_OWNER, OBJECT_NAME, OBJECT_TYPE, OPTION$ FROM SYS.DBA_USED_PRIVS WHERE 'PUBLIC' MEMBER OF PATH;

--DBA view for unused privileges
CREATE OR REPLACE VIEW SYS.DBA_UNUSED_PRIVS(CAPTURE, USERNAME, ROLENAME, SYS_PRIV, OBJ_PRIV, USER_PRIV, OBJECT_OWNER, OBJECT_NAME, OBJECT_TYPE, COLUMN_NAME, OPTION$, PATH) as
SELECT cap.name, 
 (select u.name from dual where cap.type = 1 or cap.type = 3),
 (select u.name from dual where cap.type = 2 or cap.type = 4),
 (select m.name from sys.system_privilege_map m where priv.syspriv# = -m.privilege),
 (select m.name from sys.table_privilege_map m  
  where priv.objpriv# = m.privilege and priv.syspriv# = 0),
 decode(priv.userpriv#, 0, 'INHERIT PRIVILEGES', 1, 'TRANSLATE SQL', NULL),
 decode(priv.userpriv#, 255,
        (select u.name from sys.obj$ o, sys.user$ u
        where o.obj#=priv.obj# and o.owner#=u.user#), NULL),
 decode(priv.userpriv#, 255,
        (select o.name from sys.obj$ o, sys.user$ u where o.obj#=priv.obj#
         and o.owner#=u.user#), 
        (select u.name from sys.user$ u where u.user# = priv.obj#)),
 decode(priv.userpriv#, 255,
        (select d.object_type from dba_objects d where d.object_id = priv.obj#), 'USER'),
 (select c.name from sys.col$ c
  where priv.col# !=0 and obj#=priv.obj# and col#=priv.col#),
  priv.option$, pa.path
FROM sys.priv_unused$ priv, sys.priv_capture$ cap, sys.user$ u, 
     sys.priv_unused_path$ pa
WHERE priv.capture = cap.id# and u.user#=priv.user# and priv.id# = pa.id# 
      and priv.capture = pa.capture;

--unused system privilege with grant path
CREATE OR REPLACE VIEW SYS.DBA_UNUSED_SYSPRIVS_PATH(CAPTURE, USERNAME, ROLENAME, SYS_PRIV, ADMIN_OPTION, PATH) 
as
SELECT CAPTURE, USERNAME, ROLENAME, SYS_PRIV, OPTION$, PATH FROM SYS.DBA_UNUSED_PRIVS
WHERE SYS_PRIV IS NOT NULL;

--unused system privileges without grant path
CREATE OR REPLACE VIEW SYS.DBA_UNUSED_SYSPRIVS(CAPTURE, USERNAME, ROLENAME, SYS_PRIV, ADMIN_OPTION) 
as
SELECT UNIQUE CAPTURE, USERNAME, ROLENAME, SYS_PRIV, OPTION$ FROM SYS.DBA_UNUSED_PRIVS
WHERE SYS_PRIV IS NOT NULL;

--unused object privileges with grant path
CREATE OR REPLACE VIEW SYS.DBA_UNUSED_OBJPRIVS_PATH(CAPTURE, USERNAME, ROLENAME, OBJ_PRIV, OBJECT_OWNER, OBJECT_NAME, OBJECT_TYPE, COLUMN_NAME, GRANT_OPTION, PATH) 
as
SELECT CAPTURE, USERNAME, ROLENAME, OBJ_PRIV, OBJECT_OWNER, OBJECT_NAME, OBJECT_TYPE, COLUMN_NAME, OPTION$, PATH
FROM SYS.DBA_UNUSED_PRIVS
WHERE OBJ_PRIV IS NOT NULL;

--unused object privileges without grant path
CREATE OR REPLACE VIEW SYS.DBA_UNUSED_OBJPRIVS(CAPTURE, USERNAME, ROLENAME, OBJ_PRIV, OBJECT_OWNER, OBJECT_NAME, OBJECT_TYPE, COLUMN_NAME, GRANT_OPTION) 
as
SELECT UNIQUE CAPTURE, USERNAME, ROLENAME, OBJ_PRIV, OBJECT_OWNER, OBJECT_NAME, OBJECT_TYPE, COLUMN_NAME , OPTION$
FROM SYS.DBA_UNUSED_PRIVS
WHERE OBJ_PRIV IS NOT NULL;

--unused user privileges with grant path
CREATE OR REPLACE VIEW SYS.DBA_UNUSED_USERPRIVS_PATH(CAPTURE, USERNAME, ROLENAME, USER_PRIV, ONUSER, GRANT_OPTION, PATH)
as
SELECT CAPTURE, USERNAME, ROLENAME, USER_PRIV, OBJECT_NAME, OPTION$, PATH
FROM SYS.DBA_UNUSED_PRIVS WHERE USER_PRIV IS NOT NULL;

--unused user privileges with grant path
CREATE OR REPLACE VIEW SYS.DBA_UNUSED_USERPRIVS(CAPTURE, USERNAME, ROLENAME, USER_PRIV, ONUSER, GRANT_OPTION)
as
SELECT UNIQUE CAPTURE, USERNAME, ROLENAME, USER_PRIV, OBJECT_NAME, OPTION$
FROM SYS.DBA_UNUSED_PRIVS WHERE USER_PRIV IS NOT NULL;

CREATE OR REPLACE PUBLIC SYNONYM DBA_PRIV_CAPTURES FOR sys.DBA_PRIV_CAPTURES;
CREATE OR REPLACE PUBLIC SYNONYM DBA_USED_PRIVS FOR sys.DBA_USED_PRIVS;
CREATE OR REPLACE PUBLIC SYNONYM DBA_USED_SYSPRIVS_PATH FOR sys.DBA_USED_SYSPRIVS_PATH;
CREATE OR REPLACE PUBLIC SYNONYM DBA_USED_OBJPRIVS_PATH FOR sys.DBA_USED_OBJPRIVS_PATH;
CREATE OR REPLACE PUBLIC SYNONYM DBA_USED_USERPRIVS_PATH FOR sys.DBA_USED_USERPRIVS_PATH;
CREATE OR REPLACE PUBLIC SYNONYM DBA_USED_SYSPRIVS FOR sys.DBA_USED_SYSPRIVS;
CREATE OR REPLACE PUBLIC SYNONYM DBA_USED_OBJPRIVS FOR sys.DBA_USED_OBJPRIVS;
CREATE OR REPLACE PUBLIC SYNONYM DBA_USED_USERPRIVS FOR sys.DBA_USED_USERPRIVS;
CREATE OR REPLACE PUBLIC SYNONYM DBA_USED_PUBPRIVS FOR sys.DBA_USED_PUBPRIVS;
CREATE OR REPLACE PUBLIC SYNONYM DBA_UNUSED_PRIVS FOR SYS.DBA_UNUSED_PRIVS;
CREATE OR REPLACE PUBLIC SYNONYM DBA_UNUSED_SYSPRIVS_PATH FOR SYS.DBA_UNUSED_SYSPRIVS_PATH;
CREATE OR REPLACE PUBLIC SYNONYM DBA_UNUSED_OBJPRIVS_PATH FOR SYS.DBA_UNUSED_OBJPRIVS_PATH;
CREATE OR REPLACE PUBLIC SYNONYM DBA_UNUSED_USERPRIVS_PATH FOR SYS.DBA_UNUSED_USERPRIVS_PATH;
CREATE OR REPLACE PUBLIC SYNONYM DBA_UNUSED_SYSPRIVS FOR SYS.DBA_UNUSED_SYSPRIVS;
CREATE OR REPLACE PUBLIC SYNONYM DBA_UNUSED_OBJPRIVS FOR SYS.DBA_UNUSED_OBJPRIVS;
CREATE OR REPLACE PUBLIC SYNONYM DBA_UNUSED_USERPRIVS FOR SYS.DBA_UNUSED_USERPRIVS;

-- grant SELECT ON DBA_ views to CAPTURE_ADMIN
grant select on DBA_PRIV_CAPTURES to CAPTURE_ADMIN;
grant select on DBA_USED_PRIVS to CAPTURE_ADMIN;
grant select on DBA_USED_SYSPRIVS to CAPTURE_ADMIN;
grant select on DBA_USED_OBJPRIVS to CAPTURE_ADMIN;
grant select on DBA_USED_USERPRIVS to CAPTURE_ADMIN;
grant select on DBA_USED_SYSPRIVS_PATH to CAPTURE_ADMIN;
grant select on DBA_USED_OBJPRIVS_PATH to CAPTURE_ADMIN;
grant select on DBA_USED_USERPRIVS_PATH to CAPTURE_ADMIN;
grant select on DBA_USED_PUBPRIVS to CAPTURE_ADMIN;
grant select on DBA_UNUSED_PRIVS to CAPTURE_ADMIN;
grant select on DBA_UNUSED_SYSPRIVS to CAPTURE_ADMIN;
grant select on DBA_UNUSED_OBJPRIVS to CAPTURE_ADMIN;
grant select on DBA_UNUSED_USERPRIVS to CAPTURE_ADMIN;
grant select on DBA_UNUSED_SYSPRIVS_PATH to CAPTURE_ADMIN;
grant select on DBA_UNUSED_OBJPRIVS_PATH to CAPTURE_ADMIN;
grant select on DBA_UNUSED_USERPRIVS_PATH to CAPTURE_ADMIN;


@?/rdbms/admin/sqlsessend.sql
