Rem
Rem $Header: rdbms/admin/catqitab.sql /st_rdbms_12.1.0.1/1 2013/01/03 10:52:42 surman Exp $
Rem
Rem catqitab.sql
Rem
Rem Copyright (c) 2011, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      catqitab.sql - Creation of tables
Rem
Rem    DESCRIPTION
Rem      Creation of queryable patch inventory tables.
Rem
Rem    NOTES
Rem      .
Rem
Rem BEGIN SQL_FILE_METADATA
Rem SQL_SOURCE_FILE: rdbms/admin/catqitab.sql
Rem SQL_SHIPPED_FILE: rdbms/admin/catqitab.sql
Rem SQL_PHASE: CATPTABS_MAIN
Rem SQL_STARTUP_MODE: NORMAL
Rem SQL_IGNORABLE_ERRORS: NONE
Rem SQL_CALLING_FILE: rdbms/admin/catqptabs.sql
Rem END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    surman      12/10/12 - XbranchMerge surman_bug-12876907 from main
Rem    surman      11/14/12 - 12876907: Add ORACLE_SCRIPT
Rem    tbhukya     09/24/12 - Bug 14664194 : Use bat file for preprocessor
Rem    tbhukya     07/13/12 - create new tables with xml implementation.
Rem    dkoppar     07/01/12 - add xml support
Rem    tbhukya     05/08/12 - Bugs 13973746, 13964278 and add opatch_inst_job
Rem    surman      04/12/12 - 13615447: Add SQL patching tags
Rem    tbhukya     12/19/11 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql

variable opatch_log_dir varchar2(1000);
variable opatch_script_dir varchar2(1000);


-- Create directories for log, script and xml file
BEGIN
  select value into :opatch_log_dir
               from v$parameter
               where name='user_dump_dest';

  --dbms_system.get_env( 'ORACLE_HOME', :opatch_script_dir );
  :opatch_script_dir := :opatch_script_dir || '/QOpatch';

  -- single quotes in :opatch_log_dir and :opatch_script_dir
  -- would need extra quoting
  execute immediate 'CREATE OR REPLACE directory opatch_log_dir AS ''' ||
                     :opatch_log_dir || '''';
  execute immediate 'CREATE OR REPLACE directory opatch_script_dir AS ''' ||
                     :opatch_script_dir || '''';
END;
/


CREATE TABLE opatch_xml_inv
(
     xml_inventory      CLOB
)
ORGANIZATION EXTERNAL
(
    TYPE oracle_loader
    DEFAULT DIRECTORY opatch_script_dir
    ACCESS PARAMETERS
    (
      RECORDS DELIMITED BY NEWLINE
      READSIZE 67108864
      preprocessor opatch_script_dir:'qopiprep.bat'
      BADFILE opatch_script_dir:'qopatch_bad.bad'
      LOGFILE opatch_log_dir:'qopatch_log.log'
      FIELDS TERMINATED BY 'UIJSVTBOEIZBEFFQBL'
      MISSING FIELD VALUES ARE NULL
      REJECT ROWS WITH ALL NULL FIELDS
      (
        xml_inventory    CHAR(100000000)
      )
    )
    LOCATION(opatch_script_dir:'qopiprep.bat')
  )
  PARALLEL 1
  REJECT LIMIT UNLIMITED;

CREATE TABLE opatch_xinv_tab
(
     xml_inventory      CLOB
)
TABLESPACE SYSAUX;


CREATE TABLE opatch_inst_job
       (
         inst_id    NUMBER primary key,
         node_name  VARCHAR2(60) NOT NULL,
         inst_name  VARCHAR2(60) NOT NULL,
         inst_job   VARCHAR2(128) NOT NULL
       )
       TABLESPACE SYSAUX;

CREATE TABLE opatch_inst_patch
       (
          nodeName VARCHAR2(60),
          patchNum VARCHAR2(15)
       )
       TABLESPACE SYSAUX;

create type opatch_node_array as VARRAY(100) of varchar(128);
/

@?/rdbms/admin/sqlsessend.sql
