Rem
Rem catspd.sql
Rem
Rem Copyright (c) 2011, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      catspd.sql - Sql Plan Directive catalog views
Rem
Rem    DESCRIPTION
Rem      This file contain view definitions of Sql Plan Directives.
Rem
Rem    NOTES
Rem      The views in this file can be created only after creating dbms_spd
Rem      package as the views refer to functions in the package.
Rem
Rem
Rem BEGIN SQL_FILE_METADATA
Rem SQL_SOURCE_FILE: rdbms/admin/catspd.sql
Rem SQL_SHIPPED_FILE: rdbms/admin/catspd.sql
Rem SQL_PHASE: CATPDEPS_MAIN2
Rem SQL_STARTUP_MODE: NORMAL
Rem SQL_IGNORABLE_ERRORS: NONE
Rem SQL_CALLING_FILE: rdbms/admin/catpdeps.sql
Rem END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    surman      12/10/12 - XbranchMerge surman_bug-12876907 from main
Rem    surman      11/14/12 - 12876907: Add ORACLE_SCRIPT
Rem    surman      03/27/12 - 13615447: Add SQL patching tags
Rem    schakkap    10/03/11 - project SPD (31794): display fixed tables,
Rem                           add auto_drop column
Rem    schakkap    07/04/11 - project SPD (31794): fix last_used timestamp
Rem    schakkap    04/01/11 - project SPD (31794): add catalog views
Rem    schakkap    04/01/11 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql

Rem
Rem _BASE* views
Rem The following views are not exposed. They just decode flags, collist etc
Rem from base dictionary tables.
Rem

CREATE OR REPLACE VIEW "_BASE_OPT_FINDING" (
    f_id,
    f_own#,
    type,
    reason,
    ctime,
    tab_cnt
) AS
SELECT
    f.f_id,
    f_own#,
    decode(f.type, 1, 'OPTIMIZER_BAD_DECISION', 'UNKNOWN'),
    decode(f.reason, 1, 'SINGLE TABLE CARDINALITY MISESTIMATE', 
                     2, 'JOIN CARDINALITY MISESTIMATE',
                     3, 'QUERY BLOCK CARDINALITY MISESTIMATE',
                     4, 'GROUP BY CARDINALITY MISESTIMATE',
                     5, 'HAVING CARDINALITY MISESTIMATE',
                     6, 'SPREADSHEET CARDINALITY MISESTIMATE',
                        'UNKNOWN'),
    cast(f.ctime as timestamp),
    f.tab_cnt
FROM
    sys.opt_finding$ f
/

CREATE OR REPLACE VIEW "_BASE_OPT_FINDING_OBJ" (
    f_id,
    f_obj#,
    obj_type,
    col_list,
    cvec_size,
    notes
) AS
SELECT
    f.f_id,
    f.f_obj#,
    f.obj_type,
    f.col_list,
    f.cvec_size,
    xmltype(
      '<obj_note>' ||
         '<equality_predicates_only>' || 
           decode(bitand(f.flags, 1), 0, 'NO', 'YES') ||
         '</equality_predicates_only>' ||
         '<simple_column_predicates_only>' || 
           decode(bitand(f.flags, 2), 0, 'NO', 'YES') ||
         '</simple_column_predicates_only>' ||
         '<index_access_by_join_predicates>' || 
           decode(bitand(f.flags, 4), 0, 'NO', 'YES') ||
         '</index_access_by_join_predicates>' || 
         '<filter_on_joining_object>' || 
           decode(bitand(f.flags, 8), 0, 'NO', 'YES') ||
         '</filter_on_joining_object>' ||
       '</obj_note>')  notes
FROM
    sys.opt_finding_obj$ f
/

CREATE OR REPLACE VIEW "_BASE_OPT_FINDING_OBJ_COL" (
    f_id,
    f_obj#,
    obj_type,
    notes,
    intcol#
) AS
SELECT
    f.f_id,
    f.f_obj#,
    f.obj_type,
    f.notes,
    c.column_value
FROM
    sys."_BASE_OPT_FINDING_OBJ" f,
    table(sys.dbms_spd_internal.get_vec_set_ids(f.col_list, f.cvec_size)) c
/

CREATE OR REPLACE VIEW "_BASE_OPT_DIRECTIVE" (
    dir_own#,
    dir_id,
    f_id,
    type,
    state,
    auto_drop,
    created,
    last_modified,
    last_used
) AS
SELECT
    d.dir_own#,
    d.dir_id,
    d.f_id,
    decode(type, 1, 'DYNAMIC_SAMPLING', 'UNKNOWN'),
    decode(state, 1, 'NEW', 
                 2, 'MISSING_STATS',
                 3, 'HAS_STATS',
                 4, 'CANDIDATE',
                 5, 'PERMANENT',
                 6, 'DISABLED',
                 'UNKNOWN'),
    decode(bitand(flags, 1), 1, 'YES', 'NO'),
    cast(d.created as timestamp),
    cast(d.last_modified as timestamp),
    -- Please see QOSD_DAYS_TO_UPDATE and QOSD_PLUS_SECONDS for more details 
    -- about 6.5
    cast(d.last_used as timestamp) - NUMTODSINTERVAL(6.5, 'day')
FROM
    sys.opt_directive$ d
/

Rem
Rem Public views
Rem

CREATE OR REPLACE VIEW dba_sql_plan_directives (
    directive_id,
    type,
    state,
    auto_drop,
    reason,
    created,
    last_modified,
    last_used
) AS
SELECT
    d.dir_id,
    d.type,
    d.state,
    d.auto_drop,
    f.reason,
    d.created,
    d.last_modified,
    d.last_used
FROM
    sys."_BASE_OPT_DIRECTIVE" d,
    sys."_BASE_OPT_FINDING" f
WHERE d.f_id = f.f_id
/

COMMENT ON TABLE dba_sql_plan_directives IS
    'Set of sql plan directives'
/
COMMENT ON COLUMN dba_sql_plan_directives.directive_id IS
    'The identifier of the sql plan directive'
/
COMMENT ON COLUMN dba_sql_plan_directives.type IS
    'The type of the sql plan directive'
/
COMMENT ON COLUMN dba_sql_plan_directives.state IS
    'The state of the sql plan directive'
/
COMMENT ON COLUMN dba_sql_plan_directives.auto_drop IS
    'If YES, the sql plan directive gets dropped when unused beyond SPD_RETENTION_WEEKS'
/
COMMENT ON COLUMN dba_sql_plan_directives.reason IS
    'The reason for creating the sql plan directive'
/
COMMENT ON COLUMN dba_sql_plan_directives.created IS
    'The creation timestamp of the sql plan directive'
/
COMMENT ON COLUMN dba_sql_plan_directives.last_modified IS
    'The timestamp of most recent modification of the sql plan directive'
/
COMMENT ON COLUMN dba_sql_plan_directives.last_used IS
    'The timestamp of most recent usage of the sql plan directive'
/

CREATE OR REPLACE PUBLIC SYNONYM dba_sql_plan_directives 
FOR sys.dba_sql_plan_directives
/
GRANT SELECT ON sys.dba_sql_plan_directives TO select_catalog_role
/

CREATE OR REPLACE VIEW dba_sql_plan_dir_objects (
    directive_id,
    owner,
    object_name,
    subobject_name,
    object_type,
    notes
) AS
SELECT
    d.dir_id,
    u.name,
    o.name,
    c.name,
    'COLUMN',
    NULL
FROM
    sys."_BASE_OPT_DIRECTIVE" d,
    sys."_BASE_OPT_FINDING_OBJ_COL" ft,
    (select obj#, owner#, name from sys.obj$
     union all
     select object_id obj#, 0 owner#, name from  v$fixed_table) o,
    (select obj#, intcol#, name from sys.col$
     union all
     select kqfcotob obj#, kqfcocno intcol#, kqfconam name 
     from sys.x$kqfco) c,
    sys.user$ u
WHERE 
    d.f_id = ft.f_id and ft.f_obj# = o.obj# and o.owner# = u.user#
    and o.obj# = c.obj# and ft.intcol# = c.intcol#
union all
SELECT
    d.dir_id,
    u.name,
    o.name,
    NULL,
    'TABLE',
    fo.notes
FROM
    sys."_BASE_OPT_DIRECTIVE" d,
    sys."_BASE_OPT_FINDING_OBJ" fo,
    (select obj#, owner#, name from sys.obj$
     union all
     select object_id obj#, 0 owner#, name from  v$fixed_table) o,
    sys.user$ u
WHERE 
    d.f_id = fo.f_id and fo.f_obj# = o.obj# and o.owner# = u.user#
/

COMMENT ON TABLE dba_sql_plan_dir_objects IS
    'Set of objects in sql plan directive'
/
COMMENT ON COLUMN dba_sql_plan_dir_objects.directive_id IS
    'The identifier of the sql plan directive'
/
COMMENT ON COLUMN dba_sql_plan_dir_objects.owner IS
    'The username of the owner of the object in the sql plan directive'
/
COMMENT ON COLUMN dba_sql_plan_dir_objects.object_name IS
    'The name of the object in the sql plan directive'
/
COMMENT ON COLUMN dba_sql_plan_dir_objects.subobject_name IS
    'The name of the sub-object (for example column) in the sql plan directive'
/
COMMENT ON COLUMN dba_sql_plan_dir_objects.object_type IS
    'The type of the (sub-)object in the sql plan directive'
/
COMMENT ON COLUMN dba_sql_plan_dir_objects.notes IS
    'Other notes about the object'
/

CREATE OR REPLACE PUBLIC SYNONYM dba_sql_plan_dir_objects 
FOR sys.dba_sql_plan_dir_objects
/
GRANT SELECT ON sys.dba_sql_plan_dir_objects TO select_catalog_role
/

@?/rdbms/admin/sqlsessend.sql
