Rem
Rem $Header: rdbms/admin/catupend.sql /st_rdbms_12.1.0.1/1 2013/01/03 10:52:43 surman Exp $
Rem
Rem catupend.sql
Rem
Rem Copyright (c) 2006, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      catupend.sql - CATalog UPgrade END
Rem
Rem    DESCRIPTION
Rem      Final scripts for the Complete upgrade
Rem
Rem    NOTES
Rem      Invoked by catupgrd.sql
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    surman      12/10/12 - XbranchMerge surman_bug-12876907 from main
Rem    surman      11/14/12 - 12876907: Add ORACLE_SCRIPT
Rem    cdilling    11/05/12 - set EDITION for CATPROC - lrg 7333924
Rem    cmlim       11/04/12 - bug 14763826
Rem    gravipat    05/14/12 - create_cdbviews is now part of CDBView package
Rem    jerrede     03/09/12 - Bug #13719893 Correct utlusts.sql timmings
Rem    dvoss       02/16/12 - bug 13719292 - logminer build only if no
Rem                           migration
Rem    aramappa    02/03/12 - #13653782:invoke olsrle to validate lbac_events
Rem    cdilling    08/28/11 - remove XE check in 12.1
Rem    mdietric    03/23/11 - remove STATS_END - bug 11901407
Rem    traney      01/31/11 - 35209: always run utlmmig.sql
Rem    cmlim       03/02/10 - bug 9412562: add reminder to run DBMS_DST after
Rem                           db upgrade
Rem    cdilling    08/17/09 - don't invoke utlmmig.sql for 11.2 patch upgrades
Rem    nlee        04/02/09 - Fix for bug 8289601.
Rem    yiru        02/28/09 - fix lrg problem: 3795747
Rem    srtata      02/03/09 - validate LBAC_EVENTS : reupgrade issue
Rem    achoi       04/03/08 - run utlmmig.sql for 11.2
Rem    rburns      07/11/07 - no utlmmig for patch upgrade
Rem    cdilling    04/23/07 - add end timestamp for gathering stats
Rem    rburns      02/17/07 - remove edition column if it exists (XE database)
Rem    achoi       11/06/06 - add utlmmig to add index to bootstrap object
Rem    rburns      07/19/06 - fix log miner location 
Rem    rburns      05/22/06 - parallel upgrade 
Rem    rburns      05/22/06 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql

Rem =====================================================================
Rem Recreate XS component - V$XS_SESSION view if it is invalid
Rem Used when customers rerun catupgrd mutiple times
Rem =====================================================================

DECLARE
  stat VARCHAR(4000);
BEGIN
  SELECT status into stat FROM DBA_OBJECTS  
  WHERE object_name = 'V$XS_SESSION' and owner='SYS' ;
  IF stat = 'INVALID' THEN
    execute immediate 'create or replace view v$xs_session as
         select *
           from xs$sessions with read only'; 
    execute immediate 'create or replace public synonym V$XS_SESSION 
              for v$xs_session';
    execute immediate 'grant select on V$XS_SESSION to DBA';
  END IF; 
EXCEPTION
  WHEN OTHERS THEN
    RETURN;
END;
/

Rem =====================================================================
Rem Set the edition for CATPROC in registry$ table using the edition
Rem value in v$instance. (AFTER all component upgrades)
Rem =====================================================================

EXECUTE sys.dbms_registry.set_edition('CATPROC');

Rem =====================================================================
Rem Recompile DDL triggers
Rem =====================================================================

@@utlrdt

Rem ======================================================================
Rem Recompile all views
Rem ======================================================================

@@utlrvw

Rem ====================================================================
Rem Validate OLS package on which OLS logon and DDL triggers depend.
Rem If not validated these triggers fire with invalid package state
Rem and cause issues in post upgrade mode. 
Rem =====================================================================

@@olsrle

Rem ====================================================================
Rem Create cdb views for upgrade after the component upgrade is done.
Rem ====================================================================

exec CDBView.create_cdbviews(FALSE);


Rem ====================================================================
Rem UPgrade - Add Oracle-Supplied Bits where db was previously pre-12.1
Rem ====================================================================

-- 'uposb' stands for 'UPgrade - update Oracle-Supplied Bits'

VARIABLE uposb_name VARCHAR2(100)
COLUMN :uposb_name NEW_VALUE uposb_file NOPRINT

DECLARE
  p_prv_version  VARCHAR2(30);
BEGIN
  EXECUTE IMMEDIATE
    'SELECT dbms_registry.prev_version(''CATPROC'') FROM sys.dual'
  INTO p_prv_version;
  if substr(p_prv_version, 1, 6) < '12.1.0' then
    :uposb_name := 'catuposb.sql';  -- update oracle-supplied bits
  else
    :uposb_name := 'nothing.sql';  -- execute 'nothing'
  end if;
END;
/

select :uposb_name from sys.dual;
@@&uposb_file
 

DOC
#######################################################################
#######################################################################

   The above PL/SQL lists the SERVER components in the upgraded
   database, along with their version and status at the completion of
   the component upgrade.  Any error messages generated during the 
   component upgrade are also listed.

   Please review the status and version columns and check the details
   any errors in the spool log file.  If there are errors in the spool
   file, or any components are not VALID or not the current version,
   consult the Oracle Database Upgrade Guide for troubleshooting 
   recommendations.

#######################################################################
#######################################################################
#
Rem =====================================================================
Rem Longer identifiers for Bootstrap Objects. utlmmig will shutdown the
Rem database.
Rem DB must be restarted after this script.
Rem =====================================================================


Rem Display start time of utlmmig 
SELECT sys.dbms_registry_sys.time_stamp_comp_display('UTLMMIG_BG') AS
       timestamp FROM DUAL;

@@utlmmig

DOC
#######################################################################
#######################################################################
 
   The above sql script is the final step of the upgrade. Please
   review any errors in the spool log file. If there are any errors in
   the spool file, consult the Oracle Database Upgrade Guide for
   troubleshooting recommendations.
 
   Next restart for normal operation, and then run utlrp.sql to
   recompile any invalid application objects.

   If the source database had an older time zone version prior to
   upgrade, then please run the DBMS_DST package.  DBMS_DST will upgrade
   TIMESTAMP WITH TIME ZONE data to use the latest time zone file shipped
   with Oracle.
 
#######################################################################
#######################################################################
#

Rem 12876907: We can't call sqlsessend here because utlmmig has already
Rem shut down the database

