Rem
Rem $Header: rdbms/admin/catupgrd.sql /st_rdbms_12.1.0.1/2 2013/01/12 21:15:13 jerrede Exp $
Rem
Rem catupgrd.sql
Rem
Rem Copyright (c) 1999, 2013, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      catupgrd.sql - CATalog UPGraDe to the new release
Rem
Rem    DESCRIPTION
Rem     This script is to be used for upgrading a 9.2, 10.1 or 10.2 
Rem     database to the new release.  This script provides a direct 
Rem     upgrade path from these releases to the new Oracle release.
Rem
Rem      The upgrade is partitioned into the following 5 stages:
Rem        STAGE 1: call the "i" script for the oldest supported release:
Rem                 This loads all tables that are necessary
Rem                 to perform basic DDL commands for the new release
Rem        STAGE 2: call utlip.sql to invalidate PL/SQL objects
Rem        STAGE 3: Determine the original release and call the 
Rem                 c0x0x0x0.sql for the release.  This performs all 
Rem                 necessary dictionary upgrade actions to bring the 
Rem                 database from the original release to new release.
Rem
Rem    NOTES
Rem
Rem      * This script needs to be run in the new release environment
Rem        (after installing the release to which you want to upgrade).
Rem      * You must be connected AS SYSDBA to run this script.
Rem
Rem
Rem BEGIN SQL_FILE_METADATA
Rem SQL_SOURCE_FILE: rdbms/admin/catupgrd.sql
Rem SQL_SHIPPED_FILE: rdbms/admin/catupgrd.sql
Rem SQL_PHASE: INSTALL
Rem SQL_STARTUP_MODE: NORMAL
Rem SQL_IGNORABLE_ERRORS: NONE
Rem SQL_CALLING_FILE: NONE
Rem END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jerrede     01/10/13 - Fix Bug 16094874. Remove command sqlsessend.sql
Rem                           Cannot issue this command when the database
Rem                           has been shutdown.
Rem    surman      12/10/12 - XbranchMerge surman_bug-12876907 from main
Rem    surman      11/14/12 - 12876907: Add ORACLE_SCRIPT
Rem    jerrede     08/29/12 - Mandatory Post Upgrade
Rem    surman      03/27/12 - 13615447: Add SQL patching tags
Rem    jerrede     03/16/12 - Fix Display Comments
Rem    jerrede     02/02/12 - Fix Bug 13656337
Rem    jerrede     12/12/11 - Add Comments for Parallel Upgrade
Rem    jerrede     10/28/11 - Fix Bug 13252372
Rem    jerrede     09/01/11 - Parallel Upgrade Project #23496
Rem    cmlim       04/19/11 - bug 12337546: exit from catupgrd.sql at end of
Rem                           upgrade
Rem    skabraha    03/03/11 - move validate_all_versions to catupprc.sql
Rem    skabraha    07/22/10 - reset all old version types to valid
Rem    cdilling    03/29/07 - set error logging off - bug 5959958
Rem    rburns      12/11/06 - eliminate first phase
Rem    rburns      07/19/06 - fix log miner location 
Rem    rburns      05/22/06 - restructure for parallel upgrade 
Rem    rburns      02/15/06 - re-run message with expected errors
Rem    gviswana    03/09/06 - Add utlrdt 
Rem    rburns      02/10/06 - fix re-run logic for 11.1 
Rem    rburns      01/10/06 - release 11.1.0 
Rem    rburns      11/09/05 - version fixes
Rem    rburns      10/21/05 - remove 817 and 901 upgrades 
Rem    cdilling    09/28/05 - temporary version until db version updated
Rem    ssubrama    08/17/05 - bug 4523571 add note before utlip 
Rem    sagrawal    06/28/05 - invalidate PL/SQL objects for upgrade to 11 
Rem    rburns      03/14/05 - dbms_registry_sys timestamp 
Rem    rburns      02/27/05 - record action for history 
Rem    rburns      10/18/04 - remove catpatch.sql 
Rem    rburns      09/02/04 - remove dbms_output compile 
Rem    rburns      06/17/04 - use registry log and utlusts 
Rem    mvemulap    05/26/04 - grid mcode compatibility 
Rem    jstamos     05/20/04 - utlip workaround 
Rem    rburns      05/17/04 - rburns_single_updown_scripts
Rem    rburns      01/27/04 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql


DOC
######################################################################
######################################################################
                                 NOTE

    The catupgrd.sql is being deprecated in the 12.1 release of the
    Oracle Database.  Customers are encouraged to use catctl.pl as
    the replacement for catupgrd.sql when upgrading the database dictionary.

                    cd $ORACLE_HOME/rdbms/admin
                    $ORACLE_HOME/perl/bin/perl catctl.pl -n 4 catupgrd.sql 

    Refer to the Oracle Database Upgrade Guide for more information.

    This database upgrade procedure must be called with the following
    argument when invoking from the SQL prompt:

                    @catupgrd.sql PARALLEL=NO

######################################################################
######################################################################
#


WHENEVER SQLERROR CONTINUE;

SET FEEDBACK OFF
SET TERMOUT OFF   

COLUMN 1 NEW_VALUE  1
SELECT NULL "1" FROM SYS.DUAL WHERE ROWNUM = 0;
SELECT NVL('&&1', 'PARALLEL=NO') FROM SYS.DUAL;

SET FEEDBACK ON
SET TERMOUT ON

Rem =====================================================================
Rem Exit immediately if there are errors on this check
Rem =====================================================================

WHENEVER SQLERROR EXIT;

Rem
Rem Will fail with a ORA-01476: divisor is equal to zero
Rem when parameter has not been passed
Rem
SELECT (to_number(count(*)))/(to_number(count(*))) FROM DUAL 
WHERE  UPPER('&&1') = 'PARALLEL=NO' OR 
       UPPER('&&1') = 'PARALLEL=YES';


WHENEVER SQLERROR CONTINUE;

DOC
#######################################################################
#######################################################################

   The first time this script is run, there should be no error messages
   generated; all normal upgrade error messages are suppressed.

   If this script is being re-run after correcting some problem, then 
   expect the following error which is not automatically suppressed:

   ORA-00001: unique constraint (<constraint_name>) violated
              possibly in conjunction with
   ORA-06512: at "<procedure/function name>", line NN

   These errors will automatically be suppressed by the Database Upgrade
   Assistant (DBUA) when it re-runs an upgrade.

#######################################################################
#######################################################################
#

Rem **********************************************************************
Rem 
Rem  NOTE: SQL CODE NOT PERMITTED IN THIS FILE ONLY THE EXECUTION OF A
Rem       .SQL or .PLB file.
Rem
Rem **********************************************************************

Rem
Rem Initial checks and RDBMS upgrade scripts
Rem
@@catupstr.sql

Rem
Rem Execute upgrade and catalog session script
Rem
@@catupses.sql    --CATFILE -SES
@@catalogses.sql  --CATFILE -SES

Rem
Rem Run catalog with some multiprocess phases
Rem
@@catalog.sql     --CATFILE -X

Rem
Rem Execute catproc session script
Rem
@@catprocses.sql  --CATFILE -SES

Rem
Rem Run catproc with some multiprocess phases
Rem
@@catproc.sql     --CATFILE -X

--CATCTL -R
--CATCTL -S
Rem
Rem Final RDBMS upgrade scripts
Rem
@@catupprc.sql

Rem
Rem Upgrade components with some multiprocess phases
Rem
@@cmpupgrd.sql    --CATFILE -X

--CATCTL -S
Rem
Rem Final upgrade scripts
Rem
@@catupend.sql
Rem
Rem Post Upgrade Script
Rem
--CATCTL -SE catuppst.sql EOL
--CATCTL -SE catshutdown.sql EOL

Rem
Rem Set errorlogging off
Rem
SET ERRORLOGGING OFF;

REM
REM NOTE:
REM   Database has been shut down
REM   NO SQL Commands beyond this point
REM 

REM END OF CATUPGRD.SQL

Rem bug 12337546 - Exit current sqlplus session at end of catupgrd.sql.
Rem                This forces user to start a new sqlplus session in order
Rem                to connect to the upgraded db.
exit

Rem *********************************************************************
Rem END catupgrd.sql
Rem *********************************************************************
