Rem
Rem $Header: rdbms/admin/catuppst.sql /st_rdbms_12.1.0.1/6 2013/03/15 10:08:28 cmlim Exp $
Rem
Rem catuppst.sql
Rem
Rem Copyright (c) 2006, 2013, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      catuppst.sql - CATalog UPgrade PoST-upgrade actions
Rem
Rem    DESCRIPTION
Rem      This post-upgrade script performs remaining upgrade actions that
Rem      do not require that the database be open in UPGRADE mode.
Rem      Automatically apply the latest PSU.
Rem
Rem    NOTES
Rem      You must be connected AS SYSDBA to run this script.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cmlim       03/13/13 - XbranchMerge cmlim_bug-16306200 from main
Rem    cmlim       03/01/13 - bug 16306200: remove the workaround (added in
Rem                           txn in bug 16085743) that re-updated
Rem                           oracle-supplied bit in views owned by SYS after
Rem                           bootstrap.  Workaround not needed once the shared
Rem                           pool is flushed in catuposb.sql (bug 16306200).
Rem    cmlim       01/11/13 - bug 16085743: extra: re-update oracle supplied
Rem                           bit in views owned by SYS after bootstrap
Rem    jerrede     01/11/13 - Move Removal of EXF/RUL to upgrade. 
Rem                           LogMiner/Standyby can not deal with removing
Rem                           a component outside of upgrade. 
Rem    sjanardh    01/10/13 - XbranchMerge maba_bug-14615619 from main
Rem    jerrede     12/19/12 - Bug#16025279 Add Event for Not Removing EXF/RUL
Rem                           Upgrade Components
Rem    surman      12/10/12 - XbranchMerge surman_bug-12876907 from main
Rem    maba        11/26/12 - fixed bug 14615619
Rem    surman      11/15/12 - 12876907: start and end session scripts
Rem    jerrede     11/05/12 - Add Exadata Bundle support
Rem    cmlim       10/27/12 - bug 14258301 : gather fixed obj stats if none of
Rem    jerrede     11/05/12 - Add Exadata Bundle support
Rem                           the fixed object tables have had stats collected
Rem    mfallen     09/20/12 - bug 14390165: check if AWR data needs update
Rem    jerrede     10/23/12 - Unset _ORACLE_SCRIPT
Rem    jerrede     10/23/12 - Add Session Info
Rem    maba        09/13/12 - added create dequeue log for bug 14278722
Rem    jerrede     06/26/12 - Set event to optionally update required stats
Rem                           during upgrade
Rem    rpang       05/21/12 - Add network ACL migration status check
Rem    traney      05/09/12 - lrg 6949943: mask ORA-942s
Rem    jerrede     04/17/12 - Moved Mandatory Changes to catrequired.sql
Rem    traney      04/04/12 - lrg 6762280: drop DBMS_DDL_INTERNAL_LIB
Rem    traney      03/12/12 - bug 13719175: move post-utlmmig stats here
Rem    cdilling    12/13/11 - drop SYSMAN schema - removal of EM component for
Rem                           upgrade to 12.1
Rem    aramappa    06/22/11 - Always run olstrig.sql when OLS installed in DB
Rem    xbarr       04/28/11 - move DMSYS removal code to odmu112.sql
Rem    xbarr       10/25/10 - run dmsysrem.sql to drop DMSYS schema if exists  
Rem    cdilling    07/21/10 - add call to catbundle.sql for bug 9925339
Rem    srtata      12/16/08 - run olstrig.sql when upgrading from prior to 10.2 
Rem    srtata      10/15/08 - put back olstrig.sql as we found it cannot be run
Rem                           as part of upgrade
Rem    srtata      02/26/08 - move olstrig.sql to olsdbmig.sql
Rem    ushaft      02/05/07 - post upgrade for ADDM tasks.
Rem    cdilling    12/06/06 - add support for error logging
Rem    rburns      11/10/06 - post upgrade actions
Rem    rburns      11/10/06 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql

Rem =====================================================================
Rem Call Common session settings
Rem =====================================================================
@@catpses.sql

Rem *********************************************************************
Rem BEGIN catuppst.sql
Rem *********************************************************************
Rem Set identifier to POSTUP for errorlogging

SET ERRORLOGGING ON TABLE sys.registry$error;
SET ERRORLOGGING ON IDENTIFIER 'POSTUP';

SELECT dbms_registry_sys.time_stamp('postup_bgn') as timestamp from dual;

Rem =======================================================================
Rem  Run Post Upgrade Operations
Rem =======================================================================

@@catrequired.sql

--
-- These were created in utlmmig.sql but could not be dropped until now.
-- Suppress "does not exist" errors.
--
set serveroutput on;
begin
  sys.dbms_output.put_line('catuppst: Dropping library DBMS_DDL_INTERNAL_LIB');
  execute immediate 'drop library DBMS_DDL_INTERNAL_LIB';
exception
  when others then
  if sqlcode = -4043 then
      null;
  end if;
end;
/

begin
  sys.dbms_output.put_line('catuppst: Dropping view _CURRENT_EDITION_OBJ_MIG');
  execute immediate 'drop view "_CURRENT_EDITION_OBJ_MIG"';
exception
  when others then
    if sqlcode = -942 then
      null;
    end if;
end;
/

begin
  sys.dbms_output.put_line('catuppst: Dropping view _ACTUAL_EDITION_OBJ_MIG');
  execute immediate 'drop view "_ACTUAL_EDITION_OBJ_MIG"';
exception
  when others then
    if sqlcode = -942 then
      null;
    end if;
end;
/

set serveroutput off;

Rem =======================================================================
Rem Upgrade AWR Baseline information
Rem =======================================================================

@@awrblmig.sql

Rem =======================================================================
Rem AWR inactive DBIDs check
Rem =======================================================================

set serveroutput on

declare
  cnt number;
begin
  select count(*) into cnt
    from sys.wrm$_wr_control
   where bitand(status_flag, 4) = 4;
  if (cnt > 0) then
    dbms_output.put_line(
      'AWR has data for ' || cnt || ' different DBID(s) that need updating.');
    dbms_output.put_line(
      'These are either imported AWR snapshots, or snapshots from before');
    dbms_output.put_line(
      'changing the DBID of the database. You will not be able to import');
    dbms_output.put_line(
      'additional data for those DBIDs until they are updated.');
    dbms_output.put_line(
      'Please use the rdbms/admin/awrupd12.sql script to update data for ' ||
      'those DBIDs after the database has been upgraded.');
  end if;
end;
/

set serveroutput off

Rem =======================================================================
Rem Upgrade ADDM task metadata
Rem =======================================================================

@@addmtmig.sql

Rem =======================================================================
Rem If OLS in the database, run olstrig.sql to updated OLS policies
Rem =======================================================================

COLUMN :ols_name NEW_VALUE ols_file NOPRINT;
VARIABLE ols_name VARCHAR2(30)
DECLARE
BEGIN
   IF dbms_registry.is_loaded('OLS') IS NOT NULL THEN
      :ols_name := '@olstrig.sql';   -- OLS installed in DB
   ELSE
      :ols_name := dbms_registry.nothing_script;   -- No OLS
   END IF;
END;
/
SELECT :ols_name FROM DUAL;
@&ols_file


Rem =======================================================================
Rem If EM in the database, run @emremove.sql to remove EM schema
Rem =======================================================================

COLUMN :em_name NEW_VALUE em_file NOPRINT;
VARIABLE em_name VARCHAR2(30)
DECLARE
BEGIN
   IF dbms_registry.is_loaded('EM') IS NOT NULL THEN
      :em_name := '@emremove.sql';   -- EM exists in DB
   ELSE
      :em_name := dbms_registry.nothing_script;   -- No EM
   END IF;
END;
/
SELECT :em_name FROM DUAL;
@&em_file

Rem =======================================================================
Rem Network ACL migration status check
Rem =======================================================================

set serveroutput on

declare
  cnt number;
begin
  select count(*) into cnt from dba_xs_acls
   where owner = 'SYS' and name like 'PRE_12_1_NETWORK_ACL_%';
  if (cnt > 0) then
    dbms_output.put_line(
      cnt || ' network access control lists (ACL) from releases earlier than');
    dbms_output.put_line(
      'Oracle Database 12.1 are not migrated. Please refer to the "Oracle');
    dbms_output.put_line(
      'Database Upgrade Guide" section titled "Configure Fine-Grained Access');
    dbms_output.put_line(
      'to External Network Services After Upgrading Oracle Database" for');
    dbms_output.put_line(
      'more information.');
  end if;
end;
/

set serveroutput off

Rem =======================================================================
Rem AQ post upgrade code start
Rem =======================================================================
set serveroutput on
-- create dequeue logs and recreate base views for old multiconsumer qtables
declare
  cursor qt_cur is select schema, name, flags from system.aq$_queue_tables;
begin
  -- only execute the script if version is in 11.1 or 10.2
  for qt in qt_cur loop
    if (sys.dbms_aqadm_sys.mcq_8_1(qt.flags)) then
      begin
        if not sys.dbms_aqadm_sys.object_exists(qt.schema, 'AQ$_' || qt.name ||
         '_L', 'TABLE') then
          sys.dbms_prvtaqim.create_dequeue_log(qt.schema, qt.name, qt.flags);
          sys.dbms_prvtaqim.create_base_view(qt.schema, qt.name, qt.flags);
        end if;
      exception
        when others then
          dbms_system.ksdwrt(dbms_system.alert_file,
                         'catuppst.sql: create dequeue log or recreate base' ||
                         ' view failed for ' || qt.schema || '.' || qt.name || ', error msg ' || SQLERRM);
      end;
    end if;
    -- validate queues in post upgrade only for scheduler queue
    if (qt.name = 'SCHEDULER$_EVENT_QTAB') then
      sys.dbms_aqadm_sys.validate_qtab_queues(qt.schema, qt.name);
      dbms_aqadm.start_queue(queue_name => 'scheduler$_event_queue');
    end if;
  end loop;
end;
/ 
set serveroutput off
Rem =======================================================================
Rem AQ post upgrade code end
Rem =======================================================================


Rem =======================================================================
Rem Bug 14258301 - Gather fixed objects stats IF NONE of the fixed object
Rem tables has stats
Rem =======================================================================

set serveroutput on
declare
  has_stats_cnt  number := 0;  -- # of fixed object tables that have stats
begin
  -- find # of fixed object tables that have had stats collected
  execute immediate
    'select count(*) ' ||
    'from sys.dba_tab_statistics ' ||
    ' where owner = ''SYS'' and table_name like ''X$%'' ' ||
    '       and last_analyzed is not null'
    into has_stats_cnt;

  -- if none of the fixed obj tables have had stats collected
  -- then gather fixed objects stats
  -- else do nothing
  if (has_stats_cnt = 0) then
    sys.dbms_output.put_line('catuppst: Gathering fixed objects stats now...');
    sys.dbms_stats.gather_fixed_objects_stats;
    sys.dbms_output.put_line('catuppst: Gathering fixed objects stats done.');
  end if;
end;
/
set serveroutput off

Rem =======================================================================
Rem Gather Fixed Objects Stats end
Rem =======================================================================


Rem =======================================================================
Rem Signal 'end' of catuppst.sql before catbundle.sql is executed
Rem =======================================================================

SELECT dbms_registry_sys.time_stamp('postup_end') as timestamp from dual;

Rem Set errorlogging off
SET ERRORLOGGING OFF;


Rem =======================================================================
Rem Begin of catbundle.sql
Rem =======================================================================

Rem Call catbundle.sql to apply the Patch Set Update (PSU)
Rem

COLUMN    :bundle_name  NEW_VALUE bundle_file NOPRINT;
VARIABLE   bundle_name  VARCHAR2(50)

declare

  nNumCells   NUMBER := 0;

begin

   nNumCells := sys.dbms_registry.num_of_exadata_cells();
   IF (nNumCells > 0) THEN
      :bundle_name := 'catbundle_exa.sql'; -- Exadata PSU
   ELSE
      :bundle_name := 'catbundle_psu.sql'; -- Normal PSU
   END IF;

end;
/

SELECT :bundle_name FROM DUAL;
@@&bundle_file

@?/rdbms/admin/sqlsessend.sql

Rem *********************************************************************
Rem END catuppst.sql
Rem *********************************************************************

