Rem
Rem $Header: rdbms/admin/catupstr.sql /st_rdbms_12.1.0.1/6 2013/04/03 02:47:38 vpriyans Exp $
Rem
Rem catupstr.sql
Rem
Rem Copyright (c) 2006, 2013, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      catupstr.sql - CATalog UPgrade STaRt script
Rem
Rem    DESCRIPTION
Rem      This script performs the initial checks for upgrade
Rem      (open for UPGRADE, AS SYSDBA, etc.) and then runs
Rem      the "i" scripts, utlip.sql, and the "c" scripts
Rem      to complete the basic RDBMS upgrade
Rem
Rem    NOTES
Rem      Invoked from catupgrd.sql
Rem
Rem     *WARNING*   *WARNING*  *WARNING*  *WARNING*  *WARNING*  *WARNING*
Rem
Rem      set serveroutput must be set to off before
Rem      invoking utlip.sql script otherwise deadlocks
Rem      and internal errors may result.
Rem
Rem     *WARNING*   *WARNING*  *WARNING*  *WARNING*  *WARNING*  *WARNING*
Rem
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jibyun      03/28/13 - Bug 16567861: throw an error if the following
Rem                           users/roles already exist: SYSBACKUP, SYSDG,
Rem                           SYSKM, capture_admin
Rem    yiru        03/28/13 - Bug 16561033: Add query to check the existence
Rem                           of RAS reserved roles
Rem    vpriyans    03/28/13 - Bug 16571958: tracking bug for bug#16552266
Rem    vpriyans    03/28/13 - Bug 16552266: modify query to check the existence
Rem                           of audit admins
Rem    aramappa    03/04/13 - XbranchMerge aramappa_bug-16317592 from main
Rem    aramappa    02/19/13 - bug 16317592 - Remove PREUPG_AUD$ check
Rem    cmlim       01/09/13 - comment: fix INVALID_TABLEDATA error in old OH
Rem    surman      12/10/12 - XbranchMerge surman_bug-12876907 from main
Rem    bmccarth    12/05/12 - check for invalid table data - 7174392
Rem                         - remove unsupported prior version checks
Rem                         - Fix use of dual
Rem    surman      11/15/12 - 12876907: start and end session scripts
Rem    jerrede     11/08/12 - Make sure set serverouput is off Lrg 8473773
Rem    brwolf      10/22/12 - enable editioning for public synonyms
Rem    cmlim       10/16/12 - "_ORACLE_SCRIPT"=true set is missing at begin of
Rem                           catupstr.sql
Rem    amunnoli    10/05/12 - Bug 14727837:Fix AUDSYS query to work 
Rem                           for non-english locale
Rem    amunnoli    09/14/12 - Bug 14560783:Throw error on upgrade if AUDSYS,
Rem                           AUDIT_ADMIN(/VIEWER) exists in the source DB
Rem    aramappa    08/30/12 - bug 14555249: fix olspreupgrade query to work for
Rem                           non-english locale
Rem    cdilling    08/29/12 - version to 12.1.0.1.0
Rem    cdilling    08/29/12 - version to 12.1.0.1.0
Rem    cdilling    08/20/12 - add 10205 to check for olspreupgrade
Rem    bmccarth    07/10/12 - tz to 18
Rem    traney      07/09/12 - bug 12915774: mark sys objects noneditionable
Rem    srtata      03/09/12 - bug 13779729 : add checks for OLS pre-upgrade
Rem    jerrede     12/21/11 - Make Parallel Upgrade the Default
Rem    jerrede     12/12/11 - Display Version Info
Rem    cdilling    11/16/11 - run @i1002000.sql rather than @i090200.sql
Rem    jerrede     10/28/11 - Fix Bug 13252372
Rem    cmlim       10/26/11 - update_tzv_17: change time zone file version from
Rem                           16 to 17
Rem    cdilling    10/13/11 - check direct upgrade versions for 12.1
Rem    yanchuan    10/11/11 - Bug 12776828: admin procedure name changes
Rem    cmlim       10/04/11 - update_tzv_16: change utlu_tz_version from 15 to
Rem                           16
Rem    cmlim       09/16/11 - olsdv upgrade: updated checks to dv-not-enabled
Rem                           and ols-not-installed
Rem    cmlim       11/11/09 - change the timezone check from 8 to 11
Rem    jerrede     09/01/11 - Parallel Upgrade Project #23496
Rem    brwolf      08/31/11 - 32733: finer-grained editioning
Rem    cmlim       04/17/11 - bug 12363704: update time zone check in
Rem                           catupstr.sql that will work for re-upgrades
Rem                         - update time zone file version from 14 to 15
Rem    traney      04/05/11 - 35209: long identifiers dictionary upgrade
Rem    cdilling    02/17/11 - invoke utlip for upgrade to 12.1
Rem    cdilling    02/12/11 - bug 10373381: check instance to the 4th digit
Rem    cmlim       12/14/10 - bug 10400001: check that 112 oracle has DV off
Rem                           prior to upgrade
Rem    bmccarth    08/13/10 - version_script update for 12.1
Rem    cdilling    08/04/10 - add support for 12.1 instance version
Rem    cmlim       06/21/10 - update_tzv14: 11202 is now at time zone file v14
Rem    cmlim       04/26/10 - bug 9546509; suggest to force a checkpoint prior
Rem                           to shutdown abort in instructions
Rem    cdilling    03/12/10 - abort upgrade if invalid conditions for editions
Rem                           - bug 9454506
Rem    cmlim       02/01/10 - 11202 is now at time zone file version 13
Rem    cdilling    06/01/09 - check for supported upgrade versions
Rem    cdilling    05/26/09 - for PSU check only 5 digits for version
Rem    cmlim       01/16/09 - bug 7496789: update check on when DV needs to be
Rem                           relinked off
Rem    cmlim       12/19/08 - timezone_b7193417-c: rewrite timezone check
Rem    cmlim       12/12/08 - timezone_b7193417-b: if old OH has newer timezone
Rem                           version than 8, abort if new OH is not patched
Rem    rlong       09/25/08 - 
Rem    cmlim       07/24/08 - bug 7193417: support timezone file version
Rem                           changes in 11.2
Rem    awitkows    03/30/08 - DST. repl registry with props
Rem    rburns      11/11/07 - XbranchMerge rburns_bug-6446262 from
Rem                           st_rdbms_project-18813
Rem    rburns      11/08/07 - check for INVALID old versions of types
Rem    jciminsk    10/22/07 - Upgrade support for 11.2
Rem    cdilling    10/09/07 - update version to 11.2
Rem    cdilling    08/23/07 - check disabled indexes only
Rem    rburns      07/16/07 - add 11.1 patch upgrade
Rem    rburns      05/29/07 - add timezone version check
Rem    rburns      05/01/07 - reload dbms_assert
Rem    rburns      03/10/07 - add DV and OLS check
Rem    cdilling    02/19/07 - add sys.enabled$indexes table for bug 5530085
Rem    dvoss       02/19/07 - Check bootstrap migration status
Rem    rburns      10/23/06 - add session script
Rem    rburns      08/14/06 - add RDBMS identifier
Rem    cdilling    06/08/06 - add error logging table
Rem    gviswana    06/07/06 - Enable 4523571 fix 
Rem    rburns      05/22/06 - parallel upgrade 
Rem    rburns      05/22/06 - Created
Rem

Rem =====================================================================
Rem Exit immediately if there are errors in the initial checks
Rem =====================================================================

WHENEVER SQLERROR EXIT;        

@@?/rdbms/admin/sqlsessstart.sql


Rem Set session initializations by invoking catpses.sql directly.
Rem This script will set session variable "_ORACLE_SCRIPT" to TRUE.
@@catpses.sql


DOC 
######################################################################
######################################################################
    The following statement will cause an "ORA-01722: invalid number"
    error if the user running this script is not SYS.  Disconnect
    and reconnect with AS SYSDBA.
######################################################################
######################################################################
#

SELECT TO_NUMBER('MUST_BE_AS_SYSDBA') FROM SYS.DUAL
WHERE USER != 'SYS';

DOC
######################################################################
######################################################################
    The following statement will cause an "ORA-01722: invalid number"
    error if the database server version is not correct for this script.
    Perform "ALTER SYSTEM CHECKPOINT" prior to "SHUTDOWN ABORT", and use
    a different script or a different server.
######################################################################
######################################################################
#

SELECT TO_NUMBER('MUST_BE_12_1_0_1') FROM v$instance
WHERE substr(version,1,8) != '12.1.0.1';

DOC
#######################################################################
#######################################################################
   The following statement will cause an "ORA-01722: invalid number"
   error if the database has not been opened for UPGRADE.  

   Perform "ALTER SYSTEM CHECKPOINT" prior to "SHUTDOWN ABORT",  and 
   restart using UPGRADE.
#######################################################################
#######################################################################
#

SELECT TO_NUMBER('MUST_BE_OPEN_UPGRADE') FROM v$instance
WHERE status != 'OPEN MIGRATE';

DOC
#######################################################################
#######################################################################
     The following statement will cause an "ORA-01722: invalid number"
     error if Oracle Database Vault is enabled in the database.
     Oracle Database Vault cannot be enabled while the database is
     upgrading since administrative actions may not be permitted.

     To disable Database Vault in this database, log in as Database
     Vault administrator and run this operation
     "DVSYS.DBMS_MACADM.DISABLE_DV()".  Then restart the server
     in UPGRADE mode to continue the database upgrade.
#######################################################################
#######################################################################
#

SELECT TO_NUMBER('DATABASE_VAULT_ENABLED') FROM v$option
 WHERE
  value = 'TRUE' and parameter = 'Oracle Database Vault';

DOC
#######################################################################
#######################################################################
   The following statement will cause an "ORA-01722: invalid number"
   error if Oracle Database Vault is installed but
   Oracle Label Security is not.  To successfully upgrade Oracle
   Database Vault, both Database Vault and Label Security must be
   installed.

   Install Oracle Label Security in this database before continuing
   the database upgrade.
#######################################################################
#######################################################################
#

SELECT TO_NUMBER('LABEL_SECURITY_NOT_INSTALLED') FROM SYS.DUAL
WHERE (SELECT COUNT(*) FROM user$ where name = 'LBACSYS') = 0 and
      (SELECT COUNT(*) FROM user$ where name = 'DVSYS') = 1;

DOC
#######################################################################
#######################################################################
   The following statement will cause an "ORA-01722: invalid number"
   error if bootstrap migration is in progress and logminer clients
   require utlmmig.sql to be run next to support this redo stream.

   Run utlmmig.sql
   then (if needed) 
   restart the database using UPGRADE and
   rerun the upgrade script.
#######################################################################
#######################################################################
#

SELECT TO_NUMBER('MUST_RUN_UTLMMIG.SQL')
    FROM SYS.V$DATABASE V
    WHERE V.LOG_MODE = 'ARCHIVELOG' and
          V.SUPPLEMENTAL_LOG_DATA_MIN != 'NO' and
          exists (select 1 from sys.props$
                  where name = 'LOGMNR_BOOTSTRAP_UPGRADE_ERROR');


DOC
#######################################################################
#######################################################################
   The following error is generated if the pre-upgrade tool has not been
   run in the old ORACLE_HOME home prior to upgrading a pre-11.2 database: 

   SELECT TO_NUMBER('MUST_HAVE_RUN_PRE-UPGRADE_TOOL_FOR_TIMEZONE')
                       *
      ERROR at line 1:
      ORA-01722: invalid number

     o Action:
       Shutdown database ("alter system checkpoint" and then "shutdown abort").
       Revert to the original oracle home and start the database.
       Run pre-upgrade tool against the database.
       Review and take appropriate actions based on the pre-upgrade
       output before opening the datatabase in the new software version.
    
#######################################################################
#######################################################################
#
Rem time zone check 1
Rem   SELECT TO_NUMBER('MUST_HAVE_RUN_PRE-UPGRADE_TOOL_FOR_TIMEZONE')

Rem Assure CHAR semantics are not used in the dictionary
ALTER SESSION SET NLS_LENGTH_SEMANTICS=BYTE;

Rem To keep the check simple and avoid multiple errors - in upgrade mode,
Rem create registry$database and add tz_version in case the table
Rem and/or column do not exist.
CREATE TABLE registry$database
               (platform_id NUMBER, platform_name VARCHAR2(101),
                edition VARCHAR2(30), tz_version NUMBER);
ALTER TABLE registry$database add (tz_version number);

Rem Check if tz_version was populated if the db is pre-11.2
SELECT TO_NUMBER('MUST_HAVE_RUN_PRE-UPGRADE_TOOL_FOR_TIMEZONE')
   FROM sys.props$
   WHERE
     (
       (
        (0 = (select count(*) from registry$database))
        OR
        ((SELECT tz_version from registry$database) is null)
       )
       AND
       (
        ((SELECT substr(version,1,4) FROM registry$ where cid = 'CATPROC') =
          '10.2') OR
        ((SELECT substr(version,1,4) FROM registry$ where cid = 'CATPROC') =
          '11.1')
       )
     );


DOC
#######################################################################
#######################################################################
   The following error is generated if the pre-upgrade tool has not been
   run in the old oracle home prior to upgrading a pre-11.2 database:

      SELECT TO_NUMBER('MUST_BE_SAME_TIMEZONE_FILE_VERSION')
                       *
      ERROR at line 1:
      ORA-01722: invalid number

     o Action:
       Shutdown database ("alter system checkpoint" and then "shutdown abort").
       Revert to the original ORACLE_HOME and start the database.
       Run pre-upgrade tool against the database.
       Review and take appropriate actions based on the pre-upgrade
       output before opening the datatabase in the new software version.

#######################################################################
#######################################################################
#
Rem time zone check 2
Rem   SELECT TO_NUMBER('MUST_BE_SAME_TIMEZONE_FILE_VERSION')

Rem Check if sys.props$ was populated if the db is pre-11.2
SELECT TO_NUMBER('MUST_BE_SAME_TIMEZONE_FILE_VERSION')
   FROM sys.props$
   WHERE
     (
      ((SELECT TO_NUMBER(value$) from sys.props$
         WHERE name = 'DST_PRIMARY_TT_VERSION') !=
       (SELECT tz_version from registry$database))
      AND
       (((SELECT substr(version,1,4) FROM registry$ where cid = 'CATPROC') =
         '10.2') OR
       ((SELECT substr(version,1,4) FROM registry$ where cid = 'CATPROC') =
         '11.1'))
     );


DOC
#######################################################################
#######################################################################
   The following error is generated if (1) the old release uses a time
   zone file version newer than the one shipped with the new oracle
   release and (2) the new oracle home has not been patched yet:

      SELECT TO_NUMBER('MUST_PATCH_TIMEZONE_FILE_VERSION_ON_NEW_ORACLE_HOME')
                       *
      ERROR at line 1:
      ORA-01722: invalid number

     o Action:
       Shutdown database ("alter system checkpoint" and then "shutdown abort").
       Patch new ORACLE_HOME to the same time zone file version as used
       in the old ORACLE_HOME.

#######################################################################
#######################################################################
#
Rem time zone check 3
Rem   SELECT TO_NUMBER('MUST_PATCH_TIMEZONE_FILE_VERSION_ON_NEW_ORACLE_HOME')

Rem Check if time zone file version used by the database exists in new home
SELECT TO_NUMBER('MUST_PATCH_TIMEZONE_FILE_VERSION_ON_NEW_ORACLE_HOME')
   FROM sys.props$
   WHERE
     (
      (name = 'DST_PRIMARY_TT_VERSION' AND TO_NUMBER(value$) > 18)
      AND
      (0 = (select count(*) from v$timezone_file))
     );


DOC 
#######################################################################
#######################################################################
    The following statements will cause an "ORA-01722: invalid number"
    error if the SYSAUX tablespace does not exist or is not
    ONLINE for READ WRITE, PERMANENT, EXTENT MANAGEMENT LOCAL, and
    SEGMENT SPACE MANAGEMENT AUTO.
 
    The SYSAUX tablespace is used in 10.1 to consolidate data from
    a number of tablespaces that were separate in prior releases. 
    Consult the Oracle Database Upgrade Guide for sizing estimates.

    Create the SYSAUX tablespace, for example,

     create tablespace SYSAUX datafile 'sysaux01.dbf' 
         size 70M reuse 
         extent management local 
         segment space management auto 
         online;

    Then rerun the upgrade script.
#######################################################################
#######################################################################
#

SELECT TO_NUMBER('No SYSAUX tablespace') FROM dual 
WHERE 'SYSAUX' NOT IN (SELECT name from ts$);

SELECT TO_NUMBER('Not ONLINE for READ/WRITE') from ts$
WHERE name='SYSAUX' AND online$ !=1;

SELECT TO_NUMBER ('Not PERMANENT') from ts$
WHERE name='SYSAUX' AND 
      (contents$ !=0 or (contents$ = 0 AND bitand(flags, 16)= 16));

SELECT TO_NUMBER ('Not LOCAL extent management') from ts$
WHERE name='SYSAUX' AND bitmapped = 0;

SELECT TO_NUMBER ('Not AUTO segment space management') from ts$
WHERE name='SYSAUX' AND bitand(flags,32) != 32;

DOC
#######################################################################
#######################################################################
     The following statement will cause an "ORA-01722: invalid number"
     error if a user or role with the names AUDSYS, AUDIT_ADMIN, or
     AUDIT_VIEWER is found in the database.

     o Cause:
       User 'AUDSYS', role 'AUDIT_ADMIN', and role 'AUDIT_VIEWER' are Oracle
       supplied in 12.1.  Hence, these existing user or role names
       found in the database must be dropped before upgrading.

     o Fixup:
       Please move the contents from AUDSYS schema to a different schema
       before dropping the AUDSYS schema.  The fixup needs to be done in
       the original oracle home.

     o Action:
       Shutdown database ("alter system checkpoint" and then "shutdown abort").
       Revert to the original oracle home and start the database.
       Move AUDSYS schema as needed.
       Drop the existing user/role name.
       Revert to the new oracle home and restart the database in UPGRADE mode.
       Continue the database upgrade.

       Note - the following drops require execution as SYS:
       To drop user 'AUDSYS'       - "DROP USER AUDSYS CASCADE".
       To drop role 'AUDIT_ADMIN'  - "DROP ROLE AUDIT_ADMIN".
       To drop role 'AUDIT_VIEWER' - "DROP ROLE AUDIT_VIEWER".
#######################################################################
#######################################################################
#

SELECT TO_NUMBER('Reserved AUDIT roles already exist') FROM SYS.DUAL
WHERE (select count(*) from sys.user$ WHERE
        name in ('AUDSYS', 'AUDIT_ADMIN', 'AUDIT_VIEWER')) > 0 AND
      (select SUBSTR(version,1,4) FROM registry$ where
       cid = 'CATPROC') < '12.1';

DOC
#######################################################################
#######################################################################
     The following statement will cause an "ORA-01722: invalid number"
     error if a user/role with the name PROVISIONER, XS_RESOURCE, 
     XS_SESSION_ADMIN, XS_NAMESPACE_ADMIN, XS_CACHE_ADMIN is found in the 
     database. 
     
     PROVISIONER, XS_RESOURCE, XS_SESSION_ADMIN, XS_NAMESPACE_ADMIN,
     XS_CACHE_ADMIN are Oracle supplied roles in 12.1. Hence, these existing 
     user or role names found in the database must be dropped before 
     upgrading.

     Please move the contents in the existing schemas to different schemas,
     if necessary, before dropping these schemas. The fixup needs to be
     done in the original Oracle home.

     Shutdown database ("alter system checkpoint" and then "shutdown abort").
     Revert to the original oracle home and start the database.
     Move the contents in the conflicting schemas as needed.
     Drop the conflicting users/roles.
     Revert to the new oracle home and restart the database in UPGRADE mode.
     Continue the database upgrade.

     Note - the following drops require execution as SYS:
     To drop role 'PROVISIONER'         - "DROP ROLE PROVISIONER".
     To drop role 'XS_RESOURCE'         - "DROP ROLE XS_RESOURCE".
     To drop role 'XS_SESSION_ADMIN'    - "DROP ROLE XS_SESSION_ADMIN".
     To drop role 'XS_NAMESPACE_ADMIN'  - "DROP ROLE XS_NAMESPACE_ADMIN".
     To drop role 'XS_CACHE_ADMIN'      - "DROP ROLE XS_CACHE_ADMIN".
#######################################################################
#######################################################################
#
SELECT TO_NUMBER('RAS_RESERVED_ROLES_FOUND') FROM SYS.DUAL
WHERE (select count(*) from sys.user$ WHERE
        name in ('PROVISIONER', 'XS_RESOURCE', 'XS_SESSION_ADMIN',
                 'XS_NAMESPACE_ADMIN', 'XS_CACHE_ADMIN')) > 0 AND
      (select SUBSTR(version,1,4) FROM registry$ where
       cid = 'CATPROC') < '12.1' ;

DOC
#######################################################################
#######################################################################
     The following statement will cause an "ORA-01722: invalid number"
     error, if a user or role with the name SYSBACKUP, SYSDG, SYSKM, or
     CAPTURE_ADMIN is found in the database.

     SYSBACKUP, SYSDG, and SYSKM are Oracle supplied users in 12.1, and 
     CAPTURE_ADMIN is Oracle supplied role in 12.1. Hence, these 
     existing user or role names found in the database must be dropped
     before upgrading. 

     Please move the contents in the existing schemas to different schemas,
     if necessary, before dropping these schemas. The fixup needs to be
     done in the original Oracle home.

     Shutdown database ("alter system checkpoint" and then "shutdown abort").
     Revert to the original oracle home and start the database.
     Move the contents in the conflicting schemas as needed.
     Drop the conflicting users/roles.
     Revert to the new oracle home and restart the database in UPGRADE mode.
     Continue the database upgrade.

     Note - the following drops require execution as SYS:
     To drop user 'SYSBACKUP'      - "DROP USER SYSBACKUP CASCADE".
     To drop user 'SYSDG'          - "DROP USER SYSDG CASCADE".
     To drop user 'SYSKM'          - "DROP USER SYSKM CASCADE".
     To drop role 'CAPTURE_ADMIN'  - "DROP ROLE CAPTURE_ADMIN".
#######################################################################
#######################################################################
#

SELECT TO_NUMBER('SOD_USERS_ARE_FOUND') FROM SYS.DUAL
WHERE (select count(*) from sys.user$ WHERE
        name in ('SYSBACKUP', 'SYSDG', 'SYSKM')) > 0 AND
      (select SUBSTR(version,1,4) FROM registry$ where
       cid = 'CATPROC') < '12.1';

SELECT TO_NUMBER('CAPTURE_ADMIN_IS_FOUND') FROM SYS.DUAL
WHERE (select count(*) from sys.user$ WHERE
        name = 'CAPTURE_ADMIN') > 0 AND
      (select SUBSTR(version,1,4) FROM registry$ where
       cid = 'CATPROC') < '12.1';

DOC
#######################################################################
#######################################################################

     The following statement will cause an "ORA-01722: invalid number"
     error, if the database contains invalid data as a result of type
     evolution which was performed without the data being converted.
     
     To resolve this specific "ORA-01722: invalid number" error:
       Shutdown database ("alter system checkpoint" and then "shutdown abort").
       Perform the data conversion (details below) in the old ORACLE_HOME.

     Please refer to Oracle Database Object-Relational Developer's Guide
     for more information about type evolution.

     Data in columns of evolved types must be converted before the
     database can be upgraded. 

     This data can be converted at any time prior to the upgrade (the
     conversion does not need to be performed directly before the
     upgrade). The data conversion process can be time consuming.

     The following commands will perform the data conversion for Oracle
     supplied data:

     @?/rdbms/admin/utluppkg.sql
     SET SERVEROUTPUT ON;
     exec dbms_preup.run_fixup_and_report('INVALID_SYS_TABLEDATA');
     SET SERVEROUTPUT OFF;

     You should then confirm that any non-Oracle supplied data is also
     converted.  You should review the data and determine if it needs
     to be converted or removed. 

     To view the data which is affected by type evolution, execute the following:

     SELECT rpad(u.name,128) TABLENAME, rpad(o.name,128) OWNER,
       rpad(c.name,128) COLNAME FROM SYS.OBJ$ o, SYS.COL$ c, SYS.COLTYPE$ t,
         SYS.USER$ u
         WHERE o.OBJ# = t.OBJ# AND c.OBJ# = t.OBJ# AND c.COL# = t.COL#
           AND t.INTCOL# = c.INTCOL# AND BITAND(t.FLAGS, 256) = 256
           AND o.OWNER# = u.USER# AND o.OWNER# NOT IN
            (SELECT UNIQUE (d.USER_ID) FROM SYS.DBA_USERS d, SYS.REGISTRY$ r
               WHERE d.USER_ID = r.SCHEMA# and r.NAMESPACE='SERVER');

     Once the data is confirmed, the following commands will convert the
     the data returned by the above query.

     @?/rdbms/admin/utluppkg.sql
     SET SERVEROUTPUT ON;
     exec dbms_preup.run_fixup_and_report('INVALID_USR_TABLEDATA');
     SET SERVEROUTPUT OFF;

     Depending on the amount of data involved, converting the evolved type
     data can take a significant amount of time.

#######################################################################
#######################################################################
#

SELECT TO_NUMBER('INVALID_TABLEDATA') FROM SYS.DUAL
WHERE (SELECT COUNT(*) FROM SYS.OBJ$ o, SYS.COL$ c, SYS.COLTYPE$ t
         WHERE o.OBJ# = t.OBJ# AND c.OBJ# = t.OBJ# AND c.COL# = t.COL# 
           AND t.INTCOL# = c.INTCOL# AND BITAND(t.FLAGS, 256) = 256 
       ) > 0;

Rem =====================================================================
Rem Assure CHAR semantics are not used in the dictionary
Rem =====================================================================

ALTER SESSION SET NLS_LENGTH_SEMANTICS=BYTE;

Rem =====================================================================
Rem Continue even if there are SQL errors in remainder of script
Rem =====================================================================

WHENEVER SQLERROR CONTINUE;  

Rem
Rem Bug 5530085
Rem
Rem Poplulate sys.enabled_indexes table with the list of function-based 
Rem indexes that are currently not 'disabled'. This schema/index name list 
Rem will be later used in utlrp.sql to enable indexes in the list that may 
Rem have become disabled. 
Rem
CREATE TABLE sys.enabled$indexes( schemaname, indexname, objnum )
AS select u.name, o1.name, i.obj# from user$ u, obj$ o1, obj$ o2, ind$ i
    where
        u.user# = o1.owner# and o1.type# = 1 and o1.obj# = i.obj#
       and bitand(i.property, 16)= 16 and bitand(i.flags, 1024)=0
       and i.bo# = o2.obj# and bitand(o2.flags, 2)=0;



Rem
Rem Create error logging table
Rem
CREATE TABLE sys.registry$error(username   VARCHAR(256),
                                timestamp  TIMESTAMP,
                                script     VARCHAR(1024),
                                identifier VARCHAR(256),
                                message    CLOB,
                                statement  CLOB);
                                         
DELETE FROM sys.registry$error;
commit;

Rem
Rem Run Session initialization scripts
Rem error logging table must exist
Rem
@@catupses.sql
@@catalogses.sql


Rem
Rem Pre-create log to record upgrade operations and errors
Rem

CREATE TABLE registry$log (
             cid         VARCHAR2(128),              /* component identifier */
             namespace   VARCHAR2(128),               /* component namespace */
             operation   NUMBER NOT NULL,              /* current operation */
             optime      TIMESTAMP,                  /* operation timestamp */
             errmsg      varchar2(1000)         /* ORA error message number */
             );
Rem Clear log entries if the table already exists
DELETE FROM registry$log;

Rem put timestamps into spool log and registry$log
INSERT INTO registry$log (cid, namespace, operation, optime)
       VALUES ('UPGRD_BGN','SERVER',-1,SYSTIMESTAMP);
COMMIT;
SELECT 'COMP_TIMESTAMP UPGRD__BGN ' || 
        TO_CHAR(SYSTIMESTAMP,'YYYY-MM-DD HH24:MI:SS ')  || 
        TO_CHAR(SYSTIMESTAMP,'J SSSSS ')
        AS timestamp FROM SYS.DUAL;

--
--   Display Version Info from registry$
--
SELECT org_version from sys.registry$ where cid = 'CATPROC';
SELECT prv_version from sys.registry$ where cid = 'CATPROC';
SELECT version from sys.registry$ where cid = 'CATPROC';

--
-- NOTE: DBUA_TIMESTAMP is sorted by catctl.pl if you change the
-- position of the SYSTIMESTAMP output then you have to change
-- the substr command on the sort in catrpt.pl.
--
SELECT 'DBUA_TIMESTAMP RDBMS      STARTED     ' || 
       TO_CHAR(SYSTIMESTAMP,'YYYY-MM-DD HH24:MI:SS ') from SYS.DUAL;

Rem =====================================================================
Rem BEGIN STAGE 1: load dictionary changes for basic SQL processing
Rem =====================================================================

Rem run all of the "i" scripts from the earliest supported release
@@i1002000.sql

Rem =====================================================================
Rem END STAGE 1: load dictionary changes for basic SQL processing
Rem =====================================================================

Rem =====================================================================
Rem Between stages 1 and 2
Rem =====================================================================

-- Beginning in version 12.1, PUBLIC has editioning enabled for public
-- synonyms.  Because utlip recreates the public synonym for dbms_standard,
-- before utlip can run all existing synonyms in PUBLIC must be marked as
-- non-editionable.  We do that here.

update obj$ set flags = flags + 1048576
  where owner# = 1 and type# in (5,10) and bitand(flags, 1048576) = 0;

-- bug 12915774: Set noneditionable bit for builtin schema objects
update obj$ set flags = (flags - bitand(flags, 1048576) + 1048576)
  where owner# in (select u.user# from registry$ r, user$ u 
    where r.status in (0,1,3,5)
       and r.namespace = 'SERVER'
       and r.schema#   = u.user#
     union all
     select u.user#
     from registry$ r, registry$schemas s, user$ u
     where r.status in (0,1,3,5)
       and r.namespace = 'SERVER'
       and r.cid       = s.cid
       and s.schema#   = u.user#)
  and type# in (4,5,7,8,9,11,12,13,14,22,114);
commit;
alter role "PUBLIC" enable editions for synonym;
alter system flush shared_pool;

Rem =====================================================================
Rem BEGIN STAGE 2: invalidate all non-Java objects
Rem =====================================================================

--
-- Invalidate all PL/SQL packages
--
@@utlip.sql 


-- Bug 6446262, check forINVALID old versions of types and update 
-- any with status = 6
SELECT name, subname, owner#, status FROM obj$
       WHERE type#=13 AND subname IS NOT NULL AND status > 1;
UPDATE obj$ SET status=1 
       WHERE type#=13 AND subname IS NOT NULL AND status=6;
COMMIT;
ALTER SYSTEM FLUSH SHARED_POOL;

-- Reload dbms_assert package for changed interfaces (used in "c" scripts)
@@dbmsasrt.sql
@@prvtasrt.plb

Rem =====================================================================
Rem END STAGE 2: invalidate all non-Java objects
Rem =====================================================================

Rem =====================================================================
Rem BEGIN STAGE 3: dictionary upgrade
Rem =====================================================================

WHENEVER SQLERROR EXIT

DOC
#######################################################################
#######################################################################
     The following check_edition_exists procedure may result in this error:

       ERROR at line 1:
	ORA-20000: Editioning view exists for non-edition enabled schema
	ORA-06512: at "SYS.CHECK_EDITION_EXISTS", line 21
	ORA-06512: at line 2

     if there exists non-edition enabled schemas that have editioning
     views. One of the following corrective actions must be taken before 
     the upgrade will proceed.

	1. Drop these editioning views.
	2. Edition enable the schemas using the alter user statement.
	3. Replace the editioning views with regular views.

     Perform a "ALTER SYSTEM CHECKPOINT" prior to "SHUTDOWN ABORT" and take
     a corrective action described above.

     Restriction is for:
     1) When source database is 11.2.0.1 and is being upgraded to 11.2.0.2.
     2) To identify the particular schema/views run the pre-upgrade script
        /rdbms/admin/utlu112i.sql in normal mode on the source database.
     
#######################################################################
#######################################################################
#

CREATE OR REPLACE PROCEDURE check_edition_exists
AS

  d_version      VARCHAR2(30);
  server_version VARCHAR2(30);
  ev_count       INTEGER;

BEGIN
  SELECT version INTO d_version FROM registry$ where cid='CATPROC';
  select version into server_version from v$instance;
  IF substr(d_version,1,8) = '11.2.0.1' AND
     substr(server_version,1,8)= '11.2.0.2'
  THEN
     EXECUTE IMMEDIATE 'SELECT count(*) FROM SYS.DBA_EDITIONING_VIEWS EV, 
                                             SYS.DBA_USERS US
                                        WHERE US.USERNAME = EV.OWNER AND
                                              US.EDITIONS_ENABLED <> ''Y'' AND
					      ROWNUM < 2'
     INTO ev_count;
      IF ev_count > 0 THEN     
        RAISE_APPLICATION_ERROR(-20000,
         'Editioning view exists for non-edition enabled schema' );
      END IF;
  END IF;

END check_edition_exists;
/


Rem check if an editioning view exists for a non edition enabled user
begin
check_edition_exists;
end;
/

drop procedure check_edition_exists;

Rem Determine original release and run the appropriate script
CREATE OR REPLACE FUNCTION version_script 
RETURN VARCHAR2 IS

  p_null         char(1);
  p_version      VARCHAR2(30);
  p_prv_version  VARCHAR2(30);
  server_version VARCHAR2(30);

BEGIN

-- For 12.1, direct uppgrades are supported from 
-- 10.2.0.5, 11.1.0.7, and 11.2.0.2 and above.

  SELECT version INTO p_version FROM registry$ where cid='CATPROC';
  IF substr(p_version,1,8) = '10.2.0.5' THEN
     RETURN '1002000';
  ELSIF substr(p_version,1,8) = '11.1.0.7' THEN
     RETURN '1101000';
  ELSIF substr(p_version,1,6) = '11.2.0' AND
        substr(p_version,1,8) != '11.2.0.1' THEN
     RETURN '1102000';
  ELSIF substr(p_version,1,6) = '12.1.0' THEN -- current version
     SELECT version INTO server_version FROM v$instance;
     IF substr(p_version,1,8) != substr(server_version,1,8) THEN --- run c1102000   
        RETURN '1102000';
     ELSE 
        -- version is the same as instance, so rerun the previous upgrade
        -- rerun upgrade of previous release 
        EXECUTE IMMEDIATE
             'SELECT prv_version FROM registry$ where cid=''CATPROC'''
        INTO p_prv_version;

        IF substr(p_prv_version,1,8) = '10.2.0.5' THEN
           RETURN '1002000';
        ELSIF substr(p_prv_version,1,8) = '11.1.0.7' THEN
           RETURN '1101000';
        ELSIF substr(p_prv_version,1,6) = '11.2.0' AND
              substr(p_prv_version,1,8) != '11.2.0.1' THEN
           RETURN '1102000';
        ELSIF substr(p_prv_version,1,6) = '12.1.0' OR
              p_prv_version IS NULL THEN  -- new database
           RETURN '1102000';
        ELSE
           RAISE_APPLICATION_ERROR(-20000,
          'Upgrade re-run not supported from version ' || p_prv_version );
        END IF;
      END IF;
  END IF;

  RAISE_APPLICATION_ERROR(-20000,
       'Upgrade not supported from version ' || p_version );

END version_script;
/

Rem get the correct script name into the "upgrade_file" variable
COLUMN file_name NEW_VALUE upgrade_file NOPRINT;
SELECT version_script AS file_name FROM SYS.DUAL;

WHENEVER SQLERROR CONTINUE

Rem run the selected "c" upgrade script
@@c&upgrade_file

Rem Remove entries from sys.duc$ - rebuilt for 11g by catalog and catproc
Rem Can cause errors on any DROP USER statements in upgrade scripts
truncate table duc$;

@?/rdbms/admin/sqlsessend.sql

Rem =====================================================================
Rem END STAGE 3: dictionary upgrade
Rem =====================================================================

