Rem
Rem $Header: rdbms/admin/cdenv.sql /st_rdbms_12.1.0.1/4 2013/05/08 09:23:35 pyam Exp $
Rem
Rem cdenv.sql
Rem
Rem Copyright (c) 2006, 2013, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      cdenv.sql - Catalog DENV.bsq views
Rem
Rem    DESCRIPTION
Rem      profiles, resources, etc.
Rem
Rem    NOTES
Rem      This script contains catalog views for objects in denv.bsq.   
Rem
Rem
Rem BEGIN SQL_FILE_METADATA
Rem SQL_SOURCE_FILE: rdbms/admin/cdenv.sql
Rem SQL_SHIPPED_FILE: rdbms/admin/cdenv.sql
Rem SQL_PHASE: CATALOG_MAIN
Rem SQL_STARTUP_MODE: NORMAL
Rem SQL_IGNORABLE_ERRORS: NONE
Rem SQL_CALLING_FILE: rdbms/admin/catalog.sql
Rem END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pyam        04/25/13 - 16709641: common pwd verify fn for DBA_PROFILES
Rem    pyam        02/06/13 - add ORACLE_MAINTAINED column
Rem    surman      12/10/12 - XbranchMerge surman_bug-12876907 from main
Rem    akruglik    12/03/12 - (15926959): add DBA_PROFILES.COMMON
Rem    surman      11/14/12 - 12876907: Add ORACLE_SCRIPT
Rem    ssonawan    11/08/12 - Bug 15841138: fix expiry_date column of DBA_USERS
Rem    jmadduku    09/06/12 - Bug 14575301: Correct lock_date in DBA_USERS
Rem    pknaggs     08/13/12 - Bug #14490021: 11G in DBA_USERS.PASSWORD_VERSIONS
Rem    ssonawan    07/12/12 - bug 13843068: update dba_users and user_users
Rem    surman      03/27/12 - 13615447: Add SQL patching tags
Rem    pknaggs     12/14/11 - 13502546: add 12C to DBA_USERS.PASSWORD_VERSIONS
Rem    jmadduku    12/14/10 - Proj 32507: Add LAST_LOGIN Column to DBA_USERS
Rem    amunnoli    02/24/11 - Proj 26873:Grant select on dba_users to 
Rem                           AUDIT_ADMIN role
Rem    spetride    06/09/10 - add DBA_DIGEST_VERIFIERS
Rem    krajaman    12/26/10 - krajaman_consolidated_database_phase6
Rem    akruglik    12/21/10 - DB Consolidation: add COMMON column to \*_USERS
Rem                           and DBA_ROLES
Rem    ssonawan    02/11/08 - bug 6757203: fix DBA_USERS view definition to
Rem                           correctly describe user's authentication type 
Rem    srseshad    12/09/07 - Add column proxy_only_connect to dba_users
Rem    vigaur      01/25/07 - Bug 4758283 Changes
Rem    vigaur      12/18/06 - 
Rem    gviswana    08/25/06 - Use DECODE for EDITIONS_ENABLED
Rem    gviswana    07/27/06 - ALTER USER ENABLE EDITIONS 
Rem    rhanckel    05/19/06 - Modifing dba users. 
Rem    cdilling    05/04/06 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql


remark
remark These are table that actually enables the user to see his or her
remark limits
remark

create or replace view DBA_PROFILES
    (PROFILE, RESOURCE_NAME, RESOURCE_TYPE, LIMIT, COMMON)
as select
   n.name, m.name,
   decode(u.type#, 0, 'KERNEL', 1, 'PASSWORD', 'INVALID'),
   decode(u.limit#,
          0, 'DEFAULT',
          2147483647, decode(u.resource#,
                             4, decode(u.type#,
                                       1, 'NULL', 'UNLIMITED'),
                             'UNLIMITED'),
          decode(u.resource#,
                 4, decode(u.type#, 1, 
                           decode(bitand(n.flags,1), 1, 'FROM ROOT', o.name),
                           u.limit#),
                 decode(u.type#,
                        0, u.limit#,
                        decode(u.resource#,
                               1, trunc(u.limit#/86400, 4),
                               2, trunc(u.limit#/86400, 4),
                               5, trunc(u.limit#/86400, 4),
                               6, trunc(u.limit#/86400, 4),
                               u.limit#)))),
   decode(bitand(n.flags, 1), 1, 'YES', 'NO')
  from sys.profile$ u, sys.profname$ n, sys.resource_map m, sys.obj$ o
  where u.resource# = m.resource#
  and u.type#=m.type#
  and o.obj# (+) = u.limit#
  and n.profile# = u.profile#
/
create or replace public synonym DBA_PROFILES for DBA_PROFILES
/
grant select on DBA_PROFILES to select_catalog_role
/
comment on table DBA_PROFILES is
'Display all profiles and their limits'
/
comment on column DBA_PROFILES.PROFILE is
'Profile name'
/
comment on column DBA_PROFILES.RESOURCE_NAME is
'Resource name'
/
comment on column DBA_PROFILES.LIMIT is
'Limit placed on this resource for this profile'
/
comment on column DBA_PROFILES.COMMON is
'Is this a common profile?'
/

REM
REM  This view enables the user to see his own profile limits
REM
create or replace view USER_RESOURCE_LIMITS
    (RESOURCE_NAME, LIMIT)
as select m.name,
          decode (u.limit#, 2147483647, 'UNLIMITED',
                           0, decode (p.limit#, 2147483647, 'UNLIMITED',
                                               p.limit#),
                           u.limit#)
  from sys.profile$ u, sys.profile$ p,
       sys.resource_map m, user$ s
  where u.resource# = m.resource#
  and p.profile# = 0
  and p.resource# = u.resource#
  and u.type# = p.type#
  and p.type# = 0
  and m.type# = 0
  and s.resource$ = u.profile#
  and s.user# = userenv('SCHEMAID')
/
comment on table USER_RESOURCE_LIMITS is
'Display resource limit of the user'
/
comment on column USER_RESOURCE_LIMITS.RESOURCE_NAME is
'Resource name'
/
comment on column USER_RESOURCE_LIMITS.LIMIT is
'Limit placed on this resource'
/
create or replace public synonym USER_RESOURCE_LIMITS for USER_RESOURCE_LIMITS
/
grant select on USER_RESOURCE_LIMITS to PUBLIC with grant option
/
create or replace view USER_PASSWORD_LIMITS
    (RESOURCE_NAME, LIMIT)
as select
  m.name,
  decode(u.limit#,
         2147483647, decode(u.resource#, 4, 'NULL', 'UNLIMITED'),
         -1, 0,
         0, decode(p.limit#,
                   2147483647, decode(p.resource#, 4, 'NULL', 'UNLIMITED'),
                   -1, 0,
                   decode(p.resource#,
                          4, po.name,
                          1, trunc(p.limit#/86400, 4),
                          2, trunc(p.limit#/86400, 4),
                          5, trunc(p.limit#/86400, 4),
                          6, trunc(p.limit#/86400, 4), p.limit#)),
         decode(u.resource#,
                4, uo.name,
                1, trunc(u.limit#/86400, 4),
                2, trunc(u.limit#/86400, 4),
                5, trunc(u.limit#/86400, 4),
                6, trunc(u.limit#/86400, 4),
                u.limit#))
  from sys.profile$ u, sys.profile$ p, sys.obj$ uo, sys.obj$ po,
       sys.resource_map m, sys.user$ s
  where u.resource# = m.resource#
  and p.profile# = 0
  and p.resource# = u.resource#
  and u.type# = p.type#
  and p.type# = 1
  and m.type# = 1
  and uo.obj#(+) = u.limit#
  and po.obj#(+) = p.limit#
  and s.resource$ = u.profile#
  and s.user# = userenv('SCHEMAID')
/
comment on table USER_PASSWORD_LIMITS is
'Display password limits of the user'
/
comment on column USER_PASSWORD_LIMITS.RESOURCE_NAME is
'Resource name'
/
comment on column USER_PASSWORD_LIMITS.LIMIT is
'Limit placed on this resource'
/
create or replace public synonym USER_PASSWORD_LIMITS for USER_PASSWORD_LIMITS
/
grant select on USER_PASSWORD_LIMITS to PUBLIC with grant option
/

REM
REM  This view shows the resource cost of the system
REM
create or replace view RESOURCE_COST
    (RESOURCE_NAME, UNIT_COST)
as select m.name,c.cost
  from sys.resource_cost$ c, sys.resource_map m where
  c.resource# = m.resource#
  and m.type# = 0
  and c.resource# in (2, 4, 7, 8)
/
comment on table RESOURCE_COST is
'Cost for each resource'
/
comment on column RESOURCE_COST.RESOURCE_NAME is
'Name of resource'
/
comment on column RESOURCE_COST.UNIT_COST is
'Cost for resource'
/
create or replace public synonym RESOURCE_COST for RESOURCE_COST
/
grant select on RESOURCE_COST to PUBLIC
/

remark
remark  FAMILY "USERS"
remark  Users enrolled in the database.
remark
create or replace view USER_USERS
    (USERNAME, USER_ID, ACCOUNT_STATUS, LOCK_DATE, EXPIRY_DATE,
        DEFAULT_TABLESPACE, TEMPORARY_TABLESPACE, CREATED,
        INITIAL_RSRC_CONSUMER_GROUP, EXTERNAL_NAME, PROXY_ONLY_CONNECT, COMMON,
        ORACLE_MAINTAINED)
as
select u.name, u.user#,
       m.status,
       decode(mod(u.astatus, 16), 4, u.ltime,
                                  5, u.ltime,
                                  6, u.ltime,
                                  8, u.ltime,
                                  9, u.ltime,
                                  10, u.ltime, to_date(NULL)),
       decode(mod(u.astatus, 16),
              1, u.exptime,
              2, u.exptime,
              5, u.exptime,
              6, u.exptime,
              9, u.exptime,
              10, u.exptime,
              decode(u.ptime, '', to_date(NULL),
                decode(p.limit#, 2147483647, to_date(NULL),
                 decode(p.limit#, 0,
                   decode(dp.limit#, 2147483647, to_date(NULL), u.ptime +
                     dp.limit#/86400),
                   u.ptime + p.limit#/86400)))),
       dts.name, tts.name, u.ctime,
       nvl(cgm.consumer_group, 'DEFAULT_CONSUMER_GROUP'),
       u.ext_username,
       decode(bitand(u.spare1, 32),
              32, 'Y',
                  'N'),
       decode(bitand(u.spare1, 128), 128, 'YES', 'NO'),
       decode(bitand(u.spare1, 256), 256, 'Y', 'N')
from sys.user$ u left outer join sys.resource_group_mapping$ cgm
     on (cgm.attribute = 'ORACLE_USER' and cgm.status = 'ACTIVE' and
         cgm.value = u.name),
     sys.ts$ dts, sys.ts$ tts, sys.user_astatus_map m,
     profile$ p, profile$ dp
where u.datats# = dts.ts#
  and u.tempts# = tts.ts#
  and ((u.astatus = m.status#) or
       (u.astatus = (m.status# + 16 - BITAND(m.status#, 16))))
  and u.type# = 1
  and u.user# = userenv('SCHEMAID')
  and u.resource$ = p.profile#
  and dp.profile# = 0
  and dp.type# = 1
  and dp.resource# = 1
  and p.type# = 1
  and p.resource# = 1
/
comment on table USER_USERS is
'Information about the current user'
/
comment on column USER_USERS.USERNAME is
'Name of the user'
/
comment on column USER_USERS.USER_ID is
'ID number of the user'
/
comment on column USER_USERS.DEFAULT_TABLESPACE is
'Default tablespace for data'
/
comment on column USER_USERS.TEMPORARY_TABLESPACE is
'Default tablespace for temporary tables'
/
comment on column USER_USERS.CREATED is
'User creation date'
/
comment on column USER_USERS.INITIAL_RSRC_CONSUMER_GROUP is
'User''s initial consumer group'
/
comment on column USER_USERS.EXTERNAL_NAME is
'User external name'
/
comment on column USER_USERS.PROXY_ONLY_CONNECT is
'Whether this user can connect only through a proxy'
/
comment on column USER_USERS.COMMON is
'Indicates whether this user is Common'
/
comment on column USER_USERS.ORACLE_MAINTAINED is
'Denotes whether the user was created, and is maintained, by Oracle-supplied scripts. A user for which this has the value Y must not be changed in any way except by running an Oracle-supplied script.'
/

create or replace public synonym USER_USERS for USER_USERS
/
grant select on USER_USERS to PUBLIC with grant option
/
create or replace view ALL_USERS
    (USERNAME, USER_ID, CREATED, COMMON, ORACLE_MAINTAINED)
as
select u.name, u.user#, u.ctime,
       decode(bitand(u.spare1, 128), 128, 'YES', 'NO'),
       decode(bitand(u.spare1, 256), 256, 'Y', 'N')
from sys.user$ u, sys.ts$ dts, sys.ts$ tts
where u.datats# = dts.ts#
  and u.tempts# = tts.ts#
  and u.type# = 1
/
comment on table ALL_USERS is
'Information about all users of the database'
/
comment on column ALL_USERS.USERNAME is
'Name of the user'
/
comment on column ALL_USERS.USER_ID is
'ID number of the user'
/
comment on column ALL_USERS.CREATED is
'User creation date'
/
comment on column ALL_USERS.COMMON is
'Indicates whether this user is Common'
/
comment on column ALL_USERS.ORACLE_MAINTAINED is
'Denotes whether the user was created, and is maintained, by Oracle-supplied scripts. A user for which this has the value Y must not be changed in any way except by running an Oracle-supplied script.'
/
create or replace public synonym ALL_USERS for ALL_USERS
/
grant select on ALL_USERS to PUBLIC with grant option
/
Rem
Rem 13502546: Add SHA-512 hash "12C" to the DBA_USERS.PASSWORD_VERSIONS.
Rem Update the view comment to explain that the PASSWORD_VERSIONS column
Rem shows the list of versions of the password hashes (also known as
Rem "verifiers") existing for the user account.
Rem The PASSWORD_VERSIONS column value includes "10G" if an old 
Rem case-insensitive ORCL hash exists, "11G" if a SHA-1 hash exists, 
Rem and "12C" if a new SHA-2 based SHA-512 hash exists.  Note that any
Rem combination of these verifiers could exist for a given account.
Rem
Rem 14490021: Remember that user$.spare4 can also contain the HTTP digest 
Rem verifier (prefixed by "H:"), so checking if spare4 is non-NULL is not a
Rem proper check for the 11G (SHA-1) verifier, we need to check specifically
Rem for the presence of the "S:" prefix which marks 11G verifiers.
Rem
create or replace view DBA_USERS
    (USERNAME, USER_ID, PASSWORD, ACCOUNT_STATUS, LOCK_DATE, EXPIRY_DATE,
        DEFAULT_TABLESPACE, TEMPORARY_TABLESPACE, CREATED, PROFILE,
        INITIAL_RSRC_CONSUMER_GROUP,EXTERNAL_NAME,PASSWORD_VERSIONS,
        EDITIONS_ENABLED, AUTHENTICATION_TYPE, PROXY_ONLY_CONNECT, 
        COMMON, LAST_LOGIN, ORACLE_MAINTAINED)
as
select u.name, u.user#,
       decode(u.password, 'GLOBAL', u.password,
                          'EXTERNAL', u.password,
                          NULL), 
       m.status,
       decode(mod(u.astatus, 16), 4, u.ltime,
                                  5, u.ltime,
                                  6, u.ltime,
                                  8, u.ltime,
                                  9, u.ltime,
                                  10, u.ltime, to_date(NULL)),
       decode(mod(u.astatus, 16),
              1, u.exptime,
              2, u.exptime,
              5, u.exptime,
              6, u.exptime,
              9, u.exptime,
              10, u.exptime,
              decode(u.ptime, '', to_date(NULL),
                decode(pr.limit#, 2147483647, to_date(NULL),
                 decode(pr.limit#, 0,
                   decode(dp.limit#, 2147483647, to_date(NULL), u.ptime +
                     dp.limit#/86400),
                   u.ptime + pr.limit#/86400)))),
       dts.name, tts.name, u.ctime, p.name,
       nvl(cgm.consumer_group, 'DEFAULT_CONSUMER_GROUP'),
       u.ext_username,
       decode(length(u.password), 16, '10G ', NULL) ||
              decode(REGEXP_INSTR(NVL2(u.spare4, u.spare4, ' '),
                                  'S:'), 0, '', '11G ') ||
              decode(REGEXP_INSTR(NVL2(u.spare4, u.spare4, ' '),
                                  'T:'), 0, '', '12C '),
       decode(bitand(u.spare1, 16),
              16, 'Y',
                  'N'),
       decode(u.password, 'GLOBAL',   'GLOBAL',
                          'EXTERNAL', 'EXTERNAL',
                          'PASSWORD'),
       decode(bitand(u.spare1, 32),
              32, 'Y',
                  'N'),
       decode(bitand(u.spare1, 128), 128, 'YES', 'NO'),
       from_tz(to_timestamp(to_char(u.spare6, 'DD-MON-YYYY HH24:MI:SS'),
                            'DD-MON-YYYY HH24:MI:SS'), '0:00') 
       at time zone sessiontimezone,
       decode(bitand(u.spare1, 256), 256, 'Y', 'N')
       from sys.user$ u left outer join sys.resource_group_mapping$ cgm
            on (cgm.attribute = 'ORACLE_USER' and cgm.status = 'ACTIVE' and
                cgm.value = u.name),
            sys.ts$ dts, sys.ts$ tts, sys.profname$ p,
            sys.user_astatus_map m, sys.profile$ pr, sys.profile$ dp
       where u.datats# = dts.ts#
       and u.resource$ = p.profile#
       and u.tempts# = tts.ts#
       and ((u.astatus = m.status#) or
            (u.astatus = (m.status# + 16 - BITAND(m.status#, 16))))
       and u.type# = 1
       and u.resource$ = pr.profile#
       and dp.profile# = 0
       and dp.type#=1
       and dp.resource#=1
       and pr.type# = 1
       and pr.resource# = 1
/
create or replace public synonym DBA_USERS for DBA_USERS
/
grant select on DBA_USERS to select_catalog_role
/
grant select on DBA_USERS to AUDIT_ADMIN
/
comment on table DBA_USERS is
'Information about all users of the database'
/
comment on column DBA_USERS.USERNAME is
'Name of the user'
/
comment on column DBA_USERS.USER_ID is
'ID number of the user'
/
comment on column DBA_USERS.PASSWORD is
'Deprecated from 11.2 -- use AUTHENTICATION_TYPE instead'
/
comment on column DBA_USERS.DEFAULT_TABLESPACE is
'Default tablespace for data'
/
comment on column DBA_USERS.TEMPORARY_TABLESPACE is
'Default tablespace for temporary tables'
/
comment on column DBA_USERS.CREATED is
'User creation date'
/
comment on column DBA_USERS.PROFILE is
'User resource profile name'
/
comment on column DBA_USERS.INITIAL_RSRC_CONSUMER_GROUP is
'User''s initial consumer group'
/
comment on column DBA_USERS.EXTERNAL_NAME is
'User external name'
/
comment on column DBA_USERS.PASSWORD_VERSIONS is
'List of versions of password hashes (e.g. 11G for SHA-1, 12C for SHA-512)'
/
comment on column DBA_USERS.EDITIONS_ENABLED is
'Whether editions are enabled for this user'
/
comment on column DBA_USERS.AUTHENTICATION_TYPE is
'Authentication mechanism for the user'
/
comment on column DBA_USERS.PROXY_ONLY_CONNECT is
'Whether this user can connect only through a proxy'
/
comment on column DBA_USERS.COMMON is
'Indicates whether this user is Common'
/
comment on column DBA_USERS.ORACLE_MAINTAINED is
'Denotes whether the user was created, and is maintained, by Oracle-supplied scripts. A user for which this has the value Y must not be changed in any way except by running an Oracle-supplied script.'
/

create or replace view DBA_DIGEST_VERIFIERS 
  (USERNAME, HAS_DIGEST_VERIFIERS, DIGEST_TYPE) as 
select u.name, 'YES', 'MD5' from user$ u where instr(spare4, 'H:')>0
union
select u.name, 'NO', NULL from user$ u where not(instr(spare4, 'H:')>0) or spare4 is null
/

create or replace public synonym DBA_DIGEST_VERIFIERS for DBA_DIGEST_VERIFIERS
/
grant select on DBA_DIGEST_VERIFIERS to select_catalog_role
/

comment on table DBA_DIGEST_VERIFIERS is 
'Information about which users have Digest verifiers and the verifier types'
/

comment on column DBA_DIGEST_VERIFIERS.USERNAME is
'Name of the user'
/

comment on column DBA_DIGEST_VERIFIERS.HAS_DIGEST_VERIFIERS is
'YES if Digest verifier exist, NO otherwise'
/

comment on column DBA_DIGEST_VERIFIERS.DIGEST_TYPE is
'The type of the Digest verifier'
/

@?/rdbms/admin/sqlsessend.sql
