Rem
Rem $Header: rdbms/admin/cdrac.sql /st_rdbms_12.1.0.1/1 2013/01/03 10:52:43 surman Exp $
Rem
Rem cdrac.sql
Rem
Rem Copyright (c) 2006, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      cdrac.sql - Catalog DRAC.bsq views
Rem
Rem    DESCRIPTION
Rem      service objects
Rem
Rem    NOTES
Rem     This script contains catalog views for objects in drac.bsq. 
Rem
Rem
Rem BEGIN SQL_FILE_METADATA
Rem SQL_SOURCE_FILE: rdbms/admin/cdrac.sql
Rem SQL_SHIPPED_FILE: rdbms/admin/cdrac.sql
Rem SQL_PHASE: CATALOG_MAIN
Rem SQL_STARTUP_MODE: NORMAL
Rem SQL_IGNORABLE_ERRORS: NONE
Rem SQL_CALLING_FILE: rdbms/admin/catalog.sql
Rem END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    surman      12/10/12 - XbranchMerge surman_bug-12876907 from main
Rem    surman      11/14/12 - 12876907: Add ORACLE_SCRIPT
Rem    surman      03/27/12 - 13615447: Add SQL patching tags
Rem    skyathap    09/13/11 - gsm_flags column to dba_services view
Rem    sroesch     07/15/11 - change service$ column to sql_translation_profile
Rem    sroesch     05/04/11 - max_lag_time column to dba_services view
Rem    sroesch     01/03/11 - add new service parameters
Rem    pyam        11/22/10 - pdb as a service attribute
Rem    achoi       09/22/09 - edition as a service attribute
Rem    cdilling    05/04/06 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql


Rem Add workgroup services views
create or replace view DBA_SERVICES
as select SERVICE_ID, NAME, NAME_HASH, NETWORK_NAME,
          CREATION_DATE, CREATION_DATE_HASH,
          FAILOVER_METHOD, FAILOVER_TYPE, FAILOVER_RETRIES, FAILOVER_DELAY,
          MIN_CARDINALITY, MAX_CARDINALITY,
          decode(GOAL, 0, 'NONE', 1, 'SERVICE_TIME', 2, 'THROUGHPUT', NULL)
            GOAL,
          decode(bitand(FLAGS, 2), 2, 'Y', 'N') DTP,
          decode(bitand(FLAGS, 1), 1, 'YES', 0, 'NO') ENABLED,
          decode(bitand(NVL(FLAGS,0), 4), 4, 'YES',
                                   0, 'NO', 'NO') AQ_HA_NOTIFICATIONS,
          decode(bitand(NVL(FLAGS,0), 8), 8, 'LONG', 0, 'SHORT', 'SHORT') CLB_GOAL,
          EDITION,
          decode(bitand(NVL(FLAGS,0), 32), 32, 'YES', 0, 'NO', 'NO') COMMIT_OUTCOME,
          RETENTION_TIMEOUT,
          REPLAY_INITIATION_TIMEOUT,
          SESSION_STATE_CONSISTENCY,
          decode(bitand(NVL(FLAGS,0), 64), 64, 'YES', 0, 'NO', 'NO') GLOBAL_SERVICE,
          PDB,
          SQL_TRANSLATION_PROFILE,
          MAX_LAG_TIME,
          GSM_FLAGS
   from service$
where DELETION_DATE is null
/

comment on column DBA_SERVICES.SERVICE_ID is
'The unique ID for this service'
/

comment on column DBA_SERVICES.NAME is
'The short name for the service'
/

comment on column DBA_SERVICES.NAME_HASH is
'The hash of the short name for the service'
/

comment on column DBA_SERVICES.NETWORK_NAME is
'The network name used to connect to the service'
/

comment on column DBA_SERVICES.CREATION_DATE is
'The date the service was created'
/

comment on column DBA_SERVICES.CREATION_DATE_HASH is
'The hash of the creation date'
/

comment on column DBA_SERVICES.FAILOVER_METHOD is
'The failover method (BASIC or NONE) for the service'
/

comment on column DBA_SERVICES.FAILOVER_TYPE is
'The failover type (SESSION or SELECT) for the service'
/

comment on column DBA_SERVICES.FAILOVER_RETRIES is
'The number of retries when failing over the service'
/

comment on column DBA_SERVICES.FAILOVER_DELAY is
'The delay between retries when failing over the service'
/

comment on column DBA_SERVICES.MIN_CARDINALITY is
'The minimum cardinality of this service to be maintained by director'
/

comment on column DBA_SERVICES.MAX_CARDINALITY is
'The maximum cardinality of this service to be allowed by director'
/

comment on column DBA_SERVICES.ENABLED is
'Indicates whether or not this service will be started/maintained by director'
/

comment on column DBA_SERVICES.AQ_HA_NOTIFICATIONS is
'Indicates whether AQ notifications are sent for HA events'
/

comment on column DBA_SERVICES.GOAL is
'The service workload management goal'
/

comment on column DBA_SERVICES.DTP is
'DTP flag for services'
/

comment on column DBA_SERVICES.CLB_GOAL is
'Connection load balancing goal for services'
/

comment on column DBA_SERVICES.EDITION is
'Initial session edition for services'
/

comment on column DBA_SERVICES.COMMIT_OUTCOME is
'Commit outcome is persisted'
/

comment on column DBA_SERVICES.RETENTION_TIMEOUT is
'How long (in secs) is the commit outcome stored before it is retained'
/

comment on column DBA_SERVICES.REPLAY_INITIATION_TIMEOUT is
'How long (in secs) can transaction be replayed after transaction start '
/

comment on column DBA_SERVICES.SESSION_STATE_CONSISTENCY is
'Type of non-transactional changes during a transaction'
/

comment on column DBA_SERVICES.GLOBAL_SERVICE is
'Service is used for global service management'
/

comment on column DBA_SERVICES.PDB is
'Service is created in a pluggable database'
/

comment on column DBA_SERVICES.SQL_TRANSLATION_PROFILE is
'Name of the SQL translation profile'
/

comment on column DBA_SERVICES.MAX_LAG_TIME is
'Maximum lag time of a global service'
/

comment on column DBA_SERVICES.GSM_FLAGS is
'Flags specific to a global service'
/

create or replace public synonym DBA_SERVICES
     for DBA_SERVICES
/
grant select on DBA_SERVICES to select_catalog_role
/


create or replace view ALL_SERVICES
as select * from dba_services
/
create or replace public synonym ALL_SERVICES
     for ALL_SERVICES
/
grant select on ALL_SERVICES to select_catalog_role
/

commit;

@?/rdbms/admin/sqlsessend.sql
