Rem
Rem $Header: rdbms/admin/cmpupend.sql /main/7 2012/02/06 04:16:29 dgraj Exp $
Rem
Rem cmpupend.sql
Rem
Rem Copyright (c) 2006, 2011, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      cmpupend.sql - CoMPonent UPgrade END script
Rem
Rem    DESCRIPTION
Rem      Final component upgrade actions
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dgraj       11/12/11 - Project 32079: Upgrade action for TSDP
Rem    mdietric    03/23/11 - remove gathering stats - bug 11901407
Rem    cdilling    04/18/07 - add timestamp for gather_stats
Rem    rburns      12/07/06 - move gather_stats
Rem    cdilling    12/14/06 - add RDBMS identifier
Rem    rburns      07/19/06 - move final actions to catupend.sql 
Rem    rburns      05/22/06 - parallel upgrade 
Rem    rburns      05/22/06 - Created
Rem

set serveroutput off
set errorlogging on identifier 'ACTIONS';

SELECT dbms_registry_sys.time_stamp('ACTIONS_BGN') AS timestamp FROM DUAL;

Rem
Rem Upgrade action for TSDP
Rem

VARIABLE dbinst_name VARCHAR2(256)
COLUMN :dbinst_name NEW_VALUE dbinst_file NOPRINT

BEGIN
  IF dbms_registry.is_loaded('XDB') IS NOT NULL THEN
     :dbinst_name := '@tsdpend.sql';
  ELSE
     :dbinst_name := dbms_registry.nothing_script;
  END IF;
END;
/
SELECT :dbinst_name FROM DUAL;
@&dbinst_file

