Rem
Rem $Header: rdbms/admin/cmpupnjv.sql /st_rdbms_12.1.0.1/2 2013/01/07 19:17:02 jerrede Exp $
Rem
Rem cmpupnjv.sql
Rem
Rem Copyright (c) 2006, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      cmpupnjv.sql - CoMPonent UPgrade Non-JaVa dependent components
Rem
Rem    DESCRIPTION
Rem      Upgrade OWM, OLAP
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cdilling    12/22/12 - Move RAC to a serial phase to avoid deadlocks
Rem    jerrede     12/20/12 - DeadLock Issue Moved MGW to serial phase (alter
Rem                           type sys.mgwi_msglink mgwu102.sql)
Rem    awesley     07/13/12 - set AMD component to 'OPTION OFF' status
Rem    awesley     04/02/12 - deprecate cwm, remove AMD
Rem    cdilling    03/05/12 - remove EM processing for 12.1
Rem    jerrede     09/01/11 - Parallel Upgrade Project #23496
Rem    cdilling    03/02/11 - set EM component to 'OPTION OFF' status
Rem    sanagara    02/17/09 - move OWM to cmpupmsc.sql
Rem    rburns      01/16/08 - add reset package
Rem    cdilling    12/07/06 - Data Vault
Rem    rburns      07/19/06 - XOQ Java dependency 
Rem    cdilling    06/08/06 - add error logging support 
Rem    rburns      05/22/06 - parallel upgrade 
Rem    rburns      05/22/06 - Created
Rem

-- clear package state before running component script
EXECUTE dbms_session.reset_package;

Rem =========================================================================
Rem Exit immediately if there are errors in the initial checks
Rem =========================================================================

WHENEVER SQLERROR EXIT;

Rem check instance version and status; set session attributes
EXECUTE dbms_registry.check_server_instance;

Rem =========================================================================
Rem Continue even if there are SQL errors in remainder of script 
Rem =========================================================================

WHENEVER SQLERROR CONTINUE;

Rem Setup component script filename variables
COLUMN dbmig_name NEW_VALUE dbmig_file NOPRINT;
VARIABLE dbinst_name VARCHAR2(256)                   
COLUMN :dbinst_name NEW_VALUE dbinst_file NOPRINT

set serveroutput off

Rem =====================================================================
Rem Upgrade OLAP Analytic Workspace
Rem =====================================================================

Rem Set identifier to APS for errorlogging
SET ERRORLOGGING ON IDENTIFIER 'APS';

SELECT dbms_registry_sys.time_stamp_display('APS') AS timestamp FROM DUAL;
SELECT dbms_registry_sys.dbupg_script('APS') AS dbmig_name FROM DUAL;
@&dbmig_file
SELECT dbms_registry_sys.time_stamp('APS') AS timestamp FROM DUAL;

Rem =====================================================================
Rem If AMD is in the registry then set its status to OPTION OFF (9)
Rem =====================================================================

Rem Set identifier to AMD for errorlogging
SET ERRORLOGGING ON IDENTIFIER 'AMD';

BEGIN
  IF dbms_registry.is_loaded('AMD') IS NOT NULL THEN
   BEGIN
     sys.dbms_registry.Option_Off('AMD');
     commit;
   END;
  END IF;
END;
/

Rem =====================================================================
Rem Upgrade Oracle Label Security 
Rem =====================================================================

Rem Set identifier to OLS for errorlogging
SET ERRORLOGGING ON IDENTIFIER 'OLS';


SELECT dbms_registry_sys.time_stamp_display('OLS') AS timestamp FROM DUAL;
SELECT dbms_registry_sys.dbupg_script('OLS') AS dbmig_name FROM DUAL;
@&dbmig_file
SELECT dbms_registry_sys.time_stamp('OLS') AS timestamp FROM DUAL;

Rem =====================================================================
Rem Upgrade Oracle Data Vault
Rem =====================================================================

Rem Set identifier to DV for errorlogging
SET ERRORLOGGING ON IDENTIFIER 'DV';


SELECT dbms_registry_sys.time_stamp_display('DV') AS timestamp FROM DUAL;
SELECT dbms_registry_sys.dbupg_script('DV') AS dbmig_name FROM DUAL;
@&dbmig_file
SELECT dbms_registry_sys.time_stamp('DV') AS timestamp FROM DUAL;



