Rem
Rem $Header: rdbms/admin/dbfs_drop_filesystem.sql /main/6 2012/10/01 18:32:11 weizhang Exp $
Rem
Rem dbfs_drop_filesystem.sql
Rem
Rem Copyright (c) 2009, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      dbfs_drop_filesystem.sql - DBFS drop filesystem
Rem
Rem    DESCRIPTION
Rem      DBFS drop filesystem script
Rem      Usage: sqlplus <dbfs_user> @dbfs_drop_filesystem.sql [ -all | <table__name> ]
Rem            
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    weizhang    09/24/12 - bug 14666696: fix sql injection security bug
Rem    xihua       10/11/10 - Bug 10104462: improved method for dropping all
Rem                           file systems
Rem    weizhang    03/11/10 - bug 9220947: tidy up
Rem    weizhang    11/19/09 - Support default fsDrop FORCE
Rem    weizhang    06/12/09 - Package name change
Rem    weizhang    04/06/09 - Created
Rem

SET ECHO OFF
SET VERIFY OFF
SET FEEDBACK OFF
SET TAB OFF
SET SERVEROUTPUT ON

define tb_name = &1

--------------------------------------------------
-- Drop DBFS file system helper package
--------------------------------------------------
create or replace package dropfilesystem_q
authid current_user
as
  type dbfsrec is record(
    store_mount varchar2(256)
  );
  type dbfs_t is table of dbfsrec
    index by binary_integer;
  procedure fsDrop(
    fsname     in  varchar2,
    dbfstable  in  dbfs_t,
    mntcnt     in  number,
    force      in  boolean
  );
end dropfilesystem_q;
/

create or replace package body dropfilesystem_q
as

  function fsEnqName(v in varchar2)
    return varchar2
  is
    ret     varchar2(1024);
  begin
    ret := dbms_assert.enquote_literal(replace(v, '''', ''''''));
    return ret;
  end;
  
  procedure fsDrop (
    fsname     in  varchar2,
    dbfstable  in  dbfs_t,
    mntcnt     in  number,
    force      in  boolean
  )
  IS
    mntdir  varchar2(256);
    stmt    varchar2(32000);
  BEGIN
    -- unmount the store from all mount points
    if(mntcnt!=0) then
      for j in dbfstable.first .. dbfstable.last
      loop
        mntdir := dbfstable(j).store_mount;
        stmt := 'begin dbms_dbfs_content.unmountStore(' ||
          'store_name=>'    || fsEnqName(fsname) ||
          ', store_mount=>' || fsEnqName(mntdir) || 
          '); end;';
        dbms_output.put_line('--------');
        dbms_output.put_line('UNMOUNT STORE: ');
        dbms_output.put_line(stmt);
        begin
          execute immediate stmt;
        exception
          when others then
          -- if FORCE is set, then ignore ORA-64008 (invalid_mount)
          if (force = true) and (sqlcode = -64008) then
            dbms_output.put_line('ignore ' || sqlerrm);
            rollback;
          else
           raise;
          end if;
        end;
      end loop;
    else
      dbms_output.put_line('--------');
      dbms_output.put_line('UNMOUNT STORE: ');
      dbms_output.put_line('No mount points found. Unmount skipped.');
    end if;
  
    -- unregister the store
    stmt := 'begin dbms_dbfs_content.unregisterStore(' ||
            'store_name=> ' || fsEnqName(fsname) ||
            '); end;';
    dbms_output.put_line('--------');
    dbms_output.put_line('UNREGISTER STORE: ');
    dbms_output.put_line(stmt);
    begin
      execute immediate stmt;
    exception
      when others then
        -- if FORCE is set, then ignore ORA-64007 (invalid_store)
        if (force = true) and (sqlcode = -64007) then
          dbms_output.put_line('Ignore ' || sqlerrm);
          rollback;
        else
          raise;
        end if;
    end;

    -- drop file system
    stmt := 'begin dbms_dbfs_sfs.dropFilesystem(' ||
            'store_name => ' || fsEnqName(fsname) ||
            '); end;' ;
    dbms_output.put_line('--------');
    dbms_output.put_line('DROP STORE: ');
    dbms_output.put_line(stmt);
    execute immediate stmt;
    
    commit;
  END fsDrop;

end dropfilesystem_q;
/
show errors;

--------------------------------------------------
-- Main entry
--------------------------------------------------
declare
  dbfstb dropfilesystem_q.dbfs_t;
  type dbfs_curstype is ref cursor;
  css dbfs_curstype;
  csm dbfs_curstype;
  fs_name varchar2(32);
  i number;

begin
  if('&tb_name'!='-all') then
    open css for
      select store_name from table(dbms_dbfs_sfs.listFilesystems) 
        where table_name='&tb_name';
    loop
      fetch css into fs_name;
      EXIT WHEN css%NOTFOUND;
    end loop;
    --store name should exist and be unique for each table
    declare
      unique_store_name EXCEPTION;
    begin
      if(css%rowcount != 1) then 
        raise unique_store_name;
      end if;
    EXCEPTION
      when unique_store_name then
        dbms_output.put_line('Error: invalid table specified '||
         '/ unique store constraint violated');
    end;
    close css;
    i := 1;
    open csm for
      select store_mount from table(dbms_dbfs_content.listMounts) 
        where store_name=fs_name;
    loop
      fetch csm into dbfstb(i);
      EXIT WHEN csm%NOTFOUND;
      i := i+1;
    end loop;
    dropfilesystem_q.fsDrop(fs_name, dbfstb, csm%rowcount, true);
    close csm;
  else
    open css for
      select store_name from table(dbms_dbfs_sfs.listFilesystems); 
    loop
      fetch css into fs_name;
      EXIT WHEN css%NOTFOUND;
      i := 1;
      open csm for
        select store_mount from table(dbms_dbfs_content.listMounts) 
          where store_name=fs_name;
      loop
        fetch csm into dbfstb(i);
        EXIT WHEN csm%NOTFOUND;
        i := i+1;
      end loop;
      dropfilesystem_q.fsDrop(fs_name, dbfstb, csm%rowcount, true);
      close csm;
    end loop;
    close css;
  end if;
exception
  when others then
    rollback;
    dbms_output.put_line('ERROR: ' || sqlcode || ' msg: ' || sqlerrm);
    raise;
end;
/
show errors;

drop package dropfilesystem_q;

undefine tb_name

