Rem
Rem $Header: rdbms/admin/dbmsgwmco.sql /main/12 2012/10/15 09:21:01 sdball Exp $
Rem
Rem dbmsgwmco.sql
Rem
Rem Copyright (c) 2011, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      dbmsgwmco.sql - Global Workload Management administration
Rem
Rem    DESCRIPTION
Rem      Defines the interfaces for dbms_gsm_common package that is used
Rem      for common definitions and procedures used for GSM.
Rem
Rem    NOTES
Rem      This package should not contain any definitions or functions
Rem      that require that the GSM cloud catalog tables be defined on the 
Rem      database.
Rem
Rem      It is primarily for defintions and functions shared by the
Rem      dbms_gsm_dbadmin and dbms_gsm_pooladmin/dbms_gsm_cloudadmin
Rem      packages.  It is loaded on both global service databases and the
Rem      GSM cloud catalog database.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sdball      10/05/12 - Add checkDBCompat
Rem    sdball      08/28/12 - Add gwmSubnet
Rem    sdball      08/21/12 - Add services_t and related types for service
Rem                           checking in verify
Rem    sdball      08/02/12 - Add reRegisterDB
Rem    sdball      06/28/12 - Add serviceChange definition
Rem    sdball      06/13/12 - Change default max instances to 10
Rem    sdball      06/07/12 - Add factoring.
Rem    sdball      05/18/12 - Add getMsg
Rem    sdball      04/24/12 - Add instance_list
Rem    skyathap    11/10/11 - constants for service_context
Rem    skyathap    11/04/11 - constants for service_context
Rem    nbenadja    09/20/11 - Add tracing functions
Rem    skyathap    08/19/11 - tweak constants for service definition to use in
Rem                           gsm_flags
Rem    nbenadja    08/12/11 - Add function existGSM().
Rem    mdilman     07/09/11 - add constants for RAC specific service parameters
Rem    mjstewar    04/26/11 - Created
Rem

-- SET ECHO ON
-- SPOOL dbmsgwmco.log

--*****************************************************************************
-- Public Types Needed for Package
--*****************************************************************************

-- Needed so that "create or replace" will work below
BEGIN

EXECUTE IMMEDIATE 'DROP TYPE gsm_list_t';
EXCEPTION
WHEN others THEN
  IF sqlcode = -4043 THEN NULL;
       -- suppress error for non-existent type
  ELSE raise;
  END IF;

END;
/

BEGIN

EXECUTE IMMEDIATE 'DROP TYPE region_list_t';
EXCEPTION
WHEN others THEN
  IF sqlcode = -4043 THEN NULL;
       -- suppress error for non-existent type
  ELSE raise;
  END IF;

END;
/

CREATE OR REPLACE TYPE gsm_t IS OBJECT ( name      varchar2(30),
                                         endpoint  varchar2(4000),
                                         ons_port  number,
                                         region    varchar2(30) );
/

CREATE OR REPLACE TYPE region_t IS OBJECT ( name      varchar2(30),
                                            buddy     varchar2(30) );
/

CREATE OR REPLACE TYPE instance_t IS OBJECT ( virt_name      varchar2(30),
                                              instance_name  varchar2(30) );
/

CREATE OR REPLACE TYPE service_t IS OBJECT (svc_name        varchar2(64),
                                  svc_network_name              varchar2(512),
                                  svc_failover_method           varchar2(64),
                                  svc_failover_type             varchar2(64),
                                  svc_failover_retries          number(10),
                                  svc_failover_delay            number(10),
                                  svc_runtime_balance           varchar2(12),
                                  svc_dtp                       varchar2(1),
                                  svc_notification              varchar2(3),
                                  svc_load_balance              varchar2(5),
                                  svc_edition                   varchar2(128),
                                  svc_commit_outcome            varchar2(3),
                                  svc_retention_timeout         number,
                                  svc_replay_initiation_timeout number,
                                  svc_session_state_consistency varchar2(128),
                                  svc_pdb                       varchar2(128),
                                  svc_sql_translation_profile   varchar2(261),
                                  svc_lag                       varchar(128),
                                  svc_locality                  number,
                                  svc_region_failover           number);
/
show errors

GRANT execute on gsmadmin_internal.gsm_t to PUBLIC;
GRANT execute on gsmadmin_internal.region_t to PUBLIC;
GRANT execute on gsmadmin_internal.instance_t to PUBLIC;
GRANT execute on gsmadmin_internal.service_t to PUBLIC;


CREATE OR REPLACE TYPE gsm_list_t IS TABLE OF gsm_t;
/

CREATE OR REPLACE TYPE region_list_t IS TABLE OF region_t;
/

CREATE OR REPLACE TYPE instance_list_t IS TABLE OF instance_t;
/

CREATE OR REPLACE TYPE service_list_t IS TABLE OF service_t;
/

GRANT execute on gsmadmin_internal.gsm_list_t to PUBLIC;
GRANT execute on gsmadmin_internal.region_list_t to PUBLIC;
GRANT execute on gsmadmin_internal.instance_list_t to PUBLIC;
GRANT execute on gsmadmin_internal.service_list_t to PUBLIC;

CREATE OR REPLACE TYPE gsm_info IS OBJECT (cloud_name     varchar2(30),
                                           dbpool_name    varchar2(30),
                                           region_name    varchar2(30),
                                           database_num   number,
                                           gsm_list       gsm_list_t,
                                           instance_list  instance_list_t,
                                           region_list    region_list_t,
                                           service_list   service_list_t,
                                           scan_name      varchar2(30),
                                           ons_port       number,
                                           dbrole         varchar(30));
/
show errors

GRANT execute on gsmadmin_internal.gsm_info to PUBLIC;
/
show errors

CREATE OR REPLACE TYPE message_param is OBJECT (param_string varchar2(30));
/

CREATE OR REPLACE TYPE message_param_list is varray(8) of message_param;
/

GRANT EXECUTE ON gsmadmin_internal.message_param_list TO PUBLIC;
/

GRANT EXECUTE ON gsmadmin_internal.message_param TO PUBLIC;
/
show errors

--*****************************************************************************
-- Database package for common GSM functions and definitions.
--*****************************************************************************

CREATE OR REPLACE PACKAGE dbms_gsm_common AS


--*****************************************************************************
-- Package Public Types
--*****************************************************************************


--*****************************************************************************
-- Package Public Constants
--*****************************************************************************

max_inst_param_name     constant    varchar2(25) := '_gsm_max_instances_per_db';
max_inst_default        constant    number := 10;

max_regions_param_name  constant    varchar2(20) := '_gsm_max_num_regions';
max_regions_default     constant    number := 10;

gsm_parameter_name           constant varchar2(10) := '_gsm';
region_list_parameter_name   constant varchar2(16) := '_gsm_region_list';

-------------------------------------------------------------------------------
-- Service definitions
-- These constants are stored in the 'service' table and used in the 
-- 'addService' routines in the dbms_gsm_pooladmin and dbms_gsm_dbadmin
-- packages.
-------------------------------------------------------------------------------

-- DB Role
db_role_none           constant  number := 0;
db_role_primary        constant  number := 1;
db_role_phys_stby      constant  number := 2;
db_role_log_stby       constant  number := 3;
db_role_snap_stby      constant  number := 4;

-- RLB Goal
rlb_goal_none          constant  number := 0;
rlb_goal_service_time  constant  number := 1;
rlb_goal_throughput    constant  number := 2;

-- CLB Goal
clb_goal_none          constant  number := 0;
clb_goal_short         constant  number := 1;
clb_goal_long          constant  number := 2;

-- TAF policy
taf_none               constant  number := 0;
taf_basic              constant  number := 1;
taf_preconnect         constant  number := 2;

-- Policy
policy_manual          constant  number := 1;
policy_automatic       constant  number := 2;

-- Failover Method
failover_none          constant  varchar2(5) := 'NONE';
failover_basic         constant  varchar2(6) := 'BASIC';

-- Failover Type
failover_type_none     constant  varchar2(5)  := 'NONE';
failover_type_session  constant  varchar2(8)  := 'SESSION';
failover_type_select   constant  varchar2(7)  := 'SELECT';
failover_type_transact constant  varchar2(12) := 'TRANSACTION';

-- Commit Outcome
commit_outcome_off     constant  number := 0;
commit_outcome_on      constant  number := 1; 

-- Session State Consistency
session_state_static   constant  varchar2(7)  := 'STATIC';
session_state_dynamic  constant  varchar2(8)  := 'DYNAMIC';

-- Distributed Transaction
dtp_off                constant  number := 0;
dtp_on                 constant  number := 1; 

-- Preferred ALL DBS?
select_dbs             constant  number := 0;
prefer_all_dbs         constant  number := 1;

-- Failover Primary
failover_primary_off   constant  number := 0;
failover_primary_on    constant  number := 1;

-- HA Notification
ha_notification_off    constant  number := 0;
ha_notification_on     constant  number := 1;

-- AQ FAN Notification
aq_off                 constant  number := 0;
aq_on                  constant  number := 1;

-- Lag
any_lag                constant  number := 1;
specified_lag          constant  number := 0;

-- GSM_FLAGS - handy bitfield to pass several attributes to the db
-- attribute positions are specified here
gsmflagpos_locality    constant  number := 0;
gsmflagpos_regionfo    constant  number := 1;

-- Locality
service_anywhere       constant  number := 0;
service_local_only     constant  number := 1;

-- Region Failover
region_failover_off    constant  number := 0;
region_failover_on     constant  number := 1;

-- Instance Cardinality on RAC
cardinality_uniform    constant  varchar2(8)  := 'UNIFORM';
cardinality_singleton  constant  varchar2(10) := 'SINGLETON';

-- Service Reference while calling dbms_service_prvt to control whether
--  the call applies to the service definition in the DB &/or OCR
srvc_context_is_db     constant number := 1;
srvc_context_is_ocr    constant number := 2;


--*****************************************************************************
-- Package Public Exceptions
--*****************************************************************************


--*****************************************************************************
-- Package Public Procedures
--*****************************************************************************

-------------------------------------------------------------------------------
--
-- PROCEDURE     setGSMParameter
--
-- Description:
--       Changes the value of the _gsm parameter on a database.       
--
-- Parameters:
--       operation: "add_gsms" -> appends the input list to the current
--                                parameter value
--                  "replace_all_gsms" -> replaces the current parameter
--                                value with the input list
--                  "remove_gsms" -> removes the input list from the
--                                current parameter value
--                  "modify_gsms" -> modify one or more gsm entries
--       gsms: a list of GSMS to add/replace/remove
--
-- Notes:
--    
------------------------------------------------------------------------------- 

add_gsms                constant number := 0;
replace_all_gsms        constant number := 1;
remove_gsms             constant number := 2;
modify_gsms             constant number := 3;

PROCEDURE setGSMParameter( operation IN number,
                           gsms      IN gsm_list_t );

-------------------------------------------------------------------------------
--
-- PROCEDURE     setRegionListParameter
--
-- Description:
--       Changes the value of the _gsm_region_list parameter on a database.       
--
-- Parameters:
--       operation: "add_regions" -> appends the input list to the current
--                                   parameter value
--                  "remove_regions" -> removes the input list from the
--                                      current parameter value
--                  "modify_regions" -> modify one or more region entries
--       regions: a list of regions to add/replace/remove
--
-- Notes:
--    
------------------------------------------------------------------------------- 

add_regions                constant number := 0;
remove_regions             constant number := 1;
modify_regions             constant number := 2;

PROCEDURE setRegionListParameter( operation IN number,
                                  regions   IN region_list_t );

-------------------------------------------------------------------------------
--
-- FUNCTION    existGSM 
--
-- Description:
--       Checks if a gsm_alias already in the _gsm parameter on a database.       
--
-- Parameters:
--       gsm_alias: the name of the GSM. 
--
-- Returns :
--   TRUE : if the gsm_alias exists.
--   FALSE : otherwise.
--
-- Notes:
------------------------------------------------------------------------------- 

FUNCTION existGSM( gsm_alias varchar2) RETURN boolean;

-------------------------------------------------------------------------------
--
-- FUNCTION    isGWMTracing 
--
-- Description:
--       Checks if GWM module tracing is enabled.       
--
-- Parameters:
--       Nome 
--
-- Returns :
--   TRUE : if the GWM sql tracing is enabled.
--   FALSE : otherwise.
--
-- Notes:
------------------------------------------------------------------------------- 

FUNCTION isGWMTracing RETURN boolean;

-------------------------------------------------------------------------------
--
-- FUNCTION    reRegisterDB
--
-- Description:
--       Re-registers database with GSM listeners after some change       
--
-- Parameters:
--       Nome 
--
-- Returns :
--       NONE
--
-- Notes:
-------------------------------------------------------------------------------

PROCEDURE reRegisterDB;

-------------------------------------------------------------------------------
--
-- FUNCTION    checkDBCompat
--
-- Description:
--       Check that database level is compatible with GDS      
--
-- Parameters:
--       None
--
-- Returns :
--       BOOLEAN
--
-- Notes:
-------------------------------------------------------------------------------
FUNCTION checkDBCompat
RETURN BOOLEAN;

-------------------------------------------------------------------------------
--
-- PROCEDURE    writeToGWMTracing 
--
-- Description:
--       prints using the GWM tracing mechanism.       
--
-- Parameters:
--      phrase : text to write 
--
-- Returns :
--      None.
--
-- Notes:
------------------------------------------------------------------------------- 

PROCEDURE writeToGWMTracing(phrase IN varchar2);

----------------------------------------------------------------------
-- Factoring. Is GDS licensed? (currently requires enterprise edition)
----------------------------------------------------------------------
PROCEDURE gwmFactor;

PROCEDURE region_params_to_region_list( region_list    OUT    region_list_t );
PROCEDURE gsm_params_to_gsm_list( gsm_list    OUT    gsm_list_t );
--------------------------------------------------------------
-- gets Message text given message number and parameters
--------------------------------------------------------------
PROCEDURE getMsg (message_number IN     binary_integer,
                  message_text   OUT    varchar2,
                  params         IN     message_param_list);
----------------------------------------------------------
--
-- PROCEDURE    serviceChange 
--
-- Description:
--       Signal a service change for registration    
--
-- Parameters:
--      NONE
--
-- Returns :
--      None.
--
-- Notes:
----------------------------------------------------------
PROCEDURE  serviceChange;

----------------------------------------------------------
--
-- PROCEDURE     gwmSubnet
--
-- Description:
--        Get subnet string for this host (RAC only)   
--
-- Parameters:
--      subnet       OUT    returned subnet string
--
-- Returns :
--      None.
--
-- Notes:
----------------------------------------------------------

PROCEDURE gwmSubnet (subnet OUT varchar2);

--*****************************************************************************
-- End of Package Public Procedures
--*****************************************************************************

END dbms_gsm_common;
/

show errors

