Rem
Rem $Header: rdbms/admin/dbmsgwmdb.sql /main/8 2012/11/13 18:20:34 itaranov Exp $
Rem
Rem dbmsgsmdb.sql
Rem
Rem Copyright (c) 2011, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      dbmsgwsmdb.sql - Global Workload Management DataBase administration 
Rem
Rem    DESCRIPTION
Rem      Defines the interface for dbms_gsm_dbadmin package that is used for 
Rem      database administration performed by GSM 
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    itaranov    11/01/12 - Split modifyService in two functions
Rem    sdball      06/13/12 - Support for number of instances
Rem    sdball      04/24/12 - Support for cross-chck verification
Rem    sdball      03/26/12 - Change addDatabase params
Rem    sdball      11/30/11 - Auto VNCR functionality
Rem    zzeng       11/21/11 - Change default for proxy_db,delete_to_move to 0
Rem    skyathap    11/10/11 - add proxy info to service routines
Rem    nbenadja    10/28/11 - Add revomeAllServices procedure
Rem    mdilman     10/24/11 - add proxy_database and primary_database params
Rem    mdilman     08/11/11 - add getCRSinfo
Rem    skyathap    08/10/11 - Add locality info to service routines
Rem    mdilman     07/26/11 - add modifyGSM and modifyDatabase
Rem    mdilman     07/09/11 - add RAC specific service attributes
Rem    mjstewar    04/27/11 - Second GSM transaction
Rem    lenovak     03/01/11 - remove and validate procedures  
Rem    mdilman     02/07/11 - add procedures
Rem    mjstewar    02/02/11 - Created
Rem

-- SET ECHO ON
-- SPOOL dbmsgwmdb.log

--*****************************************************************************
-- Database package for GSM pool database functions.
--*****************************************************************************

CREATE OR REPLACE PACKAGE dbms_gsm_dbadmin AS

  -----------------------------------------------------------------------------
  --
  -- PROCEDURE     addDatabase
  --
  -- Description:  
  -- 
  -- Parameters:   
  --   cloud_name
  --   dbpool_name
  --   region_name
  --   db_number 
  --   num_instances_reserved
  --
  -- Notes:
  --    
  -----------------------------------------------------------------------------
  PROCEDURE addDatabase( cloud_name              IN varchar2,
			 dbpool_name             IN varchar2,  
			 region_name             IN varchar2, 
			 db_number               IN number,
             num_instances_reserved  IN number 
                  default dbms_gsm_common.max_inst_default,
             force                   IN number 
                  default dbms_gsm_utility.updateFalse); 

  -----------------------------------------------------------------------------
  --
  -- PROCEDURE     modifyDatabase
  --
  -- Description: changes the region of the database 
  -- 
  -- Parameters:   
  --   region_name
  --
  -- Notes:
  --    
  -----------------------------------------------------------------------------
  PROCEDURE modifyDatabase( region_name          IN varchar2 );

  -----------------------------------------------------------------------------
  --
  -- PROCEDURE     validateDatabase
  --
  -- Description:  
  -- 
  -- Parameters:   
  --   dbpool 
  --   db_unique_name
  --
  -- Notes:
  --    
  -----------------------------------------------------------------------------
  PROCEDURE validateDatabase( dbpool         IN  varchar2,
                              db_unique_name OUT varchar2,
                              instances      OUT number);
   PROCEDURE validateDatabase( dbpool         IN  varchar2,
                              db_unique_name OUT varchar2);
  -----------------------------------------------------------------------------
  --
  -- PROCEDURE     removeDatabase
  --
  -- Description:  
  -- 
  -- Parameters:   
  --
  -- Notes:
  --    
  -----------------------------------------------------------------------------
  PROCEDURE removeDatabase;

  -----------------------------------------------------------------------------
  --
  -- PROCEDURE    addGSM 
  --
  -- Description:  
  -- 
  -- Parameters:   
  --   gsm_alias   
  --   endpoint
  --   region_name 
  --   ons_port
  --
  -- Notes:
  --    
  -----------------------------------------------------------------------------
  PROCEDURE addGSM( gsm_alias      IN  varchar2,
                    endpoint       IN  varchar2,
                    region_name    IN  varchar2,
                    ons_port       IN  number );

  -----------------------------------------------------------------------------
  --
  -- PROCEDURE    modifyGSM 
  --
  -- Description:  
  -- 
  -- Parameters:   
  --   gsm_alias   
  --   endpoint
  --   region_name 
  --   ons_port
  --
  -- Notes:
  --    
  -----------------------------------------------------------------------------
  PROCEDURE modifyGSM( gsm_alias   IN  varchar2,
                       endpoint    IN  varchar2 default NULL,
                       region_name IN  varchar2 default NULL,
                       ons_port    IN  number   default NULL );

  -----------------------------------------------------------------------------
  --
  -- PROCEDURE     removeGSM
  --
  -- Description:  
  -- 
  -- Parameters:   
  --
  -- Notes:
  --    
  -----------------------------------------------------------------------------
  PROCEDURE removeGSM( gsm_alias   IN varchar2 );


  -----------------------------------------------------------------------------
  --
  -- PROCEDURE     addService
  --
  -- Description:  Creates a new global service in the database and CRS
  -- 
  -- Parameters:   
  --   service_name - short name of the service in the data dictionary
  --   network_name - long service name used in SQLNet connect descriptors  
  --   rlb_goal - RLB goal (service time, throuput, none)
  --   clb_goal - CLB goal (short, long)
  --   distr_trans - enables distributed transaction processing  
  --   aq_notifications - enables AQ notfications 
  --   aq_ha_notifications - used to disable HA AQ notfications 
  --   lag_property - determines whether specified max lag should be enforced  
  --   max_lag_value - maximum acceptable value for replication lag 
  --   failover_method - TAF failover method  
  --   failover_type - TAF failover type
  --   failover_retries - TAF failover retries     
  --   failover_delay - TAF failover delay 
  --   edition  - databse edition
  --   pdb - privite db id 
  --   parameters for transaction continuity:
  --     commit_outcome   
  --     retention_timeout 
  --     replay_initiation_timeout 
  --     session_state_consistency 
  --   sql_translation_profile - directs how to interpret non-Oracle SQL 
  --   role - database role (primary or physical/logical/snapshot standby)
  --   proxy_db - TRUE if service is created on primary database 
  --                    to be used on standby(s) 
  --   primary_db - TRUE if this is primary database (OUT parameter)
  --
  -- Note:
  --   Constants for use in arguments are defined in dbms_gsm_common
  -----------------------------------------------------------------------------
  PROCEDURE addService( service_name              IN varchar2,
                        network_name              IN varchar2,
                        rlb_goal                  IN number default NULL,
                        clb_goal                  IN number default NULL,
                        distr_trans               IN number default NULL,
                        aq_notifications          IN number default NULL,
                        aq_ha_notifications       IN number default NULL,
                        lag_property              IN number default NULL,
                        max_lag_value             IN number default NULL,
                        failover_method           IN varchar2 default NULL,
                        failover_type             IN varchar2 default NULL,
                        failover_retries          IN number default NULL,
                        failover_delay            IN number default NULL,
                        edition                   IN varchar2 default NULL,
                        pdb                       IN varchar2 default NULL,
                        commit_outcome            IN number default NULL,
                        retention_timeout         IN number default NULL,
                        replay_initiation_timeout IN number default NULL,
                        session_state_consistency IN varchar2 default NULL,
                        sql_translation_profile   IN varchar2 default NULL,
                        locality                  IN number default NULL,
                        region_failover           IN number default NULL,
                        role                      IN number default NULL,
                        proxy_db                  IN number default 0,
                        primary_db                OUT number );

  -----------------------------------------------------------------------------
  --
  -- PROCEDURE     modifyService
  --
  -- Description:  Modifies all attributes of a global service 
  -- 
  -- Parameters:   
  --   service_name - short name of the service in the data dictionary
  --   rlb_goal - RLB goal (service time, throuput, none)
  --   clb_goal - CLB goal (short, long)
  --   distr_trans - enables distributed transaction processing  
  --   aq_notifications - enables AQ notfications 
  --   aq_ha_notifications - used to disable HA AQ notfications 
  --   lag_property - determines whether specified max lag should be enforced  
  --   max_lag_value - maximum acceptable value for replication lag 
  --   failover_method - TAF failover method  
  --   failover_type - TAF failover type
  --   failover_retries - TAF failover retries     
  --   failover_delay - TAF failover delay 
  --   edition  - databse edition
  --   pdb - privite db id 
  --   parameters for transaction continuity:
  --     commit_outcome   
  --     retention_timeout 
  --     replay_initiation_timeout 
  --     session_state_consistency 
  --   sql_translation_profile - directs how to interpret non-Oracle SQL 
  --   role - database role (primary or physical/logical/snapshot standby)
  --   network_number - network interface number to access the service
  --   server_pool - name of the server pool for the service
  --   cardinality - service cardinality on RAC (singleton or uniform)
  --   proxy_db - TRUE if service is modified on primary database 
  --                    to propagate modifications to standby(s) 
  --   primary_db - TRUE if this is primary database (OUT parameter)
  --
  -- Note:
  --   Constants for use in arguments are defined in dbms_gsm_common
  --   Depricated, use 
  --     modifyServiceLocalParameters or
  --     modifyServiceGlobalParameters instead
  -----------------------------------------------------------------------------
  PROCEDURE modifyService( service_name           IN varchar2,
                        rlb_goal                  IN number default NULL,
                        clb_goal                  IN number default NULL,
                        distr_trans               IN number default NULL,
                        aq_notifications          IN number default NULL,
                        aq_ha_notifications       IN number default NULL,
                        lag_property              IN number default NULL,
                        max_lag_value             IN number default NULL,
                        failover_method           IN varchar2 default NULL,
                        failover_type             IN varchar2 default NULL,
                        failover_retries          IN number default NULL,
                        failover_delay            IN number default NULL,
                        edition                   IN varchar2 default NULL,
                        pdb                       IN varchar2 default NULL,
                        commit_outcome            IN number default NULL,
                        retention_timeout         IN number default NULL,
                        replay_initiation_timeout IN number default NULL,
                        session_state_consistency IN varchar2 default NULL,
                        sql_translation_profile   IN varchar2 default NULL,
                        locality                  IN number default NULL,
                        region_failover           IN number default NULL,
                        role                      IN number default NULL,
                        network_number            IN number default NULL,
                        server_pool               IN varchar2 default NULL,
                        cardinality               IN varchar2 default NULL,
                        proxy_db                  IN number default 0,
                        primary_db                OUT number );


  -----------------------------------------------------------------------------
  --
  -- PROCEDURE     modifyServiceLocalParameters
  --
  -- Description:  Modifies all local attributes of a global service 
  -- 
  -- Parameters:   
  --   service_name - short name of the service in the data dictionary
  --
  --   network_number - network interface number to access the service
  --   server_pool - name of the server pool for the service
  --   cardinality - service cardinality on RAC (singleton or uniform)
  -- 
  --   proxy_db - TRUE if service is modified on primary database 
  --                    to propagate modifications to standby(s) 
  --   primary_db - TRUE if this is primary database (OUT parameter)
  --
  -- Note:
  --   Constants for use in arguments are defined in dbms_gsm_common.
  -----------------------------------------------------------------------------

   PROCEDURE modifyServiceLocalParameters(
                        service_name              IN varchar2,
                        network_number            IN number,
                        server_pool               IN varchar2,
                        cardinality               IN varchar2);

  -----------------------------------------------------------------------------
  --
  -- PROCEDURE     modifyServiceGlobalParameters
  --
  -- Description:  Modifies all global attributes of a global service 
  -- 
  -- Parameters:   
  --   service_name - short name of the service in the data dictionary
  --
  --   rlb_goal - RLB goal (service time, throuput, none)
  --   clb_goal - CLB goal (short, long)
  --   distr_trans - enables distributed transaction processing  
  --   aq_notifications - enables AQ notfications 
  --   aq_ha_notifications - used to disable HA AQ notfications 
  --   lag_property - determines whether specified max lag should be enforced  
  --   max_lag_value - maximum acceptable value for replication lag 
  --   failover_method - TAF failover method  
  --   failover_type - TAF failover type
  --   failover_retries - TAF failover retries     
  --   failover_delay - TAF failover delay 
  --   edition  - databse edition
  --   pdb - privite db id 
  --   parameters for transaction continuity:
  --     commit_outcome   
  --     retention_timeout 
  --     replay_initiation_timeout 
  --     session_state_consistency 
  --   sql_translation_profile - directs how to interpret non-Oracle SQL 
  --   role - database role (primary or physical/logical/snapshot standby)
  --
  --   proxy_db - TRUE if service is modified on primary database 
  --                    to propagate modifications to standby(s) 
  --   primary_db - TRUE if this is primary database (OUT parameter)
  --
  -- Note:
  --   Constants for use in arguments are defined in dbms_gsm_common.
  --   This procedure sets all of the parameters to the given values.
  -----------------------------------------------------------------------------

  PROCEDURE modifyServiceGlobalParameters(
                        service_name              IN varchar2,
                        rlb_goal                  IN number,
                        clb_goal                  IN number,
                        distr_trans               IN number,
                        aq_notifications          IN number,
                        aq_ha_notifications       IN number,
                        lag_property              IN number,
                        max_lag_value             IN number,
                        failover_method           IN varchar2,
                        failover_type             IN varchar2,
                        failover_retries          IN number,
                        failover_delay            IN number,
                        edition                   IN varchar2,
                        pdb                       IN varchar2,
                        commit_outcome            IN number,
                        retention_timeout         IN number,
                        replay_initiation_timeout IN number,
                        session_state_consistency IN varchar2,
                        sql_translation_profile   IN varchar2,
                        locality                  IN number,
                        region_failover           IN number,
                        role                      IN number,
                        proxy_db                  IN number,
                        primary_db                OUT number);





  -----------------------------------------------------------------------------
  --
  -- PROCEDURE     removeService
  --
  -- Description:  Removes a service from CRS and / or the database.  
  -- 
  -- Parameters:   
  --   service_name
  --   proxy_db - TRUE if service is removed on primary database 
  --                    to be removed on standby(s) 
  --   delete_to_move - TRUE if service is removed to be moved to another db
  --   primary_db - TRUE if this is primary database (OUT parameter)

  --
  -- Notes:
  --    
  -----------------------------------------------------------------------------
  PROCEDURE removeService( service_name           IN varchar2,
                           proxy_db               IN number default 0,
                           delete_to_move         IN number default 0,
                           primary_db             OUT number );

  -----------------------------------------------------------------------------
  --
  -- PROCEDURE     startService
  --
  -- Description:  
  -- 
  -- Parameters:   
  --   service_name
  --
  -- Notes:
  --    
  -----------------------------------------------------------------------------
  PROCEDURE startService( service_name IN varchar2 );

  -----------------------------------------------------------------------------
  --
  -- PROCEDURE     stopService
  --
  -- Description:  
  -- 
  -- Parameters:   
  --   service_name
  --
  -- Notes:
  --    
  -----------------------------------------------------------------------------
  PROCEDURE stopService( service_name IN varchar2 );

  -----------------------------------------------------------------------------
  --
  -- PROCEDURE     addRegion
  --
  -- Description:  
  -- 
  -- Parameters:   
  --   service_name
  --
  -- Notes:
  --    
  -----------------------------------------------------------------------------
  PROCEDURE addRegion( region_name  IN varchar2,
                       buddy_region IN varchar2 default NULL);

  -----------------------------------------------------------------------------
  --
  -- PROCEDURE    modifyRegion 
  --
  -- Description:  
  -- 
  -- Parameters:   
  --   region_name
  --   buddy_region
  --
  -- Notes:
  --    
  -----------------------------------------------------------------------------
  PROCEDURE modifyRegion( region_name  IN varchar2,
                          buddy_region IN varchar2 default NULL);

  -----------------------------------------------------------------------------
  --
  -- PROCEDURE     removeRegion
  --
  -- Description:  
  -- 
  -- Parameters:   
  --   region_name
  --
  -- Notes:
  --    

  -----------------------------------------------------------------------------
  PROCEDURE removeRegion( region_name IN varchar2 );
  -----------------------------------------------------------------------------
  --
  -- PROCEDURE    getHostInfo 
  --
  -- Description:  
  --       Gets information about connected host for GSM
  -- 
  -- Parameters:   
  --   ons_port   OUT   ONS port number
  --   scan_name  OUT   Cluster SCAN name (if appropriate)
  --   hostname   OUT   connected server host
  --
  -- Notes:
  --    
  -----------------------------------------------------------------------------
  
  PROCEDURE getHostInfo (ons_port OUT varchar2,
                         scan_name OUT varchar2,
                         hostname OUT varchar2);
  -----------------------------------------------------------------------------
  --
  -- PROCEDURE    getCRSinfo 
  --
  -- Description:  
  -- 
  -- Parameters:   
  --   ons_port
  --   scan_name 
  --
  -- Notes:
  --    
  -----------------------------------------------------------------------------
  PROCEDURE getCRSinfo( ons_port OUT varchar2, scan_name OUT varchar2 );
  
  -----------------------------------------------------------------------------
  --
  -- PROCEDURE    getGSMinfo
  --
  -- Description:  
  -- 
  -- Parameters:   
  -- Notes:
  --    
  -----------------------------------------------------------------------------
  FUNCTION getGSMInfo
  return gsm_info;
  
 
  -----------------------------------------------------------------------------
  --
  -- PROCEDURE    removeAllServices 
  --
  -- Description: stop and delete all the global services. 
  -- 
  -- Parameters:  None 
  --
  -- Notes:
  --    

  PROCEDURE removeAllServices;

  END dbms_gsm_dbadmin;

/

show errors

