Rem
Rem $Header: rdbms/admin/dbmshtdb.sql /st_rdbms_12.1.0.1/1 2013/01/03 10:52:44 surman Exp $
Rem
Rem dbmshtdb.sql
Rem
Rem Copyright (c) 2005, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      dbmshtdb.sql - DBMS HTmlDB system resource package
Rem
Rem    DESCRIPTION
Rem    This package can be used to verify htmldb system state
Rem
Rem    NOTES
Rem
Rem
Rem BEGIN SQL_FILE_METADATA
Rem SQL_SOURCE_FILE: rdbms/admin/dbmshtdb.sql
Rem SQL_SHIPPED_FILE: rdbms/admin/dbmshtdb.sql
Rem SQL_PHASE: CATPDBMS_MAIN
Rem SQL_STARTUP_MODE: NORMAL
Rem SQL_IGNORABLE_ERRORS: NONE
Rem SQL_CALLING_FILE: rdbms/admin/catpdbms.sql
Rem END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    surman      12/10/12 - XbranchMerge surman_bug-12876907 from main
Rem    surman      11/14/12 - 12876907: Add ORACLE_SCRIPT
Rem    surman      03/27/12 - 13615447: Add SQL patching tags
Rem    mxu         09/08/05 - mxu_xe_htmldb_auth
Rem    lvbcheng    08/26/05 - Add locked account exception 
Rem    mxu         08/25/05 - Add exceptions for account status checking 
Rem    lvbcheng    08/19/05 - Add internal error 
Rem    lvbcheng    08/17/05 - HTMLDB_SYSTEM
Rem    mxu         08/10/05 - Change return type 
Rem    lvbcheng    08/03/05 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql

create or replace package sys.htmldb_system authid current_user is

  /*********************************/
  /* return values for verify_user */
  /*********************************/

  valid_user CONSTANT PLS_INTEGER := 0;
  invalid_user CONSTANT PLS_INTEGER := 1;
  null_input CONSTANT PLS_INTEGER := -1;

  /******************************/
  /* exceptions for verify_user */
  /******************************/

  invalid_caller exception; /* this exception is raised if the user
                               is not allowed to call this package
                             */
  internal_error exception; /* this exception is raised only in unusual
                               situations (i.e., out of memory, database
                               down) */
  account_locked exception; /* this exception is raised if the account
                               is locked */
  password_expired exception; /* this exception is raised if the password
                                 has expired */
  /* 
  package_lockout exception; /o this exception is raised after invalid
                                user has been returned too many times
                                in the same session o/
   */

  /***********************/
  /* exception constants */
  /***********************/

  invalid_caller_errcode     CONSTANT PLS_INTEGER:= -32058;
  internal_error_errcode     CONSTANT PLS_INTEGER:= -600;
  account_locked_errcode     CONSTANT PLS_INTEGER:= -28000;
  password_expired_errcode   CONSTANT PLS_INTEGER:= -28001;

  PRAGMA EXCEPTION_INIT(invalid_caller,     -32058);
  PRAGMA EXCEPTION_INIT(internal_error,     -600);
  PRAGMA EXCEPTION_INIT(account_locked,     -28000);
  PRAGMA EXCEPTION_INIT(password_expired,   -28001);

  function verify_user(username IN varchar2 character set any_cs,
                       password IN varchar2 character set any_cs) 
    return PLS_INTEGER;
  /* 
    DESCRIPTION:
    Verify that the username and password pair is valid.

    PARAMETERS:
    username (IN) - username to be validated. Blank padded
                    usernames are not valid. Thus, 'SCOTT  '
                    is not equal to 'SCOTT'.
    password (IN) - password to be validated. Blank padded
                    usernames are not valid. Thus, 'TIGER  '
                    is not equal to 'TIGER'.

    USAGE NOTES:
    This package can only be called by the user HTMLDB_USER.
    Any other caller will be rejected.

    SECURITY:

    TBD
 
  */
end htmldb_system;
/
create or replace public synonym htmldb_system for htmldb_system;

@?/rdbms/admin/sqlsessend.sql
